/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.components;

import com.openbravo.pos.util.LogToFile;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.stage.Popup;

public class TypeOrderPopUp
extends Popup {
    private double height;
    private double width;
    private GridPane mainPane;
    private GridPane dineInPane;
    private GridPane takeAwayPane;
    private Button dineInButton;
    private String typeOrder;
    private Button takeAwayButton;
    private Label imageDineInLabel;
    private Label imageTakeAwayLabel;
    private Label dineInLabel;
    private Label takeAwayLabel;
    private Image imageDineIn;
    private Image imageTakeAway;
    private String style = "-fx-background-color: white; -fx-background-radius: 12px;";
    private String styleDineIn = "-fx-background-color: #C77F24; -fx-background-radius: 11px;";
    private String styleTakeAway = "-fx-background-color: #008CAA; -fx-background-radius: 11px;";
    private EventHandler mEventHandlerDineInAction = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            System.out.println("event " + event);
            TypeOrderPopUp.this.chooseDineIn();
        }
    };
    private EventHandler mEventHandlerTakeAwayAction = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            TypeOrderPopUp.this.chooseTakeAway();
        }
    };

    public TypeOrderPopUp(double height, double width, String typeOrder) {
        try {
            this.typeOrder = typeOrder;
            this.height = height;
            this.width = width;
            this.imageDineIn = new Image(((Object)((Object)this)).getClass().getResource("/com/openbravo/images/at_spot_line.png").toURI().toString(), 30.0, 30.0, false, false);
            this.imageTakeAway = new Image(((Object)((Object)this)).getClass().getResource("/com/openbravo/images/take_away_line.png").toURI().toString(), 30.0, 30.0, false, false);
            this.mainPane = new GridPane();
            this.mainPane.setVgap(10.0);
            this.mainPane.setHgap(10.0);
            this.mainPane.setAlignment(Pos.CENTER);
            this.mainPane.setPrefHeight(height);
            this.mainPane.setPrefWidth(width);
            this.mainPane.setStyle(this.style);
            this.buildDineInPane();
            this.buildTakeAwayPane();
            this.mainPane.add((Node)this.takeAwayButton, 0, 0);
            this.mainPane.add((Node)this.dineInButton, 0, 1);
            this.getContent().add((Object)this.mainPane);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void buildDineInPane() {
        this.dineInButton = new Button();
        this.dineInButton.setStyle("-fx-background-color: transparent;");
        this.dineInButton.setPrefHeight(this.mainPane.getPrefHeight() * 0.4);
        this.dineInButton.setPrefWidth(this.mainPane.getPrefWidth() * 0.8);
        this.dineInPane = new GridPane();
        this.dineInPane.setPrefHeight(this.mainPane.getPrefHeight() * 0.4);
        this.dineInPane.setPrefWidth(this.mainPane.getPrefWidth() * 0.8);
        this.imageDineInLabel = new Label();
        this.imageDineInLabel.setAlignment(Pos.CENTER);
        this.imageDineInLabel.setStyle(this.styleDineIn);
        this.imageDineInLabel.setPrefHeight(this.dineInButton.getPrefHeight());
        this.imageDineInLabel.setPrefWidth(this.dineInButton.getPrefWidth() * 0.3);
        this.imageDineInLabel.setGraphic((Node)new ImageView(this.imageDineIn));
        this.dineInLabel = new Label("Sur Place");
        this.dineInLabel.setStyle("-fx-font-size: 18px;");
        this.dineInLabel.setPrefHeight(this.dineInButton.getPrefHeight());
        this.dineInLabel.setPrefWidth(this.dineInButton.getPrefWidth() * 0.7);
        this.dineInPane.add((Node)this.imageDineInLabel, 0, 0);
        this.dineInPane.add((Node)this.dineInLabel, 1, 0);
        this.dineInButton.setGraphic((Node)this.dineInPane);
        this.dineInButton.setOnAction(this.mEventHandlerDineInAction);
    }

    private void buildTakeAwayPane() {
        this.takeAwayButton = new Button();
        this.takeAwayButton.setStyle("-fx-background-color: transparent;");
        this.takeAwayButton.setPrefHeight(this.mainPane.getPrefHeight() * 0.4);
        this.takeAwayButton.setPrefWidth(this.mainPane.getPrefWidth() * 0.8);
        this.takeAwayPane = new GridPane();
        this.takeAwayPane.setPrefHeight(this.mainPane.getPrefHeight() * 0.4);
        this.takeAwayPane.setPrefWidth(this.mainPane.getPrefWidth() * 0.8);
        this.imageTakeAwayLabel = new Label();
        this.imageTakeAwayLabel.setAlignment(Pos.CENTER);
        this.imageTakeAwayLabel.setStyle(this.styleTakeAway);
        this.imageTakeAwayLabel.setPrefHeight(this.takeAwayButton.getPrefHeight());
        this.imageTakeAwayLabel.setPrefWidth(this.takeAwayButton.getPrefWidth() * 0.3);
        this.imageTakeAwayLabel.setGraphic((Node)new ImageView(this.imageTakeAway));
        this.takeAwayLabel = new Label("Emporter");
        this.takeAwayLabel.setStyle("-fx-font-size: 16px;");
        this.takeAwayLabel.setPrefHeight(this.takeAwayButton.getPrefHeight());
        this.takeAwayLabel.setPrefWidth(this.takeAwayButton.getPrefWidth() * 0.7);
        this.takeAwayPane.add((Node)this.imageTakeAwayLabel, 0, 0);
        this.takeAwayPane.add((Node)this.takeAwayLabel, 1, 0);
        this.takeAwayButton.setGraphic((Node)this.takeAwayPane);
        this.takeAwayButton.setOnAction(this.mEventHandlerTakeAwayAction);
    }

    private void chooseDineIn() {
        this.typeOrder = "Sur Place";
        System.out.println("typeOrder : " + this.typeOrder);
        this.hide();
    }

    private void chooseTakeAway() {
        this.typeOrder = "A Emporter";
        this.hide();
    }

    public String getTypeOrder() {
        return this.typeOrder;
    }

    public void setTypeOrder(String typeOrder) {
        this.typeOrder = typeOrder;
    }
}

