/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.components;

import javafx.animation.Animation;
import javafx.animation.FillTransition;
import javafx.animation.ParallelTransition;
import javafx.animation.TranslateTransition;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.util.Duration;

public class ToggleSwitch
extends GridPane {
    private Rectangle background;
    private Label trigger;
    private BooleanProperty switchedOn = new SimpleBooleanProperty(false);
    private TranslateTransition translateAnimation = new TranslateTransition(Duration.seconds((double)0.25));
    private FillTransition fillAnimation = new FillTransition(Duration.seconds((double)0.25));
    private ParallelTransition animation = new ParallelTransition(new Animation[]{this.translateAnimation, this.fillAnimation});

    public BooleanProperty switchedOnProperty() {
        return this.switchedOn;
    }

    public ToggleSwitch() {
        this.background = new Rectangle(100.0, 50.0);
        this.background.setFill((Paint)Color.GRAY);
        this.trigger = new Label();
        this.trigger.setPrefHeight(45.0);
        this.trigger.setPrefWidth(45.0);
        this.trigger.setAlignment(Pos.CENTER);
        this.trigger.getStyleClass().add((Object)"bg-white");
        this.translateAnimation.setNode((Node)this.trigger);
        this.fillAnimation.setShape((Shape)this.background);
        this.getChildren().addAll((Object[])new Node[]{this.background, this.trigger});
        this.switchedOn.addListener((obs, oldState, newState) -> this.changeView());
    }

    public void changeView() {
        System.out.println("++++++++++ default");
        boolean isOn = this.switchedOn.get();
        System.out.println("++++++++++ isOn : " + isOn);
        this.translateAnimation.setToX(isOn ? 0.0 : 50.0);
        this.fillAnimation.setFromValue(isOn ? Color.GRAY : Color.GREEN);
        this.fillAnimation.setToValue(isOn ? Color.GREEN : Color.GRAY);
        this.animation.play();
    }

    public Label getTrigger() {
        return this.trigger;
    }
}

