/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.components;

import com.openbravo.components.HeaderDetailProductButton;
import com.openbravo.components.OptionDetailProductButton;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.ticket.CarteOrderInfo;
import com.openbravo.pos.ticket.GroupSubSupplementInfo;
import com.openbravo.pos.ticket.OptionItemOrder;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.ticket.SubSupplementResult;
import com.openbravo.pos.ticket.SupplementItemInfo;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.ImagesUtils;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.service.ItemService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.stage.Popup;

public class SubSupplementsPopUp
extends Popup {
    private GridPane mainPane;
    private SubSupplementResult result;
    private List<OptionItemOrder> listChoiceSupplement;
    private int parent_supplement_id;
    private List<OptionItemOrder> supplements_to_delete;
    private SupplementItemInfo parentSupplement;
    private int index_group_sub_supplement;
    private GroupSubSupplementInfo groupSubSupplementInfo;
    private ItemService mItemService;
    private final String KEY_INDEX = "KEY_INDEX";
    private final String KEY_STEP = "KEY_STEP";
    private final String KEY_NAME_GROUP_SUB_OPTION = "KEY_NAME_GROUP_SUB_OPTION";
    private GridPane header_g_sub_options_pages;
    private GridPane header_detail_product_pane;
    private GridPane pane_footer;
    private Label title_group;
    private Label info_groupe;
    private Button button_next;
    private Button button_cancel;
    private Button button_valid;
    private int NUMBER_COLUMN_OPTION = 4;
    private int NUMBER_ROW_OPTION = 3;
    private int page_options;
    private int MAX_OPTIONS_PER_PAGE = 12;
    private int MAX_OPTIONS;
    private int numberPageOptions;
    private HashMap<Integer, LinkedHashMap<Integer, OptionDetailProductButton>> map_sub_options;
    private Button nextItemOptionButton;
    private Button previousItemOptionButton;
    private LinkedHashMap<Integer, OptionDetailProductButton> itemOptionsButton;
    private ImagesUtils mImagesUtils;
    private final String SIZE_IMAGE_64 = "_64px";
    private final String SIZE_IMAGE_128 = "_128px";
    private Image imageDefaultItemOption;
    private Image imageDecrease;
    private Image imageIncrease;
    private GridPane subOptionsPane;
    private String BUTTON_OPTION = "button_option";
    private String EVENT_INCREASE_QTT_OPTION = "increase qtt option";
    private String EVENT_DECREASE_QTT_OPTION = "decrease qqt option";
    private String EVENT_ADD_OPTION = "add option";
    private Image imagePreviousItem;
    private Image imageNextItem;
    private String style = "-fx-background-color: #2E1A5C; -fx-background-radius: 12px;";
    private CarteOrderInfo groupProducts;
    private ProductInfoExt subProduct;
    private Button previous_detail_header;
    private Button next_detail_header;
    private List<HeaderDetailProductButton> groupTabs;
    private GridPane[] headerDetailProductArray;
    private int numberPageDetailProductHeader;
    private int NUMBER_G_SUB_OPTIONS_TAB = 3;
    private int page_detail_product_header;
    public static final String STR_G_SUB_OPTIONS = "group_sub_options";
    private HeaderDetailProductButton firstButton = null;
    private int index_group_option;
    private OptionDetailProductButton buttonOptionParent;
    private boolean inDriveMode = false;
    private Image imageNext;
    private Image imagePrevious;
    private String parent_supplement_global_id;
    private EventHandler mEventHandlerNextOptionAction = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            SubSupplementsPopUp.this.nextOptions();
        }
    };
    private EventHandler mEventHandlerPreviousOptionAction = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            SubSupplementsPopUp.this.previousOptions();
        }
    };
    private EventHandler mEventHandlerOptionAction = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            OptionDetailProductButton buttonOption = (OptionDetailProductButton)((Object)event.getSource());
            if (buttonOption != null) {
                if (buttonOption.getEventName() == null || !buttonOption.getEventName().equalsIgnoreCase(SubSupplementsPopUp.this.EVENT_INCREASE_QTT_OPTION) && !buttonOption.getEventName().equalsIgnoreCase(SubSupplementsPopUp.this.EVENT_DECREASE_QTT_OPTION)) {
                    SubSupplementsPopUp.this.selectOption(buttonOption);
                }
                buttonOption.setEventName(SubSupplementsPopUp.this.EVENT_ADD_OPTION);
            }
        }
    };
    private EventHandler mEventHandlerIncreaseQttOptionAction = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            Button buttonSource = (Button)event.getSource();
            if (buttonSource != null && buttonSource.getProperties().get((Object)SubSupplementsPopUp.this.BUTTON_OPTION) != null) {
                OptionDetailProductButton buttonOption = (OptionDetailProductButton)((Object)buttonSource.getProperties().get((Object)SubSupplementsPopUp.this.BUTTON_OPTION));
                buttonOption.setEventName(SubSupplementsPopUp.this.EVENT_INCREASE_QTT_OPTION);
                if (buttonOption != null) {
                    SubSupplementsPopUp.this.increaseQttOption(buttonOption);
                }
            }
        }
    };
    private EventHandler mEventHandlerDecreaseQttOptionAction = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            Button buttonSource = (Button)event.getSource();
            if (buttonSource != null && buttonSource.getProperties().get((Object)SubSupplementsPopUp.this.BUTTON_OPTION) != null) {
                OptionDetailProductButton buttonOption = (OptionDetailProductButton)((Object)buttonSource.getProperties().get((Object)SubSupplementsPopUp.this.BUTTON_OPTION));
                buttonOption.setEventName(SubSupplementsPopUp.this.EVENT_DECREASE_QTT_OPTION);
                if (buttonOption != null) {
                    SubSupplementsPopUp.this.decreaseQttOption(buttonOption);
                }
            }
        }
    };
    private EventHandler mEventHandlerGroupeSubOptionAction = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            HeaderDetailProductButton mButtonSource = (HeaderDetailProductButton)((Object)event.getSource());
            if (mButtonSource != null) {
                SubSupplementsPopUp.this.loadDetailGroupSubOption(mButtonSource);
                if (SubSupplementsPopUp.this.inDriveMode) {
                    AppLocal.displayDualScreen.propagateClick("loadDetailGroupSubOption", new Object[]{mButtonSource.getIndex(), mButtonSource.getGroup_type()});
                }
            }
        }
    };
    private EventHandler mEventHandlerCancelAction = event -> this.cancel();
    private EventHandler mEventHandlerCheckAndValidAction = event -> this.checkAndValid();
    private EventHandler mEventHandlerNextAction = event -> this.next();
    private EventHandler mEventHandlerNextHeaderTabAction = event -> this.nextHeaderTab();
    private EventHandler mEventHandlerPreviousHeaderTabAction = event -> this.previousHeaderTab();

    public SubSupplementsPopUp(double width, double height) {
        try {
            this.mImagesUtils = new ImagesUtils();
            this.imagePreviousItem = new Image(((Object)((Object)this)).getClass().getResource("/com/openbravo/images/previous_item_product.png").toURI().toString(), 30.0, 30.0, false, false);
            this.imageNextItem = new Image(((Object)((Object)this)).getClass().getResource("/com/openbravo/images/next_item_product.png").toURI().toString(), 30.0, 30.0, false, false);
            this.imageDecrease = new Image(((Object)((Object)this)).getClass().getResource("/com/openbravo/images/decrease.png").toURI().toString(), 30.0, 30.0, false, false);
            this.imageIncrease = new Image(((Object)((Object)this)).getClass().getResource("/com/openbravo/images/increase.png").toURI().toString(), 30.0, 30.0, false, false);
            this.imageDefaultItemOption = new Image(((Object)((Object)this)).getClass().getResource("/com/openbravo/images/default_image_item_option.png").toURI().toString());
            this.imageNext = new Image(((Object)((Object)this)).getClass().getResource("/com/openbravo/images/white_next_icon.png").toURI().toString(), 30.0, 30.0, false, false);
            this.imagePrevious = new Image(((Object)((Object)this)).getClass().getResource("/com/openbravo/images/white_previous_icon.png").toURI().toString(), 30.0, 30.0, false, false);
            this.mItemService = ItemService.getInstance();
            this.mainPane = new GridPane();
            this.mainPane.setVgap(10.0);
            this.mainPane.setHgap(10.0);
            this.mainPane.setAlignment(Pos.CENTER);
            this.mainPane.setPrefHeight(height);
            this.mainPane.setPrefWidth(width);
            this.mainPane.setStyle(this.style);
            this.getContent().add((Object)this.mainPane);
            this.inDriveMode = AppLocal.TYPE_DISPLAY != null && AppLocal.TYPE_DISPLAY.startsWith("window");
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public SubSupplementResult getResult() {
        return this.result;
    }

    private void loadPaneSubSupplement(GroupSubSupplementInfo groupSubSupplementInfo) {
        this.subOptionsPane.getChildren().clear();
        groupSubSupplementInfo.setOption_free_tmp(0);
        this.groupSubSupplementInfo = groupSubSupplementInfo;
        this.showFooterButtons(groupSubSupplementInfo);
        if (groupSubSupplementInfo.isHas_limit_options()) {
            this.info_groupe.setText(groupSubSupplementInfo.getMin_options() + " min - " + groupSubSupplementInfo.getMax_options() + " max");
        } else {
            this.info_groupe.setText("");
        }
        this.title_group.setText(groupSubSupplementInfo.getDisplayedTitle().toUpperCase());
        if (this.map_sub_options == null) {
            this.map_sub_options = new HashMap();
        }
        this.map_sub_options.clear();
        double padding = 50.0;
        double heightOptionsPane = AppVarUtils.getScreenDimension().getHeight() * 0.5 - padding;
        double widthOptionsPane = AppVarUtils.getScreenDimension().getWidth() * 0.7 - padding;
        double widthOption = widthOptionsPane / (double)this.NUMBER_COLUMN_OPTION;
        double heightOption = heightOptionsPane / (double)this.NUMBER_ROW_OPTION;
        int index = 0;
        int index_map = 0;
        this.itemOptionsButton = new LinkedHashMap();
        this.numberPageOptions = (int)Math.ceil((double)groupSubSupplementInfo.getSupplements().size() / (double)this.MAX_OPTIONS_PER_PAGE);
        this.MAX_OPTIONS = this.numberPageOptions > 1 ? this.MAX_OPTIONS_PER_PAGE - 1 : this.MAX_OPTIONS_PER_PAGE;
        for (SupplementItemInfo optionItem : groupSubSupplementInfo.getSupplements()) {
            Image imageOption = this.mImagesUtils.getImageOption(optionItem, AppLocal.refOptions, "_64px", false);
            if (imageOption == null) {
                imageOption = this.imageDefaultItemOption;
            }
            OptionDetailProductButton optionButton = new OptionDetailProductButton(null, null, null, groupSubSupplementInfo, optionItem, heightOption, widthOption, imageOption, this.imageDecrease, this.imageIncrease);
            int indexOption = this.indexSelectedOptionIfExist(optionItem);
            if (indexOption != -1) {
                OptionItemOrder optionItemOrder = this.listChoiceSupplement.get(indexOption);
                if (optionItemOrder != null) {
                    optionButton.setOptionItemOrder(optionItemOrder);
                    optionButton.setQuantity(optionItemOrder.getNumberOption());
                }
                optionButton.select();
            } else {
                optionButton.deselect();
            }
            optionButton.setOnAction(this.mEventHandlerOptionAction);
            optionButton.getQuantityIncreaseButton().getProperties().put((Object)this.BUTTON_OPTION, (Object)optionButton);
            optionButton.getQuantityDecreaseButton().getProperties().put((Object)this.BUTTON_OPTION, (Object)optionButton);
            optionButton.getQuantityIncreaseButton().setOnAction(this.mEventHandlerIncreaseQttOptionAction);
            optionButton.getQuantityDecreaseButton().setOnAction(this.mEventHandlerDecreaseQttOptionAction);
            if (index < this.MAX_OPTIONS) {
                this.itemOptionsButton.put(optionItem.getiD(), optionButton);
            } else {
                this.map_sub_options.put(index_map, this.itemOptionsButton);
                this.itemOptionsButton = new LinkedHashMap();
                this.itemOptionsButton.put(optionItem.getiD(), optionButton);
                ++index_map;
                index = 0;
            }
            ++index;
        }
        if (this.itemOptionsButton != null && !this.itemOptionsButton.isEmpty()) {
            this.map_sub_options.put(index_map, this.itemOptionsButton);
        }
        int column = 0;
        int row = 0;
        for (int i = 0; i < this.MAX_OPTIONS; ++i) {
            GridPane itemIngredientPane = new GridPane();
            itemIngredientPane.setPrefHeight(heightOption);
            itemIngredientPane.setPrefWidth(widthOption);
            itemIngredientPane.getStyleClass().add((Object)"border_white_opacity12");
            itemIngredientPane.getStyleClass().add((Object)"border_radius_12px");
            itemIngredientPane.getStyleClass().add((Object)"bg_radius_12px");
            itemIngredientPane.getStyleClass().add((Object)"bg_white_opacity12");
            this.subOptionsPane.add((Node)itemIngredientPane, column, row);
            if (column < this.NUMBER_COLUMN_OPTION - 1) {
                ++column;
                continue;
            }
            column = 0;
            ++row;
        }
        if (this.numberPageOptions > 1) {
            GridPane nextPreviousPane = new GridPane();
            nextPreviousPane.setAlignment(Pos.CENTER);
            nextPreviousPane.setVgap(5.0);
            nextPreviousPane.setHgap(5.0);
            nextPreviousPane.setPrefHeight(heightOption);
            nextPreviousPane.setPrefWidth(widthOption);
            nextPreviousPane.getStyleClass().add((Object)"bg_white_opacity20");
            nextPreviousPane.getStyleClass().add((Object)"border_radius_12px");
            nextPreviousPane.getStyleClass().add((Object)"bg_radius_12px");
            nextPreviousPane.getStyleClass().add((Object)"border_white_opacity12");
            this.nextItemOptionButton = new Button();
            this.nextItemOptionButton.getStyleClass().add((Object)"border_radius_14px");
            this.nextItemOptionButton.getStyleClass().add((Object)"bg_radius_14px");
            this.nextItemOptionButton.getStyleClass().add((Object)"bg_white_opacity18");
            this.nextItemOptionButton.setPrefHeight(nextPreviousPane.getPrefHeight() * 0.8);
            this.nextItemOptionButton.setPrefWidth(nextPreviousPane.getPrefWidth() * 0.45);
            this.nextItemOptionButton.setGraphic((Node)new ImageView(this.imageNextItem));
            this.nextItemOptionButton.setOnAction(this.mEventHandlerNextOptionAction);
            this.previousItemOptionButton = new Button();
            this.previousItemOptionButton.getStyleClass().add((Object)"border_radius_14px");
            this.previousItemOptionButton.getStyleClass().add((Object)"bg_radius_14px");
            this.previousItemOptionButton.getStyleClass().add((Object)"bg_white_opacity18");
            this.previousItemOptionButton.setPrefHeight(nextPreviousPane.getPrefHeight() * 0.8);
            this.previousItemOptionButton.setPrefWidth(nextPreviousPane.getPrefWidth() * 0.45);
            this.previousItemOptionButton.setGraphic((Node)new ImageView(this.imagePreviousItem));
            this.previousItemOptionButton.setOnAction(this.mEventHandlerPreviousOptionAction);
            nextPreviousPane.add((Node)this.previousItemOptionButton, 0, 0);
            nextPreviousPane.add((Node)this.nextItemOptionButton, 1, 0);
            this.subOptionsPane.add((Node)nextPreviousPane, column, row);
            this.previousItemOptionButton.setDisable(true);
            if (this.numberPageOptions == 1) {
                this.nextItemOptionButton.setDisable(true);
            }
        }
        this.page_options = 0;
        this.loadPageOptions(this.page_options);
    }

    private void loadPageOptions(int page_options) {
        LinkedHashMap<Integer, OptionDetailProductButton> mapOptionsButton = this.map_sub_options.get(page_options);
        if (mapOptionsButton != null) {
            List optionsButton = mapOptionsButton.values().stream().collect(Collectors.toList());
            int numberOptions = optionsButton.size();
            int index = 0;
            for (Node node : this.subOptionsPane.getChildren()) {
                if (index >= this.MAX_OPTIONS) break;
                if (node instanceof GridPane) {
                    GridPane optionPane = (GridPane)node;
                    optionPane.getChildren().clear();
                    if (index < numberOptions) {
                        optionPane.add((Node)optionsButton.get(index), 0, 0);
                    }
                }
                ++index;
            }
        }
    }

    public void nextOptions() {
        if (this.page_options < this.numberPageOptions - 1) {
            ++this.page_options;
            this.loadPageOptions(this.page_options);
            if (this.page_options == this.numberPageOptions - 1) {
                this.nextItemOptionButton.setDisable(true);
            }
            this.previousItemOptionButton.setDisable(false);
            if (this.inDriveMode) {
                AppLocal.displayDualScreen.propagateClick("nextSubOptions", null);
            }
        }
    }

    public void previousOptions() {
        if (this.page_options > 0) {
            --this.page_options;
            this.loadPageOptions(this.page_options);
            if (this.page_options == 0) {
                this.previousItemOptionButton.setDisable(true);
            }
            this.nextItemOptionButton.setDisable(false);
            if (this.inDriveMode) {
                AppLocal.displayDualScreen.propagateClick("previousSubOptions", null);
            }
        }
    }

    public void initializer(OptionDetailProductButton buttonOptionParent, CarteOrderInfo groupProducts, ProductInfoExt subProduct, SupplementItemInfo parentSupplement, List<OptionItemOrder> listChoiceSupplement, int index_group_option) {
        this.buttonOptionParent = buttonOptionParent;
        this.groupProducts = groupProducts;
        this.subProduct = subProduct;
        this.parentSupplement = parentSupplement;
        this.listChoiceSupplement = listChoiceSupplement;
        this.index_group_option = index_group_option;
        this.mainPane.getChildren().clear();
        int row = 0;
        this.loadHeaderButtons(parentSupplement.getGroupsSubSupplement());
        this.mainPane.add((Node)this.header_g_sub_options_pages, 0, row++);
        this.addTitleGroup();
        this.addInfoGroup();
        this.addSubOptionsPane();
        this.addFooterPane();
        this.mainPane.add((Node)this.title_group, 0, row++);
        this.mainPane.add((Node)this.info_groupe, 0, row++);
        this.mainPane.add((Node)this.subOptionsPane, 0, row++);
        this.mainPane.add((Node)this.pane_footer, 0, row++);
        this.index_group_sub_supplement = 0;
        this.parent_supplement_id = parentSupplement.getiD();
        this.parent_supplement_global_id = parentSupplement.getId_global();
        this.supplements_to_delete = new ArrayList<OptionItemOrder>();
        this.result = new SubSupplementResult();
        this.result.setListChoiceSupplement(null);
        this.result.setValid(false);
        this.result.setSupplements_to_delete(this.supplements_to_delete);
        if (this.firstButton != null) {
            this.loadDetailGroupSubOption(this.firstButton);
        }
        this.setTexts();
    }

    public void checkAndValid() {
        if (this.groupSubSupplementInfo.isHas_limit_options()) {
            boolean validMin = true;
            boolean validMax = true;
            int min_option = 0;
            int number = this.sizeOptions(this.groupSubSupplementInfo);
            if (number < (min_option = this.groupSubSupplementInfo.getMin_options())) {
                validMin = false;
            }
            if (number > this.groupSubSupplementInfo.getMax_options()) {
                validMax = false;
            }
            if (validMin && validMax) {
                this.valid();
            } else if (!validMin) {
                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "merci de s\u00e9lectionner le nombre minimum " + min_option + " des options.", 1500, NPosition.TOP_RIGHT);
            }
        } else {
            this.valid();
        }
    }

    public void valid() {
        ++this.index_group_sub_supplement;
        if (this.index_group_sub_supplement < this.parentSupplement.getGroupsSubSupplement().size()) {
            HeaderDetailProductButton buttonGSubOption = this.groupTabs.get(this.index_group_sub_supplement);
            if (this.index_group_sub_supplement < this.groupTabs.size()) {
                int page = (int)Math.ceil((double)(this.index_group_sub_supplement + 1) / (double)this.NUMBER_G_SUB_OPTIONS_TAB);
                if (--page > this.page_detail_product_header) {
                    this.nextHeaderTab();
                }
            }
            this.loadDetailGroupSubOption(buttonGSubOption);
            if (this.inDriveMode) {
                AppLocal.displayDualScreen.propagateClick("valid", null);
            }
        } else {
            this.result.setListChoiceSupplement(this.listChoiceSupplement);
            this.result.setValid(true);
            this.result.setSupplements_to_delete(this.supplements_to_delete);
            this.hide();
        }
    }

    public void selectOption(OptionDetailProductButton buttonOption) {
        SupplementItemInfo optionItem = buttonOption.getOption();
        int indexOption = this.indexSelectedOptionIfExist(optionItem);
        if (indexOption == -1) {
            this.addOption(buttonOption);
        }
    }

    private void addOption(OptionDetailProductButton buttonOption) {
        int id_group_products;
        int id_sub_product = this.subProduct != null ? this.subProduct.getID() : -1;
        int n = id_group_products = this.groupProducts != null ? this.groupProducts.getId() : -1;
        int index_group_products = this.groupProducts != null ? this.groupProducts.getIndex_carte() : (this.subProduct != null ? this.subProduct.getIndex_sub_product() : -1);
        String name_group_products = this.groupProducts != null ? this.groupProducts.getName() : null;
        String name_sub_product = this.subProduct != null ? this.subProduct.getName() : null;
        String ref_sub_product = this.subProduct != null ? this.subProduct.getRef_web() : null;
        String ref_group_products = this.groupProducts != null ? this.groupProducts.getRef_web() : null;
        String id_global_sub_product = this.subProduct != null ? this.subProduct.getId_global() : null;
        String id_global_group_products = this.groupProducts != null ? this.groupProducts.getId_global() : null;
        GroupSubSupplementInfo groupSubSupplementInfo = buttonOption.getGroupSubSupplementInfo();
        SupplementItemInfo optionItem = buttonOption.getOption();
        int number_free = 0;
        if (this.isOptionFreeable(groupSubSupplementInfo) && optionItem.getPrice_order() > 0.0) {
            optionItem.setPrice_order(0.0);
            this.decrementOptionFree(groupSubSupplementInfo, 1);
            number_free = 1;
        }
        OptionItemOrder optionItemOrder = new OptionItemOrder(id_group_products, id_sub_product, name_sub_product, name_group_products, 1, index_group_products, number_free, optionItem, this.parent_supplement_id, groupSubSupplementInfo.getId(), ref_sub_product, ref_group_products, id_global_sub_product, id_global_group_products, this.parent_supplement_global_id);
        this.listChoiceSupplement.add(optionItemOrder);
        buttonOption.setOptionItemOrder(optionItemOrder);
        buttonOption.setQuantity(1);
        buttonOption.select();
        this.setDisableButtonValid();
        if (this.inDriveMode) {
            AppLocal.displayDualScreen.propagateClick("selectSubOptions", new Object[]{buttonOption.getOption().getiD()});
        }
        if (this.listChoiceSupplement.size() > 0 && groupSubSupplementInfo.isHas_limit_options() && groupSubSupplementInfo.getMax_options() == this.sizeOptions(groupSubSupplementInfo)) {
            this.checkAndValid();
        }
        if (groupSubSupplementInfo.getNumber_click() == 1 || groupSubSupplementInfo.getMax_options() == 1) {
            buttonOption.getQuantityIncreaseButton().setOpacity(0.5);
        }
    }

    private void increaseQttOption(OptionDetailProductButton buttonOption) {
        SupplementItemInfo optionItem = buttonOption.getOption();
        GroupSubSupplementInfo groupSubSupplementInfo = buttonOption.getGroupSubSupplementInfo();
        int indexOption = this.indexSelectedOptionIfExist(optionItem);
        if (indexOption != -1) {
            int number = this.listChoiceSupplement.get(indexOption).getNumberOption();
            if (number < groupSubSupplementInfo.getNumber_click() && number < groupSubSupplementInfo.getMax_options()) {
                int numberFree = this.listChoiceSupplement.get(indexOption).getNumber_free();
                if (this.isOptionFreeable(groupSubSupplementInfo) && optionItem.getPrice_order() > 0.0) {
                    this.listChoiceSupplement.get(indexOption).setNumber_free(++numberFree);
                    this.decrementOptionFree(groupSubSupplementInfo, 1);
                }
                this.listChoiceSupplement.get(indexOption).setNumberOption(++number);
                this.listChoiceSupplement.get(indexOption).setPrice(optionItem.getPrice_order(), number - numberFree);
                buttonOption.setQuantity(number);
                buttonOption.checkFreeAndSetStyle();
                this.setDisableButtonValid();
                if (this.inDriveMode) {
                    AppLocal.displayDualScreen.propagateClick("handleSubOptionAction", new Object[]{buttonOption.getOption().getiD(), true});
                }
                if (this.listChoiceSupplement.size() > 0 && groupSubSupplementInfo.isHas_limit_options() && groupSubSupplementInfo.getMax_options() == this.sizeOptions(groupSubSupplementInfo)) {
                    this.checkAndValid();
                }
            } else {
                System.out.println("notification");
            }
            if (number >= groupSubSupplementInfo.getNumber_click() || number >= groupSubSupplementInfo.getMax_options()) {
                buttonOption.getQuantityIncreaseButton().setOpacity(0.5);
            }
        }
    }

    private void decreaseQttOption(OptionDetailProductButton buttonOption) {
        SupplementItemInfo optionItem = buttonOption.getOption();
        int indexOption = this.indexSelectedOptionIfExist(optionItem);
        if (indexOption != -1) {
            OptionItemOrder optionToDelete = this.listChoiceSupplement.get(indexOption);
            if (optionToDelete.getNumberOption() > 1) {
                this.decreaseQttOption(buttonOption, optionToDelete);
            } else {
                this.deleteOption(buttonOption, optionToDelete);
            }
            if (this.inDriveMode) {
                AppLocal.displayDualScreen.propagateClick("handleSubOptionAction", new Object[]{buttonOption.getOption().getiD(), false});
            }
        }
    }

    private void decreaseQttOption(OptionDetailProductButton buttonOption, OptionItemOrder itemToUpdate) {
        if (itemToUpdate.getNumber_free() == itemToUpdate.getNumberOption()) {
            if (!itemToUpdate.isForce_free()) {
                this.incrementOptionFree(buttonOption.getGroupSubSupplementInfo(), 1);
            }
            this.calculFreeAfterDelete(buttonOption.getGroupSubSupplementInfo());
            itemToUpdate.setNumber_free(itemToUpdate.getNumber_free() - 1);
            itemToUpdate.setNumberOption(itemToUpdate.getNumberOption() - 1);
        } else {
            itemToUpdate.setNumberOption(itemToUpdate.getNumberOption() - 1);
            if (buttonOption.getOption() != null) {
                itemToUpdate.setPrice(buttonOption.getOption().getPrice_order(), itemToUpdate.getNumberOption() - itemToUpdate.getNumber_free());
            }
        }
        this.setDisableButtonValid();
        buttonOption.setQuantity(itemToUpdate.getNumberOption());
        buttonOption.getQuantityIncreaseButton().setOpacity(1.0);
        buttonOption.checkFreeAndSetStyle();
    }

    private void deleteOption(OptionDetailProductButton buttonOtion, OptionItemOrder itemToDelete) {
        if (itemToDelete.getNumber_free() > 0) {
            this.incrementOptionFree(buttonOtion.getGroupSubSupplementInfo(), itemToDelete.getNumber_free());
            if (!itemToDelete.isForce_free()) {
                this.incrementOptionFree(buttonOtion.getGroupSubSupplementInfo(), 1);
            }
            this.listChoiceSupplement.remove(itemToDelete);
            this.calculFreeAfterDelete(buttonOtion.getGroupSubSupplementInfo());
        } else {
            this.listChoiceSupplement.remove(itemToDelete);
        }
        if (buttonOtion.getOption() != null) {
            // empty if block
        }
        buttonOtion.deselect();
        this.setDisableButtonValid();
    }

    private int indexSelectedOptionIfExist(SupplementItemInfo option) {
        int found = -1;
        for (int i = 0; i < this.listChoiceSupplement.size(); ++i) {
            if (this.listChoiceSupplement.get(i).getSupplement() != option.getiD()) continue;
            found = i;
            break;
        }
        return found;
    }

    private OptionItemOrder existOption(SupplementItemInfo option) {
        OptionItemOrder option_order = null;
        for (OptionItemOrder chosen_option : this.listChoiceSupplement) {
            if (option.getiD() != chosen_option.getSupplement()) continue;
            option_order = chosen_option;
            break;
        }
        return option_order;
    }

    public void next() {
        this.checkAndValid();
    }

    private int sizeOptions(GroupSubSupplementInfo mGroupSubSupplementInfo) {
        int size = 0;
        try {
            for (OptionItemOrder optionItem : this.listChoiceSupplement) {
                for (SupplementItemInfo supplement : mGroupSubSupplementInfo.getSupplements()) {
                    if (optionItem.getSupplement() != supplement.getiD()) continue;
                    size += optionItem.getNumberOption();
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return size;
    }

    private boolean isOptionFreeable(GroupSubSupplementInfo groupSubSupplementInfo) {
        return groupSubSupplementInfo.getOption_free() > groupSubSupplementInfo.getOption_free_tmp();
    }

    private void decrementOptionFree(GroupSubSupplementInfo groupSubSupplementInfo, int number_free) {
        groupSubSupplementInfo.setOption_free_tmp(groupSubSupplementInfo.getOption_free_tmp() + number_free);
    }

    private void incrementOptionFree(GroupSubSupplementInfo groupSubSupplementInfo, int number_free) {
        groupSubSupplementInfo.setOption_free_tmp(groupSubSupplementInfo.getOption_free_tmp() - number_free);
    }

    private void calculFreeAfterDelete(GroupSubSupplementInfo groupSubSupplementInfo) {
        if (this.isOptionFreeable(groupSubSupplementInfo)) {
            for (OptionItemOrder supplement : this.listChoiceSupplement) {
                if (!this.isOptionFreeable(groupSubSupplementInfo) || supplement.getGroupSubSupplementInfo_ID() != groupSubSupplementInfo.getId() || supplement.getNumber_free() >= supplement.getNumberOption() || !(supplement.getPrice() > 0.0)) continue;
                int free_possible = groupSubSupplementInfo.getOption_free() - groupSubSupplementInfo.getOption_free_tmp();
                int free = free_possible > supplement.getNumberOption() - supplement.getNumber_free() ? supplement.getNumberOption() - supplement.getNumber_free() : free_possible;
                double price_option = supplement.getPrice() - supplement.getPrice() / (double)(supplement.getNumberOption() - supplement.getNumber_free());
                supplement.setNumber_free(supplement.getNumber_free() + free);
                double price = price_option * (double)(supplement.getNumberOption() - supplement.getNumber_free());
                supplement.setPrice(price_option, supplement.getNumberOption() - supplement.getNumber_free());
                this.decrementOptionFree(groupSubSupplementInfo, free);
            }
        }
    }

    private void createPaneGroupSubOption(Button btnGroup, String name_groupe, int step) {
        GridPane paneName = new GridPane();
        paneName.setAlignment(Pos.CENTER);
        paneName.setPrefHeight(btnGroup.getPrefHeight());
        paneName.setPrefWidth(btnGroup.getPrefWidth());
        GridPane paneStep = new GridPane();
        paneStep.setAlignment(Pos.CENTER);
        Label label_step = new Label();
        label_step.setText(String.valueOf(step));
        label_step.setAlignment(Pos.CENTER);
        paneStep.setPrefHeight(paneName.getPrefHeight() * 0.5);
        paneStep.setPrefWidth(paneName.getPrefWidth() * 0.5);
        label_step.setPrefHeight(paneStep.getPrefHeight());
        label_step.setPrefWidth(paneStep.getPrefHeight());
        label_step.setStyle("-fx-background-color : #5C606B;");
        paneStep.add((Node)label_step, 0, 0);
        Label name_groupe_option = new Label();
        name_groupe_option.setWrapText(true);
        name_groupe_option.setText(name_groupe.toUpperCase());
        name_groupe_option.setStyle("-fx-font-family : " + AppLocal.FONT_FAMILY_OPTIONS + ";");
        name_groupe_option.setAlignment(Pos.CENTER);
        name_groupe_option.setPrefHeight(paneName.getPrefHeight() * 0.4);
        name_groupe_option.setPrefWidth(paneName.getPrefWidth());
        paneName.add((Node)paneStep, 0, 0);
        paneName.add((Node)name_groupe_option, 0, 1);
        btnGroup.getProperties().put((Object)"KEY_STEP", (Object)label_step);
        btnGroup.getProperties().put((Object)"KEY_NAME_GROUP_SUB_OPTION", (Object)name_groupe_option);
        btnGroup.setStyle("-fx-background-color : transparent;");
        btnGroup.setGraphic((Node)paneName);
    }

    private void loadDetailGroupSubOption(HeaderDetailProductButton mButtonSource) {
        try {
            if (this.checkGroupSubOption()) {
                int index;
                this.deselectHeaderTabs();
                this.selectHeaderTab(mButtonSource);
                this.index_group_sub_supplement = index = ((Integer)mButtonSource.getProperties().get((Object)"KEY_INDEX")).intValue();
                if (this.index_group_sub_supplement < this.parentSupplement.getGroupsSubSupplement().size()) {
                    this.loadPaneSubSupplement(this.parentSupplement.getGroupsSubSupplement().get(this.index_group_sub_supplement));
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void setTexts() {
        this.button_cancel.setText(AppLocal.getIntString("Button.cancel"));
        this.button_valid.setText(AppLocal.getIntString("Button.valid"));
        this.button_next.setText(AppLocal.getIntString("Button.no.thanks"));
    }

    private boolean checkGroupSubOption() {
        if (this.groupSubSupplementInfo != null && this.groupSubSupplementInfo.isHas_limit_options()) {
            boolean validMin = true;
            boolean validMax = true;
            int min_option = 0;
            int number = this.sizeOptions(this.groupSubSupplementInfo);
            if (number < (min_option = this.groupSubSupplementInfo.getMin_options())) {
                validMin = false;
            }
            if (number > this.groupSubSupplementInfo.getMax_options()) {
                validMax = false;
            }
            return validMin && validMax;
        }
        return true;
    }

    private void showFooterButtons(GroupSubSupplementInfo groupSubSupplementInfo) {
        this.pane_footer.getChildren().clear();
        this.pane_footer.add((Node)this.button_cancel, 0, 0);
        if (!(groupSubSupplementInfo.isHas_limit_options() && groupSubSupplementInfo.getMin_options() > 0 || this.sizeOptions(groupSubSupplementInfo) != 0)) {
            this.pane_footer.add((Node)this.button_next, 1, 0);
        } else {
            boolean disable = !this.checkGroupSubOption();
            this.button_valid.setDisable(disable);
            this.pane_footer.add((Node)this.button_valid, 1, 0);
        }
    }

    public void cancel() {
        this.result.setValid(false);
        this.hide();
    }

    private void setDisableButtonValid() {
        if (!this.groupSubSupplementInfo.isHas_limit_options() || this.groupSubSupplementInfo.getMin_options() <= 0) {
            int number = this.sizeOptions(this.groupSubSupplementInfo);
            this.pane_footer.getChildren().clear();
            if (number > 0) {
                this.pane_footer.add((Node)this.button_cancel, 0, 0);
                this.pane_footer.add((Node)this.button_valid, 1, 0);
            } else {
                this.pane_footer.add((Node)this.button_cancel, 0, 0);
                this.pane_footer.add((Node)this.button_next, 1, 0);
            }
        }
        boolean disable = !this.checkGroupSubOption();
        this.button_valid.setDisable(disable);
    }

    private void addTitleGroup() {
        if (this.title_group == null) {
            this.title_group = new Label();
            this.title_group.setAlignment(Pos.CENTER);
            this.title_group.setStyle("-fx-font-size: 18px; -fx-text-fill: white;");
            this.title_group.setPrefHeight(this.mainPane.getPrefHeight() * 0.1);
            this.title_group.setPrefWidth(this.mainPane.getPrefWidth());
        }
    }

    private void addInfoGroup() {
        if (this.info_groupe == null) {
            this.info_groupe = new Label();
            this.info_groupe.setAlignment(Pos.CENTER);
            this.info_groupe.setStyle("-fx-font-size: 16px; -fx-text-fill: white;");
            this.info_groupe.setPrefHeight(this.mainPane.getPrefHeight() * 0.08);
            this.info_groupe.setPrefWidth(this.mainPane.getPrefWidth());
        }
    }

    private void addSubOptionsPane() {
        if (this.subOptionsPane == null) {
            this.subOptionsPane = new GridPane();
            this.subOptionsPane.setAlignment(Pos.CENTER);
            this.subOptionsPane.setVgap(10.0);
            this.subOptionsPane.setHgap(10.0);
            this.subOptionsPane.setPrefHeight(this.mainPane.getPrefHeight() * 0.6);
            this.subOptionsPane.setPrefWidth(this.mainPane.getPrefWidth());
        }
    }

    private void addFooterPane() {
        if (this.pane_footer == null) {
            this.pane_footer = new GridPane();
            this.pane_footer.setAlignment(Pos.CENTER);
            this.pane_footer.setVgap(10.0);
            this.pane_footer.setHgap(10.0);
            this.pane_footer.setPrefHeight(this.mainPane.getPrefHeight() * 0.1);
            this.pane_footer.setPrefWidth(this.mainPane.getPrefWidth());
            if (this.button_cancel == null) {
                this.button_cancel = new Button();
                this.button_cancel.setPrefHeight(this.pane_footer.getPrefHeight() * 0.9);
                this.button_cancel.setPrefWidth(this.pane_footer.getPrefWidth() * 0.43);
                this.button_cancel.setStyle("-fx-text-fill: white;-fx-background-color: #FFFFFF1F; -fx-background-radius: 12px;");
                this.button_cancel.setOnAction(this.mEventHandlerCancelAction);
            }
            if (this.button_next == null) {
                this.button_next = new Button();
                this.button_next.setPrefHeight(this.pane_footer.getPrefHeight() * 0.9);
                this.button_next.setPrefWidth(this.pane_footer.getPrefWidth() * 0.43);
                this.button_next.setStyle("-fx-text-fill: white;-fx-background-color: #FFFFFF1F; -fx-background-radius: 12px;");
                this.button_next.setOnAction(this.mEventHandlerNextAction);
            }
            if (this.button_valid == null) {
                this.button_valid = new Button();
                this.button_valid.setPrefHeight(this.pane_footer.getPrefHeight() * 0.9);
                this.button_valid.setPrefWidth(this.pane_footer.getPrefWidth() * 0.43);
                this.button_valid.setStyle("-fx-text-fill: white;-fx-background-color: #066A69;  -fx-background-radius: 12px");
                this.button_valid.setOnAction(this.mEventHandlerCheckAndValidAction);
            }
            this.pane_footer.add((Node)this.button_cancel, 0, 0);
            this.pane_footer.add((Node)this.button_next, 1, 0);
            this.pane_footer.add((Node)this.button_valid, 2, 0);
        }
    }

    public SupplementItemInfo getParentSupplement() {
        return this.parentSupplement;
    }

    public void setParentSupplement(SupplementItemInfo parentSupplement) {
        this.parentSupplement = parentSupplement;
    }

    public ProductInfoExt getSubProduct() {
        return this.subProduct;
    }

    public void setSubProduct(ProductInfoExt subProduct) {
        this.subProduct = subProduct;
    }

    public CarteOrderInfo getGroupProducts() {
        return this.groupProducts;
    }

    public void setGroupProducts(CarteOrderInfo groupProducts) {
        this.groupProducts = groupProducts;
    }

    private void loadHeaderButtons(List<GroupSubSupplementInfo> groupsSubOptions) {
        this.groupSubSupplementInfo = null;
        if (this.header_g_sub_options_pages == null) {
            this.header_g_sub_options_pages = new GridPane();
            this.header_g_sub_options_pages.setAlignment(Pos.CENTER);
            this.header_g_sub_options_pages.setPrefHeight(this.mainPane.getPrefHeight() * 0.1);
            this.header_g_sub_options_pages.setPrefWidth(this.mainPane.getPrefWidth());
            if (this.header_detail_product_pane == null) {
                this.header_detail_product_pane = new GridPane();
                this.header_detail_product_pane.setAlignment(Pos.CENTER);
                this.header_detail_product_pane.setPrefHeight(this.mainPane.getPrefHeight() * 0.08);
            }
            if (this.next_detail_header == null) {
                this.next_detail_header = new Button();
                this.next_detail_header.setAlignment(Pos.CENTER);
                this.next_detail_header.setPrefHeight(this.mainPane.getPrefHeight() * 0.08);
                this.next_detail_header.setPrefWidth(this.header_g_sub_options_pages.getPrefWidth() * 0.1);
                this.next_detail_header.setGraphic((Node)new ImageView(this.imageNext));
                this.next_detail_header.setStyle("-fx-background-color : transparent;");
                this.next_detail_header.setOnAction(this.mEventHandlerNextHeaderTabAction);
            }
            if (this.previous_detail_header == null) {
                this.previous_detail_header = new Button();
                this.previous_detail_header.setAlignment(Pos.CENTER);
                this.previous_detail_header.setPrefHeight(this.mainPane.getPrefHeight() * 0.08);
                this.previous_detail_header.setPrefWidth(this.header_g_sub_options_pages.getPrefWidth() * 0.1);
                this.previous_detail_header.setGraphic((Node)new ImageView(this.imagePrevious));
                this.previous_detail_header.setStyle("-fx-background-color : transparent;");
                this.previous_detail_header.setOnAction(this.mEventHandlerPreviousHeaderTabAction);
            }
        } else {
            this.header_g_sub_options_pages.getChildren().clear();
            if (this.header_detail_product_pane != null) {
                this.header_detail_product_pane.getChildren().clear();
            }
        }
        double heightDetailProductPane = AppVarUtils.getScreenDimension().getHeight() * 0.08;
        this.groupTabs = new ArrayList<HeaderDetailProductButton>();
        int index = 1;
        int indexGroupe = 0;
        this.firstButton = null;
        if (groupsSubOptions != null && !groupsSubOptions.isEmpty()) {
            for (GroupSubSupplementInfo groupsSubOption : groupsSubOptions) {
                HeaderDetailProductButton groupsSubOptionButton = new HeaderDetailProductButton(STR_G_SUB_OPTIONS, groupsSubOption, index++);
                groupsSubOptionButton.getProperties().put((Object)"KEY_INDEX", (Object)indexGroupe);
                groupsSubOptionButton.setOnAction(this.mEventHandlerGroupeSubOptionAction);
                if (this.firstButton == null) {
                    this.firstButton = groupsSubOptionButton;
                }
                ++indexGroupe;
                this.groupTabs.add(groupsSubOptionButton);
            }
        }
        if (!this.groupTabs.isEmpty()) {
            double widthDetailProductTab;
            double widthDetailProductPane;
            this.numberPageDetailProductHeader = (int)Math.ceil((double)this.groupTabs.size() / (double)this.NUMBER_G_SUB_OPTIONS_TAB);
            this.headerDetailProductArray = new GridPane[this.numberPageDetailProductHeader];
            for (int i = 0; i < this.numberPageDetailProductHeader; ++i) {
                this.headerDetailProductArray[i] = new GridPane();
                this.headerDetailProductArray[i].setVgap(5.0);
                this.headerDetailProductArray[i].setHgap(5.0);
                this.headerDetailProductArray[i].setAlignment(Pos.CENTER);
            }
            if (this.groupTabs.size() < 4) {
                widthDetailProductPane = AppVarUtils.getScreenDimension().getWidth() * 0.7;
                widthDetailProductTab = widthDetailProductPane / (double)this.groupTabs.size();
                this.header_g_sub_options_pages.add((Node)this.header_detail_product_pane, 0, 0);
            } else {
                widthDetailProductPane = AppVarUtils.getScreenDimension().getWidth() * 0.56;
                widthDetailProductTab = widthDetailProductPane / (double)this.NUMBER_G_SUB_OPTIONS_TAB;
                this.header_g_sub_options_pages.add((Node)this.previous_detail_header, 0, 0);
                this.header_g_sub_options_pages.add((Node)this.header_detail_product_pane, 1, 0);
                this.header_g_sub_options_pages.add((Node)this.next_detail_header, 2, 0);
                this.previous_detail_header.setDisable(true);
            }
            this.header_detail_product_pane.setPrefWidth(widthDetailProductPane);
            int index_detail_header = 0;
            int column_detail_header = 0;
            int numberButtonsInLastpage = this.groupTabs.size() % this.NUMBER_G_SUB_OPTIONS_TAB;
            for (HeaderDetailProductButton headerButton : this.groupTabs) {
                if (this.groupTabs.size() >= 4 && index_detail_header == this.numberPageDetailProductHeader - 1 && numberButtonsInLastpage > 0 && numberButtonsInLastpage < this.NUMBER_G_SUB_OPTIONS_TAB) {
                    widthDetailProductTab = widthDetailProductPane / (double)numberButtonsInLastpage;
                }
                headerButton.setPrefHeight(heightDetailProductPane * 0.9);
                headerButton.setPrefWidth(widthDetailProductTab);
                this.headerDetailProductArray[index_detail_header].add((Node)headerButton, column_detail_header, 0);
                if (column_detail_header < this.NUMBER_G_SUB_OPTIONS_TAB - 1) {
                    ++column_detail_header;
                    continue;
                }
                ++index_detail_header;
                column_detail_header = 0;
            }
            if (this.numberPageDetailProductHeader > 0) {
                this.page_detail_product_header = 0;
                this.header_detail_product_pane.add((Node)this.headerDetailProductArray[this.page_detail_product_header], 0, 0);
            }
        }
    }

    public void nextHeaderTab() {
        if (this.page_detail_product_header < this.numberPageDetailProductHeader - 1) {
            ++this.page_detail_product_header;
            this.header_detail_product_pane.getChildren().clear();
            this.header_detail_product_pane.add((Node)this.headerDetailProductArray[this.page_detail_product_header], 0, 0);
            if (this.page_detail_product_header == this.numberPageDetailProductHeader - 1) {
                this.next_detail_header.setDisable(true);
            }
            this.previous_detail_header.setDisable(false);
            if (this.inDriveMode) {
                AppLocal.displayDualScreen.propagateClick("nextSubOptionHeaderTab", null);
            }
        }
    }

    public void previousHeaderTab() {
        if (this.page_detail_product_header > 0) {
            --this.page_detail_product_header;
            this.header_detail_product_pane.getChildren().clear();
            this.header_detail_product_pane.add((Node)this.headerDetailProductArray[this.page_detail_product_header], 0, 0);
            if (this.page_detail_product_header == 0) {
                this.previous_detail_header.setDisable(true);
            }
            this.next_detail_header.setDisable(false);
            if (this.inDriveMode) {
                AppLocal.displayDualScreen.propagateClick("previousSupOptionHeaderTab", null);
            }
        }
    }

    private void deselectHeaderTabs() {
        for (HeaderDetailProductButton headerButton : this.groupTabs) {
            headerButton.deselectSubOption();
        }
    }

    private void selectHeaderTab(HeaderDetailProductButton headerButton) {
        headerButton.select();
    }

    public int getIndex_group_option() {
        return this.index_group_option;
    }

    public void setIndex_group_option(int index_group_option) {
        this.index_group_option = index_group_option;
    }

    public OptionDetailProductButton getButtonOptionParent() {
        return this.buttonOptionParent;
    }

    public void setButtonOptionParent(OptionDetailProductButton buttonOptionParent) {
        this.buttonOptionParent = buttonOptionParent;
    }
}

