/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.components;

import com.openbravo.format.Formats;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.ItemOrderInfo;
import com.openbravo.pos.ticket.OptionItemOrder;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.ticket.ProductTicket;
import com.openbravo.pos.util.ImagesUtils;
import com.openbravo.pos.util.LogToFile;
import java.util.ArrayList;
import java.util.List;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.stage.Popup;

public class RecapOrderPopUp
extends Popup {
    private double height;
    private double width;
    private GridPane mainPane;
    private ProductInfoExt product;
    private double quantity;
    private List<OptionItemOrder> listSupplements;
    private List<ItemOrderInfo> listIngredients;
    private List<ProductTicket> listProducts;
    private ImagesUtils mImagesUtils;
    private String name_sizeProduct;
    private final String SIZE_IMAGE_64 = "_64px";
    private final String SIZE_IMAGE_128 = "_128px";
    private double priceProduct;
    private String style = "-fx-background-color: linear-gradient(from 0% 0% to 0% 100%, #906DEE 0%, #523E88 100%); -fx-border-color: #FFFFFF3D; -fx-background-radius: 12px; -fx-border-radius: 12px;";
    private String styleNameItem = "-fx-text-fill: white; -fx-font-weight: Normal; -fx-font-size: 12px;";
    private String stylePrice = "-fx-text-fill: white; -fx-font-weight: Normal; -fx-font-size: 12px;";
    private String styleButtonNextPrevious = "-fx-background-color: #FFFFFF1F;-fx-background-radius: 12px;";
    private int numberPage;
    private int page;
    private List<GridPane> detailLines;
    private int MAX_DETAIL_LINE_PER_PAGE = 10;
    private int MAX_DETAIL_LINE;
    private GridPane[] detailLinesPane;
    private GridPane detailLinesPages;
    private GridPane nextPreviousPane;
    private Button nextButton;
    private Button previousButton;
    private Image imageNext;
    private Image imagePrevious;
    private String comment;
    private EventHandler mEventHandlerNextAction = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            RecapOrderPopUp.this.nextPageDetailLine();
        }
    };
    private EventHandler mEventHandlerPreviousAction = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            RecapOrderPopUp.this.previousPageDetailLine();
        }
    };

    public RecapOrderPopUp(double height, double width) {
        try {
            this.height = height;
            this.width = width;
            this.mImagesUtils = new ImagesUtils();
            this.imagePrevious = new Image(((Object)((Object)this)).getClass().getResource("/com/openbravo/images/previous_item_product.png").toURI().toString(), 20.0, 20.0, false, false);
            this.imageNext = new Image(((Object)((Object)this)).getClass().getResource("/com/openbravo/images/next_item_product.png").toURI().toString(), 20.0, 20.0, false, false);
            this.mainPane = new GridPane();
            this.mainPane.setVgap(10.0);
            this.mainPane.setHgap(10.0);
            this.mainPane.setAlignment(Pos.TOP_CENTER);
            this.mainPane.setPrefHeight(height);
            this.mainPane.setPrefWidth(width);
            this.mainPane.setStyle(this.style);
            this.mainPane.setOnMouseClicked(event -> this.hide());
            this.getContent().add((Object)this.mainPane);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void init(ProductInfoExt product, double priceProduct, double quantity, String name_sizeProduct, List<OptionItemOrder> listSupplements, List<ItemOrderInfo> listIngredients, List<ProductTicket> listProducts, String comment) {
        try {
            this.product = product;
            this.quantity = quantity;
            this.name_sizeProduct = name_sizeProduct;
            this.listSupplements = listSupplements;
            this.listIngredients = listIngredients;
            this.listProducts = listProducts;
            this.priceProduct = priceProduct;
            this.comment = comment;
            this.addDetailLine();
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void addDetailLine() {
        if (this.detailLines == null) {
            this.detailLines = new ArrayList<GridPane>();
        } else {
            this.detailLines.clear();
        }
        boolean row = false;
        GridPane linePane = this.addProduct();
        this.detailLines.add(linePane);
        if (this.comment != null && !this.comment.isEmpty()) {
            GridPane commentPane = this.addComment();
            this.detailLines.add(commentPane);
        }
        for (ItemOrderInfo ingredient : this.listIngredients) {
            if (ingredient.getIdCarte() != 0 && ingredient.getIdCarte() != -1 || ingredient.getIdProduct() != 0 && ingredient.getIdProduct() != -1) continue;
            GridPane lineIngredientPane = this.addIngredient(ingredient);
            this.detailLines.add(lineIngredientPane);
        }
        for (OptionItemOrder supplement : this.listSupplements) {
            if (supplement.getIdCarte() != 0 && supplement.getIdCarte() != -1 || supplement.getIdProduct() != 0 && supplement.getIdProduct() != -1) continue;
            GridPane lineSupplement = this.addSupplement(supplement);
            this.detailLines.add(lineSupplement);
        }
        for (ProductTicket subProduct : this.listProducts) {
            GridPane lineSubProduct = this.addSubProduct(subProduct);
            this.detailLines.add(lineSubProduct);
            for (ItemOrderInfo ingredient : this.listIngredients) {
                if (ingredient.getIdCarte() != subProduct.getIdCarte() || ingredient.getIdProduct() != subProduct.getIdProduct() || ingredient.getIndex_carte() != subProduct.getIndex_carte()) continue;
                GridPane lineIngredientPane = this.addIngredient(ingredient);
                this.detailLines.add(lineIngredientPane);
            }
            for (OptionItemOrder supplement : this.listSupplements) {
                if (supplement.getIdCarte() != subProduct.getIdCarte() || supplement.getIdProduct() != subProduct.getIdProduct() || supplement.getIndex_carte() != subProduct.getIndex_carte()) continue;
                GridPane lineSupplement = this.addSupplement(supplement);
                this.detailLines.add(lineSupplement);
            }
        }
        this.buildPane();
    }

    private GridPane addProduct() {
        GridPane linePane = new GridPane();
        linePane.setPrefHeight(this.height * 0.1);
        linePane.setPrefWidth(this.width);
        Label labelImage = new Label();
        labelImage.setPrefHeight(linePane.getPrefHeight() * 0.8);
        labelImage.setPrefWidth(linePane.getPrefWidth() * 0.2);
        labelImage.setAlignment(Pos.CENTER);
        Image image = this.mImagesUtils.getImageProduct(this.product, AppLocal.refProducts, "_128px", false);
        if (image != null) {
            ImageView imageItem = new ImageView(image);
            imageItem.setFitHeight(50.0);
            imageItem.setFitWidth(50.0);
            imageItem.setPreserveRatio(false);
            imageItem.setSmooth(false);
            labelImage.setGraphic((Node)imageItem);
        }
        Label nameProductLabel = new Label();
        nameProductLabel.setWrapText(true);
        nameProductLabel.setStyle(this.styleNameItem);
        nameProductLabel.setAlignment(Pos.CENTER_LEFT);
        StringBuilder name = new StringBuilder();
        name.append(this.printMultiply(this.quantity)).append(" x ");
        name.append(this.product.getDisplayedName());
        if (this.name_sizeProduct != null && !this.name_sizeProduct.isEmpty()) {
            name.append(" - ").append(this.name_sizeProduct);
        }
        nameProductLabel.setText(name.toString());
        nameProductLabel.setPrefHeight(linePane.getPrefHeight() * 0.8);
        nameProductLabel.setPrefWidth(linePane.getPrefWidth() * 0.6);
        Label labelPrice = new Label();
        labelPrice.setAlignment(Pos.CENTER);
        labelPrice.setStyle(this.stylePrice);
        labelPrice.setPrefHeight(linePane.getPrefHeight() * 0.8);
        labelPrice.setPrefWidth(linePane.getPrefWidth() * 0.2);
        labelPrice.setText(Formats.CURRENCY.formatValue(this.priceProduct));
        linePane.add((Node)labelImage, 0, 0);
        linePane.add((Node)nameProductLabel, 1, 0);
        linePane.add((Node)labelPrice, 2, 0);
        return linePane;
    }

    private GridPane addSupplement(OptionItemOrder supplement) {
        GridPane supplementPane = new GridPane();
        supplementPane.setPrefHeight(this.height * 0.1);
        supplementPane.setPrefWidth(this.width);
        Label labelImage = new Label();
        labelImage.setPrefHeight(supplementPane.getPrefHeight() * 0.8);
        labelImage.setPrefWidth(supplementPane.getPrefWidth() * 0.2);
        labelImage.setAlignment(Pos.CENTER);
        Image image = supplement.getImageSupplement();
        if (image != null) {
            ImageView imageItem = new ImageView(image);
            imageItem.setFitHeight(50.0);
            imageItem.setFitWidth(50.0);
            imageItem.setPreserveRatio(false);
            imageItem.setSmooth(false);
            labelImage.setGraphic((Node)imageItem);
        }
        Label nameSupplementLabel = new Label();
        nameSupplementLabel.setWrapText(true);
        nameSupplementLabel.setStyle(this.styleNameItem);
        nameSupplementLabel.setAlignment(Pos.CENTER_LEFT);
        StringBuilder name = new StringBuilder();
        name.append(supplement.getNumberOption()).append(" x ");
        name.append(supplement.getNameSupplement());
        nameSupplementLabel.setText(name.toString());
        nameSupplementLabel.setPrefHeight(supplementPane.getPrefHeight() * 0.8);
        nameSupplementLabel.setPrefWidth(supplementPane.getPrefWidth() * 0.6);
        supplementPane.add((Node)labelImage, 0, 0);
        supplementPane.add((Node)nameSupplementLabel, 1, 0);
        if (supplement.getPrice() != 0.0) {
            Label labelPrice = new Label();
            labelPrice.setAlignment(Pos.CENTER);
            labelPrice.setStyle(this.stylePrice);
            labelPrice.setPrefHeight(supplementPane.getPrefHeight() * 0.8);
            labelPrice.setPrefWidth(supplementPane.getPrefWidth() * 0.2);
            labelPrice.setText(Formats.CURRENCY.formatValue(supplement.getPrice()));
            supplementPane.add((Node)labelPrice, 2, 0);
        }
        return supplementPane;
    }

    private GridPane addIngredient(ItemOrderInfo ingredient) {
        GridPane ingredientPane = new GridPane();
        ingredientPane.setPrefHeight(this.height * 0.1);
        ingredientPane.setPrefWidth(this.width);
        Label labelImage = new Label();
        labelImage.setPrefHeight(ingredientPane.getPrefHeight() * 0.8);
        labelImage.setPrefWidth(ingredientPane.getPrefWidth() * 0.2);
        labelImage.setAlignment(Pos.CENTER);
        Image image = ingredient.getImageIngredient();
        if (image != null) {
            ImageView imageItem = new ImageView(image);
            imageItem.setFitHeight(50.0);
            imageItem.setFitWidth(50.0);
            imageItem.setPreserveRatio(false);
            imageItem.setSmooth(false);
            labelImage.setGraphic((Node)imageItem);
        }
        Label nameIngredientLabel = new Label();
        nameIngredientLabel.setWrapText(true);
        nameIngredientLabel.setStyle(this.styleNameItem);
        nameIngredientLabel.setAlignment(Pos.CENTER_LEFT);
        nameIngredientLabel.setText(" " + AppLocal.getIntString("Label.without") + " " + ingredient.getNameSupplement().toUpperCase());
        nameIngredientLabel.setPrefHeight(ingredientPane.getPrefHeight() * 0.8);
        nameIngredientLabel.setPrefWidth(ingredientPane.getPrefWidth() * 0.6);
        ingredientPane.add((Node)labelImage, 0, 0);
        ingredientPane.add((Node)nameIngredientLabel, 1, 0);
        return ingredientPane;
    }

    private GridPane addSubProduct(ProductTicket subProduct) {
        GridPane supplementPane = new GridPane();
        supplementPane.setPrefHeight(this.height * 0.1);
        supplementPane.setPrefWidth(this.width);
        Label labelImage = new Label();
        labelImage.setPrefHeight(supplementPane.getPrefHeight() * 0.8);
        labelImage.setPrefWidth(supplementPane.getPrefWidth() * 0.2);
        labelImage.setAlignment(Pos.CENTER);
        Image image = subProduct.getImageProduct();
        if (image != null) {
            ImageView imageItem = new ImageView(image);
            imageItem.setFitHeight(50.0);
            imageItem.setFitWidth(50.0);
            imageItem.setPreserveRatio(false);
            imageItem.setSmooth(false);
            labelImage.setGraphic((Node)imageItem);
        }
        Label nameSupplementLabel = new Label();
        nameSupplementLabel.setWrapText(true);
        nameSupplementLabel.setStyle(this.styleNameItem);
        nameSupplementLabel.setAlignment(Pos.CENTER_LEFT);
        StringBuilder name = new StringBuilder();
        name.append(subProduct.getNumberProduct()).append(" x ");
        name.append(subProduct.getNameProduct());
        nameSupplementLabel.setText(name.toString());
        nameSupplementLabel.setPrefHeight(supplementPane.getPrefHeight() * 0.8);
        nameSupplementLabel.setPrefWidth(supplementPane.getPrefWidth() * 0.6);
        supplementPane.add((Node)labelImage, 0, 0);
        supplementPane.add((Node)nameSupplementLabel, 1, 0);
        if (subProduct.getPriceProduct() != 0.0) {
            Label labelPrice = new Label();
            labelPrice.setAlignment(Pos.CENTER);
            labelPrice.setStyle(this.stylePrice);
            labelPrice.setPrefHeight(supplementPane.getPrefHeight() * 0.8);
            labelPrice.setPrefWidth(supplementPane.getPrefWidth() * 0.2);
            labelPrice.setText(Formats.CURRENCY.formatValue(subProduct.getPriceProduct()));
            supplementPane.add((Node)labelPrice, 2, 0);
        }
        return supplementPane;
    }

    public String printMultiply(double quantity) {
        if (quantity == (double)Math.round(quantity)) {
            return Formats.INT.formatValue(quantity);
        }
        return Formats.DOUBLE.formatValue(quantity);
    }

    private void buildPane() {
        if (this.detailLinesPages == null) {
            this.detailLinesPages = new GridPane();
            this.detailLinesPages.setPrefWidth(this.mainPane.getPrefWidth());
        } else {
            this.detailLinesPages.getChildren().clear();
        }
        this.numberPage = (int)Math.ceil((double)this.detailLines.size() / (double)this.MAX_DETAIL_LINE_PER_PAGE);
        System.out.println("numberPage : " + this.numberPage);
        this.MAX_DETAIL_LINE = this.numberPage > 1 ? this.MAX_DETAIL_LINE_PER_PAGE - 1 : this.MAX_DETAIL_LINE_PER_PAGE;
        System.out.println("MAX_DETAIL_LINE : " + this.MAX_DETAIL_LINE);
        this.detailLinesPane = new GridPane[this.numberPage];
        this.mainPane.getChildren().clear();
        if (this.numberPage > 1) {
            this.addNextPreviousPane();
            this.detailLinesPages.setPrefHeight(this.mainPane.getPrefHeight() * 0.9);
            this.mainPane.add((Node)this.detailLinesPages, 0, 0);
            this.mainPane.add((Node)this.nextPreviousPane, 0, 1);
        } else {
            this.detailLinesPages.setPrefHeight(this.mainPane.getPrefHeight());
            this.mainPane.add((Node)this.detailLinesPages, 0, 0);
        }
        for (int i = 0; i < this.detailLinesPane.length; ++i) {
            this.detailLinesPane[i] = new GridPane();
            this.detailLinesPane[i].setVgap(5.0);
            this.detailLinesPane[i].setHgap(5.0);
            this.detailLinesPane[i].setAlignment(Pos.CENTER);
        }
        int index = 0;
        int row = 0;
        for (GridPane detailLine : this.detailLines) {
            this.detailLinesPane[index].add((Node)detailLine, 0, row);
            if (row < this.MAX_DETAIL_LINE - 1) {
                ++row;
                continue;
            }
            ++index;
            row = 0;
        }
        if (this.numberPage > 0) {
            this.page = 0;
            this.detailLinesPages.add((Node)this.detailLinesPane[this.page], 0, 0);
        }
        if (this.previousButton != null) {
            this.previousButton.setDisable(true);
        }
    }

    private void addNextPreviousPane() {
        if (this.nextPreviousPane == null) {
            this.nextPreviousPane = new GridPane();
            this.nextPreviousPane.setVgap(5.0);
            this.nextPreviousPane.setHgap(5.0);
            this.nextPreviousPane.setAlignment(Pos.CENTER);
            this.nextPreviousPane.setPrefHeight(this.mainPane.getPrefHeight() * 0.1);
            this.nextPreviousPane.setPrefWidth(this.mainPane.getPrefWidth());
            if (this.nextButton == null) {
                this.nextButton = new Button();
                this.nextButton.setAlignment(Pos.CENTER);
                this.nextButton.setGraphic((Node)new ImageView(this.imageNext));
                this.nextButton.setStyle(this.styleButtonNextPrevious);
                this.nextButton.setPrefWidth(this.nextPreviousPane.getPrefWidth() * 0.45);
                this.nextButton.setPrefHeight(this.nextPreviousPane.getPrefHeight() * 0.8);
                this.nextButton.setOnAction(this.mEventHandlerNextAction);
            }
            if (this.previousButton == null) {
                this.previousButton = new Button();
                this.previousButton.setAlignment(Pos.CENTER);
                this.previousButton.setGraphic((Node)new ImageView(this.imagePrevious));
                this.previousButton.setStyle(this.styleButtonNextPrevious);
                this.previousButton.setPrefWidth(this.nextPreviousPane.getPrefWidth() * 0.45);
                this.previousButton.setPrefHeight(this.nextPreviousPane.getPrefHeight() * 0.8);
                this.previousButton.setOnAction(this.mEventHandlerPreviousAction);
            }
            this.nextPreviousPane.add((Node)this.previousButton, 0, 0);
            this.nextPreviousPane.add((Node)this.nextButton, 1, 0);
        }
    }

    public void nextPageDetailLine() {
        System.out.println("page : " + this.page);
        System.out.println("numberPage : " + this.numberPage);
        if (this.page < this.numberPage - 1) {
            System.out.println("next 1 ");
            ++this.page;
            this.detailLinesPages.getChildren().clear();
            this.detailLinesPages.add((Node)this.detailLinesPane[this.page], 0, 0);
            if (this.page == this.numberPage - 1) {
                this.nextButton.setDisable(true);
            }
            this.previousButton.setDisable(false);
        }
    }

    public void previousPageDetailLine() {
        if (this.page > 0) {
            --this.page;
            this.detailLinesPages.getChildren().clear();
            this.detailLinesPages.add((Node)this.detailLinesPane[this.page], 0, 0);
            if (this.page == 0) {
                this.previousButton.setDisable(true);
            }
            this.nextButton.setDisable(false);
        }
    }

    private GridPane addComment() {
        GridPane commentPane = new GridPane();
        commentPane.setPrefHeight(this.height * 0.1);
        commentPane.setPrefWidth(this.width);
        Label commentLabel = new Label();
        commentLabel.setStyle(this.styleNameItem);
        commentLabel.setText("Commentaire : " + this.comment);
        commentLabel.setPrefHeight(commentPane.getPrefHeight() * 0.8);
        commentLabel.setPrefWidth(commentPane.getPrefWidth() * 0.9);
        commentPane.add((Node)commentLabel, 2, 0);
        return commentPane;
    }
}

