/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.components;

import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Text;

public class ProgressIndicatorBar
extends StackPane {
    private final ReadOnlyDoubleProperty workDone;
    private final double maxTotal;
    private double currentTotal;
    private final ProgressBar bar = new ProgressBar();
    private final Text text = new Text();
    private final String labelFormatSpecifier;
    private static final int DEFAULT_LABEL_PADDING = 5;
    private String barStyleClass = "";
    private boolean has_animation = false;

    public ProgressIndicatorBar(ReadOnlyDoubleProperty workDone, double maxTotal, String labelFormatSpecifier) {
        this.workDone = workDone;
        this.maxTotal = maxTotal;
        this.labelFormatSpecifier = labelFormatSpecifier;
    }

    public ProgressIndicatorBar(ReadOnlyDoubleProperty workDone, double maxTotal, String labelFormatSpecifier, String barStyleClass) {
        this(workDone, maxTotal, labelFormatSpecifier);
        this.barStyleClass = barStyleClass;
    }

    public ProgressIndicatorBar(ReadOnlyDoubleProperty workDone, double maxTotal, String labelFormatSpecifier, String barStyleClass, boolean has_animation) {
        this(workDone, maxTotal, labelFormatSpecifier, barStyleClass);
        this.has_animation = has_animation;
    }

    public ProgressIndicatorBar(double maxTotal, double currentTotal, String labelFormatSpecifier, String barStyleClass) {
        this(null, maxTotal, labelFormatSpecifier, barStyleClass);
        this.currentTotal = currentTotal;
    }

    public void init() {
        this.updateBarStyle();
        if (this.has_animation) {
            this.syncProgress();
            if (this.workDone != null) {
                this.workDone.addListener((ChangeListener)new ChangeListener<Number>(){

                    public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
                        ProgressIndicatorBar.this.syncProgress();
                    }
                });
            }
        } else {
            this.showValueProgress();
        }
        this.bar.setMaxWidth(Double.MAX_VALUE);
        this.getChildren().setAll((Object[])new Node[]{this.bar, this.text});
    }

    public void updateBarStyle() {
        if (!this.barStyleClass.equals("")) {
            this.bar.getStyleClass().add((Object)this.barStyleClass);
        }
    }

    public void setBarStyleClass(String barStyleClass) {
        this.barStyleClass = barStyleClass;
    }

    private void showValueProgress() {
        if (this.maxTotal == 0.0 || this.currentTotal == 0.0) {
            this.text.setText("");
            this.bar.setProgress(-1.0);
        } else {
            this.text.setText(String.format(this.labelFormatSpecifier, Math.ceil(this.currentTotal)));
            this.bar.setProgress(this.currentTotal / this.maxTotal);
        }
        this.bar.setMinHeight(this.text.getBoundsInLocal().getHeight() + 10.0);
        this.bar.setMinWidth(this.text.getBoundsInLocal().getWidth() + 10.0);
    }

    private void syncProgress() {
        if (this.workDone == null || this.maxTotal == 0.0) {
            this.text.setText("");
            this.bar.setProgress(-1.0);
        } else {
            this.text.setText(String.format(this.labelFormatSpecifier, Math.ceil(this.workDone.get())));
            this.bar.setProgress(this.workDone.get() / this.maxTotal);
        }
        this.bar.setMinHeight(this.text.getBoundsInLocal().getHeight() + 10.0);
        this.bar.setMinWidth(this.text.getBoundsInLocal().getWidth() + 10.0);
    }
}

