/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.components;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

public class ProgressBarCustomized {
    private JDialog dialogueProgressBar;
    private JProgressBar pb;
    private JLabel titleLabel;
    public static final int CENTER_BOTTOM = 1;
    public static final int CENTER = 0;
    public static final int CENTER_TOP = 2;

    public ProgressBarCustomized(String title) {
        this.initializer(title, 0);
    }

    public ProgressBarCustomized(String title, int position) {
        this.initializer(title, position);
    }

    public JDialog getDialogueProgressBar() {
        return this.dialogueProgressBar;
    }

    public void setDialogueProgressBar(JDialog dialogueProgressBar) {
        this.dialogueProgressBar = dialogueProgressBar;
    }

    public JProgressBar getPb() {
        return this.pb;
    }

    public void setPb(JProgressBar pb) {
        this.pb = pb;
    }

    public JLabel getTitleLabel() {
        return this.titleLabel;
    }

    public void setTitleLabel(JLabel title) {
        this.titleLabel = title;
    }

    private void initializer(String title, int position) {
        this.dialogueProgressBar = new JDialog();
        this.dialogueProgressBar.setUndecorated(true);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        this.dialogueProgressBar.setSize(710, 80);
        this.dialogueProgressBar.getContentPane().setBackground(new Color(250, 190, 88));
        Dimension screenSize = toolkit.getScreenSize();
        int x = (screenSize.width - this.dialogueProgressBar.getWidth()) / 2;
        int y = 0;
        switch (position) {
            case 0: {
                y = (screenSize.height - this.dialogueProgressBar.getHeight()) / 2;
                break;
            }
            case 1: {
                y = screenSize.height - this.dialogueProgressBar.getHeight() * 2;
                break;
            }
            case 2: {
                y = this.dialogueProgressBar.getHeight();
            }
        }
        this.dialogueProgressBar.setLocation(x, y);
        this.pb = new JProgressBar();
        this.titleLabel = new JLabel(title);
        this.titleLabel.setHorizontalAlignment(0);
        this.pb.setMinimum(0);
        this.pb.setMaximum(100);
        this.pb.setStringPainted(true);
        this.pb.setBackground(Color.GREEN);
        FlowLayout layout = new FlowLayout();
        layout.setAlignment(1);
        this.dialogueProgressBar.setLayout(layout);
        this.dialogueProgressBar.setAlwaysOnTop(true);
        this.dialogueProgressBar.getContentPane().add(this.titleLabel);
        this.dialogueProgressBar.getContentPane().add(this.pb);
        this.pb.setPreferredSize(new Dimension(700, 30));
        this.titleLabel.setPreferredSize(new Dimension(700, 30));
        this.dialogueProgressBar.setVisible(true);
        int currentValue = 0;
        this.pb.setValue(currentValue);
    }
}

