/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.components;

import com.openbravo.components.SwitchButton;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.service.ItemService;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.text.TextAlignment;

public class ProductStockPane
extends GridPane {
    private double width;
    private double height;
    private GridPane pane_switch_product;
    private GridPane pane_switch_product_borne;
    private GridPane pane_switch_product_online;
    private GridPane pane_switch_product_platform;
    private GridPane pane_product_deactive;
    private GridPane pane_on_off_borne;
    private GridPane pane_product;
    private GridPane pane_on_off;
    private GridPane pane_on_off_online;
    private GridPane pane_on_off_platform;
    private ProductInfoExt product;
    private ItemService mItemService;
    private SwitchButton mSwitchButton;
    private SwitchButton mSwitchButtonOnline;
    private SwitchButton mSwitchButtonBorne;
    private SwitchButton mSwitchButtonPlatform;
    private Button button_sold_out_temporary;
    private Label label_product_deactive;
    private Label label_product_sold_out;
    private Label label_on_off_borne;
    private Label label_on_off_online;
    private Label label_on_off_platform;
    private EventHandler mEventHandlerClickSwitchOnline = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            if (ProductStockPane.this.mSwitchButtonOnline.isState()) {
                ProductStockPane.this.mSwitchButtonOnline.setOff();
                ProductStockPane.this.setHiddenOnline(true);
            } else {
                ProductStockPane.this.mSwitchButtonOnline.setOn();
                ProductStockPane.this.setHiddenOnline(false);
            }
        }
    };
    private EventHandler mEventHandlerClickSwitchBorne = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            if (ProductStockPane.this.mSwitchButtonBorne.isState()) {
                ProductStockPane.this.mSwitchButtonBorne.setOff();
                ProductStockPane.this.setHiddenBorne(true);
            } else {
                ProductStockPane.this.mSwitchButtonBorne.setOn();
                ProductStockPane.this.setHiddenBorne(false);
            }
        }
    };
    private EventHandler mEventHandlerClickSwitchPlatform = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            if (ProductStockPane.this.mSwitchButtonPlatform.isState()) {
                ProductStockPane.this.mSwitchButtonPlatform.setOff();
                ProductStockPane.this.setHiddenPlatform(true);
            } else {
                ProductStockPane.this.mSwitchButtonPlatform.setOn();
                ProductStockPane.this.setHiddenPlatform(false);
            }
        }
    };

    public ProductStockPane(ProductInfoExt product, double height, double width) {
        this.width = width;
        this.height = height;
        this.product = product;
        this.mItemService = ItemService.getInstance();
        this.setAlignment(Pos.CENTER);
        this.addPanesSwitch();
    }

    public void setOffProduct() {
        this.setOffSwitchButtons();
        this.setOff();
        this.setSoldOut(true);
    }

    private void setOffSwitchButtons() {
        this.mSwitchButton.setOff();
        if (this.mSwitchButtonBorne != null) {
            this.mSwitchButtonBorne.setOff();
        }
        if (this.mSwitchButtonOnline != null) {
            this.mSwitchButtonOnline.setOff();
        }
        if (this.mSwitchButtonPlatform != null) {
            this.mSwitchButtonPlatform.setOff();
        }
    }

    public void setOnSwithButtons() {
        this.mSwitchButton.setOn();
        if (this.mSwitchButtonBorne != null) {
            this.mSwitchButtonBorne.setOn();
        }
        if (this.mSwitchButtonOnline != null) {
            this.mSwitchButtonOnline.setOn();
        }
        if (this.mSwitchButtonPlatform != null) {
            this.mSwitchButtonPlatform.setOn();
        }
    }

    private void setOff() {
        this.getChildren().clear();
        if (AppLocal.MODEL_CAISSE != null && AppLocal.MODEL_CAISSE.equalsIgnoreCase("Maitre")) {
            this.add((Node)this.pane_product, 0, 1);
            if (this.product.isSold_out_temporary()) {
                this.add((Node)this.pane_product_deactive, 0, 2);
            }
        } else if (this.product.isSold_out_temporary()) {
            this.add((Node)this.pane_product_deactive, 0, 0);
        } else {
            this.label_product_sold_out.setText(AppLocal.getIntString("Text.disabled.product"));
            this.add((Node)this.pane_product, 0, 0);
        }
    }

    private void addPanesSwitch() {
        this.pane_product = new GridPane();
        this.pane_product.setAlignment(Pos.CENTER);
        this.pane_product.setVgap(5.0);
        this.pane_product.setHgap(5.0);
        this.pane_product.setPrefHeight(this.height * 0.2);
        this.pane_product.setPrefWidth(this.width * 0.7);
        this.pane_product.setAlignment(Pos.CENTER);
        this.label_product_sold_out = new Label();
        this.label_product_sold_out.setWrapText(true);
        this.label_product_sold_out.setAlignment(Pos.CENTER);
        this.label_product_sold_out.setStyle("-fx-text-fill: white;-fx-font-size: 18pt;");
        this.label_product_sold_out.setPrefHeight(this.pane_product.getPrefHeight());
        this.pane_switch_product = new GridPane();
        this.pane_switch_product.setAlignment(Pos.CENTER);
        this.pane_switch_product.setPrefHeight(this.pane_product.getPrefHeight());
        this.pane_product.add((Node)this.label_product_sold_out, 0, 0);
        this.pane_product.add((Node)this.pane_switch_product, 1, 0);
        this.pane_on_off = new GridPane();
        this.pane_on_off.setAlignment(Pos.CENTER);
        this.pane_on_off.setPrefHeight(this.height * 0.55);
        this.pane_on_off.setPrefWidth(this.width * 0.7);
        this.pane_on_off_borne = new GridPane();
        this.pane_on_off_borne.setAlignment(Pos.TOP_CENTER);
        this.pane_on_off_borne.setVgap(5.0);
        this.pane_on_off_borne.setHgap(5.0);
        this.pane_on_off_borne.setPrefHeight(this.pane_on_off.getPrefHeight());
        this.pane_on_off_borne.setPrefWidth(this.pane_on_off.getPrefWidth() * 0.25);
        this.pane_on_off_borne.setAlignment(Pos.CENTER);
        this.label_on_off_borne = new Label();
        this.label_on_off_borne.setAlignment(Pos.CENTER);
        this.label_on_off_borne.setStyle("-fx-text-fill: white;-fx-font-size: 18pt;");
        this.label_on_off_borne.setPrefHeight(this.pane_on_off_borne.getPrefHeight() * 0.2);
        this.label_on_off_borne.setPrefWidth(this.pane_on_off_borne.getPrefWidth());
        this.pane_switch_product_borne = new GridPane();
        this.pane_switch_product_borne.setAlignment(Pos.CENTER);
        this.pane_switch_product_borne.setPrefHeight(this.pane_on_off_borne.getPrefHeight() * 0.2);
        this.pane_switch_product_borne.setPrefWidth(this.pane_on_off_borne.getPrefWidth());
        this.pane_on_off_borne.add((Node)this.label_on_off_borne, 0, 0);
        this.pane_on_off_borne.add((Node)this.pane_switch_product_borne, 0, 1);
        this.pane_on_off_online = new GridPane();
        this.pane_on_off_online.setAlignment(Pos.TOP_CENTER);
        this.pane_on_off_online.setVgap(5.0);
        this.pane_on_off_online.setHgap(5.0);
        this.pane_on_off_online.setPrefHeight(this.pane_on_off.getPrefHeight());
        this.pane_on_off_online.setPrefWidth(this.pane_on_off.getPrefWidth() * 0.25);
        this.pane_on_off_online.setAlignment(Pos.CENTER);
        this.label_on_off_online = new Label();
        this.label_on_off_online.setAlignment(Pos.CENTER);
        this.label_on_off_online.setStyle("-fx-text-fill: white;-fx-font-size: 18pt;");
        this.label_on_off_online.setPrefHeight(this.pane_on_off_online.getPrefHeight() * 0.2);
        this.label_on_off_online.setPrefWidth(this.pane_on_off_online.getPrefWidth());
        this.pane_switch_product_online = new GridPane();
        this.pane_switch_product_online.setAlignment(Pos.CENTER);
        this.pane_switch_product_online.setPrefHeight(this.pane_on_off_online.getPrefHeight() * 0.2);
        this.pane_switch_product_online.setPrefWidth(this.pane_on_off_online.getPrefWidth());
        this.pane_on_off_online.add((Node)this.label_on_off_online, 0, 0);
        this.pane_on_off_online.add((Node)this.pane_switch_product_online, 0, 1);
        this.pane_on_off_platform = new GridPane();
        this.pane_on_off_platform.setAlignment(Pos.TOP_CENTER);
        this.pane_on_off_platform.setVgap(5.0);
        this.pane_on_off_platform.setHgap(5.0);
        this.pane_on_off_platform.setPrefHeight(this.pane_on_off.getPrefHeight());
        this.pane_on_off_platform.setPrefWidth(this.pane_on_off.getPrefWidth() * 0.25);
        this.pane_on_off_platform.setAlignment(Pos.CENTER);
        this.label_on_off_platform = new Label();
        this.label_on_off_platform.setAlignment(Pos.CENTER);
        this.label_on_off_platform.setStyle("-fx-text-fill: white;-fx-font-size: 18pt;");
        this.label_on_off_platform.setPrefHeight(this.pane_on_off_platform.getPrefHeight() * 0.2);
        this.label_on_off_platform.setPrefWidth(this.pane_on_off_platform.getPrefWidth());
        this.pane_switch_product_platform = new GridPane();
        this.pane_switch_product_platform.setAlignment(Pos.CENTER);
        this.pane_switch_product_platform.setPrefHeight(this.pane_on_off_platform.getPrefHeight() * 0.2);
        this.pane_switch_product_platform.setPrefWidth(this.pane_on_off_platform.getPrefWidth());
        this.pane_on_off_platform.add((Node)this.label_on_off_platform, 0, 0);
        this.pane_on_off_platform.add((Node)this.pane_switch_product_platform, 0, 1);
        this.pane_on_off.add((Node)this.pane_on_off_borne, 0, 0);
        this.pane_on_off.add((Node)this.pane_on_off_online, 1, 0);
        this.pane_on_off.add((Node)this.pane_on_off_platform, 2, 0);
        this.button_sold_out_temporary = new Button();
        this.button_sold_out_temporary.setAlignment(Pos.CENTER);
        this.button_sold_out_temporary.setPrefWidth(this.width * 0.7);
        this.button_sold_out_temporary.setPrefHeight(this.height * 0.15);
        this.button_sold_out_temporary.setStyle("-fx-background-color: #e1b210;-fx-font-size: 16pt;");
        this.pane_product_deactive = new GridPane();
        this.pane_product_deactive.setAlignment(Pos.CENTER);
        this.pane_product_deactive.setPrefWidth(this.width * 0.7);
        this.pane_product_deactive.setPrefHeight(this.height * 0.15);
        this.label_product_deactive = new Label();
        this.label_product_deactive.setAlignment(Pos.CENTER);
        this.label_product_deactive.setWrapText(true);
        this.label_product_deactive.setPrefHeight(this.pane_product_deactive.getPrefHeight());
        this.label_product_deactive.setPrefWidth(this.pane_product_deactive.getPrefWidth() * 0.4);
        this.label_product_deactive.setStyle("-fx-text-fill: white;-fx-background-color: #fb3e3e;-fx-font-size: 16pt;");
        this.pane_product_deactive.add((Node)this.label_product_deactive, 0, 0);
        this.add((Node)this.pane_product, 0, 0);
        this.add((Node)this.pane_on_off, 0, 1);
        this.add((Node)this.button_sold_out_temporary, 0, 2);
        double width_switch = 70.0;
        this.mSwitchButton = new SwitchButton(width_switch, width_switch * 0.5);
        this.pane_switch_product.add((Node)this.mSwitchButton, 0, 0);
        this.mSwitchButtonBorne = new SwitchButton(width_switch, width_switch * 0.5);
        this.mSwitchButtonBorne.setOnMouseClicked(this.mEventHandlerClickSwitchBorne);
        this.mSwitchButtonBorne.getButton().setOnMouseClicked(this.mEventHandlerClickSwitchBorne);
        this.checkHiddenBorne();
        this.pane_switch_product_borne.add((Node)this.mSwitchButtonBorne, 0, 0);
        if (AppLocal.ORDER_ONLINE_ENABLED && AppLocal.SUIVI_ONLINE_ORDER) {
            this.mSwitchButtonOnline = new SwitchButton(width_switch, width_switch * 0.5);
            this.mSwitchButtonOnline.setOnMouseClicked(this.mEventHandlerClickSwitchOnline);
            this.mSwitchButtonOnline.getButton().setOnMouseClicked(this.mEventHandlerClickSwitchOnline);
            this.checkHiddenOnline();
            this.pane_switch_product_online.add((Node)this.mSwitchButtonOnline, 0, 0);
        }
        if (AppLocal.MODULE_UBER_EATS || AppLocal.MODULE_DELIVERO) {
            this.mSwitchButtonPlatform = new SwitchButton(width_switch, width_switch * 0.5);
            this.mSwitchButtonPlatform.setOnMouseClicked(this.mEventHandlerClickSwitchPlatform);
            this.mSwitchButtonPlatform.getButton().setOnMouseClicked(this.mEventHandlerClickSwitchPlatform);
            this.checkHiddenPlatform();
            this.pane_switch_product_platform.add((Node)this.mSwitchButtonPlatform, 0, 0);
        }
        this.label_on_off_platform.setText("Platform");
        this.label_on_off_borne.setText(AppLocal.getIntString("Label.borne"));
        this.label_on_off_online.setText(AppLocal.getIntString("Label.website"));
        this.label_product_deactive.setText(AppLocal.getIntString("Label.product.deactive"));
        this.button_sold_out_temporary.setText(AppLocal.getIntString("Text.deactivate.product"));
        this.label_product_sold_out.setText(this.product.getName());
        this.label_product_deactive.setTextAlignment(TextAlignment.CENTER);
    }

    public void setHiddenOnline(boolean hidden_online) {
        if (hidden_online) {
            this.mItemService.setHiddenOnline(this.product.getID(), hidden_online);
        } else {
            this.mItemService.setHiddenOnlineTemporary(this.product.getID(), hidden_online);
            this.product.setHidden_online_temporary(hidden_online);
        }
        this.product.setHidden_online(hidden_online);
        AppLocal.product_management = true;
        this.mItemService.sychroniseItem(this.product, false, true);
    }

    public void setHiddenBorne(boolean hidden_borne) {
        if (hidden_borne) {
            this.mItemService.setHiddenBorne(this.product.getID(), hidden_borne);
        } else {
            this.mItemService.setHiddenBorneTemporary(this.product.getID(), hidden_borne);
            this.product.setHidden_borne_temporary(hidden_borne);
        }
        this.product.setHidden_borne(hidden_borne);
        AppLocal.product_management = true;
        this.mItemService.sychroniseItem(this.product, true, false);
    }

    public void setHiddenPlatform(boolean hidden_platform) {
        if (hidden_platform) {
            this.mItemService.setHiddenPlatform(this.product.getID(), hidden_platform);
        } else {
            this.mItemService.setHiddenUberEatsTemporary(this.product.getID(), hidden_platform);
            this.product.setHidden_ubereat_temporary(hidden_platform);
        }
        this.product.setHidden_platform(hidden_platform);
        AppLocal.product_management = true;
        this.mItemService.uploadItemsPlatform(this.product.getID(), hidden_platform, false);
    }

    private void checkHiddenOnline() {
        if (this.product.isHidden_online()) {
            this.mSwitchButtonOnline.setOff();
        } else {
            this.mSwitchButtonOnline.setOn();
        }
    }

    private void checkHiddenBorne() {
        if (this.product.isHidden_borne()) {
            this.mSwitchButtonBorne.setOff();
        } else {
            this.mSwitchButtonBorne.setOn();
        }
    }

    private void checkHiddenPlatform() {
        if (this.product.isHidden_platform()) {
            this.mSwitchButtonPlatform.setOff();
        } else {
            this.mSwitchButtonPlatform.setOn();
        }
    }

    public void setHiddenOnlineTemporary(boolean hidden_online) {
        this.mItemService.setHiddenOnlineTemporary(this.product.getID(), hidden_online);
        this.product.setHidden_online(hidden_online);
        this.product.setHidden_online_temporary(hidden_online);
        AppLocal.product_management = true;
        this.mItemService.sychroniseItem(this.product, false, true);
    }

    public void setHiddenBorneTemporary(boolean hidden_borne) {
        this.mItemService.setHiddenBorneTemporary(this.product.getID(), hidden_borne);
        this.product.setHidden_borne(hidden_borne);
        this.product.setHidden_borne_temporary(hidden_borne);
        AppLocal.product_management = true;
        this.mItemService.sychroniseItem(this.product, true, false);
    }

    public void setHiddenPlatformTemporary(boolean hidden_ubereats) {
        this.mItemService.setHiddenUberEatsTemporary(this.product.getID(), hidden_ubereats);
        this.product.setHidden_platform(hidden_ubereats);
        this.product.setHidden_ubereat_temporary(hidden_ubereats);
        AppLocal.product_management = true;
        this.mItemService.uploadItemsUberEats(false);
    }

    public void setSoldOutTemporary() {
        this.setSoldOutTemporary(true);
        this.mSwitchButton.setOff();
        if (this.mSwitchButtonBorne != null) {
            this.mSwitchButtonBorne.setOff();
        }
        if (this.mSwitchButtonOnline != null) {
            this.mSwitchButtonOnline.setOff();
        }
        if (this.mSwitchButtonPlatform != null) {
            this.mSwitchButtonPlatform.setOff();
        }
        this.setOff();
    }

    public void setSoldOutTemporary(boolean sold_out) {
        this.mItemService.setSoldOutTemporary(this.product.getID(), sold_out);
        this.product.setSold_out(sold_out);
        this.product.setHidden_platform(sold_out);
        this.product.setHidden_online(sold_out);
        this.product.setHidden_borne(sold_out);
        this.product.setSold_out_temporary(sold_out);
        this.product.setHidden_ubereat_temporary(sold_out);
        this.product.setHidden_online_temporary(sold_out);
        this.product.setHidden_borne_temporary(sold_out);
        AppLocal.product_management = true;
        this.mItemService.sychroniseItem(this.product, true, true);
    }

    public void checkSoldOut() {
        if (this.product.isSold_out()) {
            this.setOff();
            if (this.mSwitchButton != null) {
                this.mSwitchButton.setOff();
            }
        } else {
            this.getChildren().clear();
            this.add((Node)this.pane_product, 0, 0);
            this.add((Node)this.pane_on_off, 0, 1);
            this.add((Node)this.button_sold_out_temporary, 0, 2);
            if (this.mSwitchButton != null) {
                this.mSwitchButton.setOn();
            }
        }
    }

    public void setSoldOut(boolean sold_out) {
        if (sold_out) {
            this.mItemService.setSoldOutAndHidden(this.product.getID(), sold_out);
        } else {
            this.mItemService.setSoldOutTemporary(this.product.getID(), sold_out);
            this.product.setSold_out_temporary(sold_out);
            this.product.setHidden_ubereat_temporary(sold_out);
            this.product.setHidden_online_temporary(sold_out);
            this.product.setHidden_borne_temporary(sold_out);
        }
        this.product.setSold_out(sold_out);
        this.product.setHidden_platform(sold_out);
        this.product.setHidden_online(sold_out);
        this.product.setHidden_borne(sold_out);
        AppLocal.product_management = true;
        this.mItemService.sychroniseItem(this.product, true, true);
    }

    public SwitchButton getmSwitchButton() {
        return this.mSwitchButton;
    }

    public void setmSwitchButton(SwitchButton mSwitchButton) {
        this.mSwitchButton = mSwitchButton;
    }

    public Button getButton_sold_out_temporary() {
        return this.button_sold_out_temporary;
    }

    public void setButton_sold_out_temporary(Button button_sold_out_temporary) {
        this.button_sold_out_temporary = button_sold_out_temporary;
    }
}

