/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.components;

import com.openbravo.format.Formats;
import com.openbravo.pos.ticket.CarteOrderInfo;
import com.openbravo.pos.ticket.ProductInfoExt;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.text.TextAlignment;

public class ProductFamilleButton
extends Button {
    private ProductInfoExt product;
    private String style = "-fx-border-color: #FFFFFF14; -fx-border-radius: 16px; -fx-background-color: #FFFFFF10;  -fx-background-radius: 16px;";
    private String styleSelected = "-fx-border-color: #FFFFFF14; -fx-border-radius: 16px; -fx-background-color: #F6C443;  -fx-background-radius: 16px;";
    private String styleName = "-fx-text-fill: white; -fx-font-size: 12px;";
    private String styleNameSelected = "-fx-text-fill: black; -fx-font-size: 12px;";
    private String stylePrice = "-fx-text-fill: white; -fx-font-size: 12px; -fx-padding: 10px 10px 10px 10px;";
    private String stylePriceSelected = "-fx-text-fill: black; -fx-font-size: 12px; -fx-padding: 10px 10px 10px 10px;";
    private Label labelName;
    private Label labelImage;
    private Label labelPrice;
    private double width;
    private double height;
    private GridPane mainPane;
    private Image imageItem;
    private boolean selected;
    private CarteOrderInfo groupProduct;
    private int index;

    public ProductFamilleButton() {
        this.init();
    }

    public ProductFamilleButton(CarteOrderInfo groupProduct, ProductInfoExt product, double width, double height, Image imageItem, int index) {
        this.groupProduct = groupProduct;
        this.width = width;
        this.height = height;
        this.product = product;
        this.imageItem = imageItem;
        this.index = index;
        this.init();
    }

    private void init() {
        this.setPrefHeight(this.height);
        this.setPrefWidth(this.width);
        this.mainPane = new GridPane();
        this.mainPane.setAlignment(Pos.CENTER);
        this.mainPane.setPrefHeight(this.height);
        this.mainPane.setPrefWidth(this.width);
        this.labelName = new Label();
        this.labelName.setAlignment(Pos.TOP_LEFT);
        this.labelName.setTextAlignment(TextAlignment.LEFT);
        this.labelName.setPrefHeight(this.mainPane.getPrefHeight());
        this.labelName.setPrefWidth(this.mainPane.getPrefWidth() * 0.5);
        this.labelName.setText(this.product.getDisplayedName());
        this.labelImage = new Label();
        this.labelImage.setPrefHeight(this.mainPane.getPrefHeight());
        this.labelImage.setPrefWidth(this.mainPane.getPrefWidth() * 0.25);
        if (this.imageItem != null) {
            ImageView imageViewItem = new ImageView(this.imageItem);
            imageViewItem.setFitHeight(this.labelImage.getPrefHeight() * 0.9);
            imageViewItem.setFitWidth(this.labelImage.getPrefWidth() * 0.9);
            imageViewItem.setPreserveRatio(false);
            imageViewItem.setSmooth(false);
            this.labelImage.setGraphic((Node)imageViewItem);
        }
        this.labelPrice = new Label();
        this.labelPrice.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        this.labelPrice.setAlignment(Pos.BOTTOM_RIGHT);
        this.labelPrice.setPrefHeight(this.mainPane.getPrefHeight());
        this.labelPrice.setPrefWidth(this.mainPane.getPrefWidth() * 0.25);
        this.labelPrice.setText(Formats.CURRENCY.formatValue(this.product.getPriceSell()));
        this.mainPane.add((Node)this.labelImage, 0, 0);
        this.mainPane.add((Node)this.labelName, 1, 0);
        this.mainPane.add((Node)this.labelPrice, 2, 0);
        this.setGraphic((Node)this.mainPane);
    }

    public void deselect() {
        this.selected = false;
        this.setStyle(this.style);
        this.labelName.setStyle(this.styleName);
        this.labelPrice.setStyle(this.stylePrice);
    }

    public void select() {
        this.selected = true;
        this.setStyle(this.styleSelected);
        this.labelName.setStyle(this.styleNameSelected);
        this.labelPrice.setStyle(this.stylePriceSelected);
    }

    public CarteOrderInfo getGroupProduct() {
        return this.groupProduct;
    }

    public void setGroupProduct(CarteOrderInfo groupProduct) {
        this.groupProduct = groupProduct;
    }

    public ProductInfoExt getProduct() {
        return this.product;
    }

    public void setProduct(ProductInfoExt product) {
        this.product = product;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }
}

