/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.components;

import com.openbravo.basic.BasicException;
import com.openbravo.controllers.PopUpNotificationController;
import com.openbravo.pos.util.LogToFile;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class PopUpOnlineOrderNotification
extends JDialog {
    Component parent;
    PopUpNotificationController controller;
    private boolean isShowing;

    public PopUpOnlineOrderNotification(Frame parent, boolean modal) {
        super(parent, modal);
        this.parent = parent;
    }

    public PopUpOnlineOrderNotification(Dialog parent, boolean modal) {
        super(parent, modal);
        this.parent = parent;
    }

    private void initAndShowGUI(final int number_order) {
        System.out.println("++++++++++ start initAndShowGUI");
        final JFXPanel fxPanel = new JFXPanel();
        fxPanel.setSize(400, 400);
        this.getContentPane().add((Component)fxPanel, "Center");
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    System.out.println("++++++++++  initFX");
                    PopUpOnlineOrderNotification.this.initFX(fxPanel, number_order);
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        });
    }

    private void initFX(JFXPanel fxPanel, int number_order) throws IOException, BasicException, URISyntaxException {
        System.out.println("++++++++++++++++++++++++++++++++ start   initFX: ");
        String fxmlFile = "/fxml/popup_notification_orders.fxml";
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource(fxmlFile));
        Parent rootNode = (Parent)loader.load();
        this.controller = (PopUpNotificationController)loader.getController();
        System.out.println("controller  1 : " + this.controller);
        Scene scenePop = new Scene(rootNode, 400.0, 400.0);
        scenePop.getStylesheets().add((Object)"/styles/styles.css");
        this.controller.init(null);
        this.controller.apply(number_order);
        this.controller.setmPopUpOnlineOrderNotification(this);
        fxPanel.setScene(scenePop);
    }

    private void init(int number_order) throws BasicException {
        this.initComponents();
        this.setSize(400, 400);
        System.out.println("++++++++++++ initAndShowGUI");
        this.initAndShowGUI(number_order);
        this.setVisible(true);
    }

    private static Window getWindow(Component parent) {
        if (parent == null) {
            return new JFrame();
        }
        if (parent instanceof Frame || parent instanceof Dialog) {
            return (Window)parent;
        }
        return PopUpOnlineOrderNotification.getWindow(parent.getParent());
    }

    public PopUpOnlineOrderNotification(Component parent, int number_order) {
        super((Frame)PopUpOnlineOrderNotification.getWindow(parent), true);
        try {
            this.setPreferredSize(new Dimension(400, 400));
            System.out.println("+++++++++++++++++ init controller");
            this.init(number_order);
        }
        catch (BasicException ex) {
            Logger.getLogger(PopUpOnlineOrderNotification.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void show(final int number_order) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    PopUpOnlineOrderNotification.this.controller.apply(number_order);
                    if (!PopUpOnlineOrderNotification.this.isShowing) {
                        PopUpOnlineOrderNotification.this.setVisible(true);
                    }
                    PopUpOnlineOrderNotification.this.isShowing = true;
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        });
    }

    private void initComponents() {
        this.setDefaultCloseOperation(2);
        this.setSize(new Dimension(700, 600));
        this.setType(Window.Type.POPUP);
        this.setSize(new Dimension(400, 400));
        this.setLocationRelativeTo(null);
    }
}

