/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.components;

import com.openbravo.controllers.PopUpNotificationController;
import com.openbravo.dao.DataLogicOrder;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.util.AppVarUtils;
import java.io.IOException;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;

public class PopUpNotification {
    private Scene principal_scene;
    private static Stage modalStage;
    private PopUpNotificationController controller;
    private DataLogicOrder dlOrders;
    private AppView mAppView;

    public PopUpNotification(Scene scene, Stage modalStage, DataLogicOrder dlOrders) {
        this.principal_scene = scene;
        PopUpNotification.modalStage = modalStage;
        this.dlOrders = dlOrders;
    }

    public void init() throws IOException {
        if (this.principal_scene != null && modalStage != null) {
            String fxmlFile = "/fxml/popup_notification_orders.fxml";
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource(fxmlFile));
            Parent rootNode = (Parent)loader.load();
            Scene scenePop = new Scene(rootNode, 400.0, 400.0);
            scenePop.getStylesheets().add((Object)"/styles/styles.css");
            this.controller = (PopUpNotificationController)loader.getController();
            modalStage.setScene(scenePop);
            modalStage.initOwner(this.principal_scene.getWindow());
            modalStage.initModality(Modality.APPLICATION_MODAL);
            modalStage.initStyle(StageStyle.UTILITY);
            modalStage.setAlwaysOnTop(true);
            this.controller.setM_PopUpNotification(this);
            this.controller.init(this.mAppView);
        }
    }

    public Stage getModalStage() {
        return modalStage;
    }

    public void setModalStage(Stage modalStage) {
        PopUpNotification.modalStage = modalStage;
    }

    public AppView getmAppView() {
        return this.mAppView;
    }

    public void setmAppView(AppView mAppView) {
        this.mAppView = mAppView;
    }

    public boolean isShowing() {
        return modalStage != null && modalStage.isShowing();
    }

    public void show(int number_order) {
        if (this.isShowing() && (AppLocal.SUIVI_ONLINE_ORDER || AppVarUtils.QUEUED_ONLINE_ORDERS_COUNT > 0)) {
            this.controller.apply(number_order);
        } else if (modalStage != null && (AppLocal.SUIVI_ONLINE_ORDER || AppVarUtils.QUEUED_ONLINE_ORDERS_COUNT > 0)) {
            modalStage.show();
            this.controller.apply(number_order);
        }
    }

    public void hide() {
        if (modalStage != null && modalStage.isShowing()) {
            modalStage.hide();
        }
    }
}

