/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.components;

import com.openbravo.components.views.ButtonBoxAdditional;
import com.openbravo.format.Formats;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.util.ColorUtils;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;

public class PanePromotionProduct
extends GridPane {
    private double width_product;
    private double height_product;
    private double percent_height_price = AppLocal.HIDE_NAME_PRODUCTS ? 0.15 : 0.13;
    private ProductInfoExt product;
    private String color_hex = ColorUtils.getColor(AppLocal.color_borne);
    private String text_color_borne_hex = ColorUtils.getColor(AppLocal.TEXT_COLOR_BORNE);
    private String text_color_items_hex = ColorUtils.getColor(AppLocal.TEXT_COLOR_ITEMS);
    private String bg_color_items_hex = ColorUtils.getColor(AppLocal.BG_COLOR_ITEMS);
    private int indice_line_additional;
    private Pos price_position;
    private ImageView image_product;
    private Image image_tag;

    public PanePromotionProduct width_product(double width_product) {
        this.width_product = width_product;
        return this;
    }

    public PanePromotionProduct height_product(double height_product) {
        this.height_product = height_product;
        return this;
    }

    public PanePromotionProduct product(ProductInfoExt product) {
        this.product = product;
        return this;
    }

    public PanePromotionProduct indice_line_additional(int indice_line_additional) {
        this.indice_line_additional = indice_line_additional;
        return this;
    }

    public PanePromotionProduct price_position(Pos price_position) {
        this.price_position = price_position;
        return this;
    }

    public PanePromotionProduct image_product(ImageView image_product) {
        this.image_product = image_product;
        return this;
    }

    public PanePromotionProduct image_tag(Image image_tag) {
        this.image_tag = image_tag;
        return this;
    }

    public PanePromotionProduct build() {
        this.setPrefWidth(this.width_product);
        this.setPrefHeight(this.height_product);
        this.setVgap(2.0);
        this.setHgap(2.0);
        double heightPrice = this.getPrefHeight() * this.percent_height_price;
        String price = Formats.CURRENCY.formatValue(this.product.getPriceSell());
        Label priceProduct = new Label(price);
        priceProduct.setStyle("-fx-font-size: 14pt; -fx-text-fill: #ffffff; -fx-background-radius: 0em 0em 1em 1em; -fx-background-color: " + this.color_hex + ";");
        priceProduct.setAlignment(Pos.CENTER);
        priceProduct.setPrefWidth(this.width_product);
        priceProduct.setPrefHeight(heightPrice);
        ButtonBoxAdditional btnProduct = new ButtonBoxAdditional(this.product, this, null, this.getPrefWidth(), this.getPrefHeight() * 0.7);
        double widthImage = this.getPrefWidth();
        GridPane pane_bottom_price = new GridPane();
        pane_bottom_price.setPrefWidth(widthImage);
        pane_bottom_price.setPrefHeight(heightPrice);
        pane_bottom_price.setAlignment(Pos.CENTER);
        pane_bottom_price.add((Node)priceProduct, 0, 0);
        Label nameProduct = new Label(this.product.getDisplayedName().toUpperCase());
        nameProduct.setPrefWidth(widthImage);
        nameProduct.setPrefHeight(this.getPrefHeight() * 0.13);
        nameProduct.setAlignment(Pos.CENTER);
        if (this.image_product != null) {
            btnProduct.setGraphic((Node)this.image_product);
            pane_bottom_price.setPrefWidth(this.image_product.getBoundsInLocal().getWidth());
        }
        GridPane paneInfoProduct = new GridPane();
        paneInfoProduct.setPrefWidth(this.width_product);
        paneInfoProduct.setPrefHeight(this.height_product);
        int j = 0;
        paneInfoProduct.add((Node)btnProduct, 0, j++);
        if (!AppLocal.HIDE_NAME_PRODUCTS) {
            paneInfoProduct.add((Node)nameProduct, 0, j++);
        }
        paneInfoProduct.add((Node)pane_bottom_price, 0, j++);
        if (this.image_tag != null && this.image_tag.getException() == null) {
            StackPane stack_pane_product = new StackPane();
            GridPane paneImageTag = new GridPane();
            paneImageTag.setPrefHeight(this.width_product);
            paneImageTag.setPrefWidth(this.width_product);
            paneImageTag.setAlignment(Pos.TOP_RIGHT);
            ImageView imageViewTag = new ImageView(this.image_tag);
            imageViewTag.setFitHeight(paneImageTag.getPrefHeight() * 0.25);
            imageViewTag.setFitWidth(paneImageTag.getPrefWidth() * 0.25);
            imageViewTag.setPreserveRatio(false);
            imageViewTag.setSmooth(false);
            paneImageTag.add((Node)imageViewTag, 0, 0);
            stack_pane_product.setPrefHeight(this.width_product);
            stack_pane_product.setPrefWidth(this.width_product);
            stack_pane_product.getChildren().add((Object)paneInfoProduct);
            stack_pane_product.getChildren().add((Object)paneImageTag);
            this.add((Node)stack_pane_product, 0, 0);
        } else {
            this.add((Node)paneInfoProduct, 0, 0);
        }
        btnProduct.setStyle("-fx-background-color: transparent;-fx-text-fill: #000000;");
        nameProduct.setStyle("-fx-font-size: 14 pt; -fx-text-fill: #000000; -fx-font-weight: normal; -fx-font-family: 'Futura PT Medium Italic';");
        this.getProperties().put((Object)"button", (Object)btnProduct);
        this.getProperties().put((Object)"name", (Object)nameProduct);
        this.getProperties().put((Object)"price", (Object)priceProduct);
        this.getProperties().put((Object)"pane_bottom_price", (Object)pane_bottom_price);
        this.getProperties().put((Object)"paneInfoProduct", (Object)paneInfoProduct);
        paneInfoProduct.setStyle("-fx-background-color:  white; -fx-background-radius: 1.45em");
        DropShadow dropShadow = new DropShadow();
        this.setEffect((Effect)dropShadow);
        return this;
    }
}

