/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.components;

import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.util.ColorUtils;
import java.util.HashMap;
import java.util.List;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;
import javafx.scene.text.TextAlignment;

public class PaneProduct
extends Button {
    private String color_hex;
    private String text_color_borne_hex;
    private String text_color_items_hex;
    private String bg_color_items_hex;
    private ProductInfoExt product;
    private double heightPane;
    private double widthPane;
    private int sizeDescription;
    private int sizeProduct;
    private ImageView imageProduct;
    private ImageView imageDisableProduct;
    private List<Double> image_products_height;
    private List<Double> image_products_width;
    private List<Double> percents_height_image;
    private int price_position = AppLocal.POSITION_PRICE == null || AppLocal.POSITION_PRICE.isEmpty() ? 2 : Integer.parseInt(AppLocal.POSITION_PRICE);
    private HashMap<Integer, Pos> price_positions = new HashMap();
    private ImageView imageLabeledProduct;
    private ImageView imageBestSale;
    private boolean product_moment;
    private String background;
    private int step_product;
    private String text_color_price_hex;
    private GridPane paneProduct;
    private StackPane stack_pane_product;
    private GridPane paneName;
    private Label priceProduct;
    private int number_items;
    private ImageView image_promo;
    private String type_image_moment;
    private String bg_color_price;
    private String bg_color_image_product;

    public PaneProduct() {
        this.price_positions.put(0, Pos.BOTTOM_LEFT);
        this.price_positions.put(1, Pos.BOTTOM_CENTER);
        this.price_positions.put(2, Pos.BOTTOM_RIGHT);
        this.color_hex = ColorUtils.getColor(AppLocal.color_borne);
        this.text_color_items_hex = ColorUtils.getColor(AppLocal.TEXT_COLOR_ITEMS);
        this.bg_color_items_hex = AppLocal.HIDE_BACKGROUND_NAME_PRODUCTS ? "transparent" : ColorUtils.getColor(AppLocal.BG_COLOR_ITEMS);
        this.bg_color_image_product = AppLocal.HIDE_BACKGROUND_PRODUCTS ? "transparent" : ColorUtils.getColor(AppLocal.BG_COLOR_IMAGE_PRODUCT);
        this.text_color_price_hex = ColorUtils.getColor(AppLocal.TEXT_COLOR_PRICE);
        this.bg_color_price = ColorUtils.getColor(AppLocal.BG_COLOR_PRICE);
    }

    public PaneProduct imageLabeledProduct(ImageView imageLabeledProduct) {
        this.imageLabeledProduct = imageLabeledProduct;
        return this;
    }

    public PaneProduct product(ProductInfoExt product) {
        this.product = product;
        return this;
    }

    public PaneProduct heightPane(double heightPane) {
        this.heightPane = heightPane;
        return this;
    }

    public PaneProduct widthPane(double widthPane) {
        this.widthPane = widthPane;
        return this;
    }

    public PaneProduct sizeProduct(int sizeProduct) {
        this.sizeProduct = sizeProduct;
        return this;
    }

    public PaneProduct sizeDescription(int sizeDescription) {
        this.sizeDescription = sizeDescription;
        return this;
    }

    public PaneProduct imageProduct(ImageView imageProduct) {
        this.imageProduct = imageProduct;
        return this;
    }

    public PaneProduct imageDisabeleProduct(ImageView imageDisableProduct) {
        this.imageDisableProduct = imageDisableProduct;
        return this;
    }

    public PaneProduct image_products_height(List<Double> image_products_height) {
        this.image_products_height = image_products_height;
        return this;
    }

    public PaneProduct image_products_width(List<Double> image_products_width) {
        this.image_products_width = image_products_width;
        return this;
    }

    public PaneProduct percents_height_image(List<Double> percents_height_image) {
        this.percents_height_image = percents_height_image;
        return this;
    }

    public PaneProduct imageBestSale(ImageView imageBestSale) {
        this.imageBestSale = imageBestSale;
        return this;
    }

    public PaneProduct product_moment(boolean product_moment) {
        this.product_moment = product_moment;
        return this;
    }

    public PaneProduct type_image_product_moment(String type) {
        this.type_image_moment = type;
        return this;
    }

    public PaneProduct step_product(int step_product) {
        this.step_product = step_product;
        return this;
    }

    public PaneProduct number_items(int number_items) {
        this.number_items = number_items;
        return this;
    }

    public PaneProduct image_promo(ImageView image_promo) {
        this.image_promo = image_promo;
        return this;
    }

    public PaneProduct build() {
        boolean higher_price;
        boolean existImage = false;
        this.paneProduct = new GridPane();
        this.setPrefHeight(this.heightPane);
        this.setPrefWidth(this.widthPane);
        this.paneProduct.setPrefHeight(this.heightPane);
        this.paneProduct.setPrefWidth(this.widthPane);
        this.paneProduct.setAlignment(Pos.CENTER);
        this.paneName = new GridPane();
        this.paneName.setAlignment(Pos.CENTER);
        this.background = AppLocal.HIDE_BACKGROUND_PRODUCTS || this.product_moment ? "transparent" : this.bg_color_image_product;
        Object label_description = null;
        double percent_height_image = this.product_moment ? 0.95 : (AppLocal.HIDE_NAME_PRODUCTS ? 0.9 : 0.75);
        this.percents_height_image.add(percent_height_image);
        this.priceProduct = new Label(this.printPrice());
        String size_price = AppLocal.type_borne.equals("horizontal") ? "12pt" : "13pt";
        String colorPrice = this.text_color_price_hex;
        if (AppLocal.HIDE_BACKGROUND_PRICE) {
            this.priceProduct.setStyle("-fx-font-size: " + size_price + "; -fx-text-fill: " + colorPrice + "; -fx-border-color: transparent; -fx-background-color: transparent;");
        } else {
            this.priceProduct.setStyle("-fx-font-size: " + size_price + "; -fx-text-fill: " + colorPrice + "; -fx-border-color: " + this.bg_color_price + "; -fx-background-color: " + this.bg_color_price + ";");
        }
        double with_price = this.number_items > 2 ? this.widthPane * 0.4 : this.widthPane * 0.22;
        Object name_product = this.product.getDisplayedName().toUpperCase();
        String description = this.product.getDisplayedDescription();
        if (AppLocal.SHOW_DESCRIPTION && description != null && !description.isEmpty()) {
            name_product = (String)name_product + "(" + description + ")";
        }
        Label nameProduct = null;
        if (!(AppLocal.HIDE_NAME_PRODUCTS || this.product.isHide_name_in_borne() || this.product_moment)) {
            nameProduct = new Label((String)name_product);
            nameProduct.setAlignment(Pos.CENTER);
            nameProduct.setTextAlignment(TextAlignment.CENTER);
            this.paneName.setPrefWidth(this.paneProduct.getPrefWidth());
            nameProduct.setPrefWidth(this.paneProduct.getPrefWidth());
            this.sizeProduct = this.sizeProduct > 19 ? this.sizeProduct - 3 : this.sizeProduct;
            nameProduct.setStyle("-fx-padding: 0 0 0 0; -fx-text-fill: " + this.text_color_items_hex + "; -fx-font-size : " + this.sizeProduct + "pt; -fx-font-family : " + AppLocal.FONT_FAMILY_PRODUCTS + "; -fx-font-weight: bold; -fx-background-color: " + this.bg_color_items_hex + ";");
            nameProduct.setWrapText(true);
        }
        this.stack_pane_product = null;
        GridPane paneImageBestSale = null;
        if (this.product.isBest_sale()) {
            paneImageBestSale = new GridPane();
            paneImageBestSale.setPrefHeight(this.heightPane);
            paneImageBestSale.setPrefWidth(this.widthPane);
            paneImageBestSale.setAlignment(Pos.TOP_RIGHT);
            paneImageBestSale.add((Node)this.imageBestSale, 0, 0);
            this.stack_pane_product = new StackPane();
            this.stack_pane_product.setPrefHeight(this.heightPane);
            this.stack_pane_product.setPrefWidth(this.widthPane);
            this.stack_pane_product.getChildren().add((Object)this.paneProduct);
            this.stack_pane_product.getChildren().add((Object)paneImageBestSale);
        }
        if (this.imageProduct != null) {
            Label labelImage = new Label();
            labelImage.setAlignment(Pos.CENTER);
            labelImage.setGraphic((Node)this.imageProduct);
            labelImage.setPrefHeight(this.heightPane * percent_height_image);
            labelImage.setPrefWidth(this.widthPane);
            this.paneName.setStyle("-fx-background-color:  " + this.bg_color_items_hex + ";");
            labelImage.setStyle("-fx-background-color:  " + this.background + ";");
            int j = 0;
            this.paneName.setPrefHeight(this.heightPane * 0.15);
            if (nameProduct != null) {
                nameProduct.setPrefHeight(this.heightPane * 0.15);
            }
            this.priceProduct.setPrefWidth(with_price);
            this.priceProduct.setPrefHeight(this.heightPane * 0.09);
            this.priceProduct.setAlignment(Pos.CENTER);
            GridPane pane_bottom_price = new GridPane();
            pane_bottom_price.setPrefWidth(this.widthPane);
            if (!this.product_moment) {
                pane_bottom_price.setPrefHeight(this.heightPane * 0.1);
            }
            pane_bottom_price.setAlignment(this.price_positions.get(this.price_position));
            this.paneProduct.add((Node)labelImage, 0, 0);
            ++j;
            if (!AppLocal.HIDE_NAME_PRODUCTS && !this.product_moment) {
                if (nameProduct != null) {
                    this.paneName.add((Node)nameProduct, 0, 0);
                }
                this.paneProduct.add((Node)this.paneName, 0, 1);
                ++j;
            }
            StackPane stack_pane = new StackPane();
            stack_pane.setPrefHeight(pane_bottom_price.getPrefHeight());
            stack_pane.setPrefWidth(pane_bottom_price.getPrefWidth());
            GridPane paneBackground = new GridPane();
            paneBackground.setPrefHeight(pane_bottom_price.getPrefHeight());
            paneBackground.setPrefWidth(pane_bottom_price.getPrefWidth());
            Label labelBackground = new Label();
            labelBackground.setPrefHeight(pane_bottom_price.getPrefHeight() * 0.5);
            labelBackground.setPrefWidth(pane_bottom_price.getPrefWidth());
            labelBackground.setStyle("-fx-background-color:  " + this.background + ";");
            paneBackground.setAlignment(Pos.TOP_CENTER);
            paneBackground.add((Node)labelBackground, 0, 0);
            stack_pane.getChildren().add((Object)paneBackground);
            if ((this.product.getPriceSell() != 0.0 || this.product.isUse_points() && this.product.getPrice_point() != 0.0) && !this.product.isHide_price_in_borne()) {
                stack_pane.getChildren().add((Object)this.priceProduct);
            }
            pane_bottom_price.add((Node)stack_pane, 0, 0);
            if (!this.product_moment) {
                this.paneProduct.add((Node)pane_bottom_price, 0, j);
            }
            ++j;
            this.image_products_height.add(this.imageProduct.getBoundsInLocal().getHeight());
            this.image_products_width.add(this.imageProduct.getBoundsInLocal().getWidth());
            existImage = true;
        }
        if (!existImage) {
            if (nameProduct != null) {
                this.paneName.add((Node)nameProduct, 0, 0);
                this.paneName.setPrefHeight(this.heightPane * 0.9);
                nameProduct.setPrefHeight(this.paneName.getPrefHeight() * 0.4);
            }
            GridPane panePrice = new GridPane();
            panePrice.setPrefHeight(this.heightPane * 0.1);
            panePrice.setAlignment(Pos.CENTER);
            panePrice.add((Node)this.priceProduct, 0, 0);
            if (!this.product_moment) {
                this.paneProduct.add((Node)this.paneName, 0, 0);
            }
            if ((this.product.getPriceSell() != 0.0 || this.product.isUse_points() && this.product.getPrice_point() != 0.0) && !this.product.isHide_price_in_borne()) {
                this.paneProduct.add((Node)panePrice, 0, 1);
            }
        }
        boolean bl = higher_price = this.product.isUse_points() && (AppLocal.currentCustomerLoyalty == null || AppLocal.currentCustomerLoyalty != null && AppLocal.currentCustomerLoyalty.getPoints() < this.product.getPrice_point());
        if (this.product.isSold_out() || this.product.isAvailable_caisse() || higher_price) {
            this.setDisablePaneProduct(higher_price, this.product.isAvailable_caisse());
        } else {
            this.setEnablePaneProduct();
        }
        this.setStyle("-fx-background-color:  transparent;");
        return this;
    }

    public ProductInfoExt getProduct() {
        return this.product;
    }

    private String printPrice() {
        return this.product.printPriceSell();
    }

    public void setDisablePaneProduct(boolean higher_price, boolean disableWithoutHideImage) {
        StackPane stack_pane = new StackPane();
        stack_pane.setPrefHeight(this.heightPane);
        stack_pane.setPrefWidth(this.widthPane);
        if (this.stack_pane_product != null) {
            stack_pane.getChildren().add((Object)this.stack_pane_product);
        } else {
            stack_pane.getChildren().add((Object)this.paneProduct);
        }
        stack_pane.getChildren().add((Object)this.imageDisableProduct);
        this.setGraphic((Node)stack_pane);
        if (higher_price) {
            if (!this.imageProduct.getStyleClass().contains((Object)"opacity_50")) {
                this.imageProduct.getStyleClass().add((Object)"opacity_50");
            }
            if (!this.imageDisableProduct.getStyleClass().contains((Object)"opacity_50")) {
                this.imageDisableProduct.getStyleClass().add((Object)"opacity_50");
            }
        } else {
            boolean disable;
            boolean bl = disable = !disableWithoutHideImage;
            if (this.stack_pane_product != null) {
                this.stack_pane_product.setDisable(disable);
            }
            this.paneProduct.setDisable(disable);
            this.setDisable(disable);
        }
        this.product.setClickable(false);
    }

    public double getHeightPane() {
        return this.heightPane;
    }

    public double getWidthPane() {
        return this.widthPane;
    }

    public void setImageDisableProduct(ImageView imageDisableProduct) {
        this.imageDisableProduct = imageDisableProduct;
    }

    public void setEnablePaneProduct() {
        this.getProperties().put((Object)"paneName", (Object)this.paneName);
        this.getProperties().put((Object)"labelPrice", (Object)this.priceProduct);
        if (this.product.getPromotions() != null && !this.product.getPromotions().isEmpty() && this.image_promo != null) {
            String text_promo = this.product.getPromotions().get(0).getDisplayedText();
            this.setImagePromo(this.image_promo, text_promo);
        } else if (this.product.isLabeled() && this.imageLabeledProduct != null) {
            System.out.println("imageLabeledProduct : " + this.imageLabeledProduct.getBoundsInLocal().getHeight());
            this.setImage(this.imageLabeledProduct);
        } else if (this.stack_pane_product != null) {
            this.setGraphic((Node)this.stack_pane_product);
        } else {
            this.setGraphic((Node)this.paneProduct);
        }
        this.paneProduct.setDisable(false);
        this.setDisable(false);
        if (this.imageProduct != null && this.imageProduct.getStyleClass().contains((Object)"opacity_50")) {
            this.imageProduct.getStyleClass().remove((Object)"opacity_50");
        }
        boolean clickable = !this.product.isAvailable_caisse();
        this.product.setClickable(clickable);
    }

    private void setImage(ImageView image) {
        StackPane stack_pane = new StackPane();
        stack_pane.setPrefHeight(this.heightPane);
        stack_pane.setPrefWidth(this.widthPane);
        if (this.stack_pane_product != null) {
            stack_pane.getChildren().add((Object)this.stack_pane_product);
        } else {
            stack_pane.getChildren().add((Object)this.paneProduct);
        }
        stack_pane.getChildren().add((Object)image);
        this.setGraphic((Node)stack_pane);
    }

    private void setImagePromo(ImageView image, String text_promo) {
        StackPane stack_pane = new StackPane();
        stack_pane.setPrefHeight(this.heightPane);
        stack_pane.setPrefWidth(this.widthPane);
        if (this.stack_pane_product != null) {
            stack_pane.getChildren().add((Object)this.stack_pane_product);
        } else {
            stack_pane.getChildren().add((Object)this.paneProduct);
        }
        stack_pane.getChildren().add((Object)image);
        List<String> splitted = List.of(text_promo.split("="));
        String content = splitted.size() > 1 ? String.join((CharSequence)"\n", splitted) : splitted.get(0);
        double defaultHeight = image.getBoundsInLocal().getHeight();
        if (splitted.size() > 1) {
            defaultHeight *= 2.0;
        }
        Label labelPromo = new Label(content);
        labelPromo.setPrefWidth(image.getFitWidth());
        image.setFitHeight(defaultHeight);
        labelPromo.setAlignment(Pos.CENTER);
        labelPromo.setTranslateY(-defaultHeight * 0.05);
        labelPromo.setTextAlignment(TextAlignment.CENTER);
        labelPromo.getStyleClass().add((Object)"text-white");
        labelPromo.getStyleClass().add((Object)"text-size-16");
        stack_pane.getChildren().add((Object)labelPromo);
        this.setGraphic((Node)stack_pane);
    }

    public PaneProduct buildCategory() {
        this.paneProduct = new GridPane();
        this.setPrefHeight(this.heightPane);
        this.setPrefWidth(this.widthPane);
        this.paneProduct.setPrefHeight(this.heightPane);
        this.paneProduct.setPrefWidth(this.widthPane);
        this.paneProduct.setAlignment(Pos.CENTER);
        if (this.imageProduct != null) {
            Label labelImage = new Label();
            labelImage.setAlignment(Pos.CENTER);
            labelImage.setGraphic((Node)this.imageProduct);
            labelImage.setPrefHeight(this.heightPane);
            labelImage.setPrefWidth(this.widthPane);
            this.paneProduct.add((Node)labelImage, 0, 0);
        }
        this.setStyle("-fx-background-color:  transparent;");
        this.setGraphic((Node)this.paneProduct);
        return this;
    }
}

