/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.components;

import com.openbravo.components.views.ButtonBoxOption;
import com.openbravo.controllers.borne.IOptionItem;
import com.openbravo.format.Formats;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.IngredientItem;
import com.openbravo.pos.ticket.OptionItem;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.ticket.SupplementItemInfo;
import com.openbravo.pos.ticket.SupplementProduct;
import com.openbravo.pos.util.ColorUtils;
import fr.protactile.procaisse.dao.entities.AllergeneSupplement;
import java.util.ArrayList;
import java.util.List;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Circle;

public class PaneOption
extends Button {
    private String color_hex = ColorUtils.getColor(AppLocal.color_borne);
    private String text_color_borne_hex = ColorUtils.getColor(AppLocal.TEXT_COLOR_BORNE);
    private SupplementItemInfo option;
    private SupplementProduct groupeOption;
    private double heightPane;
    private double widthPane;
    private List<Double> image_option_heights;
    private List<Double> image_option_width;
    private IOptionItem optionItem;
    private static Image image_delete_item;
    private boolean sub_supplement;
    private double perecent_width_image = 0.7;
    private ProductInfoExt subProduct;
    private ImageView imageOption;
    private boolean isIngredient;
    private final String SIZE_IMAGE_512 = "_512px";
    private final String SIZE_IMAGE_256 = "_256px";
    private final String SIZE_IMAGE_128 = "_128px";

    public PaneOption groupeOption(SupplementProduct groupeOption) {
        this.groupeOption = groupeOption;
        return this;
    }

    public PaneOption optionItem(IOptionItem optionItem) {
        this.optionItem = optionItem;
        return this;
    }

    public PaneOption option(SupplementItemInfo option) {
        this.option = option;
        return this;
    }

    public PaneOption widthPane(double widthPane) {
        this.widthPane = widthPane;
        return this;
    }

    public PaneOption heightPane(double heightPane) {
        this.heightPane = heightPane;
        return this;
    }

    public PaneOption image_option_heights(List<Double> image_option_heights) {
        this.image_option_heights = image_option_heights;
        return this;
    }

    public PaneOption image_option_width(List<Double> image_option_width) {
        this.image_option_width = image_option_width;
        return this;
    }

    public PaneOption buildOption() {
        this.build(true);
        return this;
    }

    public PaneOption sub_supplement(boolean sub_supplement) {
        this.sub_supplement = sub_supplement;
        return this;
    }

    public PaneOption buildIngredient() {
        this.build(false);
        return this;
    }

    public PaneOption perecent_width_image(double perecent_width_image) {
        this.perecent_width_image = perecent_width_image;
        return this;
    }

    public PaneOption subProduct(ProductInfoExt subProduct) {
        this.subProduct = subProduct;
        return this;
    }

    public PaneOption imageOption(ImageView imageOption) {
        this.imageOption = imageOption;
        return this;
    }

    public PaneOption isIngredient(boolean isIngredient) {
        this.isIngredient = isIngredient;
        return this;
    }

    public void build(boolean add_footer_pane) {
        StackPane stack_pane;
        this.setPrefHeight(this.heightPane);
        this.setPrefWidth(this.widthPane);
        String option_name = this.option.getDisplayedName();
        System.out.println("option_name *********: " + option_name);
        Object nameOption = this.isIngredient ? AppLocal.getIntString("Label.without") + " " + option_name.toUpperCase() : option_name.toUpperCase();
        System.out.println("nameOption **********: " + (String)nameOption);
        if (nameOption == null && !this.isIngredient && this.option.getPrice_order() != 0.0) {
            nameOption = (String)nameOption + "\n" + Formats.CURRENCY.formatValue(this.option.getPrice_order());
        }
        boolean existImage = false;
        double heightImage = this.heightPane * 0.7;
        double widthImage = this.option.getPath() != null && !this.option.getPath().isEmpty() ? this.widthPane * this.perecent_width_image : this.widthPane * 0.57;
        GridPane paneName = new GridPane();
        paneName.setHgap(5.0);
        paneName.setVgap(5.0);
        paneName.setPrefHeight(this.heightPane);
        paneName.setPrefWidth(this.widthPane);
        Label nameCategory = new Label((String)nameOption);
        int size_option = ((String)nameOption).length() > 16 ? 9 : 11;
        nameCategory.setStyle("-fx-font-size: " + size_option + "pt; -fx-font-family : " + AppLocal.FONT_FAMILY_OPTIONS + ";");
        nameCategory.setAlignment(Pos.CENTER);
        nameCategory.setWrapText(true);
        Image image_option = this.optionItem != null ? this.optionItem.getImage("_256px") : null;
        Label labelImage = null;
        int index_row = 0;
        double prencent_height_name = 1.0;
        double prencent_pane_main = 1.0;
        GridPane pane_footer = null;
        if (add_footer_pane) {
            Label labelQtt = new Label();
            pane_footer = new GridPane();
            pane_footer.setHgap(5.0);
            pane_footer.setVgap(5.0);
            pane_footer.setPrefHeight(paneName.getPrefHeight() * 0.08);
            pane_footer.setPrefWidth(paneName.getPrefWidth());
            labelQtt.setPrefHeight(pane_footer.getPrefHeight());
            ButtonBoxOption increaseQtt = new ButtonBoxOption(this.groupeOption, this.option, pane_footer.getPrefWidth() * 0.3, pane_footer.getPrefHeight(), "+", this);
            ButtonBoxOption decreaseQtt = new ButtonBoxOption(this.groupeOption, this.option, pane_footer.getPrefWidth() * 0.3, pane_footer.getPrefHeight(), "-", this);
            labelQtt.setPrefWidth(pane_footer.getPrefWidth() * 0.4);
            labelQtt.setAlignment(Pos.CENTER);
            pane_footer.add((Node)decreaseQtt, 0, 0);
            pane_footer.add((Node)labelQtt, 1, 0);
            pane_footer.add((Node)increaseQtt, 2, 0);
            pane_footer.setAlignment(Pos.CENTER);
            increaseQtt.setStyle("-fx-font-weight: bold; -fx-text-fill: " + this.text_color_borne_hex + "; -fx-background-color: #ffffff;-fx-border-color: " + this.color_hex + "; -fx-font-size: 18px;");
            decreaseQtt.setStyle("-fx-font-weight: bold; -fx-text-fill: " + this.text_color_borne_hex + "; -fx-background-color: #ffffff;-fx-border-color: " + this.color_hex + "; -fx-font-size: 18px;");
            labelQtt.setStyle("-fx-text-fill: " + this.text_color_borne_hex + "; -fx-background-color: #ffffff;-fx-border-color: " + this.color_hex + "; -fx-font-size: 14px;");
            this.getProperties().put((Object)"footer_pane", (Object)pane_footer);
            this.getProperties().put((Object)"increaseQtt", (Object)increaseQtt);
            this.getProperties().put((Object)"decreaseQtt", (Object)decreaseQtt);
            this.getProperties().put((Object)"labelQtt", (Object)labelQtt);
            prencent_height_name -= 0.08;
            prencent_pane_main -= 0.08;
        }
        if (this.imageOption != null) {
            labelImage = new Label();
            labelImage.setAlignment(Pos.CENTER);
            labelImage.setGraphic((Node)this.imageOption);
            labelImage.setPrefHeight(paneName.getPrefHeight() * 0.6);
            labelImage.setPrefWidth(paneName.getPrefWidth());
            this.getProperties().put((Object)"image", (Object)labelImage);
            existImage = true;
            prencent_height_name -= 0.6;
        } else if (image_option != null) {
            ImageView iv2 = new ImageView();
            iv2.setImage(image_option);
            if (AppLocal.type_borne.equals("horizontal")) {
                iv2.setFitHeight(heightImage);
            } else {
                iv2.setFitWidth(widthImage);
            }
            iv2.setPreserveRatio(true);
            iv2.setSmooth(true);
            iv2.setCache(true);
            labelImage = new Label();
            labelImage.setAlignment(Pos.CENTER);
            labelImage.setGraphic((Node)iv2);
            labelImage.setPrefHeight(paneName.getPrefHeight() * 0.6);
            labelImage.setPrefWidth(paneName.getPrefWidth());
            this.getProperties().put((Object)"image", (Object)labelImage);
            if (this.image_option_heights != null) {
                this.image_option_heights.add(iv2.getBoundsInLocal().getHeight());
            }
            if (this.image_option_width != null) {
                this.image_option_width.add(iv2.getBoundsInLocal().getWidth());
            }
            existImage = true;
            prencent_height_name -= 0.6;
        }
        nameCategory.setPrefHeight(paneName.getPrefHeight() * prencent_height_name);
        nameCategory.setPrefWidth(paneName.getPrefWidth());
        GridPane paneMain = new GridPane();
        paneMain.setPrefHeight(paneName.getPrefHeight() * prencent_pane_main);
        paneMain.setPrefWidth(paneName.getPrefWidth());
        HBox pane = this.getAllergensPane();
        if (pane != null) {
            paneMain.add((Node)pane, 0, index_row++);
        }
        if (labelImage != null) {
            paneMain.add((Node)labelImage, 0, index_row++);
        }
        paneMain.add((Node)nameCategory, 0, index_row++);
        if (this.optionItem == null && !this.isIngredient || this.optionItem != null && this.optionItem instanceof OptionItem) {
            stack_pane = new StackPane();
            stack_pane.setPrefHeight(this.getPrefHeight());
            stack_pane.setPrefWidth(this.getPrefWidth());
            GridPane panePrice = new GridPane();
            panePrice.setPrefHeight(paneMain.getPrefHeight());
            panePrice.setPrefWidth(paneMain.getPrefWidth());
            panePrice.setAlignment(Pos.TOP_CENTER);
            Label labelPrice = new Label();
            labelPrice.setPrefHeight(panePrice.getPrefHeight() * 0.2);
            labelPrice.setPrefWidth(panePrice.getPrefWidth() * 0.3);
            labelPrice.setStyle("-fx-font-size: 11pt; -fx-font-weight: bold;");
            stack_pane.getChildren().add((Object)paneMain);
            stack_pane.getChildren().add((Object)panePrice);
            this.getProperties().put((Object)"panePrice", (Object)panePrice);
            this.getProperties().put((Object)"labelPrice", (Object)labelPrice);
            paneName.add((Node)stack_pane, 0, 0);
        } else {
            paneName.add((Node)paneMain, 0, 0);
        }
        if (add_footer_pane) {
            paneName.add((Node)pane_footer, 0, 1);
        }
        this.getProperties().put((Object)"label", (Object)nameCategory);
        this.getProperties().put((Object)"paneMain", (Object)paneMain);
        if (this.optionItem == null && this.isIngredient || this.optionItem != null && this.optionItem instanceof IngredientItem) {
            stack_pane = new StackPane();
            stack_pane.setPrefHeight(this.getPrefHeight());
            stack_pane.setPrefWidth(this.getPrefWidth());
            GridPane paneImage = new GridPane();
            paneImage.setPrefHeight(this.getPrefHeight());
            paneImage.setPrefWidth(this.getPrefWidth());
            ImageView image_select_ingredient = new ImageView();
            paneImage.setAlignment(Pos.TOP_CENTER);
            paneImage.add((Node)image_select_ingredient, 0, 0);
            stack_pane.getChildren().add((Object)paneName);
            stack_pane.getChildren().add((Object)paneImage);
            this.getProperties().put((Object)"image_select_ingredient", (Object)image_select_ingredient);
            this.setGraphic((Node)stack_pane);
        } else {
            if (!this.sub_supplement) {
                DropShadow dropShadow = new DropShadow();
                paneMain.setEffect((Effect)dropShadow);
                paneMain.setStyle("-fx-background-color:  white; -fx-background-radius: 1em");
            }
            this.setGraphic((Node)paneName);
            this.setStyle("-fx-background-color:  transparent;");
        }
    }

    public SupplementProduct getmSupplementProduct() {
        return this.groupeOption;
    }

    public SupplementItemInfo getOptionItem() {
        return this.option;
    }

    public ProductInfoExt getSubProduct() {
        return this.subProduct;
    }

    public void setSubProduct(ProductInfoExt subProduct) {
        this.subProduct = subProduct;
    }

    public HBox getAllergensPane() {
        List<AllergeneSupplement> allergensOptions = this.option.getAllergenes();
        if (allergensOptions != null && !allergensOptions.isEmpty()) {
            ArrayList<String> allergens = new ArrayList<String>();
            for (AllergeneSupplement allergen : allergensOptions) {
                allergens.add(allergen.getName());
            }
            String[] allergensArray = (String[])allergens.toArray(String[]::new);
            ImageView allergenCta = new ImageView(new Image(((Object)((Object)this)).getClass().getResourceAsStream("/images/allergens-cta.png")));
            allergenCta.setPreserveRatio(true);
            double imageSize = this.widthPane * 0.15;
            allergenCta.setFitWidth(imageSize);
            allergenCta.setPreserveRatio(true);
            allergenCta.setSmooth(true);
            allergenCta.setCache(true);
            allergenCta.setPickOnBounds(true);
            double circleSize = imageSize / 2.0;
            double translate = imageSize / 7.0;
            Circle clip = new Circle(circleSize, circleSize, circleSize);
            allergenCta.setClip((Node)clip);
            DropShadow dropShadow = new DropShadow();
            dropShadow.setColor(Color.rgb((int)50, (int)50, (int)50, (double)0.4));
            Group imageGroup = new Group(new Node[]{allergenCta});
            imageGroup.setTranslateX(translate);
            imageGroup.setTranslateY(-translate);
            imageGroup.setEffect((Effect)dropShadow);
            HBox hbox = new HBox();
            hbox.setPrefWidth(this.widthPane);
            hbox.setAlignment(Pos.TOP_RIGHT);
            hbox.getChildren().add((Object)imageGroup);
            this.getProperties().put((Object)"allergens", (Object)allergensArray);
            return hbox;
        }
        return null;
    }
}

