/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.components;

import com.openbravo.format.Formats;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.DateUtils;
import java.text.SimpleDateFormat;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;

public class OrderCell
extends HBox {
    private String orderId;
    private TicketInfo order;
    private GridPane pane;
    private double width;
    private final SimpleDateFormat timeFormatter = DateUtils.timeFormatter;
    private GridPane firstPane;
    private Label labelNew;
    private ImageView imageNew;

    public OrderCell() {
        this.width = AppVarUtils.getScreenDimension().getWidth() * 0.8 * 0.28;
        this.pane = new GridPane();
    }

    public OrderCell orderId(String orderId) {
        this.orderId = orderId;
        return this;
    }

    public OrderCell order(TicketInfo order) {
        this.order = order;
        return this;
    }

    public OrderCell imageNew(ImageView imageNew) {
        this.imageNew = imageNew;
        return this;
    }

    public OrderCell build() {
        Label first_label = new Label();
        Label second_label = new Label();
        Object text_first_label = this.timeFormatter.format(this.order.getDate());
        text_first_label = (String)text_first_label + "\n" + (this.order.getCustomer() != null ? this.order.getCustomer().getName() : this.order.getName_customer());
        Object text_second_label = "";
        first_label.setText((String)text_first_label);
        text_second_label = "N\u00b0" + this.order.getNumero_platform_order();
        text_second_label = (String)text_second_label + "\n" + Formats.CURRENCY.formatValue(this.order.getTotal() + this.order.getTotal_fee_ubereat() + this.order.getTax_ubereat());
        second_label.setAlignment(Pos.CENTER_RIGHT);
        second_label.setPrefWidth(this.width * 0.5);
        second_label.setText((String)text_second_label);
        this.pane.setPrefWidth(this.width);
        if (this.imageNew != null) {
            this.firstPane = new GridPane();
            this.firstPane.setPrefWidth(this.width * 0.5);
            this.labelNew = new Label();
            this.labelNew.setGraphic((Node)this.imageNew);
            this.firstPane.add((Node)first_label, 0, 0);
            this.firstPane.add((Node)this.labelNew, 1, 0);
            this.pane.add((Node)this.firstPane, 0, 0);
        } else {
            first_label.setPrefWidth(this.width * 0.5);
            this.pane.add((Node)first_label, 0, 0);
        }
        this.pane.add((Node)second_label, 1, 0);
        this.pane.setMaxWidth(Double.MAX_VALUE);
        this.getChildren().add((Object)this.pane);
        return this;
    }

    public OrderCell buildLine() {
        this.pane.setPrefWidth(this.width);
        this.pane.setPrefHeight(2.0);
        this.pane.getStyleClass().add((Object)"bg_8395a7");
        this.getChildren().add((Object)this.pane);
        this.setPrefHeight(2.0);
        return this;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public TicketInfo getOrder() {
        return this.order;
    }

    public Label getLabelNew() {
        return this.labelNew;
    }
}

