/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.components;

import com.openbravo.pos.ticket.CarteOrderInfo;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.ticket.SupplementProduct;
import com.openbravo.pos.util.ColorUtils;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;

public class OptionDetailProductTab
extends Button {
    private SupplementProduct groupOption;
    private int index;
    private String styleOptionPane = "-fx-background-color: #5C606B; -fx-background-radius: 12px";
    private String style = "-fx-background-color: transparent;  -fx-background-radius: 12px 12px 0px 0px;";
    private String styleSelected;
    private String styleSelectedOptionPane;
    private String styleName = "-fx-text-fill: white; -fx-font-size: 12px;";
    private String styleInfos = "-fx-text-fill: white; -fx-font-size: 10px";
    private Label labelName;
    private Label labelInfosOption;
    private double width;
    private double height;
    private GridPane groupOptionPane;
    private GridPane baseFrame;
    private CarteOrderInfo groupProducts;
    private ProductInfoExt product;

    public OptionDetailProductTab() {
        this.init();
    }

    public OptionDetailProductTab(CarteOrderInfo groupProducts, ProductInfoExt product, SupplementProduct groupOption, double width, double height, int index) {
        this.groupProducts = groupProducts;
        this.product = product;
        this.width = width;
        this.height = height;
        this.groupOption = groupOption;
        this.index = index;
        this.init();
    }

    private void init() {
        this.setPrefHeight(this.height);
        this.setPrefWidth(this.width);
        this.labelName = new Label();
        this.labelName.setText(this.groupOption.getName());
        this.labelName.setStyle(this.styleName);
        this.baseFrame = new GridPane();
        this.baseFrame.setPrefHeight(this.height);
        this.baseFrame.setPrefWidth(this.width);
        this.baseFrame.setAlignment(Pos.TOP_CENTER);
        this.groupOptionPane = new GridPane();
        this.groupOptionPane.setAlignment(Pos.CENTER);
        this.groupOptionPane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        this.groupOptionPane.setPrefHeight(this.height * 0.8);
        this.groupOptionPane.setPrefWidth(this.width);
        this.labelName.setPrefHeight(this.groupOptionPane.getPrefHeight() * 0.4);
        this.labelName.setPrefWidth(this.width);
        this.groupOptionPane.add((Node)this.labelName, 0, 0);
        this.labelInfosOption = new Label();
        this.labelInfosOption.setStyle(this.styleInfos);
        if (this.groupOption != null && !this.groupOption.getIs_ingredient().booleanValue()) {
            this.labelInfosOption.setText(this.groupOption.getMin_options() + " min - " + this.groupOption.getMax_options() + " max");
        }
        this.labelInfosOption.setPrefHeight(this.groupOptionPane.getPrefHeight() * 0.4);
        this.labelInfosOption.setPrefWidth(this.width);
        this.groupOptionPane.add((Node)this.labelInfosOption, 0, 1);
        this.groupOptionPane.setStyle(this.styleOptionPane);
        this.baseFrame.add((Node)this.groupOptionPane, 0, 0);
        this.setGraphic((Node)this.baseFrame);
        this.setStyle(this.style);
        String bg_color_option = this.groupOption.getColor() != null && !this.groupOption.getColor().isEmpty() ? ColorUtils.getColor(this.groupOption.getColor()) : "#333645";
        this.styleSelected = "-fx-background-color: " + bg_color_option + ";-fx-background-radius: 12px 12px 0px 0px;";
        this.styleSelectedOptionPane = "-fx-background-color: " + bg_color_option + "; -fx-background-radius: 12px;";
    }

    public SupplementProduct getGroupOption() {
        return this.groupOption;
    }

    public void setGroupOption(SupplementProduct groupOption) {
        this.groupOption = groupOption;
    }

    public void deselect() {
        this.setStyle(this.style);
        this.groupOptionPane.setStyle(this.styleOptionPane);
    }

    public void select() {
        this.setStyle(this.styleSelected);
        this.groupOptionPane.setStyle(this.styleSelectedOptionPane);
    }

    public CarteOrderInfo getGroupProducts() {
        return this.groupProducts;
    }

    public void setGroupProducts(CarteOrderInfo groupProducts) {
        this.groupProducts = groupProducts;
    }

    public ProductInfoExt getProduct() {
        return this.product;
    }

    public void setProduct(ProductInfoExt product) {
        this.product = product;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }
}

