/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.components;

import com.openbravo.format.Formats;
import com.openbravo.pos.ticket.CarteOrderInfo;
import com.openbravo.pos.ticket.GroupSubSupplementInfo;
import com.openbravo.pos.ticket.OptionItemOrder;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.ticket.SupplementItemInfo;
import com.openbravo.pos.ticket.SupplementProduct;
import com.openbravo.pos.util.LogToFile;
import java.net.URISyntaxException;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.scene.shape.Circle;
import javafx.scene.shape.SVGPath;
import javafx.scene.text.TextAlignment;

public class OptionDetailProductButton
extends Button {
    private SupplementItemInfo optionItem;
    private String style = "-fx-padding: 0 0 0 0; -fx-background-color: #FFFFFF1F; -fx-border-color: #FFFFFF1F;-fx-background-radius: 12px; -fx-border-radius: 12px;";
    private String styleSelectedFree = "-fx-padding: 0 0 0 0; -fx-background-color: #FFFFFF1F; -fx-border-color: #0B8871;-fx-background-radius: 12px; -fx-border-radius: 12px;";
    private String styleSelectedPaid = "-fx-padding: 0 0 0 0; -fx-background-color: #FFFFFF1F; -fx-border-color: #FB5B4D;-fx-background-radius: 12px; -fx-border-radius: 12px;";
    private final String styleTextPrice = "-fx-text-fill: white; -fx-font-weight: Normal; -fx-font-size: 14px;";
    private final String styleName = "-fx-text-fill: white; -fx-font-weight: Normal; -fx-font-size: 14px;";
    private final String styleQuantityPaid = "-fx-font-size: 14px; -fx-text-fill: #FB5B4D; -fx-border-color : #FB5B4D; -fx-background-radius: 3em; -fx-background-color: #FFF; -fx-border-radius: 3em;";
    private final String styleQuantityFree = "-fx-font-size: 14px; -fx-text-fill: #0B8871; -fx-border-color : #0B8871; -fx-background-radius: 3em; -fx-background-color: #FFF; -fx-border-radius: 3em;";
    private final String styleLabelBGPaid = "-fx-background-color: #FB5B4D;-fx-padding: 0 0 0 0; ";
    private final String styleLabelBGFree = "-fx-background-color: #0B8871;-fx-padding: 0 0 0 0; ";
    private double height;
    private double width;
    private Image imageItem;
    private GridPane optionPane;
    private Label textPrice;
    private Label labelName;
    private StackPane basePane;
    private GridPane quantityPane;
    private GridPane quantityValuePane;
    private GridPane quantityIncreasePane;
    private GridPane quantityDecreasePane;
    private Label quantityValueLabel;
    private Button quantityIncreaseButton;
    private Button quantityDecreaseButton;
    private Image imageDecrease;
    private Image imageIncrease;
    private boolean selected;
    private SupplementProduct groupOption;
    private int quantity;
    private String eventName;
    private CarteOrderInfo groupProducts;
    private ProductInfoExt subProduct;
    private Arc arcLeft;
    private Arc arcRight;
    private OptionItemOrder optionItemOrder;
    private Label labelBgRight;
    private SVGPath svgPathRight;
    private SVGPath svgPathLeft;
    private GroupSubSupplementInfo groupSubSupplementInfo;
    private int index_group_option;
    private ImageView imageViewRight;
    private ImageView imageViewLeft;
    private Image imageRight;
    private Image imageRightFree;
    private Image imageLeft;
    private Image imageLeftFree;

    public OptionDetailProductButton() {
        this.init();
    }

    public OptionDetailProductButton(CarteOrderInfo groupProducts, ProductInfoExt subProduct, SupplementProduct groupOption, GroupSubSupplementInfo groupSubSupplementInfo, SupplementItemInfo optionItem, double height, double width, Image imageItem, Image imageDecrease, Image imageIncrease) {
        this.groupProducts = groupProducts;
        this.subProduct = subProduct;
        this.groupOption = groupOption;
        this.groupSubSupplementInfo = groupSubSupplementInfo;
        this.optionItem = optionItem;
        this.height = height;
        this.width = width;
        this.imageItem = imageItem;
        this.imageDecrease = imageDecrease;
        this.imageIncrease = imageIncrease;
        this.init();
    }

    public SupplementItemInfo getOption() {
        return this.optionItem;
    }

    public void setOption(SupplementItemInfo option) {
        this.optionItem = option;
    }

    private void init() {
        this.setPrefHeight(this.height);
        this.setPrefWidth(this.width);
        this.buildPaneOption();
    }

    private void buildPaneOption() {
        this.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
        this.basePane = new StackPane();
        this.basePane.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
        this.basePane.setPrefHeight(this.height * 0.9);
        this.basePane.setPrefWidth(this.width);
        this.optionPane = new GridPane();
        this.optionPane.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
        this.optionPane.setAlignment(Pos.CENTER);
        this.optionPane.setPrefHeight(this.height * 0.9);
        this.optionPane.setPrefWidth(this.width);
        GridPane paneImages = new GridPane();
        paneImages.setAlignment(Pos.CENTER);
        paneImages.setPrefHeight(this.optionPane.getPrefHeight() * 0.5);
        paneImages.setPrefWidth(this.optionPane.getPrefWidth());
        StackPane stackPaneImage = new StackPane();
        Label labelImage = new Label();
        labelImage.setAlignment(Pos.CENTER);
        labelImage.setPrefHeight(this.optionPane.getPrefHeight() * 0.5);
        labelImage.setPrefWidth(this.optionPane.getPrefHeight() * 0.5);
        if (this.imageItem != null) {
            ImageView imageView = new ImageView(this.imageItem);
            imageView.setFitHeight(labelImage.getPrefHeight() * 0.8);
            imageView.setFitWidth(labelImage.getPrefHeight() * 0.8);
            imageView.setPreserveRatio(false);
            imageView.setSmooth(false);
            labelImage.setGraphic((Node)imageView);
            Circle circle = new Circle();
            circle.setRadius(labelImage.getPrefWidth() / 2.0);
            circle.setFill((Paint)Color.WHITE);
            stackPaneImage.getChildren().add((Object)circle);
            stackPaneImage.getChildren().add((Object)labelImage);
        }
        paneImages.add((Node)stackPaneImage, 0, 0);
        this.textPrice = new Label(Formats.CURRENCY.formatValue(this.optionItem.getPrice_order()));
        this.textPrice.setTextAlignment(TextAlignment.CENTER);
        this.textPrice.setAlignment(Pos.CENTER);
        this.labelName = new Label(this.optionItem.getDisplayedName());
        this.labelName.setAlignment(Pos.CENTER);
        this.labelName.setTextAlignment(TextAlignment.CENTER);
        this.labelName.setWrapText(true);
        this.labelName.setPrefHeight(this.optionPane.getPrefHeight() * 0.3);
        this.labelName.setPrefWidth(this.optionPane.getPrefWidth());
        this.textPrice.setPrefHeight(this.optionPane.getPrefHeight() * 0.2);
        this.textPrice.setPrefWidth(this.optionPane.getPrefWidth());
        this.labelName.setStyle("-fx-text-fill: white; -fx-font-weight: Normal; -fx-font-size: 14px;");
        this.textPrice.setStyle("-fx-text-fill: white; -fx-font-weight: Normal; -fx-font-size: 14px;");
        this.optionPane.add((Node)paneImages, 0, 0);
        this.optionPane.add((Node)this.labelName, 0, 1);
        this.optionPane.add((Node)this.textPrice, 0, 2);
        this.basePane.getChildren().add((Object)this.optionPane);
        this.quantityPane = new GridPane();
        this.quantityPane.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
        this.quantityPane.setAlignment(Pos.CENTER);
        this.quantityPane.setPrefHeight(this.height * 0.9);
        this.quantityPane.setPrefWidth(this.width);
        this.quantityValuePane = new GridPane();
        this.quantityValuePane.setAlignment(Pos.CENTER);
        this.quantityValuePane.setPrefHeight(this.quantityPane.getPrefHeight() * 0.7);
        this.quantityValuePane.setPrefWidth(this.quantityPane.getPrefWidth() * 0.32);
        this.quantityIncreasePane = new GridPane();
        this.quantityIncreasePane.setAlignment(Pos.CENTER_RIGHT);
        this.quantityIncreasePane.setPrefHeight(this.quantityPane.getPrefHeight() * 0.7);
        this.quantityIncreasePane.setPrefWidth(this.quantityPane.getPrefWidth() * 0.34);
        this.quantityDecreasePane = new GridPane();
        this.quantityDecreasePane.setAlignment(Pos.CENTER_LEFT);
        this.quantityDecreasePane.setPrefHeight(this.quantityPane.getPrefHeight() * 0.7);
        this.quantityDecreasePane.setPrefWidth(this.quantityPane.getPrefWidth() * 0.34);
        this.quantityValueLabel = new Label();
        this.quantityValueLabel.setAlignment(Pos.CENTER);
        this.quantityValueLabel.setTextAlignment(TextAlignment.CENTER);
        this.quantityValueLabel.setPrefHeight(this.quantityValuePane.getPrefHeight() * 0.4);
        this.quantityValueLabel.setPrefWidth(this.quantityValuePane.getPrefHeight() * 0.4);
        this.quantityValuePane.add((Node)this.quantityValueLabel, 0, 0);
        this.quantityIncreaseButton = new Button();
        this.quantityIncreaseButton.setAlignment(Pos.CENTER_RIGHT);
        this.quantityIncreaseButton.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
        this.quantityIncreaseButton.setPrefHeight(this.quantityIncreasePane.getPrefHeight());
        this.quantityIncreaseButton.setPrefWidth(this.quantityIncreasePane.getPrefWidth() * 0.7);
        this.quantityIncreaseButton.setStyle(" -fx-background-color : transparent; -fx-padding: 0 0 0 0;");
        ImageView stackPaneRight = this.getBackgroundIncreaseQtt();
        this.quantityIncreaseButton.setGraphic((Node)stackPaneRight);
        this.quantityIncreasePane.add((Node)this.quantityIncreaseButton, 0, 0);
        this.quantityDecreaseButton = new Button();
        this.quantityDecreaseButton.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
        this.quantityDecreaseButton.setAlignment(Pos.CENTER_LEFT);
        this.quantityDecreaseButton.setPrefHeight(this.quantityDecreasePane.getPrefHeight());
        this.quantityDecreaseButton.setPrefWidth(this.quantityDecreasePane.getPrefWidth() * 0.7);
        ImageView stackPaneLeft = this.getBackgroundDecreaseQtt();
        this.quantityDecreaseButton.setGraphic((Node)stackPaneLeft);
        this.quantityDecreaseButton.setStyle(" -fx-background-color : transparent; -fx-padding: 0 0 0 0;");
        this.quantityDecreasePane.add((Node)this.quantityDecreaseButton, 0, 0);
        this.quantityPane.add((Node)this.quantityDecreasePane, 0, 0);
        this.quantityPane.add((Node)this.quantityValuePane, 1, 0);
        this.quantityPane.add((Node)this.quantityIncreasePane, 2, 0);
        this.quantityPane.setVisible(false);
        this.basePane.getChildren().add((Object)this.quantityPane);
        this.setGraphic((Node)this.basePane);
    }

    public void select() {
        this.checkFreeAndSetStyle();
        this.selected = true;
        this.quantityPane.setVisible(true);
    }

    public void deselect() {
        this.setStyle(this.style);
        this.selected = false;
        this.quantityPane.setVisible(false);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public SupplementProduct getGroupOption() {
        return this.groupOption;
    }

    public void setGroupOption(SupplementProduct supplementProduct) {
        this.groupOption = supplementProduct;
    }

    public Button getQuantityIncreaseButton() {
        return this.quantityIncreaseButton;
    }

    public void setQuantityIncreaseButton(Button quantityIncreaseButton) {
        this.quantityIncreaseButton = quantityIncreaseButton;
    }

    public Button getQuantityDecreaseButton() {
        return this.quantityDecreaseButton;
    }

    public void setQuantityDecreaseButton(Button quantityDecreaseButton) {
        this.quantityDecreaseButton = quantityDecreaseButton;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public void setQuantity(int quantity) {
        this.quantity = quantity;
        this.quantityValueLabel.setText(String.valueOf(quantity));
    }

    public String getEventName() {
        return this.eventName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    private ImageView getBackgroundIncreaseQtt() {
        this.imageViewRight = new ImageView();
        try {
            this.imageRight = new Image(((Object)((Object)this)).getClass().getResource("/com/openbravo/images/increase_qtt_option.png").toURI().toString());
            this.imageRightFree = new Image(((Object)((Object)this)).getClass().getResource("/com/openbravo/images/increase_qtt_option_free.png").toURI().toString());
        }
        catch (URISyntaxException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return this.imageViewRight;
    }

    private ImageView getBackgroundDecreaseQtt() {
        this.imageViewLeft = new ImageView();
        try {
            this.imageLeft = new Image(((Object)((Object)this)).getClass().getResource("/com/openbravo/images/decrease_qtt_option.png").toURI().toString());
            this.imageLeftFree = new Image(((Object)((Object)this)).getClass().getResource("/com/openbravo/images/decrease_qtt_option_free.png").toURI().toString());
        }
        catch (URISyntaxException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return this.imageViewLeft;
    }

    public CarteOrderInfo getGroupProducts() {
        return this.groupProducts;
    }

    public void setGroupProducts(CarteOrderInfo groupProducts) {
        this.groupProducts = groupProducts;
    }

    public ProductInfoExt getSubProduct() {
        return this.subProduct;
    }

    public void setSubProduct(ProductInfoExt subProduct) {
        this.subProduct = subProduct;
    }

    public void checkFreeAndSetStyle() {
        boolean isFree;
        boolean bl = isFree = this.optionItemOrder.getNumberOption() == this.optionItemOrder.getNumber_free() && this.optionItemOrder.getNumberOption() > 0;
        if (isFree) {
            this.quantityValueLabel.setStyle("-fx-font-size: 14px; -fx-text-fill: #0B8871; -fx-border-color : #0B8871; -fx-background-radius: 3em; -fx-background-color: #FFF; -fx-border-radius: 3em;");
            this.setStyle(this.styleSelectedFree);
            this.setImage(this.imageViewLeft, this.imageLeftFree);
            this.setImage(this.imageViewRight, this.imageRightFree);
        } else {
            this.quantityValueLabel.setStyle("-fx-font-size: 14px; -fx-text-fill: #FB5B4D; -fx-border-color : #FB5B4D; -fx-background-radius: 3em; -fx-background-color: #FFF; -fx-border-radius: 3em;");
            this.setStyle(this.styleSelectedPaid);
            this.setImage(this.imageViewLeft, this.imageLeft);
            this.setImage(this.imageViewRight, this.imageRight);
        }
    }

    public OptionItemOrder getOptionItemOrder() {
        return this.optionItemOrder;
    }

    public void setOptionItemOrder(OptionItemOrder optionItemOrder) {
        this.optionItemOrder = optionItemOrder;
    }

    public Image getImageItem() {
        return this.imageItem;
    }

    public void setImageItem(Image imageItem) {
        this.imageItem = imageItem;
    }

    public GroupSubSupplementInfo getGroupSubSupplementInfo() {
        return this.groupSubSupplementInfo;
    }

    public void setGroupSubSupplementInfo(GroupSubSupplementInfo groupSubSupplementInfo) {
        this.groupSubSupplementInfo = groupSubSupplementInfo;
    }

    public int getIndex_group_option() {
        return this.index_group_option;
    }

    public void setIndex_group_option(int index_group_option) {
        this.index_group_option = index_group_option;
    }

    private void setImage(ImageView imageView, Image image) {
        imageView.setImage(image);
        imageView.setStyle("-fx-padding: 0 0 0 0;");
        imageView.setFitHeight(this.quantityPane.getPrefHeight() * 0.7);
        imageView.setPreserveRatio(true);
        imageView.setSmooth(true);
    }
}

