/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.components;

import com.openbravo.format.Formats;
import com.openbravo.pos.util.AppVarUtils;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import org.json.JSONArray;
import org.json.JSONObject;

public class OnLineCell
extends HBox {
    int indexLine;
    Label label = new Label();
    Label labelPrice = new Label();
    Label labelUnit = new Label();
    Label labelTotal = new Label();
    Button button = new Button();
    private double maxWidth;
    private HBox hboxProduit = new HBox();
    private GridPane pane = new GridPane();
    boolean discount;
    boolean disocuntOrder;

    public OnLineCell(JSONObject line) {
        String itemName;
        int j;
        this.maxWidth = AppVarUtils.getScreenDimension().getWidth() * 0.7 * 0.5 - 65.0;
        this.hboxProduit = new HBox();
        this.pane = new GridPane();
        this.pane.setVgap(2.0);
        this.pane.setHgap(2.0);
        String quantity = !line.isNull("quantity") ? "" + line.getInt("quantity") : "1";
        String name_product = !line.isNull("size") ? line.getString("title") + " - " + line.getString("size") : line.getString("title");
        this.label.setWrapText(true);
        this.label.getStyleClass().add((Object)"align-left");
        this.label.setText(name_product);
        this.labelUnit.setText(quantity);
        this.labelPrice.setText(Formats.CURRENCY.formatValue(line.getDouble("price")));
        this.labelTotal.setText(Formats.CURRENCY.formatValue(line.getDouble("price") * line.getDouble("quantity")));
        this.label.setPrefWidth(this.maxWidth * 0.6);
        this.labelUnit.setPrefWidth(this.maxWidth * 0.1);
        this.labelPrice.setPrefWidth(this.maxWidth * 0.15);
        this.labelTotal.setPrefWidth(this.maxWidth * 0.15);
        this.hboxProduit.getChildren().addAll((Object[])new Node[]{this.labelUnit, this.label, this.labelPrice, this.labelTotal});
        this.hboxProduit.setMaxWidth(Double.MAX_VALUE);
        this.pane.add((Node)this.hboxProduit, 0, 0);
        int i = 1;
        if (!line.isNull("supplements")) {
            JSONArray supplements = line.getJSONArray("supplements");
            for (j = 0; j < supplements.length(); ++j) {
                JSONObject supplement = supplements.getJSONObject(j);
                if (supplement.getDouble("amount") == 0.0) continue;
                double numberOptions = 1.0;
                itemName = line.getString("name");
                HBox hboxOption = new HBox();
                Label labelOption = new Label(itemName);
                labelOption.setPrefWidth(this.maxWidth * 0.6);
                Label labelUnitOption = new Label(String.valueOf(numberOptions));
                Label labelPriceOption = new Label(Formats.CURRENCY.formatValue(line.getDouble("amount")));
                Label labelTotalOption = new Label(Formats.CURRENCY.formatValue(numberOptions * line.getDouble("amount")));
                labelUnitOption.setPrefWidth(this.maxWidth * 0.1);
                labelPriceOption.setPrefWidth(this.maxWidth * 0.15);
                labelTotalOption.setPrefWidth(this.maxWidth * 0.15);
                hboxOption.getChildren().addAll((Object[])new Node[]{labelUnitOption, labelOption, labelPriceOption, labelTotalOption});
                this.pane.add((Node)hboxOption, 0, i);
                ++i;
            }
        }
        if (!line.isNull("items")) {
            JSONArray products = line.getJSONArray("items");
            for (j = 0; j < products.length(); ++j) {
                JSONObject product = products.getJSONObject(j);
                JSONObject item = product.getJSONObject("item");
                String numberOptions = String.valueOf(1);
                itemName = item.getString("name");
                HBox hboxItem = new HBox();
                Label labelItem = new Label();
                labelItem.setText(itemName);
                labelItem.setPrefWidth(this.maxWidth * 0.6);
                Label labelPriceItem = new Label();
                Label labelTotalItem = new Label();
                Label labelUnitItem = new Label();
                labelPriceItem.setPrefWidth(this.maxWidth * 0.1);
                labelTotalItem.setPrefWidth(this.maxWidth * 0.15);
                labelUnitItem.setPrefWidth(this.maxWidth * 0.15);
                labelUnitItem.setText(numberOptions);
                labelPriceItem.setText(!product.isNull("price") ? Formats.CURRENCY.formatValue(product.getDouble("price")) : "");
                labelTotalItem.setText(!product.isNull("amount") ? Formats.CURRENCY.formatValue(product.getDouble("amount")) : "");
                hboxItem.getChildren().addAll((Object[])new Node[]{labelUnitItem, labelItem, labelPriceItem, labelTotalItem});
                this.pane.add((Node)hboxItem, 0, i);
                ++i;
            }
        }
        if (!line.isNull("note") && !line.getString("note").isEmpty()) {
            HBox hboxItem = new HBox();
            Label labelNote = new Label();
            labelNote.setText("NB. : " + line.getString("note"));
            labelNote.setPrefWidth(this.maxWidth);
            hboxItem.getChildren().addAll((Object[])new Node[]{labelNote});
            this.pane.add((Node)hboxItem, 0, i);
        }
        this.pane.setMaxWidth(Double.MAX_VALUE);
        this.getChildren().add((Object)this.pane);
    }

    public String toString() {
        return super.toString();
    }
}

