/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.components;

import com.openbravo.components.SwitchButton;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.ticket.SupplementItemInfo;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;

public class NodeItemOnOff
extends GridPane {
    private Object item;
    private Image image;
    private double height;
    private double width;
    private SwitchButton mSwitchButton;
    private String itemType;

    public NodeItemOnOff item(Object item) {
        this.item = item;
        return this;
    }

    public NodeItemOnOff image(Image image) {
        this.image = image;
        return this;
    }

    public NodeItemOnOff height(double height) {
        this.height = height;
        return this;
    }

    public NodeItemOnOff width(double width) {
        this.width = width;
        return this;
    }

    public NodeItemOnOff itemType(String itemType) {
        this.itemType = itemType;
        return this;
    }

    public NodeItemOnOff build() {
        this.setAlignment(Pos.CENTER);
        this.setPrefHeight(this.height);
        this.setPrefWidth(this.width);
        Label labelName = new Label();
        labelName.setAlignment(Pos.CENTER);
        labelName.getStyleClass().add((Object)"text-white");
        labelName.setWrapText(true);
        labelName.setPrefHeight(this.getPrefHeight() * 0.6);
        GridPane paneSwitch = new GridPane();
        paneSwitch.setPrefHeight(this.getPrefHeight() * 0.4);
        paneSwitch.setAlignment(Pos.CENTER);
        if (this.image != null) {
            Label labelImage = new Label();
            labelImage.setPrefHeight(this.getPrefHeight() * 0.9);
            labelImage.setPrefWidth(this.getPrefWidth() * 0.5);
            ImageView imageOption = this.getImage(this.image);
            labelImage.setGraphic((Node)imageOption);
            labelName.setPrefWidth(this.getPrefWidth() * 0.5);
            paneSwitch.setPrefWidth(this.getPrefWidth() * 0.5);
            this.add((Node)labelImage, 0, 0, 1, 2);
            this.add((Node)labelName, 1, 0, 1, 1);
            this.add((Node)paneSwitch, 1, 1, 1, 1);
        } else {
            labelName.setPrefWidth(this.getPrefWidth());
            paneSwitch.setPrefWidth(this.getPrefWidth());
            this.add((Node)labelName, 0, 0);
            this.add((Node)paneSwitch, 0, 1);
        }
        double width_switch = 50.0;
        this.mSwitchButton = new SwitchButton(width_switch, width_switch * 0.5);
        paneSwitch.add((Node)this.mSwitchButton, 0, 0);
        switch (this.itemType) {
            case "option_item": {
                if (!(this.item instanceof SupplementItemInfo)) break;
                SupplementItemInfo optionItem = (SupplementItemInfo)this.item;
                labelName.setText(optionItem.getName());
                if (optionItem.isSold_out()) {
                    this.mSwitchButton.setOff();
                    break;
                }
                this.mSwitchButton.setOn();
                break;
            }
            case "product_item": {
                if (!(this.item instanceof ProductInfoExt)) break;
                ProductInfoExt product = (ProductInfoExt)this.item;
                labelName.setText(product.getName());
                if (product.isSold_out()) {
                    this.mSwitchButton.setOff();
                    break;
                }
                this.mSwitchButton.setOn();
                break;
            }
            case "ingredient_item": {
                if (!(this.item instanceof SupplementItemInfo)) break;
                SupplementItemInfo optionItem = (SupplementItemInfo)this.item;
                labelName.setText(optionItem.getName());
                if (optionItem.isSold_out()) {
                    this.mSwitchButton.setOff();
                    break;
                }
                this.mSwitchButton.setOn();
            }
        }
        return this;
    }

    private ImageView getImage(Image image) {
        ImageView imageOption = new ImageView(image);
        imageOption.setFitHeight(this.getPrefHeight() * 0.6);
        imageOption.setPreserveRatio(true);
        imageOption.setSmooth(true);
        imageOption.setCache(true);
        return imageOption;
    }

    public SwitchButton getmSwitchButton() {
        return this.mSwitchButton;
    }

    public void setmSwitchButton(SwitchButton mSwitchButton) {
        this.mSwitchButton = mSwitchButton;
    }

    public Object getItem() {
        return this.item;
    }

    public void setItem(Object item) {
        this.item = item;
    }

    public String getItemType() {
        return this.itemType;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
    }
}

