/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.components;

import com.openbravo.components.base.AppLoaderBuilder;
import com.openbravo.components.base.AppLoaderComponent;
import com.openbravo.components.interfaces.EventHiddenModal;
import com.openbravo.pos.forms.AppLocal;
import java.awt.Dimension;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.EventHandler;
import javafx.scene.Scene;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.WindowEvent;

public class LazyModal
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Stage modalStage;
    private String mUrlFileXml;
    private Dimension mDimension;
    private EventHiddenModal mEventHiddenModal;
    private AppLoaderBuilder mLoadder;
    private Scene mParentScene;
    private StageStyle mStageStyle = StageStyle.UTILITY;
    private Modality mModality = Modality.APPLICATION_MODAL;
    private boolean isDetroyed = false;

    private LazyModal(Scene mParentScene, String mUrlFileXml, Dimension mDimension, EventHiddenModal mEventHiddenModal) {
        this.mParentScene = mParentScene;
        this.mUrlFileXml = mUrlFileXml;
        this.mDimension = mDimension;
        this.mEventHiddenModal = mEventHiddenModal;
        this.modalStage = new Stage();
    }

    public LazyModal(StageStyle mStageStyle, Scene mParentScene, String mUrlFileXml, Dimension mDimension, EventHiddenModal mEventHiddenModal) {
        this(mParentScene, mUrlFileXml, mDimension, mEventHiddenModal);
        this.mStageStyle = mStageStyle;
        this.initStageProperties();
    }

    public LazyModal(StageStyle mStageStyle, Scene mParentScene, String mUrlFileXml, Dimension mDimension) {
        this(mParentScene, mUrlFileXml, mDimension, null);
        this.mStageStyle = mStageStyle;
        this.initStageProperties();
    }

    public LazyModal(Modality mModality, Scene mParentScene, String mUrlFileXml, Dimension mDimension, EventHiddenModal mEventHiddenModal) {
        this(mParentScene, mUrlFileXml, mDimension, mEventHiddenModal);
        this.mModality = mModality;
        this.initStageProperties();
    }

    public LazyModal(Modality mModality, Scene mParentScene, String mUrlFileXml, Dimension mDimension) {
        this(mParentScene, mUrlFileXml, mDimension, null);
        this.mModality = mModality;
        this.initStageProperties();
    }

    public LazyModal(Modality mModality, StageStyle mStageStyle, Scene mParentScene, String mUrlFileXml, Dimension mDimension, EventHiddenModal mEventHiddenModal) {
        this(mParentScene, mUrlFileXml, mDimension, mEventHiddenModal);
        this.mModality = mModality;
        this.mStageStyle = mStageStyle;
        this.initStageProperties();
    }

    public void setEventHiddenModal(EventHiddenModal mEventHiddenModal) {
        this.mEventHiddenModal = mEventHiddenModal;
    }

    public AppLoaderBuilder getLoadder() {
        return this.mLoadder;
    }

    public Stage getModalStage() {
        return this.modalStage;
    }

    private void initStageProperties() {
        this.modalStage.initOwner(this.mParentScene.getWindow());
        this.modalStage.initModality(this.mModality);
        this.modalStage.initStyle(StageStyle.TRANSPARENT);
    }

    public void load(Object ... args) {
        if (this.modalStage == null || !this.isDetroyed) {
            this.modalStage = new Stage();
            this.initStageProperties();
        }
        try {
            this.mLoadder = AppLoaderComponent.build(this.getClass().getResource(this.mUrlFileXml), this.mDimension.getWidth(), this.mDimension.getHeight());
            if (this.mLoadder != null) {
                this.modalStage.setResizable(false);
                this.mLoadder.getScene().setFill((Paint)Color.TRANSPARENT);
                this.modalStage.setScene(this.mLoadder.getScene());
                this.modalStage.setAlwaysOnTop(true);
                this.mLoadder.getController().init(this.modalStage, args);
                this.mLoadder.getScene().getStylesheets().add((Object)"/styles/styles.css");
                this.mLoadder.getScene().getStylesheets().add((Object)"/styles/app.css");
                this.show();
                this.appendToList();
                this.onHideAction();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(LazyModal.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void show() {
        if (this.modalStage != null) {
            this.modalStage.show();
        }
    }

    public void hide() {
        if (this.modalStage != null) {
            this.modalStage.hide();
        }
    }

    public void appendToList() {
        if (this.modalStage != null) {
            AppLocal.listPopUp.add(this.modalStage);
        }
    }

    public void removeFromList() {
        if (this.modalStage != null) {
            if (this.modalStage.isShowing()) {
                this.hide();
            }
            AppLocal.listPopUp.remove(this.modalStage);
        }
    }

    private void onHideAction() {
        if (this.modalStage != null) {
            this.modalStage.setOnHidden((EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent event) {
                    if (LazyModal.this.mEventHiddenModal != null) {
                        LazyModal.this.mEventHiddenModal.onHidden(LazyModal.this.mLoadder);
                    } else {
                        LazyModal.this.mLoadder = null;
                        LazyModal.this.modalStage = null;
                        LazyModal.this.isDetroyed = true;
                    }
                    LazyModal.this.removeFromList();
                }
            });
        }
    }

    public void destroyEvents() {
        if (this.mLoadder != null) {
            this.mLoadder.reset();
        }
        this.mLoadder = null;
        this.modalStage = null;
        this.isDetroyed = true;
    }

    public Dimension getmDimension() {
        return this.mDimension;
    }

    public void setmDimension(Dimension mDimension) {
        this.mDimension = mDimension;
    }

    public Scene getmParentScene() {
        return this.mParentScene;
    }

    public void setmParentScene(Scene mParentScene) {
        this.mParentScene = mParentScene;
    }
}

