/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.components;

import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.CarteOrderInfo;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.ticket.SupplementItemInfo;
import com.openbravo.pos.util.StringUtils;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow;

public class IngredientDetailProductButton
extends Button {
    private SupplementItemInfo ingredient;
    private String style = "-fx-background-color: #232531; -fx-border-color: #FFFFFF3D;-fx-background-radius: 12px; -fx-border-radius: 12px;";
    private final String style_text_without = "-fx-fill: white; -fx-font-weight: Normal;";
    private final String style_textflow_without = "-fx-background-color: #EE5540; -fx-background-radius: 6px; -fx-font-size: 12px; -fx-font-weight: Normal;";
    private final String style_name = "-fx-fill: white; -fx-font-size: 14px;  -fx-font-weight: Normal;";
    private final String style_text_without_removed = "-fx-fill: #BB4849; -fx-font-size: 12px; -fx-font-weight: Normal;";
    private final String style_textflow_without_removed = "-fx-font-size: 12px; -fx-font-weight: Normal;";
    private double height;
    private double width;
    private Image imageItem;
    private boolean removed;
    private Image imageRemovedIngredient;
    private GridPane paneIngredient;
    private Text textWithout;
    private TextFlow textFlowWithout;
    private Label labelName;
    private ImageView imageViewRemovedIngredient;
    private Label labelImageRemovedImgredient;
    private Text textName;
    private CarteOrderInfo groupProducts;
    private ProductInfoExt supProduct;

    public IngredientDetailProductButton() {
        this.init();
    }

    public IngredientDetailProductButton(CarteOrderInfo groupProducts, ProductInfoExt supProduct, SupplementItemInfo ingredient, double height, double width, Image imageItem, Image imageRemovedIngredient, boolean removed) {
        this.groupProducts = groupProducts;
        this.supProduct = supProduct;
        this.ingredient = ingredient;
        this.height = height;
        this.width = width;
        this.imageItem = imageItem;
        this.imageRemovedIngredient = imageRemovedIngredient;
        this.removed = removed;
        this.init();
    }

    public SupplementItemInfo getIngredient() {
        return this.ingredient;
    }

    public void setIngredient(SupplementItemInfo ingredient) {
        this.ingredient = ingredient;
    }

    private void init() {
        this.setStyle(this.style);
        this.setPrefHeight(this.height);
        this.setPrefWidth(this.width);
        this.buildPaneIngredient();
    }

    private void buildPaneIngredient() {
        this.paneIngredient = new GridPane();
        this.paneIngredient.setAlignment(Pos.CENTER);
        this.paneIngredient.setPrefHeight(this.height * 0.9);
        this.paneIngredient.setPrefWidth(this.width * 0.9);
        StackPane paneImages = new StackPane();
        paneImages.setPrefHeight(this.paneIngredient.getPrefHeight() * 0.8);
        paneImages.setPrefWidth(this.paneIngredient.getPrefHeight() * 0.8);
        Label labelImage = new Label();
        labelImage.setPrefHeight(this.paneIngredient.getPrefHeight() * 0.8);
        labelImage.setPrefWidth(this.paneIngredient.getPrefHeight() * 0.8);
        if (this.imageItem != null) {
            ImageView imageView = new ImageView(this.imageItem);
            imageView.setFitHeight(labelImage.getPrefHeight() * 0.8);
            imageView.setFitWidth(labelImage.getPrefHeight() * 0.8);
            imageView.setPreserveRatio(false);
            imageView.setSmooth(false);
            labelImage.setGraphic((Node)imageView);
        }
        this.labelImageRemovedImgredient = new Label();
        this.labelImageRemovedImgredient.setPrefHeight(this.paneIngredient.getPrefHeight() * 0.8);
        this.labelImageRemovedImgredient.setPrefWidth(this.paneIngredient.getPrefHeight() * 0.8);
        paneImages.getChildren().add((Object)labelImage);
        paneImages.getChildren().add((Object)this.labelImageRemovedImgredient);
        GridPane textWithoutPane = new GridPane();
        textWithoutPane.setAlignment(Pos.BOTTOM_LEFT);
        textWithoutPane.setPrefHeight(this.paneIngredient.getPrefHeight() * 0.35);
        textWithoutPane.setPrefWidth(this.paneIngredient.getPrefWidth() * 0.9 - labelImage.getPrefWidth());
        this.textWithout = new Text(StringUtils.CapitalizeFirstLetter(AppLocal.getIntString("Label.without")));
        this.textFlowWithout = new TextFlow();
        this.textFlowWithout.getChildren().add((Object)this.textWithout);
        textWithoutPane.add((Node)this.textFlowWithout, 0, 0);
        this.textName = new Text(this.ingredient.getDisplayedName());
        this.textName.setTextAlignment(TextAlignment.LEFT);
        this.labelName = new Label();
        this.labelName.setAlignment(Pos.TOP_LEFT);
        this.labelName.setTextAlignment(TextAlignment.LEFT);
        this.labelName.setWrapText(true);
        this.labelName.setPrefHeight(this.paneIngredient.getPrefHeight() * 0.45);
        this.labelName.setPrefWidth(this.paneIngredient.getPrefWidth() * 0.9 - labelImage.getPrefWidth());
        this.textName.setWrappingWidth(this.labelName.getPrefWidth() * 0.9);
        this.labelName.setGraphic((Node)this.textName);
        this.textName.setStyle("-fx-fill: white; -fx-font-size: 14px;  -fx-font-weight: Normal;");
        this.labelName.setStyle("-fx-fill: white; -fx-font-size: 14px;  -fx-font-weight: Normal;");
        this.paneIngredient.add((Node)paneImages, 0, 0, 1, 2);
        this.paneIngredient.add((Node)textWithoutPane, 1, 0);
        this.paneIngredient.add((Node)this.labelName, 1, 1);
        this.setGraphic((Node)this.paneIngredient);
        if (this.removed) {
            this.selectRemovedIngredient();
        } else {
            this.deselectIngredient();
        }
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void setRemoved(boolean removed) {
        this.removed = removed;
    }

    public void selectRemovedIngredient() {
        this.textWithout.setStyle("-fx-fill: #BB4849; -fx-font-size: 12px; -fx-font-weight: Normal;");
        this.textFlowWithout.setStyle("-fx-font-size: 12px; -fx-font-weight: Normal;");
        this.textWithout.setStrikethrough(true);
        this.textName.setStrikethrough(true);
        if (this.imageViewRemovedIngredient == null) {
            this.imageViewRemovedIngredient = new ImageView(this.imageRemovedIngredient);
            this.imageViewRemovedIngredient.setFitHeight(this.labelImageRemovedImgredient.getPrefHeight() * 0.8);
            this.imageViewRemovedIngredient.setFitWidth(this.labelImageRemovedImgredient.getPrefHeight() * 0.8);
            this.imageViewRemovedIngredient.setPreserveRatio(false);
            this.imageViewRemovedIngredient.setSmooth(false);
            this.labelImageRemovedImgredient.setGraphic((Node)this.imageViewRemovedIngredient);
        }
        this.labelImageRemovedImgredient.setGraphic((Node)this.imageViewRemovedIngredient);
    }

    public void deselectIngredient() {
        this.textWithout.setStyle("-fx-fill: white; -fx-font-weight: Normal;");
        this.textFlowWithout.setStyle("-fx-background-color: #EE5540; -fx-background-radius: 6px; -fx-font-size: 12px; -fx-font-weight: Normal;");
        this.textWithout.setStrikethrough(false);
        this.textName.setStrikethrough(false);
        this.labelImageRemovedImgredient.setGraphic(null);
    }

    public CarteOrderInfo getGroupProducts() {
        return this.groupProducts;
    }

    public void setGroupProducts(CarteOrderInfo groupProducts) {
        this.groupProducts = groupProducts;
    }

    public ProductInfoExt getSupProduct() {
        return this.supProduct;
    }

    public void setSupProduct(ProductInfoExt supProduct) {
        this.supProduct = supProduct;
    }

    public Image getImageItem() {
        return this.imageItem;
    }

    public void setImageItem(Image imageItem) {
        this.imageItem = imageItem;
    }
}

