/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.components;

import com.openbravo.pos.ticket.CarteOrderInfo;
import com.openbravo.pos.ticket.GroupSubSupplementInfo;
import com.openbravo.pos.ticket.ProductInfoExt;
import javafx.scene.control.Button;
import javafx.scene.control.Label;

public class HeaderDetailProductButton
extends Button {
    private String group_type;
    private Object groupItem;
    private int index;
    private String style = "-fx-background-color: #26292C; -fx-text-fill: white;  -fx-font-size: 12px; -fx-background-radius: 12px";
    private String style_index = "-fx-background-color: #FFFFFF16; -fx-text-fill: #EBEBF5;  -fx-font-size: 12px; -fx-border-radius: 38px; -fx-background-radius:38px";
    private String style_sub_options = "-fx-background-color: transparent; -fx-text-fill: white;  -fx-font-size: 12px; -fx-background-radius: 12px";
    private Label number_label;
    private String selected_style;
    private String bg_color;

    public HeaderDetailProductButton() {
        this.init();
    }

    public HeaderDetailProductButton(String group_type, Object groupItem, int index) {
        this.group_type = group_type;
        this.groupItem = groupItem;
        this.index = index;
        this.init();
    }

    private void init() {
        this.setStyle(this.style);
        System.out.println("group_type : " + this.group_type);
        switch (this.group_type) {
            case "ingredients": {
                this.setText("ingredients");
                this.bg_color = "#956FF8";
                break;
            }
            case "options": {
                this.setText("options");
                this.bg_color = "#956FF8";
                break;
            }
            case "sub_product": {
                if (this.groupItem != null && this.groupItem instanceof ProductInfoExt) {
                    String name = ((ProductInfoExt)this.groupItem).getDisplayedName();
                    this.setText(name);
                }
                this.bg_color = "#003653";
                break;
            }
            case "group_products": {
                if (this.groupItem != null && this.groupItem instanceof CarteOrderInfo) {
                    String name = ((CarteOrderInfo)this.groupItem).getDisplayedName();
                    this.setText(name);
                }
                this.bg_color = "#003653";
                break;
            }
            case "group_sub_options": {
                if (this.groupItem != null && this.groupItem instanceof GroupSubSupplementInfo) {
                    String name = ((GroupSubSupplementInfo)this.groupItem).getName_group();
                    this.setText(name);
                }
                this.bg_color = "#956FF8";
                break;
            }
            default: {
                this.bg_color = "#956FF8";
            }
        }
        this.selected_style = "-fx-background-color: " + this.bg_color + "; -fx-text-fill: white;  -fx-font-size: 12px; -fx-background-radius: 12px";
    }

    public String getGroup_type() {
        return this.group_type;
    }

    public void setGroup_type(String group_type) {
        this.group_type = group_type;
    }

    public Object getGroupItem() {
        return this.groupItem;
    }

    public void setGroupItem(Object groupItem) {
        this.groupItem = groupItem;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void deselect() {
        this.setStyle(this.style);
    }

    public void select() {
        this.setStyle(this.selected_style);
    }

    public void deselectSubOption() {
        this.setStyle(this.style_sub_options);
    }
}

