/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.components;

import com.openbravo.components.views.DualScreenLabel;
import com.openbravo.format.Formats;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.ItemOrderInfo;
import com.openbravo.pos.ticket.OptionItemOrder;
import com.openbravo.pos.ticket.ProductTicket;
import com.openbravo.pos.ticket.TicketLineInfo;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.text.TextAlignment;

public class HBoxCell
extends HBox {
    TicketLineInfo line;
    int indexLine;
    Label label = new Label();
    Label labelPrice = new Label();
    Button button = new Button();
    private double widthline;
    private HBox hboxProduit = new HBox();
    private GridPane pane = new GridPane();
    boolean discount;
    boolean disocuntOrder;
    private TicketLineInfo item;
    private double price;
    private double total;

    public HBoxCell item(TicketLineInfo item) {
        this.item = item;
        return this;
    }

    public HBoxCell price(double price) {
        this.price = price;
        return this;
    }

    public HBoxCell total(double total) {
        this.total = total;
        return this;
    }

    public HBoxCell(TicketLineInfo line, int indexLine, boolean displayQuantity, double width, String typeOrder, boolean has_delete_lines_order_permission) {
        this.widthline = width;
        this.hboxProduit = new HBox();
        this.pane = new GridPane();
        this.line = line;
        this.indexLine = indexLine;
        this.pane.setVgap(2.0);
        this.pane.setHgap(2.0);
        if (this.line.isNext()) {
            this.label.setText(this.line.getNextRetourn());
            this.label.setPrefWidth(this.widthline * 0.9);
            this.button.setPrefWidth(this.widthline * 0.1);
            this.button.setText("X");
            this.button.getStyleClass().add((Object)"btn_delete_list");
            this.getChildren().addAll((Object[])new Node[]{this.label, this.button});
        } else {
            String text_color = line.isSend_kitchen() ? "text_deep_rose" : "text_black";
            String name_product = line.printPanier();
            this.label.setWrapText(true);
            this.label.getStyleClass().add((Object)"align-left");
            this.label.getStyleClass().add((Object)text_color);
            this.label.setText(name_product);
            this.labelPrice.setText(line.printValueProduct());
            if (line.isSend_kitchen()) {
                this.label.setPrefWidth(this.widthline * 0.5);
            } else {
                this.label.setPrefWidth(this.widthline * 0.6);
            }
            this.labelPrice.setPrefWidth(this.widthline * 0.3);
            this.labelPrice.getStyleClass().add((Object)text_color);
            this.button.setText("X");
            this.button.setPrefWidth(this.widthline * 0.1);
            this.button.getStyleClass().add((Object)"btn_delete_list");
            if (line.getUnits_paid() != 0.0 && !line.isSend_kitchen()) {
                this.getChildren().addAll((Object[])new Node[]{this.label});
                this.hboxProduit.getChildren().addAll((Object[])new Node[]{this.label, this.labelPrice});
            } else {
                if (line.isSend_kitchen()) {
                    Label label_icon = new Label();
                    label_icon.setPrefWidth(this.widthline * 0.1);
                    try {
                        Image image = new Image(((Object)((Object)this)).getClass().getResource("/com/openbravo/images/printer_rose.png").toURI().toString());
                        ImageView image_print = new ImageView(image);
                        image_print.setFitWidth(this.widthline * 0.08);
                        image_print.setPreserveRatio(true);
                        image_print.setSmooth(true);
                        image_print.setCache(true);
                        label_icon.setGraphic((Node)image_print);
                    }
                    catch (URISyntaxException ex) {
                        Logger.getLogger(HBoxCell.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.hboxProduit.getChildren().add((Object)label_icon);
                }
                this.hboxProduit.getChildren().addAll((Object[])new Node[]{this.label, this.labelPrice});
                if (has_delete_lines_order_permission && (line.isSend_kitchen() && line.getUnits_paid() == 0.0 || !line.isSend_kitchen())) {
                    this.hboxProduit.getChildren().add((Object)this.button);
                }
            }
            this.hboxProduit.setMaxWidth(Double.MAX_VALUE);
            this.pane.add((Node)this.hboxProduit, 0, 0);
            int i = 1;
            if (!typeOrder.equals("En Livraison") && (line.getPlace_served() != null && !line.getPlace_served().equals(typeOrder) || line.getTime_served() != null && line.getTime_served().equals("later"))) {
                Object typeLine = "";
                if (line.getPlace_served() != null && !line.getPlace_served().equals(typeOrder)) {
                    typeLine = line.getPlace_served() + " ";
                }
                if (line.getTime_served() != null && line.getTime_served().equals("later")) {
                    typeLine = (String)typeLine + "- " + AppLocal.text_later + " -";
                }
                HBox hboxTypeLine = new HBox();
                Label labelType = new Label((String)typeLine);
                labelType.setPrefWidth(this.widthline);
                labelType.getStyleClass().add((Object)text_color);
                hboxTypeLine.getChildren().addAll((Object[])new Node[]{labelType});
                this.pane.add((Node)hboxTypeLine, 0, i);
                ++i;
            }
            for (ItemOrderInfo ingredient : line.getListIngredients()) {
                if (ingredient.getIdProduct() != -1 && ingredient.getIdProduct() != 0) continue;
                HBox hboxIngredient = new HBox();
                Label labelIngredient = new Label(" sans " + ingredient.getNameSupplement());
                labelIngredient.setPrefWidth(this.widthline);
                labelIngredient.getStyleClass().add((Object)text_color);
                hboxIngredient.getChildren().addAll((Object[])new Node[]{labelIngredient});
                this.pane.add((Node)hboxIngredient, 0, i);
                ++i;
            }
            for (OptionItemOrder supplement : line.getListSupplements()) {
                if (supplement.getIdProduct() != -1 && supplement.getIdProduct() != 0) continue;
                if (!displayQuantity) {
                    for (int j = 0; j < supplement.getNumberOption(); ++j) {
                        HBox hboxOption = new HBox();
                        Label labelOption = new Label(supplement.getNameSupplement());
                        labelOption.setPrefWidth(this.widthline * 0.6);
                        labelOption.getStyleClass().add((Object)text_color);
                        Label labelPriceOption = new Label(this.printPrice(supplement.getPrice() / (double)supplement.getNumberOption()));
                        labelPriceOption.setPrefWidth(this.widthline * 0.4);
                        labelPriceOption.getStyleClass().add((Object)text_color);
                        hboxOption.getChildren().addAll((Object[])new Node[]{labelOption, labelPriceOption});
                        this.pane.add((Node)hboxOption, 0, i);
                        ++i;
                    }
                    continue;
                }
                HBox hboxOption = new HBox();
                Label labelOption = new Label();
                labelOption.setPrefWidth(this.widthline * 0.6);
                labelOption.getStyleClass().add((Object)text_color);
                Label labelPriceOption = new Label();
                labelPriceOption.setPrefWidth(this.widthline * 0.4);
                labelPriceOption.getStyleClass().add((Object)text_color);
                if (supplement.getNumberOption() > 1) {
                    labelOption.setText("+" + this.printQuantity(line.getMultiply() * (double)supplement.getNumberOption()) + " " + supplement.getNameSupplement());
                    labelPriceOption.setText(this.printPrice(supplement.getPrice() * line.getMultiply()));
                } else if (line.getMultiply() > 1.0) {
                    labelOption.setText("+" + this.printQuantity(line.getMultiply()) + " " + supplement.getNameSupplement());
                    labelPriceOption.setText(this.printPrice(supplement.getPrice() * line.getMultiply()));
                } else {
                    labelOption.setText("+" + supplement.getNameSupplement());
                    labelPriceOption.setText(this.printPrice(supplement.getPrice()));
                }
                hboxOption.getChildren().addAll((Object[])new Node[]{labelOption, labelPriceOption});
                this.pane.add((Node)hboxOption, 0, i);
                ++i;
            }
            for (ProductTicket item : line.getListProducts()) {
                HBox hboxItem = new HBox();
                Label labelItem = new Label();
                labelItem.setPrefWidth(this.widthline * 0.6);
                labelItem.getStyleClass().add((Object)text_color);
                Label labelPriceItem = new Label();
                labelPriceItem.setPrefWidth(this.widthline * 0.4);
                labelPriceItem.getStyleClass().add((Object)text_color);
                double quantity = line.getMultiply() * (double)item.getNumberProduct();
                if (quantity > 1.0) {
                    labelItem.setText(" " + this.printQuantity(quantity) + " " + item.getNameProduct());
                } else {
                    labelItem.setText(" " + item.getNameProduct());
                }
                labelPriceItem.setText(item.printPrice());
                hboxItem.getChildren().addAll((Object[])new Node[]{labelItem, labelPriceItem});
                this.pane.add((Node)hboxItem, 0, i);
                ++i;
                for (OptionItemOrder supplement : line.getListSupplements()) {
                    if (supplement.getIdProduct() != item.getIdProduct() || supplement.getIdCarte() != item.getIdCarte() || supplement.getIndex_carte() != item.getIndex_carte()) continue;
                    if (!displayQuantity) {
                        for (int j = 0; j < supplement.getNumberOption(); ++j) {
                            HBox hboxOptionItem = new HBox();
                            Label labelOption = new Label(" +" + supplement.getNameSupplement());
                            labelOption.setPrefWidth(this.widthline * 0.6);
                            labelOption.getStyleClass().add((Object)text_color);
                            Label labelPriceOption = new Label(supplement.printPrice());
                            labelPriceOption.setPrefWidth(this.widthline * 0.4);
                            labelPriceOption.getStyleClass().add((Object)text_color);
                            hboxOptionItem.getChildren().addAll((Object[])new Node[]{labelOption, labelPriceOption});
                            this.pane.add((Node)hboxOptionItem, 0, i);
                            ++i;
                        }
                        continue;
                    }
                    HBox hboxOption = new HBox();
                    Label labelOption = new Label();
                    labelOption.setPrefWidth(this.widthline * 0.6);
                    labelOption.getStyleClass().add((Object)text_color);
                    Label labelPriceOption = new Label();
                    labelPriceOption.setPrefWidth(this.widthline * 0.4);
                    labelPriceOption.getStyleClass().add((Object)text_color);
                    if (supplement.getNumberOption() > 1) {
                        labelOption.setText(" +" + this.printQuantity(line.getMultiply() * (double)supplement.getNumberOption()) + " " + supplement.getNameSupplement());
                        labelPriceOption.setText(this.printPrice(supplement.getPrice() * line.getMultiply() * (double)supplement.getNumberOption()));
                    } else if (line.getMultiply() > 1.0) {
                        labelOption.setText(" +" + this.printQuantity(line.getMultiply()) + " " + supplement.getNameSupplement());
                        labelPriceOption.setText(this.printPrice(supplement.getPrice() * line.getMultiply()));
                    } else {
                        labelOption.setText(" +" + supplement.getNameSupplement());
                        labelPriceOption.setText(this.printPrice(supplement.getPrice()));
                    }
                    hboxOption.getChildren().addAll((Object[])new Node[]{labelOption, labelPriceOption});
                    this.pane.add((Node)hboxOption, 0, i);
                    ++i;
                }
                for (ItemOrderInfo ingredient : line.getListIngredients()) {
                    if (ingredient.getIdProduct() != item.getIdProduct() || ingredient.getIdCarte() != item.getIdCarte() || ingredient.getIndex_carte() != item.getIndex_carte()) continue;
                    HBox hboxIngredient = new HBox();
                    Label labelIngredient = new Label(" sans " + ingredient.getNameSupplement());
                    labelIngredient.setPrefWidth(this.widthline);
                    labelIngredient.getStyleClass().add((Object)text_color);
                    hboxIngredient.getChildren().addAll((Object[])new Node[]{labelIngredient});
                    this.pane.add((Node)hboxIngredient, 0, i);
                    ++i;
                }
                if (item.getComment() == null || item.getComment().isEmpty()) continue;
                HBox hboxComment = new HBox();
                Label labelComment = new Label(item.getComment());
                labelComment.setPrefWidth(this.widthline);
                labelComment.getStyleClass().add((Object)text_color);
                hboxComment.getChildren().addAll((Object[])new Node[]{labelComment});
                this.pane.add((Node)hboxComment, 0, i);
                ++i;
            }
            this.pane.setMaxWidth(Double.MAX_VALUE);
            this.getChildren().add((Object)this.pane);
        }
    }

    public HBoxCell(String labelText, String price, double width, boolean has_delete_lines_order_permission) {
        this.widthline = width;
        this.hboxProduit = new HBox();
        this.pane = new GridPane();
        this.label.setText(labelText);
        this.labelPrice.setText("-" + price);
        this.label.setPrefWidth(this.widthline * 0.6);
        this.labelPrice.setPrefWidth(this.widthline * 0.3);
        this.button.setText("X");
        this.button.setPrefWidth(this.widthline * 0.1);
        this.button.getStyleClass().add((Object)"btn_delete_list");
        this.hboxProduit.getChildren().addAll((Object[])new Node[]{this.label, this.labelPrice});
        if (has_delete_lines_order_permission) {
            this.hboxProduit.getChildren().add((Object)this.button);
        }
        this.hboxProduit.setMaxWidth(Double.MAX_VALUE);
        this.pane.add((Node)this.hboxProduit, 0, 0);
        this.getChildren().add((Object)this.pane);
    }

    public HBoxCell(TicketLineInfo line, int indexLine, double width, boolean has_delete_lines_order_permission) {
        this.line = line;
        this.indexLine = indexLine;
        this.widthline = width;
        this.hboxProduit = new HBox();
        this.pane = new GridPane();
        String name = "";
        name = line.isPromo_basket() ? "Promotion" : line.printLabelDiscount();
        this.label.setText(" " + name);
        this.labelPrice.setText("-" + Formats.CURRENCY.formatValue(line.getDiscount()));
        this.label.setPrefWidth(this.widthline * 0.6);
        this.labelPrice.setPrefWidth(this.widthline * 0.3);
        this.button.setText("X");
        this.button.setPrefWidth(this.widthline * 0.1);
        this.button.getStyleClass().add((Object)"btn_delete_list");
        this.hboxProduit.getChildren().addAll((Object[])new Node[]{this.label, this.labelPrice});
        if (has_delete_lines_order_permission) {
            this.hboxProduit.getChildren().add((Object)this.button);
        }
        this.hboxProduit.setMaxWidth(Double.MAX_VALUE);
        this.pane.add((Node)this.hboxProduit, 0, 0);
        this.getChildren().add((Object)this.pane);
    }

    public Button getButton() {
        return this.button;
    }

    public TicketLineInfo getLine() {
        return this.line;
    }

    public int getIndex() {
        return this.indexLine;
    }

    public String printPrice(double price) {
        if (price != 0.0) {
            return Formats.CURRENCY.formatValue(price);
        }
        return "";
    }

    public String printQuantity(double multiply) {
        if (multiply == (double)Math.round(multiply)) {
            return Formats.INT.formatValue(multiply);
        }
        return Formats.DOUBLE.formatValue(multiply);
    }

    public String toString() {
        return super.toString();
    }

    public HBoxCell(TicketLineInfo line, double width) {
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.widthline = width;
        this.hboxProduit = new HBox();
        this.pane = new GridPane();
        this.line = line;
        this.pane.setVgap(2.0);
        this.pane.setHgap(2.0);
        String name_product = line.printPanier();
        this.label = new DualScreenLabel();
        this.labelPrice = new DualScreenLabel(Pos.CENTER);
        this.label.setWrapText(true);
        this.label.setText(name_product);
        this.labelPrice.setText(line.printValueProduct());
        this.label.setPrefWidth(this.widthline * 0.7);
        this.labelPrice.setPrefWidth(this.widthline * 0.3);
        this.hboxProduit.getChildren().addAll((Object[])new Node[]{this.label, this.labelPrice});
        this.hboxProduit.setMaxWidth(Double.MAX_VALUE);
        this.pane.add((Node)this.hboxProduit, 0, 0);
        int i = 1;
        for (ItemOrderInfo ingredient : line.getListIngredients()) {
            if (ingredient.getIdProduct() != -1) continue;
            HBox hboxIngredient = new HBox();
            DualScreenLabel labelIngredient = new DualScreenLabel(" sans " + ingredient.getNameSupplement());
            labelIngredient.setPrefWidth(this.widthline);
            hboxIngredient.getChildren().addAll((Object[])new Node[]{labelIngredient});
            this.pane.add((Node)hboxIngredient, 0, i);
            ++i;
        }
        for (OptionItemOrder supplement : line.getListSupplements()) {
            if (supplement.getIdProduct() != -1) continue;
            HBox hboxOption = new HBox();
            DualScreenLabel labelOption = new DualScreenLabel();
            labelOption.setPrefWidth(this.widthline * 0.7);
            DualScreenLabel labelPriceOption = new DualScreenLabel(Pos.CENTER);
            labelPriceOption.setPrefWidth(this.widthline * 0.3);
            if (supplement.getNumberOption() > 1) {
                labelOption.setText("+" + this.printQuantity(line.getMultiply() * (double)supplement.getNumberOption()) + " " + supplement.getNameSupplement());
                labelPriceOption.setText(this.printPrice(supplement.getPrice() * line.getMultiply()));
            } else if (line.getMultiply() > 1.0) {
                labelOption.setText("+" + this.printQuantity(line.getMultiply()) + " " + supplement.getNameSupplement());
                labelPriceOption.setText(this.printPrice(supplement.getPrice() * line.getMultiply()));
            } else {
                labelOption.setText("+" + supplement.getNameSupplement());
                labelPriceOption.setText(this.printPrice(supplement.getPrice()));
            }
            hboxOption.getChildren().addAll((Object[])new Node[]{labelOption, labelPriceOption});
            this.pane.add((Node)hboxOption, 0, i);
            ++i;
        }
        for (ProductTicket item : line.getListProducts()) {
            HBox hboxItem = new HBox();
            DualScreenLabel labelItem = new DualScreenLabel();
            labelItem.setPrefWidth(this.widthline * 0.7);
            DualScreenLabel labelPriceItem = new DualScreenLabel(Pos.CENTER);
            labelPriceItem.setPrefWidth(this.widthline * 0.3);
            if (line.getMultiply() > 1.0) {
                labelItem.setText(" " + this.printQuantity(line.getMultiply()) + " " + item.getNameProduct());
                labelPriceItem.setText(item.printPrice());
            } else {
                labelItem.setText(" " + item.getNameProduct());
                labelPriceItem.setText(item.printPrice());
            }
            hboxItem.getChildren().addAll((Object[])new Node[]{labelItem, labelPriceItem});
            this.pane.add((Node)hboxItem, 0, i);
            ++i;
            for (OptionItemOrder supplement : line.getListSupplements()) {
                if (supplement.getIdProduct() != item.getIdProduct() || supplement.getIdCarte() != item.getIdCarte() || supplement.getIndex_carte() != item.getIndex_carte()) continue;
                HBox hboxOption = new HBox();
                DualScreenLabel labelOption = new DualScreenLabel();
                labelOption.setPrefWidth(this.widthline * 0.7);
                DualScreenLabel labelPriceOption = new DualScreenLabel(Pos.CENTER);
                labelPriceOption.setPrefWidth(this.widthline * 0.3);
                if (supplement.getNumberOption() > 1) {
                    labelOption.setText(" +" + this.printQuantity(line.getMultiply() * (double)supplement.getNumberOption()) + " " + supplement.getNameSupplement());
                    labelPriceOption.setText(this.printPrice(supplement.getPrice() * line.getMultiply() * (double)supplement.getNumberOption()));
                } else if (line.getMultiply() > 1.0) {
                    labelOption.setText(" +" + this.printQuantity(line.getMultiply()) + " " + supplement.getNameSupplement());
                    labelPriceOption.setText(this.printPrice(supplement.getPrice() * line.getMultiply()));
                } else {
                    labelOption.setText(" +" + supplement.getNameSupplement());
                    labelPriceOption.setText(this.printPrice(supplement.getPrice()));
                }
                hboxOption.getChildren().addAll((Object[])new Node[]{labelOption, labelPriceOption});
                this.pane.add((Node)hboxOption, 0, i);
                ++i;
            }
            for (ItemOrderInfo ingredient : line.getListIngredients()) {
                if (ingredient.getIdProduct() != item.getIdProduct() || ingredient.getIdCarte() != item.getIdCarte() || ingredient.getIndex_carte() != item.getIndex_carte()) continue;
                HBox hboxIngredient = new HBox();
                DualScreenLabel labelIngredient = new DualScreenLabel(" sans " + ingredient.getNameSupplement());
                labelIngredient.setPrefWidth(this.widthline);
                hboxIngredient.getChildren().addAll((Object[])new Node[]{labelIngredient});
                this.pane.add((Node)hboxIngredient, 0, i);
                ++i;
            }
        }
        this.pane.setMaxWidth(Double.MAX_VALUE);
        this.getChildren().add((Object)this.pane);
    }

    public HBoxCell() {
        this.hboxProduit = new HBox();
        this.pane = new GridPane();
    }

    public HBoxCell buildNote() {
        this.label.setWrapText(true);
        this.label.getStyleClass().add((Object)"align-left");
        this.label.setTextAlignment(TextAlignment.LEFT);
        String name = "";
        if (this.line.getNote() != null && !this.line.getNote().isEmpty()) {
            name = this.line.getNote();
        }
        this.label.setText(name);
        this.label.setPrefWidth(this.widthline);
        this.getChildren().add((Object)this.label);
        return this;
    }

    public HBoxCell line(TicketLineInfo line) {
        this.line = line;
        return this;
    }

    public HBoxCell widthline(double widthline) {
        this.widthline = widthline;
        return this;
    }

    public HBoxCell buildLine() {
        GridPane paneItem = new GridPane();
        paneItem.setPrefWidth(this.widthline * 0.9);
        Label label_separator = new Label();
        label_separator.setPrefWidth(this.widthline * 0.02);
        label_separator.getStyleClass().add((Object)"bg_red_d57373");
        String name_item = this.item.printPanier();
        this.label.setText(name_item);
        this.labelPrice.setText(this.item.printValueProduct());
        this.labelPrice.setAlignment(Pos.CENTER_RIGHT);
        this.label.setPrefWidth(this.widthline * 0.6);
        this.label.getStyleClass().add((Object)"text-size-11");
        this.labelPrice.setPrefWidth(this.widthline * 0.38);
        this.labelPrice.getStyleClass().add((Object)"text_red_d57373");
        this.labelPrice.getStyleClass().add((Object)"text-size-12");
        GridPane paneInfoItem = new GridPane();
        paneInfoItem.setPrefWidth(this.widthline * 0.88);
        paneInfoItem.setPrefHeight(30.0);
        paneInfoItem.add((Node)this.label, 0, 0);
        paneInfoItem.add((Node)this.labelPrice, 1, 0);
        int indexItem = 0;
        double heightPaneItem = 30.0;
        paneItem.add((Node)paneInfoItem, 0, indexItem++);
        for (OptionItemOrder supplement : this.item.getListSupplements()) {
            GridPane paneOption = new GridPane();
            Label labelNameOption = new Label();
            String name_option = this.getOptionName(supplement, (int)this.item.getMultiply());
            labelNameOption.setText(name_option);
            paneOption.add((Node)labelNameOption, 0, 0);
            labelNameOption.setPrefWidth(this.widthline * 0.49);
            labelNameOption.getStyleClass().add((Object)"text-size-11");
            double amount_option = this.item.getMultiply() * supplement.getPrice();
            String formatted_amount = Formats.CURRENCY.formatValue(amount_option);
            Label labelPriceOption = new Label();
            labelPriceOption.setText(formatted_amount);
            labelPriceOption.setAlignment(Pos.CENTER_RIGHT);
            labelPriceOption.setPrefWidth(this.widthline * 0.49);
            labelPriceOption.getStyleClass().add((Object)"text_red_d57373");
            labelPriceOption.getStyleClass().add((Object)"text-size-12");
            paneOption.add((Node)labelPriceOption, 1, 0);
            paneOption.setPrefHeight(heightPaneItem);
            paneInfoItem.setPrefWidth(this.widthline * 0.88);
            paneItem.add((Node)paneOption, 0, indexItem++);
            heightPaneItem += 30.0;
        }
        if (this.item.getValueDiscount() > 0.0) {
            GridPane panePromotion = new GridPane();
            Label labelPromotion = new Label();
            labelPromotion.setText(this.item.printLabelDiscount());
            panePromotion.add((Node)labelPromotion, 0, 0);
            labelPromotion.setPrefWidth(this.widthline * 0.49);
            labelPromotion.getStyleClass().add((Object)"text-size-11");
            double value_discount = this.item.getValueDiscount();
            String formatted_amount = Formats.CURRENCY.formatValue(value_discount);
            Label labelDiscount = new Label();
            labelDiscount.setText("-" + formatted_amount);
            labelDiscount.setAlignment(Pos.CENTER_RIGHT);
            labelDiscount.setPrefWidth(this.widthline * 0.49);
            labelDiscount.getStyleClass().add((Object)"text_red_d57373");
            labelDiscount.getStyleClass().add((Object)"text-size-12");
            panePromotion.add((Node)labelDiscount, 1, 0);
            panePromotion.setPrefHeight(heightPaneItem);
            paneInfoItem.setPrefWidth(this.widthline * 0.88);
            paneItem.add((Node)panePromotion, 0, indexItem++);
            heightPaneItem += 30.0;
        }
        if (this.item.getNote() != null && !this.item.getNote().isEmpty()) {
            Label labelNote = new Label();
            labelNote.setText(this.item.getNote());
            labelNote.setPrefWidth(this.widthline);
            labelNote.getStyleClass().add((Object)"text-size-11");
            labelNote.setPrefHeight(40.0);
            heightPaneItem += 40.0;
            paneItem.add((Node)labelNote, 0, indexItem);
        }
        label_separator.setPrefHeight(heightPaneItem);
        this.pane.setPrefWidth(this.widthline);
        this.pane.setVgap(8.0);
        this.pane.setHgap(8.0);
        this.pane.add((Node)label_separator, 0, 0);
        this.pane.add((Node)paneItem, 1, 0);
        this.pane.setPrefHeight(heightPaneItem);
        this.setHeight(heightPaneItem);
        this.getChildren().add((Object)this.pane);
        return this;
    }

    public HBoxCell buildNote(String comment) {
        this.label.setWrapText(true);
        this.label.setText(comment);
        this.label.setPrefWidth(this.widthline);
        this.label.getStyleClass().add((Object)"text-size-11");
        this.label.setPrefHeight(40.0);
        this.setHeight(40.0);
        this.getChildren().add((Object)this.label);
        return this;
    }

    public HBoxCell buildLineTotal(String str_total) {
        this.label.setText(str_total);
        this.pane.setAlignment(Pos.CENTER);
        this.labelPrice.setText(Formats.CURRENCY.formatValue(this.total));
        this.labelPrice.setAlignment(Pos.CENTER_RIGHT);
        this.label.setPrefWidth(this.widthline * 0.6);
        this.label.getStyleClass().add((Object)"text-size-12");
        this.labelPrice.setPrefWidth(this.widthline * 0.3);
        this.labelPrice.getStyleClass().add((Object)"text_red_d57373");
        this.labelPrice.getStyleClass().add((Object)"text-size-12");
        this.pane.setPrefWidth(this.widthline);
        this.pane.setVgap(8.0);
        this.pane.setHgap(8.0);
        this.pane.add((Node)this.label, 0, 0);
        this.pane.add((Node)this.labelPrice, 1, 0);
        this.pane.setPrefHeight(50.0);
        this.setHeight(50.0);
        this.getChildren().add((Object)this.pane);
        return this;
    }

    private String getOptionName(OptionItemOrder supplement, int quantity_item) {
        Object name_item = "+";
        int quantity = supplement.getNumberOption() * quantity_item;
        name_item = (String)name_item + (String)(quantity > 1 ? quantity + " X " : "");
        name_item = (String)name_item + supplement.getNameSupplement();
        return name_item;
    }

    public HBoxCell buildTotalUberEat() {
        GridPane paneItem = new GridPane();
        paneItem.setPrefWidth(this.widthline * 0.9);
        Label label_separator = new Label();
        label_separator.setPrefWidth(this.widthline * 0.02);
        label_separator.getStyleClass().add((Object)"bg_red_d57373");
        this.label.setText("Service Uber Eat");
        this.labelPrice.setText(Formats.CURRENCY.formatValue(this.price));
        this.labelPrice.setAlignment(Pos.CENTER_RIGHT);
        this.label.setPrefWidth(this.widthline * 0.48);
        this.label.getStyleClass().add((Object)"text-size-11");
        this.labelPrice.setPrefWidth(this.widthline * 0.48);
        this.labelPrice.getStyleClass().add((Object)"text_red_d57373");
        this.labelPrice.getStyleClass().add((Object)"text-size-12");
        GridPane paneInfoItem = new GridPane();
        paneInfoItem.setPrefWidth(this.widthline * 0.88);
        paneInfoItem.setPrefHeight(40.0);
        paneInfoItem.add((Node)this.label, 0, 0);
        paneInfoItem.add((Node)this.labelPrice, 1, 0);
        int indexItem = 0;
        double heightPaneItem = 40.0;
        paneItem.add((Node)paneInfoItem, 0, indexItem++);
        label_separator.setPrefHeight(heightPaneItem);
        this.pane.setPrefWidth(this.widthline);
        this.pane.setVgap(8.0);
        this.pane.setHgap(8.0);
        this.pane.add((Node)label_separator, 0, 0);
        this.pane.add((Node)paneItem, 1, 0);
        this.pane.setPrefHeight(heightPaneItem);
        this.getChildren().add((Object)this.pane);
        return this;
    }

    public HBoxCell buildLineDiscount(String label_discount) {
        this.label.setText(label_discount);
        this.pane.setAlignment(Pos.CENTER);
        this.labelPrice.setText("-" + Formats.CURRENCY.formatValue(this.total));
        this.labelPrice.setAlignment(Pos.CENTER_RIGHT);
        this.label.setPrefWidth(this.widthline * 0.6);
        this.label.getStyleClass().add((Object)"text-size-12");
        this.labelPrice.setPrefWidth(this.widthline * 0.3);
        this.labelPrice.getStyleClass().add((Object)"text_red_d57373");
        this.labelPrice.getStyleClass().add((Object)"text-size-12");
        this.pane.setPrefWidth(this.widthline);
        this.pane.setVgap(8.0);
        this.pane.setHgap(8.0);
        this.pane.add((Node)this.label, 0, 0);
        this.pane.add((Node)this.labelPrice, 1, 0);
        this.pane.setPrefHeight(50.0);
        this.setHeight(50.0);
        this.getChildren().add((Object)this.pane);
        return this;
    }
}

