/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.components;

import com.openbravo.pos.ticket.DetailProductError;
import com.openbravo.pos.util.LogToFile;
import java.util.List;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.stage.Popup;

public class ErrorItemsPopUp
extends Popup {
    private double height;
    private double width;
    private List<DetailProductError> errors;
    private GridPane mainPane;
    private String style = "-fx-background-color: linear-gradient(from 0% 0% to 0% 100%, #906DEE 0%, #523E88 100%); -fx-border-color: #FFFFFF3D; -fx-background-radius: 12px; -fx-border-radius: 12px;";
    private String styleNameItem = "-fx-text-fill: white; -fx-font-weight: Normal; -fx-font-size: 12px;";

    public ErrorItemsPopUp() {
        try {
            this.mainPane = new GridPane();
            this.mainPane.setVgap(5.0);
            this.mainPane.setHgap(5.0);
            this.mainPane.setAlignment(Pos.TOP_CENTER);
            this.mainPane.setStyle(this.style);
            this.mainPane.setOnMouseClicked(event -> this.hide());
            this.getContent().add((Object)this.mainPane);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void init(List<DetailProductError> errors, double width, double height) {
        try {
            this.errors = errors;
            this.width = width;
            this.height = height;
            this.mainPane.setPrefHeight(height);
            this.mainPane.setPrefWidth(width);
            this.mainPane.getChildren().clear();
            this.loadErrors();
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void loadErrors() {
        int row = 0;
        double heightError = this.height / (double)this.errors.size();
        for (DetailProductError error : this.errors) {
            Label errorLabel = new Label();
            errorLabel.setStyle(this.styleNameItem);
            errorLabel.setText(error.getName() + " " + error.getNumber() + "/" + error.getMin());
            errorLabel.setPrefWidth(this.width * 0.9);
            errorLabel.setPrefHeight(heightError);
            this.mainPane.add((Node)errorLabel, 0, row++);
        }
    }

    public List<DetailProductError> getErrors() {
        return this.errors;
    }
}

