/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.components;

import com.openbravo.components.DriveHeaderDetailProductButton;
import com.openbravo.components.DriveOptionDetailButton;
import com.openbravo.components.DriveSubOptionDetailButton;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.ticket.CarteOrderInfo;
import com.openbravo.pos.ticket.GroupSubSupplementInfo;
import com.openbravo.pos.ticket.OptionItemOrder;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.ticket.SubSupplementResult;
import com.openbravo.pos.ticket.SupplementItemInfo;
import com.openbravo.pos.util.ImagesUtils;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.StringUtils;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;

public class DriveSubSupplementsController {
    private GridPane subOptionsPane;
    @FXML
    GridPane mainPane;
    private SubSupplementResult result;
    private List<OptionItemOrder> listChoiceSupplement;
    private int parent_supplement_id;
    private List<OptionItemOrder> supplements_to_delete;
    private SupplementItemInfo parentSupplement;
    private int index_group_sub_supplement;
    private GroupSubSupplementInfo groupSubSupplementInfo;
    private final String KEY_INDEX = "KEY_INDEX";
    private GridPane header_g_sub_options_pages;
    private GridPane pane_footer;
    private HBox header_detail_product_pane;
    private Label title_group;
    private Label info_groupe;
    private Button button_next;
    private Button button_cancel;
    private Button button_valid;
    private int NUMBER_COLUMN_OPTION = 4;
    private int NUMBER_ROW_OPTION = 3;
    private int page_options;
    private int MAX_OPTIONS_PER_PAGE = 12;
    private int MAX_OPTIONS;
    private int numberPageOptions;
    private HashMap<Integer, LinkedHashMap<Integer, DriveSubOptionDetailButton>> map_sub_options;
    private Button nextItemOptionButton;
    private Button previousItemOptionButton;
    private LinkedHashMap<Integer, DriveSubOptionDetailButton> itemOptionsButton;
    private ImagesUtils mImagesUtils;
    private final String SIZE_IMAGE_512 = "_512px";
    private Image imageDefaultItemOption;
    private Image imagePreviousItem;
    private Image imageNextItem;
    private CarteOrderInfo groupProducts;
    private ProductInfoExt subProduct;
    private List<DriveHeaderDetailProductButton> groupTabs;
    private List<List<DriveHeaderDetailProductButton>> headerDetailProductArray;
    private int numberPageDetailProductHeader;
    private int NUMBER_G_SUB_OPTIONS_TAB = 3;
    private int page_detail_product_header;
    public static final String STR_G_SUB_OPTIONS = "group_sub_options";
    private DriveHeaderDetailProductButton firstButton = null;
    private int index_group_option;
    private DriveOptionDetailButton buttonOptionParent;
    private HashMap<Integer, SoftReference> refOptions;
    private List<DriveSubOptionDetailButton> optionsButtons;
    private String parent_supplement_global_id;

    public DriveSubSupplementsController(HashMap<Integer, SoftReference> refOptions, GridPane subOptionsMainPane) {
        try {
            this.optionsButtons = new ArrayList<DriveSubOptionDetailButton>();
            this.refOptions = refOptions;
            this.mImagesUtils = new ImagesUtils();
            this.imagePreviousItem = new Image("/images/backward-arrow-grayed.png");
            this.imageNextItem = new Image("/images/forward-arrows.png");
            this.imageDefaultItemOption = new Image(this.getClass().getResource("/com/openbravo/images/default_image_item_option.png").toURI().toString());
            this.mainPane = subOptionsMainPane;
            this.mainPane.setVgap(10.0);
            this.mainPane.setHgap(10.0);
            this.mainPane.setAlignment(Pos.TOP_CENTER);
            this.mainPane.setPadding(new Insets(25.0));
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public SubSupplementResult getResult() {
        return this.result;
    }

    private void loadPaneSubSupplement(GroupSubSupplementInfo groupSubSupplementInfo) {
        this.subOptionsPane.getChildren().clear();
        groupSubSupplementInfo.setOption_free_tmp(0);
        this.groupSubSupplementInfo = groupSubSupplementInfo;
        if (groupSubSupplementInfo.isHas_limit_options()) {
            this.info_groupe.setText(groupSubSupplementInfo.getMin_options() + " min - " + groupSubSupplementInfo.getMax_options() + " max");
            this.info_groupe.setManaged(true);
            this.info_groupe.setVisible(true);
        } else {
            this.info_groupe.setText("");
            this.info_groupe.setManaged(false);
            this.info_groupe.setVisible(false);
        }
        this.title_group.setText(StringUtils.CapitalizeFirstLetter(groupSubSupplementInfo.getDisplayedTitle()));
        if (this.map_sub_options == null) {
            this.map_sub_options = new HashMap();
        }
        this.map_sub_options.clear();
        double padding = 50.0;
        double heightOptionsPane = this.mainPane.getPrefHeight() - padding;
        double widthOptionsPane = this.mainPane.getPrefWidth() - padding;
        double widthOption = widthOptionsPane / (double)this.NUMBER_COLUMN_OPTION;
        double heightOption = heightOptionsPane / (double)this.NUMBER_ROW_OPTION;
        int index = 0;
        int index_map = 0;
        this.itemOptionsButton = new LinkedHashMap();
        this.numberPageOptions = (int)Math.ceil((double)groupSubSupplementInfo.getSupplements().size() / (double)this.MAX_OPTIONS_PER_PAGE);
        this.MAX_OPTIONS = this.numberPageOptions > 1 ? this.MAX_OPTIONS_PER_PAGE - 1 : this.MAX_OPTIONS_PER_PAGE;
        for (SupplementItemInfo optionItem : groupSubSupplementInfo.getSupplements()) {
            Image imageOption = this.mImagesUtils.getImageOption(optionItem, this.refOptions, "_512px", true);
            if (imageOption == null) {
                imageOption = this.imageDefaultItemOption;
            }
            DriveSubOptionDetailButton optionButton = new DriveSubOptionDetailButton(null, null, null, groupSubSupplementInfo, optionItem, heightOption * 0.9, widthOption, imageOption);
            int indexOption = this.indexSelectedOptionIfExist(optionItem);
            this.optionsButtons.add(optionButton);
            if (indexOption != -1) {
                OptionItemOrder optionItemOrder = this.listChoiceSupplement.get(indexOption);
                if (optionItemOrder != null) {
                    optionButton.setOptionItemOrder(optionItemOrder);
                    optionButton.setQuantity(optionItemOrder.getNumberOption());
                }
                optionButton.select();
            } else {
                optionButton.deselect();
            }
            if (index < this.MAX_OPTIONS) {
                this.itemOptionsButton.put(optionItem.getiD(), optionButton);
            } else {
                this.map_sub_options.put(index_map, this.itemOptionsButton);
                this.itemOptionsButton = new LinkedHashMap();
                this.itemOptionsButton.put(optionItem.getiD(), optionButton);
                ++index_map;
                index = 0;
            }
            ++index;
        }
        if (this.itemOptionsButton != null && !this.itemOptionsButton.isEmpty()) {
            this.map_sub_options.put(index_map, this.itemOptionsButton);
        }
        int column = 0;
        int row = 0;
        for (int i = 0; i < this.MAX_OPTIONS; ++i) {
            GridPane itemIngredientPane = new GridPane();
            itemIngredientPane.setPrefHeight(heightOption);
            itemIngredientPane.setPrefWidth(widthOption);
            itemIngredientPane.getStyleClass().add((Object)"border_white_opacity12");
            itemIngredientPane.getStyleClass().add((Object)"border_radius_12px");
            itemIngredientPane.getStyleClass().add((Object)"bg_radius_12px");
            itemIngredientPane.getStyleClass().add((Object)"bg_white_opacity12");
            this.subOptionsPane.add((Node)itemIngredientPane, column, row);
            if (column < this.NUMBER_COLUMN_OPTION - 1) {
                ++column;
                continue;
            }
            column = 0;
            ++row;
        }
        if (this.numberPageOptions > 1) {
            GridPane nextPreviousPane = new GridPane();
            nextPreviousPane.setAlignment(Pos.CENTER);
            nextPreviousPane.setVgap(5.0);
            nextPreviousPane.setHgap(5.0);
            nextPreviousPane.setPrefHeight(heightOption);
            nextPreviousPane.setPrefWidth(widthOption);
            nextPreviousPane.getStyleClass().add((Object)"bg_white_opacity20");
            nextPreviousPane.getStyleClass().add((Object)"border_radius_12px");
            nextPreviousPane.getStyleClass().add((Object)"bg_radius_12px");
            nextPreviousPane.getStyleClass().add((Object)"border_white_opacity12");
            this.nextItemOptionButton = new Button();
            this.nextItemOptionButton.getStyleClass().add((Object)"border_radius_14px");
            this.nextItemOptionButton.getStyleClass().add((Object)"bg_radius_14px");
            this.nextItemOptionButton.getStyleClass().add((Object)"bg_white_opacity18");
            this.nextItemOptionButton.setPrefHeight(nextPreviousPane.getPrefHeight() * 0.8);
            this.nextItemOptionButton.setPrefWidth(nextPreviousPane.getPrefWidth() * 0.45);
            ImageView view = new ImageView(this.imageNextItem);
            view.setFitHeight(nextPreviousPane.getPrefHeight() * 0.3);
            view.setFitWidth(nextPreviousPane.getPrefWidth() * 0.35);
            this.nextItemOptionButton.setGraphic((Node)view);
            this.previousItemOptionButton = new Button();
            this.previousItemOptionButton.getStyleClass().add((Object)"border_radius_14px");
            this.previousItemOptionButton.getStyleClass().add((Object)"bg_radius_14px");
            this.previousItemOptionButton.getStyleClass().add((Object)"bg_white_opacity18");
            this.previousItemOptionButton.setPrefHeight(nextPreviousPane.getPrefHeight() * 0.8);
            this.previousItemOptionButton.setPrefWidth(nextPreviousPane.getPrefWidth() * 0.45);
            ImageView view2 = new ImageView(this.imagePreviousItem);
            view2.setFitHeight(nextPreviousPane.getPrefHeight() * 0.3);
            view2.setFitWidth(nextPreviousPane.getPrefWidth() * 0.35);
            this.previousItemOptionButton.setGraphic((Node)view2);
            nextPreviousPane.add((Node)this.previousItemOptionButton, 0, 0);
            nextPreviousPane.add((Node)this.nextItemOptionButton, 1, 0);
            this.subOptionsPane.add((Node)nextPreviousPane, column, row);
            this.previousItemOptionButton.setVisible(false);
            this.previousItemOptionButton.setManaged(false);
            if (this.numberPageOptions == 1) {
                this.nextItemOptionButton.setVisible(false);
                this.nextItemOptionButton.setManaged(false);
            }
        }
        this.page_options = 0;
        this.loadPageOptions(this.page_options);
    }

    private void loadPageOptions(int page_options) {
        LinkedHashMap<Integer, DriveSubOptionDetailButton> mapOptionsButton = this.map_sub_options.get(page_options);
        if (mapOptionsButton != null) {
            List optionsButton = mapOptionsButton.values().stream().collect(Collectors.toList());
            int numberOptions = optionsButton.size();
            int index = 0;
            for (Node node : this.subOptionsPane.getChildren()) {
                if (index >= this.MAX_OPTIONS) break;
                if (node instanceof GridPane) {
                    GridPane optionPane = (GridPane)node;
                    optionPane.getChildren().clear();
                    if (index < numberOptions) {
                        optionPane.add((Node)optionsButton.get(index), 0, 0);
                    }
                }
                ++index;
            }
        }
    }

    public void nextOptions() {
        if (this.page_options < this.numberPageOptions - 1) {
            ++this.page_options;
            this.loadPageOptions(this.page_options);
            if (!this.previousItemOptionButton.isVisible()) {
                this.previousItemOptionButton.setVisible(true);
                this.previousItemOptionButton.setManaged(true);
            }
            if (this.page_options < this.numberPageOptions - 1) {
                double width = this.previousItemOptionButton.getPrefWidth();
                this.previousItemOptionButton.setPrefWidth(width / 2.0);
                this.nextItemOptionButton.setVisible(true);
                this.nextItemOptionButton.setManaged(true);
                this.nextItemOptionButton.setPrefWidth(width / 2.0);
            } else if (this.page_options == this.numberPageOptions - 1) {
                double width = this.nextItemOptionButton.getPrefWidth();
                this.nextItemOptionButton.setVisible(false);
                this.nextItemOptionButton.setManaged(false);
                this.previousItemOptionButton.setPrefWidth(width * 2.0);
            }
        }
    }

    public void previousOptions() {
        if (this.page_options > 0) {
            --this.page_options;
            this.loadPageOptions(this.page_options);
            if (!this.nextItemOptionButton.isVisible()) {
                this.nextItemOptionButton.setVisible(true);
                this.nextItemOptionButton.setManaged(true);
            }
            if (this.page_options > this.numberPageOptions - 1) {
                double width = this.nextItemOptionButton.getPrefWidth();
                this.nextItemOptionButton.setPrefWidth(width / 2.0);
                this.previousItemOptionButton.setVisible(true);
                this.previousItemOptionButton.setManaged(true);
                this.previousItemOptionButton.setPrefWidth(width);
            } else if (this.page_options == 0) {
                double width = this.previousItemOptionButton.getPrefWidth();
                this.previousItemOptionButton.setVisible(false);
                this.previousItemOptionButton.setManaged(false);
                this.nextItemOptionButton.setPrefWidth(width * 2.0);
            }
        }
    }

    public void initializer(DriveOptionDetailButton buttonOptionParent, CarteOrderInfo groupProducts, ProductInfoExt subProduct, SupplementItemInfo parentSupplement, List<OptionItemOrder> listChoiceSupplement, int index_group_option) {
        this.optionsButtons.clear();
        this.buttonOptionParent = buttonOptionParent;
        this.groupProducts = groupProducts;
        this.subProduct = subProduct;
        this.parentSupplement = parentSupplement;
        this.listChoiceSupplement = listChoiceSupplement;
        this.index_group_option = index_group_option;
        this.mainPane.getChildren().clear();
        int row = 0;
        this.loadHeaderButtons(parentSupplement.getGroupsSubSupplement());
        this.mainPane.add((Node)this.header_g_sub_options_pages, 0, row++);
        this.addTitleGroup();
        this.addInfoGroup();
        this.addSubOptionsPane();
        this.mainPane.add((Node)this.title_group, 0, row++);
        this.mainPane.add((Node)this.info_groupe, 0, row++);
        this.mainPane.add((Node)this.subOptionsPane, 0, row++);
        this.index_group_sub_supplement = 0;
        this.parent_supplement_id = parentSupplement.getiD();
        this.parent_supplement_global_id = parentSupplement.getId_global();
        this.supplements_to_delete = new ArrayList<OptionItemOrder>();
        this.result = new SubSupplementResult();
        this.result.setListChoiceSupplement(null);
        this.result.setValid(false);
        this.result.setSupplements_to_delete(this.supplements_to_delete);
        if (this.firstButton != null) {
            this.loadDetailGroupSubOption(this.firstButton);
        }
    }

    public void checkAndValid() {
        if (this.groupSubSupplementInfo.isHas_limit_options()) {
            boolean validMin = true;
            boolean validMax = true;
            int min_option = 0;
            int number = this.sizeOptions(this.groupSubSupplementInfo);
            if (number < (min_option = this.groupSubSupplementInfo.getMin_options())) {
                validMin = false;
            }
            if (number > this.groupSubSupplementInfo.getMax_options()) {
                validMax = false;
            }
            if (validMin && validMax) {
                this.valid();
            } else if (!validMin) {
                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "merci de s\u00e9lectionner le nombre minimum " + min_option + " des options.", 1500, NPosition.TOP_RIGHT);
            }
        } else {
            this.valid();
        }
    }

    public void valid() {
        ++this.index_group_sub_supplement;
        if (this.index_group_sub_supplement < this.parentSupplement.getGroupsSubSupplement().size()) {
            DriveHeaderDetailProductButton buttonGSubOption = this.groupTabs.get(this.index_group_sub_supplement);
            this.loadDetailGroupSubOption(buttonGSubOption);
        } else {
            this.result.setListChoiceSupplement(this.listChoiceSupplement);
            this.result.setValid(true);
            this.result.setSupplements_to_delete(this.supplements_to_delete);
        }
    }

    public void selectOption(int optionId) {
        DriveSubOptionDetailButton buttonOption = this.getOptionBtn(optionId);
        SupplementItemInfo optionItem = buttonOption.getOption();
        int indexOption = this.indexSelectedOptionIfExist(optionItem);
        if (indexOption == -1) {
            this.addOption(buttonOption);
        }
    }

    private void addOption(DriveSubOptionDetailButton buttonOption) {
        int id_group_products;
        int id_sub_product = this.subProduct != null ? this.subProduct.getID() : -1;
        int n = id_group_products = this.groupProducts != null ? this.groupProducts.getId() : -1;
        int index_group_products = this.groupProducts != null ? this.groupProducts.getIndex_carte() : (this.subProduct != null ? this.subProduct.getIndex_sub_product() : -1);
        String name_group_products = this.groupProducts != null ? this.groupProducts.getName() : null;
        String name_sub_product = this.subProduct != null ? this.subProduct.getName() : null;
        String ref_sub_product = this.subProduct != null ? this.subProduct.getRef_web() : null;
        String ref_group_products = this.groupProducts != null ? this.groupProducts.getRef_web() : null;
        String id_global_sub_product = this.subProduct != null ? this.subProduct.getId_global() : null;
        String id_global_group_products = this.groupProducts != null ? this.groupProducts.getId_global() : null;
        GroupSubSupplementInfo groupSubSupplementInfo = buttonOption.getGroupSubSupplementInfo();
        SupplementItemInfo optionItem = buttonOption.getOption();
        int number_free = 0;
        if (this.isOptionFreeable(groupSubSupplementInfo) && optionItem.getPrice_order() > 0.0) {
            optionItem.setPrice_order(0.0);
            this.decrementOptionFree(groupSubSupplementInfo, 1);
            number_free = 1;
        }
        OptionItemOrder optionItemOrder = new OptionItemOrder(id_group_products, id_sub_product, name_sub_product, name_group_products, 1, index_group_products, number_free, optionItem, this.parent_supplement_id, groupSubSupplementInfo.getId(), ref_sub_product, ref_group_products, id_global_sub_product, id_global_group_products, this.parent_supplement_global_id);
        this.listChoiceSupplement.add(optionItemOrder);
        buttonOption.setOptionItemOrder(optionItemOrder);
        buttonOption.setQuantity(1);
        buttonOption.select();
        if (this.listChoiceSupplement.size() > 0 && groupSubSupplementInfo.isHas_limit_options() && groupSubSupplementInfo.getMax_options() == this.sizeOptions(groupSubSupplementInfo)) {
            this.checkAndValid();
        }
        if (groupSubSupplementInfo.getNumber_click() == 1 || groupSubSupplementInfo.getMax_options() == 1) {
            buttonOption.getQuantityIncreaseButton().setOpacity(0.5);
        }
    }

    private void increaseQttOption(DriveSubOptionDetailButton buttonOption) {
        SupplementItemInfo optionItem = buttonOption.getOption();
        GroupSubSupplementInfo groupSubSupplementInfo = buttonOption.getGroupSubSupplementInfo();
        int indexOption = this.indexSelectedOptionIfExist(optionItem);
        if (indexOption != -1) {
            int number = this.listChoiceSupplement.get(indexOption).getNumberOption();
            if (number < groupSubSupplementInfo.getNumber_click() && number < groupSubSupplementInfo.getMax_options()) {
                int numberFree = this.listChoiceSupplement.get(indexOption).getNumber_free();
                if (this.isOptionFreeable(groupSubSupplementInfo) && optionItem.getPrice_order() > 0.0) {
                    this.listChoiceSupplement.get(indexOption).setNumber_free(++numberFree);
                    this.decrementOptionFree(groupSubSupplementInfo, 1);
                }
                this.listChoiceSupplement.get(indexOption).setNumberOption(++number);
                this.listChoiceSupplement.get(indexOption).setPrice(optionItem.getPrice_order(), number - numberFree);
                buttonOption.setQuantity(number);
                if (this.listChoiceSupplement.size() > 0 && groupSubSupplementInfo.isHas_limit_options() && groupSubSupplementInfo.getMax_options() == this.sizeOptions(groupSubSupplementInfo)) {
                    this.checkAndValid();
                }
            } else {
                System.out.println("notification");
            }
            if (number >= groupSubSupplementInfo.getNumber_click() || number >= groupSubSupplementInfo.getMax_options()) {
                buttonOption.getQuantityIncreaseButton().setOpacity(0.5);
            }
        }
    }

    private void decreaseQttOption(DriveSubOptionDetailButton buttonOption) {
        SupplementItemInfo optionItem = buttonOption.getOption();
        int indexOption = this.indexSelectedOptionIfExist(optionItem);
        if (indexOption != -1) {
            OptionItemOrder optionToDelete = this.listChoiceSupplement.get(indexOption);
            if (optionToDelete.getNumberOption() > 1) {
                this.decreaseQttOption(buttonOption, optionToDelete);
            } else {
                this.deleteOption(buttonOption, optionToDelete);
            }
        }
    }

    public void handleSubOptionAction(int subOptionId, boolean increase) {
        DriveSubOptionDetailButton buttonOption = this.getOptionBtn(subOptionId);
        if (buttonOption == null) {
            return;
        }
        if (increase) {
            this.increaseQttOption(buttonOption);
        } else {
            this.decreaseQttOption(buttonOption);
        }
    }

    private void decreaseQttOption(DriveSubOptionDetailButton buttonOption, OptionItemOrder itemToUpdate) {
        if (itemToUpdate.getNumber_free() == itemToUpdate.getNumberOption()) {
            if (!itemToUpdate.isForce_free()) {
                this.incrementOptionFree(buttonOption.getGroupSubSupplementInfo(), 1);
            }
            this.calculFreeAfterDelete(buttonOption.getGroupSubSupplementInfo());
            itemToUpdate.setNumber_free(itemToUpdate.getNumber_free() - 1);
            itemToUpdate.setNumberOption(itemToUpdate.getNumberOption() - 1);
        } else {
            itemToUpdate.setNumberOption(itemToUpdate.getNumberOption() - 1);
            if (buttonOption.getOption() != null) {
                itemToUpdate.setPrice(buttonOption.getOption().getPrice_order(), itemToUpdate.getNumberOption() - itemToUpdate.getNumber_free());
            }
        }
        buttonOption.setQuantity(itemToUpdate.getNumberOption());
        buttonOption.getQuantityIncreaseButton().setOpacity(1.0);
    }

    private void deleteOption(DriveSubOptionDetailButton buttonOtion, OptionItemOrder itemToDelete) {
        if (itemToDelete.getNumber_free() > 0) {
            this.incrementOptionFree(buttonOtion.getGroupSubSupplementInfo(), itemToDelete.getNumber_free());
            if (!itemToDelete.isForce_free()) {
                this.incrementOptionFree(buttonOtion.getGroupSubSupplementInfo(), 1);
            }
            this.listChoiceSupplement.remove(itemToDelete);
            this.calculFreeAfterDelete(buttonOtion.getGroupSubSupplementInfo());
        } else {
            this.listChoiceSupplement.remove(itemToDelete);
        }
        if (buttonOtion.getOption() != null) {
            // empty if block
        }
        buttonOtion.deselect();
    }

    private int indexSelectedOptionIfExist(SupplementItemInfo option) {
        int found = -1;
        for (int i = 0; i < this.listChoiceSupplement.size(); ++i) {
            if (this.listChoiceSupplement.get(i).getSupplement() != option.getiD()) continue;
            found = i;
            break;
        }
        return found;
    }

    private int sizeOptions(GroupSubSupplementInfo mGroupSubSupplementInfo) {
        int size = 0;
        try {
            for (OptionItemOrder optionItem : this.listChoiceSupplement) {
                for (SupplementItemInfo supplement : mGroupSubSupplementInfo.getSupplements()) {
                    if (optionItem.getSupplement() != supplement.getiD()) continue;
                    size += optionItem.getNumberOption();
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return size;
    }

    private boolean isOptionFreeable(GroupSubSupplementInfo groupSubSupplementInfo) {
        return groupSubSupplementInfo.getOption_free() > groupSubSupplementInfo.getOption_free_tmp();
    }

    private void decrementOptionFree(GroupSubSupplementInfo groupSubSupplementInfo, int number_free) {
        groupSubSupplementInfo.setOption_free_tmp(groupSubSupplementInfo.getOption_free_tmp() + number_free);
    }

    private void incrementOptionFree(GroupSubSupplementInfo groupSubSupplementInfo, int number_free) {
        groupSubSupplementInfo.setOption_free_tmp(groupSubSupplementInfo.getOption_free_tmp() - number_free);
    }

    private void calculFreeAfterDelete(GroupSubSupplementInfo groupSubSupplementInfo) {
        if (this.isOptionFreeable(groupSubSupplementInfo)) {
            for (OptionItemOrder supplement : this.listChoiceSupplement) {
                if (!this.isOptionFreeable(groupSubSupplementInfo) || supplement.getGroupSubSupplementInfo_ID() != groupSubSupplementInfo.getId() || supplement.getNumber_free() >= supplement.getNumberOption() || !(supplement.getPrice() > 0.0)) continue;
                int free_possible = groupSubSupplementInfo.getOption_free() - groupSubSupplementInfo.getOption_free_tmp();
                int free = free_possible > supplement.getNumberOption() - supplement.getNumber_free() ? supplement.getNumberOption() - supplement.getNumber_free() : free_possible;
                double price_option = supplement.getPrice() - supplement.getPrice() / (double)(supplement.getNumberOption() - supplement.getNumber_free());
                supplement.setNumber_free(supplement.getNumber_free() + free);
                double price = price_option * (double)(supplement.getNumberOption() - supplement.getNumber_free());
                supplement.setPrice(price_option, supplement.getNumberOption() - supplement.getNumber_free());
                this.decrementOptionFree(groupSubSupplementInfo, free);
            }
        }
    }

    public void loadDetailGroupSubOption(int groupId, String type) {
        DriveHeaderDetailProductButton btn = this.getGroupTabBtn(type, groupId);
        if (btn == null) {
            return;
        }
        this.loadDetailGroupSubOption(btn);
    }

    private void loadDetailGroupSubOption(DriveHeaderDetailProductButton mButtonSource) {
        try {
            if (this.checkGroupSubOption()) {
                int index;
                this.deselectHeaderTabs(mButtonSource.getIndex());
                this.selectHeaderTab(mButtonSource);
                this.index_group_sub_supplement = index = ((Integer)mButtonSource.getProperties().get((Object)"KEY_INDEX")).intValue();
                if (this.index_group_sub_supplement < this.parentSupplement.getGroupsSubSupplement().size()) {
                    this.loadPaneSubSupplement(this.parentSupplement.getGroupsSubSupplement().get(this.index_group_sub_supplement));
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private boolean checkGroupSubOption() {
        if (this.groupSubSupplementInfo != null && this.groupSubSupplementInfo.isHas_limit_options()) {
            boolean validMin = true;
            boolean validMax = true;
            int min_option = 0;
            int number = this.sizeOptions(this.groupSubSupplementInfo);
            if (number < (min_option = this.groupSubSupplementInfo.getMin_options())) {
                validMin = false;
            }
            if (number > this.groupSubSupplementInfo.getMax_options()) {
                validMax = false;
            }
            return validMin && validMax;
        }
        return true;
    }

    public void cancel() {
        this.result.setValid(false);
    }

    private void addTitleGroup() {
        if (this.title_group == null) {
            this.title_group = new Label();
            this.title_group.setAlignment(Pos.CENTER);
            this.title_group.setStyle("-fx-font-size: 21pt; -fx-text-fill: gray;");
            this.title_group.setPadding(new Insets(0.0, 15.0, 0.0, 15.0));
            this.title_group.setPrefWidth(this.mainPane.getPrefWidth());
        }
    }

    private void addInfoGroup() {
        if (this.info_groupe == null) {
            this.info_groupe = new Label();
            this.info_groupe.setAlignment(Pos.CENTER);
            this.info_groupe.setStyle("-fx-font-size: 18pt; -fx-text-fill: black; -fx-font-weight: bold;");
            this.info_groupe.setPadding(new Insets(0.0, 15.0, 0.0, 15.0));
            this.info_groupe.setPrefWidth(this.mainPane.getPrefWidth());
        }
    }

    private void addSubOptionsPane() {
        if (this.subOptionsPane == null) {
            this.subOptionsPane = new GridPane();
            this.subOptionsPane.setAlignment(Pos.CENTER);
            this.subOptionsPane.setVgap(10.0);
            this.subOptionsPane.setHgap(10.0);
            this.subOptionsPane.setPrefHeight(this.mainPane.getPrefHeight() * 0.6);
            this.subOptionsPane.setPrefWidth(this.mainPane.getPrefWidth());
        }
    }

    public SupplementItemInfo getParentSupplement() {
        return this.parentSupplement;
    }

    public void setParentSupplement(SupplementItemInfo parentSupplement) {
        this.parentSupplement = parentSupplement;
    }

    public ProductInfoExt getSubProduct() {
        return this.subProduct;
    }

    public void setSubProduct(ProductInfoExt subProduct) {
        this.subProduct = subProduct;
    }

    public CarteOrderInfo getGroupProducts() {
        return this.groupProducts;
    }

    public void setGroupProducts(CarteOrderInfo groupProducts) {
        this.groupProducts = groupProducts;
    }

    private void loadHeaderButtons(List<GroupSubSupplementInfo> groupsSubOptions) {
        int buttonsCount = groupsSubOptions != null && !groupsSubOptions.isEmpty() ? groupsSubOptions.size() : 1;
        this.groupSubSupplementInfo = null;
        if (this.header_g_sub_options_pages == null) {
            this.header_g_sub_options_pages = new GridPane();
            this.header_g_sub_options_pages.setAlignment(Pos.CENTER);
            this.header_g_sub_options_pages.setPrefHeight(this.mainPane.getPrefHeight() * 0.1);
            this.header_g_sub_options_pages.setPrefWidth(this.mainPane.getPrefWidth() - 50.0);
            if (this.header_detail_product_pane == null) {
                this.header_detail_product_pane = new HBox();
                this.header_detail_product_pane.setAlignment(Pos.CENTER);
                this.header_detail_product_pane.setPrefHeight(this.mainPane.getPrefHeight() * 0.1);
            }
        } else {
            this.header_g_sub_options_pages.getChildren().clear();
            if (this.header_detail_product_pane != null) {
                this.header_detail_product_pane.getChildren().clear();
            }
        }
        double heightDetailProductPane = this.mainPane.getPrefHeight() * 0.1;
        double widthDetailProductPane = this.mainPane.getPrefWidth() - 50.0;
        double widthDetailProductTab = widthDetailProductPane / (double)Math.min(buttonsCount, this.NUMBER_G_SUB_OPTIONS_TAB);
        this.groupTabs = new ArrayList<DriveHeaderDetailProductButton>();
        int index = 1;
        int indexGroupe = 0;
        this.firstButton = null;
        if (groupsSubOptions != null && !groupsSubOptions.isEmpty()) {
            for (GroupSubSupplementInfo groupsSubOption : groupsSubOptions) {
                DriveHeaderDetailProductButton groupsSubOptionButton = new DriveHeaderDetailProductButton(STR_G_SUB_OPTIONS, groupsSubOption, index++, widthDetailProductTab, heightDetailProductPane * 0.9);
                groupsSubOptionButton.getProperties().put((Object)"KEY_INDEX", (Object)indexGroupe);
                if (this.firstButton == null) {
                    this.firstButton = groupsSubOptionButton;
                }
                ++indexGroupe;
                this.groupTabs.add(groupsSubOptionButton);
            }
        }
        if (!this.groupTabs.isEmpty()) {
            this.numberPageDetailProductHeader = (int)Math.ceil((double)this.groupTabs.size() / (double)this.NUMBER_G_SUB_OPTIONS_TAB);
            this.headerDetailProductArray = new ArrayList<List<DriveHeaderDetailProductButton>>();
            this.header_g_sub_options_pages.add((Node)this.header_detail_product_pane, 0, 0);
            this.header_detail_product_pane.setPrefWidth(widthDetailProductPane);
            this.numberPageDetailProductHeader = (int)Math.ceil((double)this.groupTabs.size() / (double)this.NUMBER_G_SUB_OPTIONS_TAB);
            this.headerDetailProductArray = new ArrayList<List<DriveHeaderDetailProductButton>>();
            for (int i = 0; i < this.numberPageDetailProductHeader; ++i) {
                ArrayList<DriveHeaderDetailProductButton> sub = new ArrayList<DriveHeaderDetailProductButton>();
                int startIndex = i * this.NUMBER_G_SUB_OPTIONS_TAB;
                int endIndex = (i + 1) * this.NUMBER_G_SUB_OPTIONS_TAB;
                int trueEndIndex = Math.min(endIndex, this.groupTabs.size());
                for (int j = startIndex; j < trueEndIndex; ++j) {
                    DriveHeaderDetailProductButton headerButton = this.groupTabs.get(j);
                    int startOrEnd = 2;
                    if (this.groupTabs.size() == 1) {
                        startOrEnd = 0;
                    } else {
                        if (j == startIndex) {
                            startOrEnd = -1;
                        }
                        if (j == trueEndIndex - 1) {
                            startOrEnd = 1;
                        }
                    }
                    headerButton.setViewForMenu(startOrEnd);
                    sub.add(headerButton);
                }
                if (sub.isEmpty()) continue;
                this.headerDetailProductArray.add(sub);
            }
            if (this.numberPageDetailProductHeader > 0) {
                this.page_detail_product_header = 0;
                this.header_detail_product_pane.getChildren().clear();
                this.header_detail_product_pane.getChildren().addAll((Collection)this.headerDetailProductArray.get(this.page_detail_product_header));
            }
        }
    }

    public void nextHeaderTab() {
        if (this.page_detail_product_header < this.numberPageDetailProductHeader - 1) {
            ++this.page_detail_product_header;
            this.header_detail_product_pane.getChildren().clear();
            this.header_detail_product_pane.getChildren().addAll((Collection)this.headerDetailProductArray.get(this.page_detail_product_header));
            if (this.page_detail_product_header == this.numberPageDetailProductHeader - 1) {
                // empty if block
            }
        }
    }

    public void previousHeaderTab() {
        if (this.page_detail_product_header > 0) {
            --this.page_detail_product_header;
            this.header_detail_product_pane.getChildren().clear();
            this.header_detail_product_pane.getChildren().addAll((Collection)this.headerDetailProductArray.get(this.page_detail_product_header));
            if (this.page_detail_product_header == 0) {
                // empty if block
            }
        }
    }

    private void deselectHeaderTabs(int selectedIndex) {
        for (DriveHeaderDetailProductButton headerButton : this.groupTabs) {
            headerButton.deselect(selectedIndex);
        }
    }

    private void selectHeaderTab(DriveHeaderDetailProductButton headerButton) {
        headerButton.select();
    }

    public int getIndex_group_option() {
        return this.index_group_option;
    }

    public void setIndex_group_option(int index_group_option) {
        this.index_group_option = index_group_option;
    }

    public DriveOptionDetailButton getButtonOptionParent() {
        return this.buttonOptionParent;
    }

    public void setButtonOptionParent(DriveOptionDetailButton buttonOptionParent) {
        this.buttonOptionParent = buttonOptionParent;
    }

    private DriveHeaderDetailProductButton getGroupTabBtn(String type, Integer index) {
        return this.groupTabs.stream().filter(tab -> {
            boolean sameType = Objects.equals(tab.getGroup_type(), type);
            boolean sameIndex = true;
            if (index != null) {
                sameIndex = Objects.equals(tab.getIndex(), index);
            }
            return sameType && sameIndex;
        }).findFirst().orElse(null);
    }

    private DriveSubOptionDetailButton getOptionBtn(int optionId) {
        return this.optionsButtons.stream().filter(optionBtn -> Objects.equals(optionBtn.getOption().getiD(), optionId)).findFirst().orElse(null);
    }
}

