/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.components;

import com.openbravo.format.Formats;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.CarteOrderInfo;
import com.openbravo.pos.ticket.GroupSubSupplementInfo;
import com.openbravo.pos.ticket.OptionItemOrder;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.ticket.SupplementItemInfo;
import com.openbravo.pos.ticket.SupplementProduct;
import com.openbravo.pos.util.ColorUtils;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow;

public class DriveSubOptionDetailButton
extends Button {
    private SupplementItemInfo optionItem;
    private final String boxStyle = "-fx-border-color: #FFFFFF14; -fx-padding: 0 10 20 10; -fx-border-radius: 20px; -fx-background-color: white;  -fx-background-radius: 20px;";
    private final String boxStyleSelected;
    private final String styleName = "-fx-text-fill: black; -fx-font-size: 14pt; -fx-font-weight: bold;";
    private final String stylePrice;
    private final String quantityLabelsStyle = "-fx-text-fill: black; -fx-font-size: 16pt; -fx-font-weight: bold; -fx-border-color: gray; -fx-border-radius: 15px; -fx-background-radius: 15px; -fx-background-color: white;";
    private double height;
    private double width;
    private Image imageItem;
    private Label textPrice;
    private Label labelName;
    private StackPane basePane;
    private VBox parentPane;
    private HBox quantityPane;
    private Button quantityIncreaseLabel;
    private Button quantityDecreaseLabel;
    private Label quantityValueLabel;
    private boolean selected;
    private SupplementProduct groupOption;
    private int quantity;
    private String eventName;
    private CarteOrderInfo groupProducts;
    private ProductInfoExt subProduct;
    private OptionItemOrder optionItemOrder;
    private GroupSubSupplementInfo groupSubSupplementInfo;
    private int index_group_option;
    private ImageView imageViewRight;
    private ImageView imageViewLeft;
    private Image imageRight;
    private Image imageRightFree;
    private Image imageLeft;
    private Image imageLeftFree;
    private StackPane backgroundBox;
    private VBox checkBox;
    private Label labelImage;
    private final String colorHex = ColorUtils.getColor(AppLocal.color_borne);

    public DriveSubOptionDetailButton() {
        this.boxStyleSelected = "-fx-border-color: transparent; -fx-border-radius: 20px; -fx-background-color: " + this.colorHex + ";  -fx-background-radius: 20px;";
        this.stylePrice = "-fx-text-fill: gray; -fx-font-size: 16pt; -fx-font-weight: normal;";
        this.init();
    }

    public DriveSubOptionDetailButton(CarteOrderInfo groupProducts, ProductInfoExt subProduct, SupplementProduct groupOption, GroupSubSupplementInfo groupSubSupplementInfo, SupplementItemInfo optionItem, double height, double width, Image imageItem) {
        this.boxStyleSelected = "-fx-border-color: transparent; -fx-border-radius: 20px; -fx-background-color: " + this.colorHex + ";  -fx-background-radius: 20px;";
        this.stylePrice = "-fx-text-fill: gray; -fx-font-size: 16pt; -fx-font-weight: normal;";
        this.groupProducts = groupProducts;
        this.subProduct = subProduct;
        this.groupOption = groupOption;
        this.groupSubSupplementInfo = groupSubSupplementInfo;
        this.optionItem = optionItem;
        this.height = height * 0.9;
        this.width = width * 0.9;
        this.imageItem = imageItem;
        this.init();
    }

    public SupplementItemInfo getOption() {
        return this.optionItem;
    }

    public void setOption(SupplementItemInfo option) {
        this.optionItem = option;
    }

    private void init() {
        this.setPrefHeight(this.height);
        this.setPrefWidth(this.width);
        this.buildPaneOption();
    }

    private void buildPaneOption() {
        this.setStyle("-fx-background-color: transparent;");
        this.parentPane = new VBox();
        this.parentPane.setAlignment(Pos.CENTER);
        this.parentPane.setPrefHeight(this.height);
        this.parentPane.setPrefWidth(this.width);
        this.parentPane.setSpacing(10.0);
        this.parentPane.setStyle("-fx-background-color: transparent");
        double innerBoxesHeights = this.parentPane.getPrefHeight() * 0.9;
        this.basePane = new StackPane();
        this.basePane.setAlignment(Pos.CENTER);
        this.basePane.setPrefHeight(innerBoxesHeights);
        this.basePane.setPrefWidth(this.width);
        VBox parentBox = new VBox();
        parentBox.setAlignment(Pos.CENTER);
        parentBox.setMinHeight(innerBoxesHeights);
        parentBox.setMaxHeight(innerBoxesHeights);
        parentBox.setPrefWidth(this.parentPane.getPrefWidth() * 0.8);
        parentBox.setStyle("-fx-background-color: transparent");
        this.labelImage = new Label();
        this.labelImage.setPrefHeight(innerBoxesHeights * 0.55);
        this.labelImage.setPrefWidth(parentBox.getPrefWidth() * 0.8);
        if (this.imageItem != null) {
            ImageView imageView = new ImageView(this.imageItem);
            imageView.setFitHeight(this.labelImage.getPrefHeight());
            imageView.setFitWidth(this.labelImage.getPrefHeight());
            imageView.setPreserveRatio(true);
            imageView.setSmooth(true);
            this.labelImage.setGraphic((Node)imageView);
            parentBox.getChildren().add((Object)this.labelImage);
        }
        this.labelName = new Label(this.optionItem.getDisplayedName());
        this.labelName.setWrapText(true);
        this.labelName.setPrefWidth(this.parentPane.getPrefWidth() * 0.9);
        this.labelName.setAlignment(Pos.CENTER);
        this.labelName.setTextAlignment(TextAlignment.CENTER);
        this.labelName.setStyle("-fx-text-fill: black; -fx-font-size: 14pt; -fx-font-weight: bold;");
        TextFlow flow = new TextFlow(new Node[]{this.labelName});
        flow.setTextAlignment(TextAlignment.CENTER);
        parentBox.getChildren().add((Object)flow);
        this.textPrice = new Label(Formats.CURRENCY.formatValue(this.optionItem.getPrice_order()));
        this.textPrice.setTextAlignment(TextAlignment.CENTER);
        this.textPrice.setAlignment(Pos.CENTER);
        this.textPrice.setStyle(this.stylePrice);
        parentBox.getChildren().add((Object)this.textPrice);
        this.backgroundBox = new StackPane();
        this.backgroundBox.setStyle("-fx-border-color: #FFFFFF14; -fx-padding: 0 10 20 10; -fx-border-radius: 20px; -fx-background-color: white;  -fx-background-radius: 20px;");
        this.backgroundBox.setMaxHeight(innerBoxesHeights * 0.5);
        this.backgroundBox.setMinHeight(innerBoxesHeights * 0.5);
        this.backgroundBox.setAlignment(Pos.TOP_RIGHT);
        this.checkBox = new VBox();
        this.checkBox.setAlignment(Pos.CENTER);
        this.checkBox.setPrefSize(30.0, 30.0);
        this.checkBox.setMaxSize(30.0, 30.0);
        this.checkBox.setStyle("-fx-background-color: " + this.colorHex + "; -fx-border-radius: 100%; -fx-background-radius: 100%;");
        this.checkBox.setTranslateX(10.0);
        this.checkBox.setTranslateY(-10.0);
        ImageView imageView2 = new ImageView(new Image("/images/white-check-sign-2.png", 15.0, 15.0, true, true));
        Label checkLabel = new Label();
        checkLabel.setGraphic((Node)imageView2);
        this.checkBox.getChildren().add((Object)checkLabel);
        this.backgroundBox.getChildren().add((Object)this.checkBox);
        this.checkBox.setVisible(false);
        this.checkBox.setManaged(false);
        VBox backgroundParentBox = new VBox();
        backgroundParentBox.setMinHeight(innerBoxesHeights);
        backgroundParentBox.setMaxHeight(innerBoxesHeights);
        backgroundParentBox.setPrefWidth(this.parentPane.getPrefWidth());
        backgroundParentBox.setAlignment(Pos.BOTTOM_CENTER);
        backgroundParentBox.getChildren().add((Object)this.backgroundBox);
        this.basePane.getChildren().add((Object)backgroundParentBox);
        this.basePane.getChildren().add((Object)parentBox);
        this.quantityPane = new HBox();
        this.quantityPane.setPadding(Insets.EMPTY);
        this.quantityPane.setSpacing(10.0);
        this.quantityPane.setAlignment(Pos.CENTER);
        this.quantityPane.setPrefHeight(this.parentPane.getPrefHeight() * 0.1);
        this.quantityPane.setPrefWidth(this.parentPane.getPrefWidth());
        this.quantityDecreaseLabel = new Button("-");
        this.quantityDecreaseLabel.setAlignment(Pos.CENTER);
        this.quantityDecreaseLabel.setPrefHeight(this.quantityPane.getPrefHeight() * 0.9);
        this.quantityDecreaseLabel.setPrefWidth(this.quantityPane.getPrefWidth() * 0.3);
        this.quantityDecreaseLabel.setStyle("-fx-text-fill: black; -fx-font-size: 16pt; -fx-font-weight: bold; -fx-border-color: gray; -fx-border-radius: 15px; -fx-background-radius: 15px; -fx-background-color: white;");
        this.quantityPane.getChildren().add((Object)this.quantityDecreaseLabel);
        this.quantityValueLabel = new Label("1");
        this.quantityValueLabel.setAlignment(Pos.CENTER);
        this.quantityValueLabel.setPrefHeight(this.quantityPane.getPrefHeight() * 0.9);
        this.quantityValueLabel.setPrefWidth(this.quantityPane.getPrefWidth() * 0.3);
        this.quantityValueLabel.setStyle("-fx-text-fill: black; -fx-font-size: 16pt; -fx-font-weight: bold; -fx-border-color: gray; -fx-border-radius: 15px; -fx-background-radius: 15px; -fx-background-color: white;");
        this.quantityPane.getChildren().add((Object)this.quantityValueLabel);
        this.quantityIncreaseLabel = new Button("+");
        this.quantityIncreaseLabel.setAlignment(Pos.CENTER);
        this.quantityIncreaseLabel.setPrefHeight(this.quantityPane.getPrefHeight() * 0.9);
        this.quantityIncreaseLabel.setPrefWidth(this.quantityPane.getPrefWidth() * 0.3);
        this.quantityIncreaseLabel.setStyle("-fx-text-fill: black; -fx-font-size: 16pt; -fx-font-weight: bold; -fx-border-color: gray; -fx-border-radius: 15px; -fx-background-radius: 15px; -fx-background-color: white;");
        this.quantityPane.getChildren().add((Object)this.quantityIncreaseLabel);
        this.parentPane.getChildren().add((Object)this.basePane);
        this.parentPane.getChildren().add((Object)this.quantityPane);
        this.quantityPane.setVisible(false);
        this.quantityPane.setManaged(false);
        this.setGraphic((Node)this.parentPane);
    }

    public void select() {
        this.selected = true;
        this.setCustomStyle();
        this.parentPane.setPrefHeight(this.height * 0.6);
        this.parentPane.setMaxHeight(this.height * 0.6);
        this.quantityPane.setManaged(true);
        this.quantityPane.setVisible(true);
    }

    public void deselect() {
        this.selected = false;
        this.setCustomStyle();
        this.quantityPane.setVisible(false);
        this.quantityPane.setManaged(false);
        this.parentPane.setPrefHeight(this.height * 0.9);
        this.parentPane.setMaxHeight(this.height * 0.9);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public SupplementProduct getGroupOption() {
        return this.groupOption;
    }

    public void setGroupOption(SupplementProduct supplementProduct) {
        this.groupOption = supplementProduct;
    }

    public Button getQuantityIncreaseButton() {
        return this.quantityIncreaseLabel;
    }

    public void setQuantityIncreaseButton(Button quantityIncreaseButton) {
        this.quantityIncreaseLabel = quantityIncreaseButton;
    }

    public Button getQuantityDecreaseButton() {
        return this.quantityDecreaseLabel;
    }

    public void setQuantityDecreaseButton(Button quantityDecreaseButton) {
        this.quantityDecreaseLabel = quantityDecreaseButton;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public void setQuantity(int quantity) {
        this.quantity = quantity;
        this.quantityValueLabel.setText(String.valueOf(quantity));
    }

    public String getEventName() {
        return this.eventName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public CarteOrderInfo getGroupProducts() {
        return this.groupProducts;
    }

    public void setGroupProducts(CarteOrderInfo groupProducts) {
        this.groupProducts = groupProducts;
    }

    public ProductInfoExt getSubProduct() {
        return this.subProduct;
    }

    public void setSubProduct(ProductInfoExt subProduct) {
        this.subProduct = subProduct;
    }

    public void checkFreeAndSetStyle() {
        boolean isFree;
        boolean bl = isFree = this.optionItemOrder.getNumberOption() == this.optionItemOrder.getNumber_free() && this.optionItemOrder.getNumberOption() > 0;
        if (isFree) {
            this.setImage(this.imageViewLeft, this.imageLeftFree);
            this.setImage(this.imageViewRight, this.imageRightFree);
        } else {
            this.setImage(this.imageViewLeft, this.imageLeft);
            this.setImage(this.imageViewRight, this.imageRight);
        }
    }

    public OptionItemOrder getOptionItemOrder() {
        return this.optionItemOrder;
    }

    public void setOptionItemOrder(OptionItemOrder optionItemOrder) {
        this.optionItemOrder = optionItemOrder;
    }

    public Image getImageItem() {
        return this.imageItem;
    }

    public void setImageItem(Image imageItem) {
        this.imageItem = imageItem;
    }

    public GroupSubSupplementInfo getGroupSubSupplementInfo() {
        return this.groupSubSupplementInfo;
    }

    public void setGroupSubSupplementInfo(GroupSubSupplementInfo groupSubSupplementInfo) {
        this.groupSubSupplementInfo = groupSubSupplementInfo;
    }

    public int getIndex_group_option() {
        return this.index_group_option;
    }

    public void setIndex_group_option(int index_group_option) {
        this.index_group_option = index_group_option;
    }

    private void setImage(ImageView imageView, Image image) {
        imageView.setImage(image);
        imageView.setStyle("-fx-padding: 0 0 0 0;");
        imageView.setFitHeight(this.quantityPane.getPrefHeight() * 0.7);
        imageView.setPreserveRatio(true);
        imageView.setSmooth(true);
    }

    private void setCustomStyle() {
        Platform.runLater(() -> {
            if (this.selected) {
                this.backgroundBox.setStyle(this.boxStyleSelected);
                this.checkBox.setVisible(true);
                this.checkBox.setManaged(true);
            } else {
                this.backgroundBox.setStyle("-fx-border-color: #FFFFFF14; -fx-padding: 0 10 20 10; -fx-border-radius: 20px; -fx-background-color: white;  -fx-background-radius: 20px;");
                this.checkBox.setVisible(false);
                this.checkBox.setManaged(false);
            }
        });
    }
}

