/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.components;

import com.openbravo.format.Formats;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.CarteOrderInfo;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.util.ColorUtils;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow;

public class DriveProductFamilleButton
extends Button {
    private ProductInfoExt product;
    private final String boxStyle = "-fx-border-color: #FFFFFF14; -fx-padding: 0 10 20 10; -fx-border-radius: 20px; -fx-background-color: white;  -fx-background-radius: 20px;";
    private final String boxStyleSelected;
    private final String styleName = "-fx-text-fill: black; -fx-font-size: 17pt; -fx-font-weight: bold;";
    private final String stylePrice;
    private final String stylePriceSelected = "-fx-text-fill: black; -fx-font-size: 20pt;";
    private Label labelName;
    private Label labelImage;
    private Label labelPrice;
    private final double width;
    private final double height;
    private StackPane stackPane;
    private final Image imageItem;
    private boolean selected;
    private CarteOrderInfo groupProduct;
    private int index;
    private final String colorHex = ColorUtils.getColor(AppLocal.color_borne);
    private VBox backgroundBox;

    public DriveProductFamilleButton(CarteOrderInfo groupProduct, ProductInfoExt product, double width, double height, Image imageItem, int index) {
        this.boxStyleSelected = "-fx-border-color: transparent; -fx-padding: 0 10 20 10; -fx-border-radius: 20px; -fx-background-color: " + this.colorHex + ";  -fx-background-radius: 20px;";
        this.stylePrice = "-fx-text-fill: " + this.colorHex + "; -fx-font-size: 20pt;";
        this.groupProduct = groupProduct;
        this.width = width;
        this.height = height;
        this.product = product;
        this.imageItem = imageItem;
        this.index = index;
        this.init();
    }

    private void init() {
        this.setStyle("-fx-background-color: transparent;");
        this.setPrefHeight(this.height);
        this.setPrefWidth(this.width);
        double innerBoxesHeights = this.height;
        this.stackPane = new StackPane();
        this.stackPane.setAlignment(Pos.CENTER);
        this.stackPane.setPrefHeight(innerBoxesHeights);
        this.stackPane.setPrefWidth(this.width);
        VBox parentBox = new VBox();
        parentBox.setAlignment(Pos.CENTER);
        parentBox.setMinHeight(innerBoxesHeights);
        parentBox.setMaxHeight(innerBoxesHeights);
        parentBox.setPrefWidth(this.width);
        parentBox.setPadding(new Insets(10.0));
        parentBox.setStyle("-fx-background-color: transparent");
        this.labelImage = new Label();
        this.labelImage.setPrefHeight(innerBoxesHeights * 0.75);
        this.labelImage.setPrefWidth(parentBox.getPrefWidth() * 0.8);
        if (this.imageItem != null) {
            ImageView imageViewItem = new ImageView(this.imageItem);
            imageViewItem.setFitHeight(this.labelImage.getPrefHeight());
            imageViewItem.setFitWidth(this.labelImage.getPrefWidth());
            imageViewItem.setFitWidth(this.labelImage.getPrefWidth());
            imageViewItem.setPreserveRatio(true);
            imageViewItem.setSmooth(false);
            this.labelImage.setGraphic((Node)imageViewItem);
            parentBox.getChildren().add((Object)this.labelImage);
        }
        this.labelName = new Label(this.product.getDisplayedName());
        this.labelName.setWrapText(true);
        this.labelName.setPrefWidth(this.width * 0.9);
        this.labelName.setAlignment(Pos.CENTER);
        this.labelName.setTextAlignment(TextAlignment.CENTER);
        this.labelName.setStyle("-fx-text-fill: black; -fx-font-size: 17pt; -fx-font-weight: bold;");
        TextFlow flow = new TextFlow(new Node[]{this.labelName});
        flow.setTextAlignment(TextAlignment.CENTER);
        parentBox.getChildren().add((Object)flow);
        this.labelPrice = new Label(" + " + Formats.CURRENCY.formatValue(this.product.getPriceSell()));
        this.labelPrice.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        this.labelPrice.setAlignment(Pos.CENTER);
        this.labelPrice.setStyle(this.stylePrice);
        parentBox.getChildren().add((Object)this.labelPrice);
        this.backgroundBox = new VBox();
        this.backgroundBox.setStyle("-fx-border-color: #FFFFFF14; -fx-padding: 0 10 20 10; -fx-border-radius: 20px; -fx-background-color: white;  -fx-background-radius: 20px;");
        this.backgroundBox.setMaxHeight(innerBoxesHeights * 0.5);
        this.backgroundBox.setMinHeight(innerBoxesHeights * 0.5);
        VBox backgroundParentBox = new VBox();
        backgroundParentBox.setMinHeight(innerBoxesHeights);
        backgroundParentBox.setMaxHeight(innerBoxesHeights);
        backgroundParentBox.setPrefWidth(this.width);
        backgroundParentBox.setAlignment(Pos.BOTTOM_CENTER);
        backgroundParentBox.getChildren().add((Object)this.backgroundBox);
        this.stackPane.getChildren().add((Object)backgroundParentBox);
        this.stackPane.getChildren().add((Object)parentBox);
        this.setGraphic((Node)this.stackPane);
    }

    public void deselect() {
        this.selected = false;
        this.setCustomStyle();
    }

    public void select() {
        this.selected = true;
        this.setCustomStyle();
    }

    public CarteOrderInfo getGroupProduct() {
        return this.groupProduct;
    }

    public void setGroupProduct(CarteOrderInfo groupProduct) {
        this.groupProduct = groupProduct;
    }

    public ProductInfoExt getProduct() {
        return this.product;
    }

    public void setProduct(ProductInfoExt product) {
        this.product = product;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    private void setCustomStyle() {
        Platform.runLater(() -> {
            if (this.selected) {
                this.backgroundBox.setStyle(this.boxStyleSelected);
                this.labelPrice.setStyle("-fx-text-fill: black; -fx-font-size: 20pt;");
            } else {
                this.backgroundBox.setStyle("-fx-border-color: #FFFFFF14; -fx-padding: 0 10 20 10; -fx-border-radius: 20px; -fx-background-color: white;  -fx-background-radius: 20px;");
                this.labelPrice.setStyle(this.stylePrice);
            }
        });
    }
}

