/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.components;

import com.openbravo.format.Formats;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.CarteOrderInfo;
import com.openbravo.pos.ticket.GroupSubSupplementInfo;
import com.openbravo.pos.ticket.OptionItemOrder;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.ticket.SupplementItemInfo;
import com.openbravo.pos.ticket.SupplementProduct;
import com.openbravo.pos.util.ColorUtils;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow;

public class DriveOptionDetailButton
extends Button {
    private SupplementItemInfo optionItem;
    private final String style = "-fx-padding: 0 0 0 0; -fx-background-color: white; -fx-border-color: #FFFFFF1F; -fx-background-radius: 12px; -fx-border-radius: 12px;";
    private String selectStyle;
    private final String styleSelectedFree = "-fx-padding: 0 0 0 0; -fx-background-color: #FFFFFF1F; -fx-border-color: #0B8871;-fx-background-radius: 12px; -fx-border-radius: 12px;";
    private final String styleSelectedPaid = "-fx-padding: 0 0 0 0; -fx-background-color: #FFFFFF1F; -fx-border-color: #FB5B4D;-fx-background-radius: 12px; -fx-border-radius: 12px;";
    private final String styleTextPrice = "-fx-text-fill: black; -fx-font-weight: Normal; -fx-font-size: 15pt;";
    private final String styleName = "-fx-text-fill: black; -fx-font-weight: bold; -fx-font-size: 14pt;";
    private final String styleQuantityPaid = "-fx-font-size: 14px; -fx-text-fill: #FB5B4D; -fx-border-color : #FB5B4D; -fx-background-radius: 3em; -fx-background-color: #FFF; -fx-border-radius: 3em;";
    private final String styleQuantityFree = "-fx-font-size: 14px; -fx-text-fill: #0B8871; -fx-border-color : #0B8871; -fx-background-radius: 3em; -fx-background-color: #FFF; -fx-border-radius: 3em;";
    private final String quantityLabelsStyle = "-fx-text-fill: black; -fx-font-size: 18pt; -fx-font-weight: bold; -fx-border-color: gray; -fx-border-radius: 15px; -fx-background-radius: 15px; -fx-background-color: white;";
    private double height;
    private double width;
    private Image imageItem;
    private VBox optionPane;
    private Label textPrice;
    private Label labelName;
    private VBox basePane;
    private HBox quantityPane;
    private Button quantityIncreaseLabel;
    private Button quantityDecreaseLabel;
    private Label quantityValueLabel;
    private boolean selected;
    private SupplementProduct groupOption;
    private int quantity;
    private String eventName;
    private CarteOrderInfo groupProducts;
    private ProductInfoExt subProduct;
    private OptionItemOrder optionItemOrder;
    private GroupSubSupplementInfo groupSubSupplementInfo;
    private int index_group_option;
    private ImageView imageViewRight;
    private ImageView imageViewLeft;
    private Image imageRight;
    private Image imageRightFree;
    private Image imageLeft;
    private Image imageLeftFree;

    public DriveOptionDetailButton() {
        this.init();
    }

    public DriveOptionDetailButton(CarteOrderInfo groupProducts, ProductInfoExt subProduct, SupplementProduct groupOption, GroupSubSupplementInfo groupSubSupplementInfo, SupplementItemInfo optionItem, double height, double width, Image imageItem) {
        this.groupProducts = groupProducts;
        this.subProduct = subProduct;
        this.groupOption = groupOption;
        this.groupSubSupplementInfo = groupSubSupplementInfo;
        this.optionItem = optionItem;
        this.height = height;
        this.width = width;
        this.imageItem = imageItem;
        this.init();
    }

    public SupplementItemInfo getOption() {
        return this.optionItem;
    }

    public void setOption(SupplementItemInfo option) {
        this.optionItem = option;
    }

    private void init() {
        this.selectStyle = "-fx-padding: 0 0 0 0; -fx-background-color: " + ColorUtils.getColor(AppLocal.color_borne) + "; -fx-border-color: #FFFFFF1F; -fx-background-radius: 12px; -fx-border-radius: 12px;";
        this.setPrefHeight(this.height);
        this.setPrefWidth(this.width);
        this.buildPaneOption();
    }

    private void buildPaneOption() {
        this.setStyle("-fx-background-color: transparent;");
        this.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
        this.basePane = new VBox();
        this.basePane.setStyle("-fx-background-color: transparent;");
        this.basePane.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
        this.basePane.setPrefHeight(this.height);
        this.basePane.setPrefWidth(this.width);
        this.basePane.setSpacing(10.0);
        this.optionPane = new VBox();
        this.optionPane.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
        this.optionPane.setAlignment(Pos.CENTER);
        this.optionPane.setPrefHeight(this.height * 0.9);
        this.optionPane.setPrefWidth(this.width);
        Label labelImage = new Label();
        labelImage.setAlignment(Pos.CENTER);
        labelImage.setPrefHeight(this.optionPane.getPrefHeight() * 0.6);
        labelImage.setPrefWidth(this.optionPane.getPrefWidth() * 0.8);
        if (this.imageItem != null) {
            ImageView imageView = new ImageView(this.imageItem);
            imageView.setFitHeight(labelImage.getPrefHeight() * 0.9);
            imageView.setFitWidth(labelImage.getPrefHeight() * 0.9);
            imageView.setPreserveRatio(false);
            imageView.setSmooth(false);
            labelImage.setGraphic((Node)imageView);
            this.optionPane.getChildren().add((Object)labelImage);
        }
        this.labelName = new Label(this.optionItem.getDisplayedName());
        this.labelName.setWrapText(true);
        this.labelName.setPrefWidth(this.width * 0.9);
        this.labelName.setAlignment(Pos.CENTER);
        this.labelName.setTextAlignment(TextAlignment.CENTER);
        this.labelName.setStyle("-fx-text-fill: black; -fx-font-weight: bold; -fx-font-size: 14pt;");
        TextFlow flow = new TextFlow(new Node[]{this.labelName});
        flow.setPrefWidth(this.width);
        flow.setTextAlignment(TextAlignment.CENTER);
        this.optionPane.getChildren().add((Object)flow);
        this.textPrice = new Label(Formats.CURRENCY.formatValue(this.optionItem.getPrice_order()));
        this.textPrice.setTextAlignment(TextAlignment.CENTER);
        this.textPrice.setAlignment(Pos.CENTER);
        this.textPrice.setStyle("-fx-text-fill: black; -fx-font-weight: Normal; -fx-font-size: 15pt;");
        this.optionPane.getChildren().add((Object)this.textPrice);
        this.basePane.getChildren().add((Object)this.optionPane);
        this.quantityPane = new HBox();
        this.quantityPane.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
        this.quantityPane.setSpacing(10.0);
        this.quantityPane.setAlignment(Pos.CENTER);
        this.quantityPane.setPrefHeight(this.height * 0.15);
        this.quantityPane.setPrefWidth(this.width);
        this.quantityDecreaseLabel = new Button("-");
        this.quantityDecreaseLabel.setAlignment(Pos.CENTER);
        this.quantityDecreaseLabel.setPrefHeight(this.quantityPane.getPrefHeight() * 0.9);
        this.quantityDecreaseLabel.setPrefWidth(this.quantityPane.getPrefWidth() * 0.3);
        this.quantityDecreaseLabel.setStyle("-fx-text-fill: black; -fx-font-size: 18pt; -fx-font-weight: bold; -fx-border-color: gray; -fx-border-radius: 15px; -fx-background-radius: 15px; -fx-background-color: white;");
        this.quantityPane.getChildren().add((Object)this.quantityDecreaseLabel);
        this.quantityValueLabel = new Label("1");
        this.quantityValueLabel.setAlignment(Pos.CENTER);
        this.quantityValueLabel.setPrefHeight(this.quantityPane.getPrefHeight() * 0.9);
        this.quantityValueLabel.setPrefWidth(this.quantityPane.getPrefWidth() * 0.3);
        this.quantityValueLabel.setStyle("-fx-text-fill: black; -fx-font-size: 18pt; -fx-font-weight: bold; -fx-border-color: gray; -fx-border-radius: 15px; -fx-background-radius: 15px; -fx-background-color: white;");
        this.quantityPane.getChildren().add((Object)this.quantityValueLabel);
        this.quantityIncreaseLabel = new Button("+");
        this.quantityIncreaseLabel.setAlignment(Pos.CENTER);
        this.quantityIncreaseLabel.setPrefHeight(this.quantityPane.getPrefHeight() * 0.9);
        this.quantityIncreaseLabel.setPrefWidth(this.quantityPane.getPrefWidth() * 0.3);
        this.quantityIncreaseLabel.setStyle("-fx-text-fill: black; -fx-font-size: 18pt; -fx-font-weight: bold; -fx-border-color: gray; -fx-border-radius: 15px; -fx-background-radius: 15px; -fx-background-color: white;");
        this.quantityPane.getChildren().add((Object)this.quantityIncreaseLabel);
        this.basePane.getChildren().add((Object)this.quantityPane);
        this.quantityPane.setVisible(false);
        this.quantityPane.setManaged(false);
        this.setGraphic((Node)this.basePane);
    }

    public void select() {
        this.optionPane.setStyle(this.selectStyle);
        this.selected = true;
        this.optionPane.setPrefHeight(this.height * 0.75);
        this.quantityPane.setManaged(true);
        this.quantityPane.setVisible(true);
    }

    public void deselect() {
        this.optionPane.setStyle("-fx-padding: 0 0 0 0; -fx-background-color: white; -fx-border-color: #FFFFFF1F; -fx-background-radius: 12px; -fx-border-radius: 12px;");
        this.selected = false;
        this.quantityPane.setVisible(false);
        this.quantityPane.setManaged(false);
        this.optionPane.setPrefHeight(this.height * 0.9);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public SupplementProduct getGroupOption() {
        return this.groupOption;
    }

    public void setGroupOption(SupplementProduct supplementProduct) {
        this.groupOption = supplementProduct;
    }

    public Button getQuantityIncreaseButton() {
        return this.quantityIncreaseLabel;
    }

    public void setQuantityIncreaseButton(Button quantityIncreaseButton) {
        this.quantityIncreaseLabel = quantityIncreaseButton;
    }

    public Button getQuantityDecreaseButton() {
        return this.quantityDecreaseLabel;
    }

    public void setQuantityDecreaseButton(Button quantityDecreaseButton) {
        this.quantityDecreaseLabel = quantityDecreaseButton;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public void setQuantity(int quantity) {
        this.quantity = quantity;
        this.quantityValueLabel.setText(String.valueOf(quantity));
    }

    public String getEventName() {
        return this.eventName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public CarteOrderInfo getGroupProducts() {
        return this.groupProducts;
    }

    public void setGroupProducts(CarteOrderInfo groupProducts) {
        this.groupProducts = groupProducts;
    }

    public ProductInfoExt getSubProduct() {
        return this.subProduct;
    }

    public void setSubProduct(ProductInfoExt subProduct) {
        this.subProduct = subProduct;
    }

    public void checkFreeAndSetStyle() {
        boolean isFree;
        boolean bl = isFree = this.optionItemOrder.getNumberOption() == this.optionItemOrder.getNumber_free() && this.optionItemOrder.getNumberOption() > 0;
        if (isFree) {
            this.quantityValueLabel.setStyle("-fx-font-size: 14px; -fx-text-fill: #0B8871; -fx-border-color : #0B8871; -fx-background-radius: 3em; -fx-background-color: #FFF; -fx-border-radius: 3em;");
            this.setStyle("-fx-padding: 0 0 0 0; -fx-background-color: #FFFFFF1F; -fx-border-color: #0B8871;-fx-background-radius: 12px; -fx-border-radius: 12px;");
            this.setImage(this.imageViewLeft, this.imageLeftFree);
            this.setImage(this.imageViewRight, this.imageRightFree);
        } else {
            this.quantityValueLabel.setStyle("-fx-font-size: 14px; -fx-text-fill: #FB5B4D; -fx-border-color : #FB5B4D; -fx-background-radius: 3em; -fx-background-color: #FFF; -fx-border-radius: 3em;");
            this.setStyle("-fx-padding: 0 0 0 0; -fx-background-color: #FFFFFF1F; -fx-border-color: #FB5B4D;-fx-background-radius: 12px; -fx-border-radius: 12px;");
            this.setImage(this.imageViewLeft, this.imageLeft);
            this.setImage(this.imageViewRight, this.imageRight);
        }
    }

    public OptionItemOrder getOptionItemOrder() {
        return this.optionItemOrder;
    }

    public void setOptionItemOrder(OptionItemOrder optionItemOrder) {
        this.optionItemOrder = optionItemOrder;
    }

    public Image getImageItem() {
        return this.imageItem;
    }

    public void setImageItem(Image imageItem) {
        this.imageItem = imageItem;
    }

    public GroupSubSupplementInfo getGroupSubSupplementInfo() {
        return this.groupSubSupplementInfo;
    }

    public void setGroupSubSupplementInfo(GroupSubSupplementInfo groupSubSupplementInfo) {
        this.groupSubSupplementInfo = groupSubSupplementInfo;
    }

    public int getIndex_group_option() {
        return this.index_group_option;
    }

    public void setIndex_group_option(int index_group_option) {
        this.index_group_option = index_group_option;
    }

    private void setImage(ImageView imageView, Image image) {
        imageView.setImage(image);
        imageView.setStyle("-fx-padding: 0 0 0 0;");
        imageView.setFitHeight(this.quantityPane.getPrefHeight() * 0.7);
        imageView.setPreserveRatio(true);
        imageView.setSmooth(true);
    }
}

