/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.components;

import com.openbravo.pos.ticket.CarteOrderInfo;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.ticket.SupplementItemInfo;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow;

public class DriveIngredientDetailButton
extends VBox {
    private SupplementItemInfo ingredient;
    private final String style = "-fx-background-color: transparent;";
    private final String styleName = "-fx-text-fill: black; -fx-font-size: 15pt;  -fx-font-weight: Normal;";
    private double height;
    private double width;
    private Image imageItem;
    private boolean removed;
    private Label labelName;
    private CarteOrderInfo groupProducts;
    private ProductInfoExt supProduct;
    private StackPane imagesStack;
    private Label removedImageLabel;
    private Circle checkedCircle;
    private Label imgLabel;

    public DriveIngredientDetailButton() {
        this.init();
    }

    public DriveIngredientDetailButton(CarteOrderInfo groupProducts, ProductInfoExt supProduct, SupplementItemInfo ingredient, double height, double width, Image imageItem, Image imageRemovedIngredient, boolean removed) {
        this.groupProducts = groupProducts;
        this.supProduct = supProduct;
        this.ingredient = ingredient;
        this.height = height * 0.95;
        this.width = width * 0.9;
        this.imageItem = imageItem;
        this.removed = removed;
        this.init();
    }

    public SupplementItemInfo getIngredient() {
        return this.ingredient;
    }

    public void setIngredient(SupplementItemInfo ingredient) {
        this.ingredient = ingredient;
    }

    private void init() {
        this.setStyle("-fx-background-color: transparent;");
        this.setPrefHeight(this.height);
        this.setPrefWidth(this.width);
        this.buildPaneIngredient();
    }

    private void buildPaneIngredient() {
        this.imagesStack = new StackPane();
        this.imagesStack.setAlignment(Pos.CENTER);
        this.setAlignment(Pos.CENTER);
        this.setSpacing(10.0);
        this.imgLabel = new Label();
        this.imgLabel.setPrefHeight(this.height * 0.7);
        this.imgLabel.setPrefWidth(this.width);
        this.imgLabel.setAlignment(Pos.CENTER);
        if (this.imageItem != null) {
            ImageView imageView = new ImageView(this.imageItem);
            imageView.setFitHeight(this.imgLabel.getPrefHeight() * 0.7);
            imageView.setFitWidth(this.imgLabel.getPrefWidth() * 0.6);
            imageView.setPreserveRatio(false);
            imageView.setSmooth(false);
            this.imgLabel.setGraphic((Node)imageView);
            this.checkedCircle = new Circle();
            this.checkedCircle.setRadius(imageView.getFitWidth() * 0.5);
            this.checkedCircle.setFill((Paint)Color.WHITE);
            this.checkedCircle.setStroke((Paint)Color.GREEN);
            this.checkedCircle.setStrokeWidth(3.0);
            this.imagesStack.getChildren().add((Object)this.checkedCircle);
            this.imagesStack.getChildren().add((Object)this.imgLabel);
            ImageView imageView2 = new ImageView(new Image("/com/openbravo/images/removed_ingredient.png"));
            imageView2.setFitHeight(imageView.getFitHeight());
            imageView2.setFitWidth(imageView.getFitWidth());
            imageView2.setPreserveRatio(true);
            imageView2.setSmooth(true);
            this.removedImageLabel = new Label();
            this.removedImageLabel.setGraphic((Node)imageView2);
            this.imagesStack.getChildren().add((Object)this.removedImageLabel);
        }
        this.getChildren().add((Object)this.imagesStack);
        this.labelName = new Label(this.ingredient.getDisplayedName());
        this.labelName.setWrapText(true);
        this.labelName.setStyle("-fx-text-fill: black; -fx-font-size: 15pt;  -fx-font-weight: Normal;");
        this.labelName.setAlignment(Pos.CENTER);
        TextFlow flow = new TextFlow(new Node[]{this.labelName});
        flow.setTextAlignment(TextAlignment.CENTER);
        this.getChildren().add((Object)flow);
        if (this.removed) {
            this.selectRemovedIngredient();
        } else {
            this.deselectIngredient();
        }
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void setRemoved(boolean removed) {
        this.removed = removed;
    }

    public void selectRemovedIngredient() {
        this.removedImageLabel.setVisible(true);
        this.checkedCircle.setStrokeWidth(0.0);
    }

    public void deselectIngredient() {
        this.removedImageLabel.setVisible(false);
        this.checkedCircle.setStrokeWidth(3.0);
    }

    public CarteOrderInfo getGroupProducts() {
        return this.groupProducts;
    }

    public void setGroupProducts(CarteOrderInfo groupProducts) {
        this.groupProducts = groupProducts;
    }

    public ProductInfoExt getSupProduct() {
        return this.supProduct;
    }

    public void setSupProduct(ProductInfoExt supProduct) {
        this.supProduct = supProduct;
    }

    public Image getImageItem() {
        return this.imageItem;
    }

    public void setImageItem(Image imageItem) {
        this.imageItem = imageItem;
    }
}

