/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.components;

import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.CarteOrderInfo;
import com.openbravo.pos.ticket.GroupSubSupplementInfo;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.util.ColorUtils;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextFlow;

public class DriveHeaderDetailProductButton
extends VBox {
    private String group_type;
    private Object groupItem;
    private int index;
    private final String style_sub_options = "-fx-background-color: transparent; -fx-text-fill: white;  -fx-font-size: 12px; -fx-background-radius: 12px";
    private boolean circular = false;
    private String formBgColor;
    private String dashBgColor;
    private HBox leftDash;
    private HBox rightDash;
    private Label contentBox;
    private final double circleDefaultWidth = 80.0;
    private final double circleDefaultHeight = 80.0;
    private final double rectangleDefaultWidth = 230.0;
    private final double rectangleDefaultHeight = 70.0;
    private double width = 400.0;
    private double height = 80.0;
    private String content;
    private int startOrEnd;
    private boolean isMenuStepper = false;

    public DriveHeaderDetailProductButton() {
        this.init();
    }

    public DriveHeaderDetailProductButton(String group_type, Object groupItem, int index, double width, double height) {
        this.group_type = group_type;
        this.groupItem = groupItem;
        this.index = index;
        this.width = width;
        this.height = height;
        this.init();
    }

    private void init() {
        this.setPadding(Insets.EMPTY);
        this.setPrefHeight(this.height);
        this.setPrefWidth(this.width);
        this.setStyle("-fx-background-color: transparent;");
        this.dashBgColor = "lightgray";
        this.formBgColor = "white";
        this.leftDash = new HBox();
        this.rightDash = new HBox();
        this.contentBox = new Label();
        switch (this.group_type) {
            case "ingredients": {
                this.content = "ingredients";
                break;
            }
            case "options": {
                this.content = "options";
                break;
            }
            case "sub_product": {
                if (this.groupItem == null || !(this.groupItem instanceof ProductInfoExt)) break;
                this.content = ((ProductInfoExt)this.groupItem).getDisplayedName();
                break;
            }
            case "group_products": {
                if (this.groupItem == null || !(this.groupItem instanceof CarteOrderInfo)) break;
                this.content = ((CarteOrderInfo)this.groupItem).getDisplayedName();
                break;
            }
            case "group_sub_options": {
                if (this.groupItem == null || !(this.groupItem instanceof GroupSubSupplementInfo)) break;
                this.content = ((GroupSubSupplementInfo)this.groupItem).getName_group();
                break;
            }
            default: {
                this.formBgColor = "#956FF8";
                this.dashBgColor = "#956FF8";
            }
        }
    }

    public String getGroup_type() {
        return this.group_type;
    }

    public void setGroup_type(String group_type) {
        this.group_type = group_type;
    }

    public Object getGroupItem() {
        return this.groupItem;
    }

    public void setGroupItem(Object groupItem) {
        this.groupItem = groupItem;
    }

    public int getIndex() {
        return this.index;
    }

    public String getContent() {
        return this.content;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void deselect(int currentButtonIndex) {
        if (this.index < currentButtonIndex && !this.isMenuStepper) {
            this.dashBgColor = ColorUtils.getColor(AppLocal.color_borne);
            this.formBgColor = ColorUtils.getColor(AppLocal.color_borne);
        } else {
            this.dashBgColor = "lightgray";
            this.formBgColor = "white";
        }
        if (this.isMenuStepper) {
            Platform.runLater(() -> this.setMenuStepperCircleBox(false));
        }
        this.setStyles();
    }

    public void select() {
        this.dashBgColor = ColorUtils.getColor(AppLocal.color_borne);
        this.formBgColor = ColorUtils.getColor(AppLocal.color_borne);
        if (this.isMenuStepper) {
            this.setStyles(true);
            Platform.runLater(() -> this.setMenuStepperCircleBox(true));
        } else {
            this.setStyles();
        }
    }

    public void deselectSubOption() {
        this.setStyle("-fx-background-color: transparent; -fx-text-fill: white;  -fx-font-size: 12px; -fx-background-radius: 12px");
    }

    public void setViewForMenu(int startOrEnd) {
        this.startOrEnd = startOrEnd;
        this.isMenuStepper = true;
        this.circular = true;
        this.setMenuStepperCircleBox(false);
    }

    public void setView(int startOrEnd, boolean circular) {
        this.startOrEnd = startOrEnd;
        this.circular = circular;
        if (circular) {
            this.setCircleBox();
        } else {
            this.setRectangleBox();
        }
    }

    public void setCircleBox() {
        this.getChildren().clear();
        double dashWidth = (this.width - 80.0) / 2.0;
        double dashHeight = 10.0;
        if (this.startOrEnd == -1 || this.startOrEnd == 1) {
            dashWidth *= 2.0;
        }
        HBox hbox = new HBox();
        hbox.setPadding(Insets.EMPTY);
        hbox.setPrefHeight(80.0);
        hbox.setStyle("-fx-background-color: transparent;");
        hbox.setMinWidth(this.width);
        hbox.setMaxWidth(this.width);
        if (this.startOrEnd != -1 && this.startOrEnd != 0) {
            this.leftDash.setMinHeight(dashHeight);
            this.leftDash.setMaxHeight(dashHeight);
            this.leftDash.setMinWidth(dashWidth);
            this.leftDash.setMaxWidth(dashWidth);
            hbox.getChildren().add((Object)this.leftDash);
        }
        this.contentBox.setText(String.valueOf(this.index));
        this.contentBox.setWrapText(true);
        this.contentBox.setPrefWidth(80.0);
        this.contentBox.setPrefHeight(80.0);
        this.contentBox.setMinHeight(80.0);
        this.contentBox.setMaxHeight(80.0);
        this.contentBox.setAlignment(Pos.CENTER);
        hbox.getChildren().add((Object)this.contentBox);
        if (this.startOrEnd != 1 && this.startOrEnd != 0) {
            this.rightDash.setMinHeight(dashHeight);
            this.rightDash.setMaxHeight(dashHeight);
            this.rightDash.setMinWidth(dashWidth);
            this.rightDash.setMaxWidth(dashWidth);
            hbox.getChildren().add((Object)this.rightDash);
        }
        Label contentLabel = new Label(this.content.toUpperCase().toUpperCase());
        contentLabel.setStyle("-fx-background-color: transparent; -fx-text-fill: black;  -fx-font-size: 13pt; -fx-padding: 4; -fx-font-weight: bold;");
        contentLabel.setWrapText(true);
        contentLabel.setPrefWidth(120.0);
        HBox hbox2 = new HBox(new Node[]{new TextFlow(new Node[]{contentLabel})});
        hbox2.setMinWidth(this.width);
        hbox2.setMaxWidth(this.width);
        this.getChildren().add((Object)hbox);
        this.getChildren().add((Object)hbox2);
        switch (this.startOrEnd) {
            case -1: {
                hbox.setAlignment(Pos.CENTER_LEFT);
                hbox2.setAlignment(Pos.CENTER_LEFT);
                this.setAlignment(Pos.TOP_LEFT);
                break;
            }
            case 1: {
                hbox.setAlignment(Pos.CENTER_RIGHT);
                hbox2.setAlignment(Pos.CENTER_RIGHT);
                this.setAlignment(Pos.TOP_RIGHT);
                break;
            }
            default: {
                hbox.setAlignment(Pos.CENTER);
                hbox2.setAlignment(Pos.CENTER);
                this.setAlignment(Pos.TOP_CENTER);
            }
        }
    }

    public void setRectangleBox() {
        this.getChildren().clear();
        double dashWidth = (this.width - 230.0) / 2.0;
        double dashHeight = 10.0;
        if (this.startOrEnd == -1 || this.startOrEnd == 1) {
            dashWidth *= 2.0;
        }
        HBox hbox = new HBox();
        hbox.setPadding(Insets.EMPTY);
        hbox.setPrefHeight(70.0);
        hbox.setStyle("-fx-background-color: transparent;");
        hbox.setAlignment(Pos.CENTER);
        hbox.setMinWidth(this.width);
        hbox.setMaxWidth(this.width);
        if (this.startOrEnd != -1 && this.startOrEnd != 0) {
            this.leftDash.setMinHeight(dashHeight);
            this.leftDash.setMaxHeight(dashHeight);
            this.leftDash.setMinWidth(dashWidth);
            this.leftDash.setMaxWidth(dashWidth);
            hbox.getChildren().add((Object)this.leftDash);
        }
        this.contentBox.setText(this.content.toUpperCase());
        this.contentBox.setWrapText(true);
        this.contentBox.setMinWidth(230.0);
        this.contentBox.setMaxWidth(230.0);
        this.contentBox.setMinHeight(70.0);
        this.contentBox.setMaxHeight(70.0);
        this.contentBox.setAlignment(Pos.CENTER);
        hbox.getChildren().add((Object)this.contentBox);
        if (this.startOrEnd != 1 && this.startOrEnd != 0) {
            this.rightDash.setMinHeight(dashHeight);
            this.rightDash.setMaxHeight(dashHeight);
            this.rightDash.setMinWidth(dashWidth);
            this.rightDash.setMaxWidth(dashWidth);
            hbox.getChildren().add((Object)this.rightDash);
        }
        this.getChildren().add((Object)hbox);
        this.setAlignment(Pos.CENTER);
    }

    public void setStyles() {
        this.setStyles(false);
    }

    public void setStyles(boolean selectedFromMenu) {
        double borderWidth;
        this.leftDash.setStyle("-fx-background-color:" + this.dashBgColor + ";");
        double d = borderWidth = this.formBgColor.equals("white") ? 1.0 : 0.0;
        if (this.circular) {
            int fontSize = selectedFromMenu ? 12 : 20;
            this.contentBox.setStyle("-fx-background-color: " + this.formBgColor + "; -fx-text-fill: black; -fx-font-size: " + fontSize + "pt; -fx-font-weight: bold; -fx-border-width: " + borderWidth + "px; -fx-border-radius: 50em; -fx-background-radius: 50em; -fx-border-color: lightgray; -fx-background-border: none; -fx-effect: dropshadow(gaussian, rgba(0,0,0,0.3), 10, 0.0, 0, 4);");
        } else {
            this.contentBox.setStyle("-fx-background-color: " + this.formBgColor + "; -fx-background-radius: 20px; -fx-border-radius: 20px; -fx-text-fill: black; -fx-font-size: 15pt; -fx-font-weight: bold; -fx-border-width: " + borderWidth + "px; -fx-background-radius: 20px; -fx-border-radius: 20px; -fx-border-color: lightgray; -fx-background-border: none; -fx-effect: dropshadow(gaussian, rgba(0,0,0,0.3), 10, 0.0, 0, 4);");
        }
        this.rightDash.setStyle("-fx-background-color: " + this.dashBgColor + ";");
    }

    public void setMenuStepperCircleBox(boolean selected) {
        this.getChildren().clear();
        double relativeWidth = selected ? 160.0 : 80.0;
        double dashWidth = (this.width - relativeWidth) / 2.0;
        double dashHeight = 10.0;
        if (this.startOrEnd == -1 || this.startOrEnd == 1) {
            dashWidth *= 2.0;
        }
        HBox hbox = new HBox();
        hbox.setPadding(Insets.EMPTY);
        hbox.setPrefHeight(80.0);
        hbox.setStyle("-fx-background-color: transparent;");
        hbox.setMinWidth(this.width);
        hbox.setMaxWidth(this.width);
        if (this.startOrEnd != -1 && this.startOrEnd != 0) {
            this.leftDash.setMinHeight(dashHeight);
            this.leftDash.setMaxHeight(dashHeight);
            this.leftDash.setMinWidth(dashWidth);
            this.leftDash.setMaxWidth(dashWidth);
            hbox.getChildren().add((Object)this.leftDash);
        }
        this.contentBox.setText(selected ? this.content.toUpperCase() : String.valueOf(this.index));
        this.contentBox.setWrapText(true);
        this.contentBox.setPrefWidth(relativeWidth);
        this.contentBox.setPrefHeight(80.0);
        this.contentBox.setAlignment(Pos.CENTER);
        hbox.getChildren().add((Object)this.contentBox);
        if (this.startOrEnd != 1 && this.startOrEnd != 0) {
            this.rightDash.setMinHeight(dashHeight);
            this.rightDash.setMaxHeight(dashHeight);
            this.rightDash.setMinWidth(dashWidth);
            this.rightDash.setMaxWidth(dashWidth);
            hbox.getChildren().add((Object)this.rightDash);
        }
        this.getChildren().add((Object)hbox);
        switch (this.startOrEnd) {
            case -1: {
                hbox.setAlignment(Pos.CENTER_LEFT);
                this.setAlignment(Pos.CENTER_LEFT);
                break;
            }
            case 1: {
                hbox.setAlignment(Pos.CENTER_RIGHT);
                this.setAlignment(Pos.CENTER_RIGHT);
                break;
            }
            default: {
                hbox.setAlignment(Pos.CENTER);
                this.setAlignment(Pos.CENTER);
            }
        }
    }
}

