/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.components;

import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.CarteOrderInfo;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.ticket.SupplementProduct;
import com.openbravo.pos.util.ColorUtils;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow;

public class DriveGroupOptionsHeaderButton
extends VBox {
    private SupplementProduct groupOption;
    private int index;
    private String formBgColor;
    private String leftDashBgColor;
    private String rightDashBgColor;
    private HBox leftDash;
    private HBox rightDash;
    private Label contentBox;
    private final double circleDefaultWidth = 80.0;
    private final double circleDefaultHeight = 80.0;
    private double width = 400.0;
    private double height = 80.0;
    private int startOrEnd;
    private CarteOrderInfo groupProducts;
    private ProductInfoExt product;

    public DriveGroupOptionsHeaderButton() {
        this.init();
    }

    public DriveGroupOptionsHeaderButton(CarteOrderInfo groupProducts, ProductInfoExt product, SupplementProduct groupOption, double width, double height, int index) {
        this.groupProducts = groupProducts;
        this.product = product;
        this.width = width;
        this.height = height;
        this.groupOption = groupOption;
        this.index = index;
        this.init();
    }

    private void init() {
        this.setPadding(Insets.EMPTY);
        this.setPrefHeight(this.height);
        this.setPrefWidth(this.width);
        this.setStyle("-fx-background-color: transparent;");
        this.leftDashBgColor = "lightgray";
        this.leftDashBgColor = "lightgray";
        this.formBgColor = "white";
        this.leftDash = new HBox();
        this.rightDash = new HBox();
        this.contentBox = new Label();
    }

    public SupplementProduct getGroupOption() {
        return this.groupOption;
    }

    public void setGroupOption(SupplementProduct groupOption) {
        this.groupOption = groupOption;
    }

    public CarteOrderInfo getGroupProducts() {
        return this.groupProducts;
    }

    public void setGroupProducts(CarteOrderInfo groupProducts) {
        this.groupProducts = groupProducts;
    }

    public ProductInfoExt getProduct() {
        return this.product;
    }

    public void setProduct(ProductInfoExt product) {
        this.product = product;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void deselect(int currentButtonIndex) {
        if (this.index < currentButtonIndex) {
            if (this.startOrEnd != 0) {
                if (this.startOrEnd != -1) {
                    this.leftDashBgColor = ColorUtils.getColor(AppLocal.color_borne);
                }
                if (this.startOrEnd != 1) {
                    this.rightDashBgColor = ColorUtils.getColor(AppLocal.color_borne);
                }
            }
            this.formBgColor = ColorUtils.getColor(AppLocal.color_borne);
        } else {
            if (this.startOrEnd != 0) {
                if (this.startOrEnd != -1) {
                    this.leftDashBgColor = "lightgray";
                }
                if (this.startOrEnd != 1) {
                    this.rightDashBgColor = "lightgray";
                }
            }
            this.formBgColor = "white";
        }
        this.setStyles();
    }

    public void select() {
        if (this.startOrEnd != 0) {
            if (this.startOrEnd != -1) {
                this.leftDashBgColor = ColorUtils.getColor(AppLocal.color_borne);
            }
            if (this.startOrEnd != 1) {
                this.rightDashBgColor = ColorUtils.getColor(AppLocal.color_borne);
            }
        }
        this.formBgColor = ColorUtils.getColor(AppLocal.color_borne);
        this.setStyles();
    }

    public void setView(int startOrEnd) {
        this.startOrEnd = startOrEnd;
        if (startOrEnd == 0) {
            this.leftDashBgColor = "transparent";
            this.rightDashBgColor = "transparent";
        } else {
            if (startOrEnd == -1) {
                this.leftDashBgColor = "transparent";
            }
            if (startOrEnd == 1) {
                this.rightDashBgColor = "transparent";
            }
        }
        this.setCircleBox();
    }

    public void setCircleBox() {
        double dashWidth = (this.width - 80.0) / 2.0;
        double dashHeight = 10.0;
        HBox hbox = new HBox();
        hbox.setPadding(Insets.EMPTY);
        hbox.setPrefHeight(80.0);
        hbox.setStyle("-fx-background-color: transparent;");
        hbox.setAlignment(Pos.CENTER);
        hbox.setMinWidth(this.width);
        hbox.setPrefWidth(this.width);
        hbox.setMaxWidth(this.width);
        this.leftDash.setMinHeight(dashHeight);
        this.leftDash.setMaxHeight(dashHeight);
        this.leftDash.setMinWidth(dashWidth);
        this.leftDash.setMaxWidth(dashWidth);
        hbox.getChildren().add((Object)this.leftDash);
        this.contentBox.setText(String.valueOf(this.index + 1));
        this.contentBox.setPrefWidth(80.0);
        this.contentBox.setPrefHeight(80.0);
        this.contentBox.setMinHeight(80.0);
        this.contentBox.setMaxHeight(80.0);
        this.contentBox.setAlignment(Pos.CENTER);
        hbox.getChildren().add((Object)this.contentBox);
        Label contentLabel = new Label(this.groupOption.getName());
        contentLabel.setStyle("-fx-background-color: transparent; -fx-font-weight: bold; -fx-text-fill: black;  -fx-font-size: 15pt; -fx-padding: 4 0 4 0;");
        contentLabel.setWrapText(true);
        contentLabel.setMaxWidth(144.0);
        TextFlow flow = new TextFlow(new Node[]{contentLabel});
        flow.setTextAlignment(TextAlignment.CENTER);
        HBox hbox2 = new HBox(new Node[]{flow});
        hbox2.setMinWidth(this.width);
        hbox2.setMaxWidth(this.width);
        this.getChildren().add((Object)hbox);
        this.getChildren().add((Object)hbox2);
        this.rightDash.setMinHeight(dashHeight);
        this.rightDash.setMaxHeight(dashHeight);
        this.rightDash.setMinWidth(dashWidth);
        this.rightDash.setMaxWidth(dashWidth);
        hbox.getChildren().add((Object)this.rightDash);
        hbox.setAlignment(Pos.CENTER);
        hbox2.setAlignment(Pos.CENTER);
        this.setAlignment(Pos.TOP_CENTER);
    }

    public void setStyles() {
        this.leftDash.setStyle("-fx-background-color:" + this.leftDashBgColor + ";");
        double borderWidth = this.formBgColor.equals("white") ? 1.0 : 0.0;
        this.contentBox.setStyle("-fx-background-color: " + this.formBgColor + "; -fx-text-fill: black; -fx-font-size: 20pt; -fx-font-weight: bold; -fx-border-width: " + borderWidth + "px; -fx-border-radius: 50em; -fx-background-radius: 50em; -fx-border-color: lightgray; -fx-effect: dropshadow(gaussian, rgba(0,0,0,0.3), 10, 0.0, 0, 4);");
        this.rightDash.setStyle("-fx-background-color: " + this.rightDashBgColor + ";");
    }
}

