/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.components;

import com.openbravo.pos.util.NumericUtils;
import java.util.Iterator;
import java.util.stream.Stream;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.chart.PieChart;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.text.Text;

public class DoughnutChart
extends PieChart {
    private final Circle innerCircle;
    private boolean show_values = false;

    public DoughnutChart(ObservableList<PieChart.Data> pieData) {
        super(pieData);
        this.innerCircle = new Circle();
        this.innerCircle.setFill((Paint)Color.WHITESMOKE);
        this.innerCircle.setStroke((Paint)Color.WHITE);
        this.innerCircle.setStrokeWidth(3.0);
    }

    public DoughnutChart(ObservableList<PieChart.Data> pieData, boolean show_values) {
        super(pieData);
        this.show_values = show_values;
        this.innerCircle = new Circle();
        this.innerCircle.setFill((Paint)Color.WHITESMOKE);
        this.innerCircle.setStroke((Paint)Color.WHITE);
        this.innerCircle.setStrokeWidth(3.0);
    }

    protected void layoutChartChildren(double top, double left, double contentWidth, double contentHeight) {
        if (this.show_values) {
            ObservableList d = this.getData();
            for (PieChart.Data next : d) {
                Stream ns = this.lookupAll(".chart-pie-label").stream();
                Iterator iterator1 = ns.iterator();
                while (iterator1.hasNext()) {
                    Node n = (Node)iterator1.next();
                    if (!(n instanceof Text) || !((Text)n).getText().contains(next.getName())) continue;
                    ((Text)n).setText(next.getName() + " " + NumericUtils.formatToString(next.getPieValue()) + " ");
                }
            }
        }
        super.layoutChartChildren(top, left, contentWidth, contentHeight);
        this.addInnerCircleIfNotPresent();
        this.updateInnerCircleLayout();
    }

    private void addInnerCircleIfNotPresent() {
        Pane parent;
        Node pie;
        if (this.getData().size() > 0 && (pie = ((PieChart.Data)this.getData().get(0)).getNode()).getParent() instanceof Pane && !(parent = (Pane)pie.getParent()).getChildren().contains((Object)this.innerCircle)) {
            parent.getChildren().add((Object)this.innerCircle);
        }
    }

    private void updateInnerCircleLayout() {
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double maxY = Double.MIN_VALUE;
        for (PieChart.Data data : this.getData()) {
            Node node = data.getNode();
            Bounds bounds = node.getBoundsInParent();
            if (bounds.getMinX() < minX) {
                minX = bounds.getMinX();
            }
            if (bounds.getMinY() < minY) {
                minY = bounds.getMinY();
            }
            if (bounds.getMaxX() > maxX) {
                maxX = bounds.getMaxX();
            }
            if (!(bounds.getMaxY() > maxY)) continue;
            maxY = bounds.getMaxY();
        }
        this.innerCircle.setCenterX(minX + (maxX - minX) / 2.0);
        this.innerCircle.setCenterY(minY + (maxY - minY) / 2.0);
        this.innerCircle.setRadius((maxX - minX) / 4.0);
    }
}

