/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.components;

import com.openbravo.components.DiscountButton;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.util.LogToFile;
import fr.protactile.procaisse.dao.entities.ReductionInfo;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.stage.Popup;

public class DiscountsProductPopUp
extends Popup {
    private double height;
    private double width;
    private GridPane mainPane;
    private String style = "-fx-background-color: #FFF; -fx-background-radius: 12px;";
    private String styleTitle = " -fx-font-size: 18px;";
    private List<ReductionInfo> reductions;
    private ReductionInfo reduction;
    private GridPane discountsPane;
    private int MAX_DISCOUNT;
    private HashMap<Integer, LinkedHashMap<Integer, DiscountButton>> map_discounts;
    private LinkedHashMap<Integer, DiscountButton> discountsButtons;
    private int numberPageDiscount;
    private Button nextDiscountButton;
    private Button previousDiscountButton;
    private int page_Discount;
    private int NUMBER_COLUMN_DISCOUNT = 4;
    private int NUMBER_ROW_DISCOUNT = 3;
    private int MAX_DISCOUNT_PER_PAGE = 12;
    private Image imagePrevious;
    private Image imageNext;
    private Label titlePane;
    private EventHandler mEventHandlerReductionAction = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            DiscountButton mButtonSource = (DiscountButton)((Object)event.getSource());
            if (mButtonSource != null && mButtonSource.getReduction() != null) {
                DiscountsProductPopUp.this.reduction = mButtonSource.getReduction();
                DiscountsProductPopUp.this.hide();
            }
        }
    };
    private EventHandler mEventHandlerNextProductFamilleAction = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            DiscountsProductPopUp.this.nextDiscounts();
        }
    };
    private EventHandler mEventHandlerPreviousProductFamilleAction = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            DiscountsProductPopUp.this.previousComments();
        }
    };

    public DiscountsProductPopUp(double height, double width, List<ReductionInfo> reductions) {
        try {
            this.reductions = reductions;
            this.reduction = this.reduction;
            this.height = height;
            this.width = width;
            this.imagePrevious = new Image(((Object)((Object)this)).getClass().getResource("/com/openbravo/images/previous_item_product.png").toURI().toString(), 20.0, 20.0, false, false);
            this.imageNext = new Image(((Object)((Object)this)).getClass().getResource("/com/openbravo/images/next_item_product.png").toURI().toString(), 20.0, 20.0, false, false);
            this.mainPane = new GridPane();
            this.mainPane.setVgap(10.0);
            this.mainPane.setHgap(10.0);
            this.mainPane.setAlignment(Pos.CENTER);
            this.mainPane.setPrefHeight(height);
            this.mainPane.setPrefWidth(width);
            this.mainPane.setStyle(this.style);
            if (this.titlePane == null) {
                this.titlePane = new Label();
                this.titlePane.setAlignment(Pos.CENTER);
                this.titlePane.setPrefHeight(height * 0.15);
                this.titlePane.setPrefWidth(width);
                this.titlePane.setStyle(this.styleTitle);
                this.titlePane.setText(AppLocal.getIntString("Text.my.discounts"));
            }
            if (this.discountsPane == null) {
                this.discountsPane = new GridPane();
                this.discountsPane.setAlignment(Pos.CENTER);
                this.discountsPane.setVgap(10.0);
                this.discountsPane.setHgap(10.0);
            }
            this.mainPane.add((Node)this.titlePane, 0, 0);
            this.mainPane.add((Node)this.discountsPane, 0, 1);
            this.mainPane.setOnMouseClicked(event -> this.hide());
            this.getContent().add((Object)this.mainPane);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public ReductionInfo getReduction() {
        return this.reduction;
    }

    public void setReduction(ReductionInfo reduction) {
        this.reduction = reduction;
    }

    public void buildDiscountPane() {
        this.discountsPane.getChildren().clear();
        if (this.map_discounts == null) {
            this.map_discounts = new HashMap();
        }
        this.map_discounts.clear();
        double padding = 50.0;
        double heightDiscountPane = this.height * 0.85 - padding;
        double widthDiscountPane = this.width - padding;
        double widthDiscount = widthDiscountPane / (double)this.NUMBER_COLUMN_DISCOUNT;
        double heightDiscount = heightDiscountPane / (double)this.NUMBER_ROW_DISCOUNT;
        int index = 0;
        int index_map = 0;
        this.discountsButtons = new LinkedHashMap();
        this.numberPageDiscount = (int)Math.ceil((double)this.reductions.size() / (double)this.MAX_DISCOUNT_PER_PAGE);
        this.MAX_DISCOUNT = this.numberPageDiscount > 1 ? this.MAX_DISCOUNT_PER_PAGE - 1 : this.reductions.size();
        for (ReductionInfo reductionInfo : this.reductions) {
            DiscountButton discountButton = new DiscountButton(reductionInfo, widthDiscount, heightDiscount);
            boolean selected = this.selected(reductionInfo);
            discountButton.select(selected);
            discountButton.setOnAction(this.mEventHandlerReductionAction);
            if (index < this.MAX_DISCOUNT) {
                this.discountsButtons.put(reductionInfo.getId(), discountButton);
            } else {
                this.map_discounts.put(index_map, this.discountsButtons);
                this.discountsButtons = new LinkedHashMap();
                this.discountsButtons.put(reductionInfo.getId(), discountButton);
                ++index_map;
                index = 0;
            }
            ++index;
        }
        if (this.discountsButtons != null && !this.discountsButtons.isEmpty()) {
            this.map_discounts.put(index_map, this.discountsButtons);
        }
        int column = 0;
        int row = 0;
        for (int i = 0; i < this.MAX_DISCOUNT; ++i) {
            GridPane productFamillePane = new GridPane();
            productFamillePane.setPrefHeight(heightDiscount);
            productFamillePane.setPrefWidth(widthDiscount);
            this.discountsPane.add((Node)productFamillePane, column, row);
            if (column < this.NUMBER_COLUMN_DISCOUNT - 1) {
                ++column;
                continue;
            }
            column = 0;
            ++row;
        }
        if (this.numberPageDiscount > 1) {
            GridPane nextPreviousPane = new GridPane();
            nextPreviousPane.setAlignment(Pos.CENTER);
            nextPreviousPane.setVgap(5.0);
            nextPreviousPane.setHgap(5.0);
            nextPreviousPane.setPrefHeight(heightDiscount);
            nextPreviousPane.setPrefWidth(widthDiscount);
            nextPreviousPane.getStyleClass().add((Object)"bg_white_opacity20");
            nextPreviousPane.getStyleClass().add((Object)"border_radius_12px");
            nextPreviousPane.getStyleClass().add((Object)"bg_radius_12px");
            nextPreviousPane.getStyleClass().add((Object)"border_white_opacity12");
            this.nextDiscountButton = new Button();
            this.nextDiscountButton.getStyleClass().add((Object)"border_radius_14px");
            this.nextDiscountButton.getStyleClass().add((Object)"bg_radius_14px");
            this.nextDiscountButton.getStyleClass().add((Object)"bg_white_opacity18");
            this.nextDiscountButton.setPrefHeight(nextPreviousPane.getPrefHeight() * 0.8);
            this.nextDiscountButton.setPrefWidth(nextPreviousPane.getPrefWidth() * 0.45);
            this.nextDiscountButton.setGraphic((Node)new ImageView(this.imageNext));
            this.nextDiscountButton.setOnAction(this.mEventHandlerNextProductFamilleAction);
            this.previousDiscountButton = new Button();
            this.previousDiscountButton.getStyleClass().add((Object)"border_radius_14px");
            this.previousDiscountButton.getStyleClass().add((Object)"bg_radius_14px");
            this.previousDiscountButton.getStyleClass().add((Object)"bg_white_opacity18");
            this.previousDiscountButton.setPrefHeight(nextPreviousPane.getPrefHeight() * 0.8);
            this.previousDiscountButton.setPrefWidth(nextPreviousPane.getPrefWidth() * 0.45);
            this.previousDiscountButton.setGraphic((Node)new ImageView(this.imagePrevious));
            this.previousDiscountButton.setOnAction(this.mEventHandlerPreviousProductFamilleAction);
            nextPreviousPane.add((Node)this.previousDiscountButton, 0, 0);
            nextPreviousPane.add((Node)this.nextDiscountButton, 1, 0);
            this.discountsPane.add((Node)nextPreviousPane, column, row);
            this.previousDiscountButton.setDisable(true);
        }
        this.page_Discount = 0;
        this.loadPageDiscount(this.page_Discount);
    }

    public void nextDiscounts() {
        if (this.page_Discount < this.numberPageDiscount - 1) {
            ++this.page_Discount;
            this.loadPageDiscount(this.page_Discount);
            if (this.page_Discount == this.numberPageDiscount - 1) {
                this.nextDiscountButton.setDisable(true);
            }
            this.previousDiscountButton.setDisable(false);
        }
    }

    public void previousComments() {
        if (this.page_Discount > 0) {
            --this.page_Discount;
            this.loadPageDiscount(this.page_Discount);
            if (this.page_Discount == 0) {
                this.previousDiscountButton.setDisable(true);
            }
            this.nextDiscountButton.setDisable(false);
        }
    }

    private void loadPageDiscount(int page_discount) {
        LinkedHashMap<Integer, DiscountButton> mapDiscountButton = this.map_discounts.get(page_discount);
        List discountsButton = mapDiscountButton.values().stream().collect(Collectors.toList());
        int numberDiscount = mapDiscountButton.size();
        int index = 0;
        for (Node node : this.discountsPane.getChildren()) {
            if (index >= this.MAX_DISCOUNT) break;
            if (node instanceof GridPane) {
                GridPane discountPane = (GridPane)node;
                discountPane.getChildren().clear();
                if (index < numberDiscount) {
                    discountPane.add((Node)discountsButton.get(index), 0, 0);
                }
            }
            ++index;
        }
    }

    private boolean selected(ReductionInfo reductionInfo) {
        return this.reduction != null && this.reduction.getReduction() != 0.0 && this.reduction.getReduction() == reductionInfo.getReduction() && this.reduction.getType() != null && this.reduction.getType().equalsIgnoreCase(reductionInfo.getType()) && this.reduction.getName() != null && this.reduction.getName().equalsIgnoreCase(reductionInfo.getName());
    }
}

