/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.components;

import fr.protactile.procaisse.dao.entities.ReductionInfo;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.layout.GridPane;
import javafx.scene.paint.Color;

public class DiscountButton
extends Button {
    private double height = 0.0;
    private double width = 0.0;
    private ReductionInfo reduction;
    private GridPane paneDiscount;
    private GridPane discountValuePane;
    private Label discountValueLabel;
    private Label discountNameLabel;
    private String styleDiscount = "-fx-text-fill: white; -fx-font-size: 18px;-fx-background-color: #008CAA; -fx-background-radius: 12px;";
    private String style = "-fx-background-radius: 12px; -fx-border-radius: 12px; -fx-border-color: rgba(255, 255, 255, 0.22); -fx-border-width: 1px;  -fx-background-color: rgba(255, 255, 255, 0.11);  -fx-effect: dropshadow(gaussian, rgba(0, 0, 0, 0.12), 14.5, 0, 0, 0);";
    private String styleDiscountName = "-fx-text-fill: #000000; -fx-font-size: 18px;";
    private String styleDiscountNameSelected = "-fx-text-fill: #FFFFFF; -fx-font-size: 18px;";

    public DiscountButton(ReductionInfo reduction, double width, double height) {
        this.width = width;
        this.height = height;
        this.reduction = reduction;
        this.setPrefHeight(height);
        this.setPrefWidth(width);
        this.paneDiscount = new GridPane();
        this.paneDiscount.setPrefHeight(height);
        this.paneDiscount.setPrefWidth(width);
        this.discountValuePane = new GridPane();
        this.discountValuePane.setAlignment(Pos.CENTER);
        this.discountValuePane.setPrefHeight(height * 0.6);
        this.discountValuePane.setPrefWidth(width);
        this.discountValueLabel = new Label();
        this.discountValueLabel.setAlignment(Pos.CENTER);
        this.discountValueLabel.setText(reduction.getDiscountValue());
        this.discountValueLabel.setStyle(this.styleDiscount);
        this.discountValueLabel.setPrefHeight(this.discountValuePane.getPrefHeight() * 0.9);
        this.discountValueLabel.setPrefWidth(this.discountValuePane.getPrefWidth() * 0.5);
        this.discountNameLabel = new Label();
        this.discountNameLabel.setAlignment(Pos.CENTER);
        this.discountNameLabel.setText(reduction.getName());
        this.discountNameLabel.setPrefHeight(height * 0.4);
        this.discountNameLabel.setPrefWidth(width);
        this.discountValuePane.add((Node)this.discountValueLabel, 0, 0);
        this.paneDiscount.add((Node)this.discountValuePane, 0, 0);
        this.paneDiscount.add((Node)this.discountNameLabel, 0, 1);
        DropShadow dropShadow = new DropShadow();
        dropShadow.setRadius(14.5);
        dropShadow.setSpread(0.0);
        dropShadow.setOffsetX(0.0);
        dropShadow.setOffsetY(0.0);
        dropShadow.setColor(Color.rgb((int)0, (int)0, (int)0, (double)0.12));
        this.paneDiscount.setEffect((Effect)dropShadow);
        this.setGraphic((Node)this.paneDiscount);
        this.setStyle("-fx-background-color:  transparent;");
    }

    public ReductionInfo getReduction() {
        return this.reduction;
    }

    public void setReduction(ReductionInfo reduction) {
        this.reduction = reduction;
    }

    public void select(boolean selected) {
        if (selected) {
            this.paneDiscount.setStyle("-fx-background-color:  #008CAA; -fx-background-radius: 12px");
            this.discountNameLabel.setStyle(this.styleDiscountNameSelected);
        } else {
            this.paneDiscount.setStyle("-fx-background-color:  white; -fx-background-radius: 12px");
            this.discountNameLabel.setStyle(this.styleDiscountName);
        }
    }
}

