/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.components;

import com.openbravo.components.CommentButton;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.util.LogToFile;
import fr.protactile.procaisse.dao.entities.CommentInfo;
import fr.protactile.procaisse.services.CommentService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import javafx.animation.PauseTransition;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.util.Duration;

public class CommentsProductPopUp
extends Stage {
    private final PauseTransition pauseTransition = new PauseTransition(Duration.seconds((double)1.0));
    private double height;
    private double width;
    private GridPane mainPane;
    private String style = "-fx-background-color: #2D5F48; -fx-background-radius: 12px;";
    private String styleSaveComment = "-fx-background-color: #34A04F; -fx-background-radius: 6px;";
    private String styleComment = "-fx-background-color: #FFF; -fx-background-radius: 9px;";
    private String styleText = "-fx-text-fill: #FFFFFF; -fx-font-size: 12px;";
    private String styleValidButton = "-fx-text-fill: #FFFFFF; -fx-font-size: 16px; -fx-background-color: #34A04F;-fx-background-radius: 6px;";
    private CommentService commentService;
    private List<CommentInfo> comments;
    private CommentInfo commentInfo;
    private String commentText;
    private GridPane commentsPane;
    private int MAX_COMMENT;
    private HashMap<Integer, LinkedHashMap<Integer, CommentButton>> map_comments;
    private LinkedHashMap<Integer, CommentButton> commentsButtons;
    private int numberPageComment;
    private Button nextCommentButton;
    private Button previousCommentButton;
    private int page_comment;
    private int NUMBER_COLUMN_COMMENT = 6;
    private int NUMBER_ROW_COMMENT = 3;
    private int MAX_COMMENT_PER_PAGE = 18;
    private Image imagePrevious;
    private Image imageNext;
    private GridPane titlePane;
    private Label titleLabel;
    private Button closeButton;
    private GridPane commentPane;
    private TextField commentTextArea;
    private GridPane saveCommentPane;
    private Button saveCommentButton;
    private Label saveCommentText;
    private Label saveCommentImage;
    private Image saveImage;
    private GridPane keyboardPane;
    private Button validButton;
    private boolean isShiftActive = false;
    private List<Button> letterButtons = new ArrayList<Button>();
    private double widthComment;
    private double heightComment;
    private GridPane validPane;
    private CommentButton commentButtonToDelete;
    private EventHandler mEventHandlerCommentAction = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            CommentButton mButtonSource = (CommentButton)((Object)event.getSource());
            if (mButtonSource != null && mButtonSource.getComment() != null) {
                CommentsProductPopUp.this.commentInfo = mButtonSource.getComment();
                CommentsProductPopUp.this.commentTextArea.setText(mButtonSource.getComment().getComment());
            }
        }
    };
    private EventHandler mEventHandlerNextProductFamilleAction = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            CommentsProductPopUp.this.nextComments();
        }
    };
    private EventHandler mEventHandlerPreviousProductFamilleAction = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            CommentsProductPopUp.this.previousComments();
        }
    };
    private EventHandler mEventHandlerCloseAction = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            CommentsProductPopUp.this.hide();
        }
    };
    private EventHandler mEventHandlerDeleteCommentAction = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            CommentButton commentButton = CommentsProductPopUp.this.commentButtonToDelete;
            if (commentButton != null && commentButton.getComment() != null) {
                CommentsProductPopUp.this.commentService.delete(commentButton.getComment());
                CommentsProductPopUp.this.commentTextArea.setText("");
                CommentsProductPopUp.this.buildListCommentsPane();
                CommentsProductPopUp.this.commentButtonToDelete = null;
            }
        }
    };
    private EventHandler mEventHandlerFinishPauseTransition = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            CommentButton mButtonSource = (CommentButton)((Object)event.getSource());
            if (mButtonSource != null) {
                CommentsProductPopUp.this.commentButtonToDelete = mButtonSource;
                CommentsProductPopUp.this.pauseTransition.stop();
            }
        }
    };
    private EventHandler mEventHandlerAddCommentAction = event -> {
        this.addComment();
        this.validComment();
    };
    private EventHandler mEventHandlerValidAction = event -> this.validComment();

    public CommentsProductPopUp(double height, double width, String comment) {
        try {
            this.height = height;
            this.width = width;
            this.commentText = comment;
            this.imagePrevious = new Image(((Object)((Object)this)).getClass().getResource("/com/openbravo/images/previous_item_product.png").toURI().toString(), 20.0, 20.0, false, false);
            this.imageNext = new Image(((Object)((Object)this)).getClass().getResource("/com/openbravo/images/next_item_product.png").toURI().toString(), 20.0, 20.0, false, false);
            this.saveImage = new Image(((Object)((Object)this)).getClass().getResource("/com/openbravo/images/save.png").toURI().toString(), 20.0, 20.0, false, false);
            this.mainPane = new GridPane();
            this.mainPane.setVgap(5.0);
            this.mainPane.setHgap(5.0);
            this.mainPane.setAlignment(Pos.CENTER);
            this.mainPane.setPrefHeight(height);
            this.mainPane.setPrefWidth(width);
            this.mainPane.setStyle(this.style);
            this.commentService = CommentService.getInstance();
            this.buildTitlePane();
            this.buildCommentPane();
            if (this.commentsPane == null) {
                this.commentsPane = new GridPane();
                this.commentsPane.setAlignment(Pos.CENTER);
                this.commentsPane.setVgap(5.0);
                this.commentsPane.setHgap(5.0);
                this.commentsPane.setPrefHeight(height * 0.26);
                this.commentsPane.setPrefWidth(width * 0.95);
            }
            this.mainPane.add((Node)this.commentsPane, 0, 2);
            this.buildkeyboardPane();
            this.buildValidButton();
            this.pauseTransition.setOnFinished(this.mEventHandlerDeleteCommentAction);
            Scene scene = new Scene((Parent)this.mainPane, width, height);
            this.setScene(scene);
            this.getScene().setFill((Paint)Color.TRANSPARENT);
            this.setAlwaysOnTop(true);
            this.initModality(Modality.APPLICATION_MODAL);
            this.initStyle(StageStyle.TRANSPARENT);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void buildListCommentsPane() {
        this.commentInfo = null;
        this.comments = this.commentService.getComments();
        this.commentsPane.getChildren().clear();
        if (this.map_comments == null) {
            this.map_comments = new HashMap();
        }
        this.map_comments.clear();
        double padding = 30.0;
        double heightCommentPane = this.commentsPane.getPrefHeight() - padding;
        double widthCommentPane = this.commentsPane.getPrefWidth() - padding;
        this.widthComment = widthCommentPane / (double)this.NUMBER_COLUMN_COMMENT;
        this.heightComment = heightCommentPane / (double)this.NUMBER_ROW_COMMENT;
        int index = 0;
        int index_map = 0;
        this.commentsButtons = new LinkedHashMap();
        this.numberPageComment = (int)Math.ceil((double)this.comments.size() / (double)this.MAX_COMMENT_PER_PAGE);
        this.MAX_COMMENT = this.numberPageComment > 1 ? this.MAX_COMMENT_PER_PAGE - 1 : this.MAX_COMMENT_PER_PAGE;
        for (CommentInfo commentInfo : this.comments) {
            CommentButton commentButton = new CommentButton(commentInfo, this.widthComment, this.heightComment);
            commentButton.setOnAction(this.mEventHandlerCommentAction);
            commentButton.setOnMousePressed(e -> this.pauseTransition.play());
            commentButton.setOnMouseReleased(this.mEventHandlerFinishPauseTransition);
            if (index < this.MAX_COMMENT) {
                this.commentsButtons.put(commentInfo.getId(), commentButton);
            } else {
                this.map_comments.put(index_map, this.commentsButtons);
                this.commentsButtons = new LinkedHashMap();
                this.commentsButtons.put(commentInfo.getId(), commentButton);
                ++index_map;
                index = 0;
            }
            ++index;
        }
        if (this.commentsButtons != null && !this.commentsButtons.isEmpty()) {
            this.map_comments.put(index_map, this.commentsButtons);
        }
        int column = 0;
        int row = 0;
        for (int i = 0; i < this.MAX_COMMENT; ++i) {
            GridPane commentPane = new GridPane();
            commentPane.setPrefHeight(this.heightComment);
            commentPane.setPrefWidth(this.widthComment);
            Label emptyCommentLabel = this.emptyCommentLabel();
            commentPane.add((Node)emptyCommentLabel, 0, 0);
            this.commentsPane.add((Node)commentPane, column, row);
            if (column < this.NUMBER_COLUMN_COMMENT - 1) {
                ++column;
                continue;
            }
            column = 0;
            ++row;
        }
        if (this.numberPageComment > 1) {
            GridPane nextPreviousPane = new GridPane();
            nextPreviousPane.setAlignment(Pos.CENTER);
            nextPreviousPane.setVgap(10.0);
            nextPreviousPane.setHgap(10.0);
            nextPreviousPane.setPrefHeight(this.heightComment);
            nextPreviousPane.setPrefWidth(this.widthComment);
            this.nextCommentButton = new Button();
            this.nextCommentButton.getStyleClass().add((Object)"border_white_opacity18");
            this.nextCommentButton.getStyleClass().add((Object)"bg_transparent");
            this.nextCommentButton.setPrefHeight(nextPreviousPane.getPrefHeight() * 0.9);
            this.nextCommentButton.setPrefWidth(nextPreviousPane.getPrefWidth() * 0.45);
            this.nextCommentButton.setGraphic((Node)new ImageView(this.imageNext));
            this.nextCommentButton.setOnAction(this.mEventHandlerNextProductFamilleAction);
            this.previousCommentButton = new Button();
            this.previousCommentButton.getStyleClass().add((Object)"border_white_opacity18");
            this.previousCommentButton.getStyleClass().add((Object)"bg_transparent");
            this.previousCommentButton.setPrefHeight(nextPreviousPane.getPrefHeight() * 0.9);
            this.previousCommentButton.setPrefWidth(nextPreviousPane.getPrefWidth() * 0.45);
            this.previousCommentButton.setGraphic((Node)new ImageView(this.imagePrevious));
            this.previousCommentButton.setOnAction(this.mEventHandlerPreviousProductFamilleAction);
            nextPreviousPane.add((Node)this.previousCommentButton, 0, 0);
            nextPreviousPane.add((Node)this.nextCommentButton, 1, 0);
            this.commentsPane.add((Node)nextPreviousPane, column, row);
            this.previousCommentButton.setDisable(true);
        }
        this.page_comment = 0;
        this.loadPageComment(this.page_comment);
    }

    public void nextComments() {
        if (this.page_comment < this.numberPageComment - 1) {
            ++this.page_comment;
            this.loadPageComment(this.page_comment);
            if (this.page_comment == this.numberPageComment - 1) {
                this.nextCommentButton.setDisable(true);
            }
            this.previousCommentButton.setDisable(false);
        }
    }

    public void previousComments() {
        if (this.page_comment > 0) {
            --this.page_comment;
            this.loadPageComment(this.page_comment);
            if (this.page_comment == 0) {
                this.previousCommentButton.setDisable(true);
            }
            this.nextCommentButton.setDisable(false);
        }
    }

    private void loadPageComment(int page_discount) {
        LinkedHashMap<Integer, CommentButton> mapCommentButton = this.map_comments.get(page_discount);
        if (mapCommentButton != null) {
            List commentsButton = mapCommentButton.values().stream().collect(Collectors.toList());
            int numberDiscount = mapCommentButton.size();
            int index = 0;
            for (Node node : this.commentsPane.getChildren()) {
                if (index >= this.MAX_COMMENT) break;
                if (node instanceof GridPane) {
                    GridPane discountPane = (GridPane)node;
                    discountPane.getChildren().clear();
                    if (index < numberDiscount) {
                        discountPane.add((Node)commentsButton.get(index), 0, 0);
                    } else {
                        discountPane.add((Node)this.emptyCommentLabel(), 0, 0);
                    }
                }
                ++index;
            }
        }
    }

    private void buildTitlePane() {
        this.titlePane = new GridPane();
        this.titleLabel = new Label();
        this.closeButton = new Button();
        this.titlePane.setPrefHeight(this.mainPane.getPrefHeight() * 0.07);
        this.titlePane.setPrefWidth(this.mainPane.getPrefWidth() * 0.95);
        this.titleLabel.setPrefHeight(this.titlePane.getPrefHeight() * 0.9);
        this.titleLabel.setPrefWidth(this.titlePane.getPrefWidth() * 0.8);
        this.titleLabel.setText(AppLocal.getIntString("Text.comment"));
        this.titleLabel.setStyle("-fx-text-fill: #FFFFFF; -fx-font-size: 18px;");
        this.closeButton.setAlignment(Pos.CENTER_RIGHT);
        this.closeButton.setPrefHeight(this.titlePane.getPrefHeight() * 0.9);
        this.closeButton.setPrefWidth(this.titlePane.getPrefWidth() * 0.2);
        this.closeButton.setText("X");
        this.closeButton.setStyle("-fx-background-color:  transparent; -fx-text-fill: #FFFFFF; -fx-font-size: 25px;");
        this.closeButton.setOnAction(this.mEventHandlerCloseAction);
        this.titlePane.add((Node)this.titleLabel, 0, 0);
        this.titlePane.add((Node)this.closeButton, 1, 0);
        this.mainPane.add((Node)this.titlePane, 0, 0);
    }

    public void buildCommentPane() {
        this.commentPane = new GridPane();
        this.commentPane.setAlignment(Pos.CENTER);
        this.commentPane.setStyle(this.styleComment);
        this.commentPane.setPrefHeight(this.mainPane.getPrefHeight() * 0.15);
        this.commentPane.setPrefWidth(this.mainPane.getPrefWidth() * 0.95);
        this.commentTextArea = new TextField();
        this.commentTextArea.setAlignment(Pos.CENTER);
        this.commentTextArea.getStyleClass().clear();
        this.commentTextArea.setStyle("-fx-border-width: 0;  -fx-font-size: 18px; -fx-border-color: transparent;");
        this.commentTextArea.setEffect(null);
        this.commentTextArea.setPromptText("Tapez votre commentaire");
        this.commentTextArea.setPrefHeight(this.commentPane.getPrefHeight() * 0.9);
        this.commentTextArea.setPrefWidth(this.commentPane.getPrefWidth() * 0.95);
        this.commentPane.add((Node)this.commentTextArea, 0, 0);
        this.mainPane.add((Node)this.commentPane, 0, 1);
        if (this.commentText != null && !this.commentText.isEmpty()) {
            this.commentTextArea.setText(this.commentText);
        }
    }

    public void buildkeyboardPane() {
        this.keyboardPane = new GridPane();
        this.keyboardPane.setAlignment(Pos.CENTER);
        this.keyboardPane.setPrefHeight(this.mainPane.getPrefHeight() * 0.33);
        this.keyboardPane.setPrefWidth(this.mainPane.getPrefWidth() * 0.95);
        this.createKeyboard();
        this.mainPane.add((Node)this.keyboardPane, 0, 3);
    }

    public void buildValidButton() {
        this.validPane = new GridPane();
        this.validPane.setHgap(5.0);
        this.validPane.setVgap(5.0);
        this.validPane.setAlignment(Pos.CENTER);
        this.validPane.setPrefHeight(this.mainPane.getPrefHeight() * 0.1);
        this.validPane.setPrefWidth(this.mainPane.getPrefWidth() * 0.95);
        this.validButton = new Button();
        this.validButton.setText("Valider");
        this.validButton.setStyle(this.styleValidButton);
        this.validButton.setPrefHeight(this.validPane.getPrefHeight() * 0.9);
        this.validButton.setPrefWidth(this.validPane.getPrefWidth() * 0.45);
        this.saveCommentButton = new Button();
        this.saveCommentButton.setText("Valider et enregistrer");
        this.saveCommentButton.setOnAction(this.mEventHandlerAddCommentAction);
        this.saveCommentButton.setStyle(this.styleValidButton);
        this.saveCommentButton.setPrefHeight(this.validPane.getPrefHeight() * 0.9);
        this.saveCommentButton.setPrefWidth(this.validPane.getPrefWidth() * 0.45);
        this.validPane.add((Node)this.validButton, 0, 0);
        this.validPane.add((Node)this.saveCommentButton, 1, 0);
        this.mainPane.add((Node)this.validPane, 0, 4);
        this.validButton.setOnAction(this.mEventHandlerValidAction);
    }

    private void createKeyboard() {
        this.keyboardPane.setHgap(10.0);
        this.keyboardPane.setVgap(10.0);
        this.keyboardPane.setAlignment(Pos.CENTER);
        GridPane lettersPane = this.createLetterPanel();
        GridPane specialCharPane = this.createSpecialCharPanel();
        GridPane numberPane = this.createNumberPanel();
        GridPane spacePane = this.createEspacePanel();
        this.keyboardPane.add((Node)lettersPane, 0, 0, 1, 1);
        this.keyboardPane.add((Node)numberPane, 2, 0, 1, 1);
        this.keyboardPane.add((Node)specialCharPane, 1, 0, 1, 1);
        this.keyboardPane.add((Node)spacePane, 0, 1, 2, 1);
    }

    private GridPane createLetterPanel() {
        GridPane grid = new GridPane();
        grid.setHgap(5.0);
        grid.setVgap(5.0);
        grid.setAlignment(Pos.CENTER);
        String[][] letters = new String[][]{{"a", "z", "e", "r", "t", "y", "u", "i", "o", "p"}, {"q", "s", "d", "f", "g", "h", "j", "k", "l", "m"}, {"w", "x", "c", "v", "b", "n"}};
        for (int row = 0; row < letters.length; ++row) {
            for (int col = 0; col < letters[row].length; ++col) {
                Button button = this.createButton(letters[row][col], 50.0, 50.0);
                grid.add((Node)button, col, row);
                this.letterButtons.add(button);
            }
        }
        return grid;
    }

    private GridPane createNumberPanel() {
        GridPane grid = new GridPane();
        grid.setHgap(5.0);
        grid.setVgap(5.0);
        grid.setAlignment(Pos.CENTER);
        String[][] specialChars = new String[][]{{"1", "2", "3", "4", "5", "6"}, {"7", "8", "9", "0", "@", "#"}, {"$", "%", "&", "*", "(", ")"}};
        for (int row = 0; row < specialChars.length; ++row) {
            for (int col = 0; col < specialChars[row].length; ++col) {
                String key = specialChars[row][col];
                Button button = this.createButton(key, 50.0, 50.0);
                grid.add((Node)button, col, row);
            }
        }
        return grid;
    }

    private GridPane createSpecialCharPanel() {
        GridPane grid = new GridPane();
        grid.setHgap(5.0);
        grid.setVgap(5.0);
        grid.setAlignment(Pos.TOP_CENTER);
        String[][] specialChars = new String[][]{{"Shift"}, {"<-"}};
        for (int row = 0; row < specialChars.length; ++row) {
            for (int col = 0; col < specialChars[row].length; ++col) {
                String key = specialChars[row][col];
                Button button = this.createButton(key, 150.0, 50.0);
                grid.add((Node)button, col, row);
            }
        }
        return grid;
    }

    private GridPane createEspacePanel() {
        GridPane grid = new GridPane();
        grid.setAlignment(Pos.CENTER);
        String[][] specialChars = new String[][]{{"Espace"}};
        for (int row = 0; row < specialChars.length; ++row) {
            for (int col = 0; col < specialChars[row].length; ++col) {
                String key = specialChars[row][col];
                Button button = this.createButton(key, 700.0, 50.0);
                grid.add((Node)button, col, row);
            }
        }
        return grid;
    }

    private Button createButton(String key, double width, double height) {
        Button button = new Button(key);
        button.setPrefSize(width, height);
        button.setStyle("-fx-font-weight: bold; -fx-text-fill: #FFFFFF; -fx-font-size: 16px; -fx-background-color: transparent; -fx-border-color: #B0B0B0; -fx-border-radius: 5px;");
        button.setOnAction(e -> this.handleKeyPress(key));
        return button;
    }

    private void handleKeyPress(String key) {
        switch (key) {
            case "<-": {
                String text = this.commentTextArea.getText();
                if (text.isEmpty()) break;
                this.commentTextArea.setText(text.substring(0, text.length() - 1));
                break;
            }
            case "Espace": {
                this.commentTextArea.appendText(" ");
                break;
            }
            case "Shift": {
                this.toggleShift();
                break;
            }
            default: {
                this.commentTextArea.appendText(this.isShiftActive ? key.toUpperCase() : key.toLowerCase());
            }
        }
    }

    private void toggleShift() {
        this.isShiftActive = !this.isShiftActive;
        for (Button button : this.letterButtons) {
            String text = button.getText();
            if (text.length() != 1 || !Character.isLetter(text.charAt(0))) continue;
            button.setText(this.isShiftActive ? text.toUpperCase() : text.toLowerCase());
        }
    }

    private void addComment() {
        if (this.commentTextArea.getText() != null && !this.commentTextArea.getText().isEmpty()) {
            if (this.commentInfo != null) {
                this.commentInfo.setComment(this.commentTextArea.getText());
                this.commentService.update(this.commentInfo);
            } else {
                this.commentInfo = new CommentInfo();
                this.commentInfo.setComment(this.commentTextArea.getText());
                this.commentService.save(this.commentInfo);
            }
            this.buildListCommentsPane();
        }
    }

    public void validComment() {
        this.commentText = this.commentTextArea.getText();
        this.hide();
    }

    public String getCommentText() {
        return this.commentText;
    }

    public void setCommentText(String commentText) {
        this.commentText = commentText;
    }

    private Label emptyCommentLabel() {
        Label emptyCommentLabel = new Label("");
        emptyCommentLabel.setAlignment(Pos.CENTER);
        emptyCommentLabel.setPrefHeight(this.heightComment);
        emptyCommentLabel.setPrefWidth(this.widthComment);
        emptyCommentLabel.setStyle("-fx-text-fill: #FFFFFF; -fx-background-color: transparent; -fx-border-color: #FFF;");
        return emptyCommentLabel;
    }
}

