/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.components;

import com.openbravo.format.Formats;
import com.openbravo.pos.ticket.TicketLineInfo;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;

public class CheckBoxCell
extends GridPane {
    private final TicketLineInfo line;
    private final int indexLine;
    private final Label labelName = new Label();
    private final Label labelPrice = new Label();
    private final CheckBox checkBox = new CheckBox();

    public CheckBoxCell(TicketLineInfo line, int indexLine, boolean checked, double discountOrder, int indexMultiply) {
        boolean paid;
        this.line = line;
        this.indexLine = indexLine;
        this.setAlignment(Pos.CENTER);
        ColumnConstraints checkBoxCol = new ColumnConstraints();
        checkBoxCol.setPercentWidth(6.0);
        ColumnConstraints labelCol = new ColumnConstraints();
        labelCol.setPercentWidth(79.0);
        ColumnConstraints priceCol = new ColumnConstraints();
        priceCol.setPercentWidth(15.0);
        this.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{checkBoxCol, labelCol, priceCol});
        this.checkBox.setSelected(checked);
        this.checkBox.setScaleX(1.6);
        this.checkBox.setScaleY(1.6);
        this.labelName.setText(line.printName());
        this.labelName.setWrapText(true);
        GridPane.setMargin((Node)this.labelName, (Insets)new Insets(0.0, 0.0, 0.0, 12.0));
        if (line.getUnitProduct() != null && line.getUnitProduct().equals("poids")) {
            paid = line.isPaid();
        } else {
            boolean bl = paid = line.getUnits_paid() > (double)indexMultiply;
        }
        if (paid) {
            this.labelName.getStyleClass().add((Object)"text-barre");
        }
        String price = line.getUnitProduct() != null && line.getUnitProduct().equals("poids") ? this.printPrice(line.getPriceByUnit() * line.getMultiply() * (1.0 - discountOrder / 100.0)) : this.printPrice(line.getPriceByUnit() * (1.0 - discountOrder / 100.0));
        this.labelPrice.setText(price);
        if (!paid) {
            this.add((Node)this.checkBox, 0, 0);
            CheckBoxCell.setHalignment((Node)this.checkBox, (HPos)HPos.CENTER);
        }
        this.add((Node)this.labelName, 1, 0);
        this.add((Node)this.labelPrice, 2, 0);
        CheckBoxCell.setHalignment((Node)this.labelPrice, (HPos)HPos.RIGHT);
    }

    private String printPrice(double price) {
        return price != 0.0 ? Formats.CURRENCY.formatValue(price) : "";
    }

    public CheckBox getCheckBox() {
        return this.checkBox;
    }

    public TicketLineInfo getLine() {
        return this.line;
    }

    public int getIndex() {
        return this.indexLine;
    }

    public boolean isChecked() {
        return this.checkBox.isSelected();
    }

    public void setChecked(boolean checked) {
        this.checkBox.setSelected(checked);
    }
}

