/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.components;

import com.openbravo.pos.ticket.CategoryInfo;
import com.openbravo.pos.util.FilerUtils;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.ThumbNailBuilder;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class CategoryButton
extends JButton {
    private FilerUtils m_FilerUtils = FilerUtils.getInstance();
    private ThumbNailBuilder tnbcat = new ThumbNailBuilder(48, 48, "com/openbravo/images/category.png");

    public CategoryButton(CategoryInfo category, boolean sub_category) {
        this.createButton(category, sub_category);
    }

    private void createButton(CategoryInfo category, boolean sub_category) {
        this.setText(category.getName());
        if (sub_category) {
            this.setPreferredSize(new Dimension(160, 60));
        } else {
            this.setPreferredSize(new Dimension(180, 60));
        }
        this.setFocusPainted(false);
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        this.setHorizontalAlignment(0);
        this.setHorizontalTextPosition(4);
        this.setVerticalTextPosition(0);
        this.setContentAreaFilled(true);
        this.setBorderPainted(false);
        this.setOpaque(true);
        this.setRolloverEnabled(true);
        this.setForeground(Color.BLACK);
        if (category.getColor() != null && !category.getColor().isEmpty()) {
            String[] tabColor = category.getColor().split(",");
            this.setBackground(new Color(Integer.parseInt(tabColor[0]), Integer.parseInt(tabColor[1]), Integer.parseInt(tabColor[2])));
        } else {
            this.setBackground(new Color(129, 207, 224));
        }
        this.setMargin(new Insets(2, 2, 2, 2));
        String resized_path = null;
        if (category.getPath() != null && !category.getPath().isEmpty()) {
            String name = category.getPath().replaceFirst("[.][^.]+$", "");
            String ext = category.getPath().substring(category.getPath().lastIndexOf(".") + 1);
            resized_path = name + "_128px." + ext;
        }
        File imageCategory = null;
        if (resized_path != null) {
            imageCategory = this.m_FilerUtils.getFileFullPath("images/catagories/" + resized_path);
        }
        if (imageCategory == null && category.getPath() != null) {
            imageCategory = this.m_FilerUtils.getFileFullPath("images/catagories/" + category.getPath());
        }
        try {
            if (imageCategory != null && imageCategory.exists()) {
                this.setIcon(new ImageIcon(this.tnbcat.getThumbNail(ImageIO.read(imageCategory))));
            }
        }
        catch (IOException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }
}

