/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.cashlogy.services;

import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.printer.PrinterHelper;
import com.openbravo.pos.ticket.MarqueNFC;
import com.openbravo.pos.util.LogToFile;
import java.util.HashMap;
import java.util.Map;

public class ResponseParser {
    public static Map<String, String> parseResponse(String response) {
        String[] fields = response.split("#");
        String[] keys = new String[]{"Code d'erreur", "Total avant BackOffice", "Total apr\u00e8s BackOffice", "Montant ins\u00e9r\u00e9", "Montant sorti", "Montant non rendu", "Montant total consolid\u00e9"};
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        for (int i = 1; i < fields.length; ++i) {
            if (i - 1 >= keys.length) continue;
            fieldMap.put(keys[i - 1], fields[i]);
        }
        return fieldMap;
    }

    public void printTicketBackOffice(String response) {
        try {
            String status = "";
            Map<String, String> parsedFields = ResponseParser.parseResponse(response);
            PrinterHelper mprinter = new PrinterHelper();
            MarqueNFC marqueNF = MarqueNFC.fetchOrStore(AppLocal.dlSales);
            String codeErreur = parsedFields.getOrDefault("Code d'erreur", "0");
            if (codeErreur.equals("0")) {
                status = "Op\u00e9ration r\u00e9ussie";
            } else if (codeErreur.startsWith("WR:LEVEL")) {
                status = "Ex\u00e9cution Ok ,Une pi\u00e8ce ou un billet est hors de sa limite !";
            } else if (codeErreur.startsWith("ER:GENERIC")) {
                status = "Ex\u00e9cution \u00e9chou\u00e9e ,D\u00e9faillance de l'appareil (une erreur de communication ou une erreur dans le rendu) ";
            } else if (codeErreur.startsWith("#ER:BUSY")) {
                status = "Ex\u00e9cution \u00e9chou\u00e9e , Cashlogy Connector est occup\u00e9 !  ";
            }
            double totalAvantBackOffice = this.parseDouble(parsedFields.getOrDefault("Total avant BackOffice", "0"));
            double totalApresBackOffice = this.parseDouble(parsedFields.getOrDefault("Total apr\u00e8s BackOffice", "0"));
            double montantInsere = this.parseDouble(parsedFields.getOrDefault("Montant ins\u00e9r\u00e9", "0"));
            double montantSorti = this.parseDouble(parsedFields.getOrDefault("Montant sorti", "0"));
            double montantNonRendu = this.parseDouble(parsedFields.getOrDefault("Montant non rendu", "0"));
            double montantTotalConsolide = this.parseDouble(parsedFields.getOrDefault("Montant total consolid\u00e9", "0"));
            parsedFields.forEach((key, value) -> System.out.println(key + ": " + value));
            mprinter.printCashlogySummary(marqueNF, status, totalAvantBackOffice, totalApresBackOffice, montantInsere, montantSorti, montantNonRendu, montantTotalConsolide);
        }
        catch (Exception ext) {
            LogToFile.log("severe", null, ext);
        }
    }

    private double parseDouble(String value) {
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }
}

