/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.cashlogy.services;

import com.openbravo.cashlogy.services.CashLogyFCC;
import com.openbravo.cashlogy.services.ResponseParser;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.NumericUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.RoundingMode;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CashLogyServices
implements CashLogyFCC {
    private InputStream input;
    private OutputStream output;
    Socket socket;
    private static CashLogyServices m_instance;
    public static final String ENCAISSEMENT = "encaissement";
    public static final String INITIALIZE_MACHINE = "initialize";
    public static final String CLOSE_MACHINE = "fermer";
    private String operation_type;

    public static CashLogyServices getInstance() {
        if (m_instance == null) {
            m_instance = new CashLogyServices();
        }
        return m_instance;
    }

    public final String CommunicteWithCashLogy(String trame) {
        String response = null;
        try {
            if (AppLocal.MODULE_CASHLOGY_IP != null && !AppLocal.MODULE_CASHLOGY_IP.isEmpty()) {
                this.socket = new Socket();
                this.socket.connect(new InetSocketAddress(AppLocal.MODULE_CASHLOGY_IP, 8092));
                this.input = this.socket.getInputStream();
                this.output = this.socket.getOutputStream();
                this.output.write(trame.getBytes());
                byte[] buffer = new byte[1024];
                int bytesRead = this.input.read(buffer);
                response = new String(buffer, 0, bytesRead);
                System.out.println(" ++++++++++++++++response " + trame + " of  CashlogyConnector" + response);
                this.input.close();
                this.output.close();
                this.socket.close();
            } else {
                System.out.println("+++++++++++++++CashLogyIP is Null");
            }
        }
        catch (IOException ex) {
            Logger.getLogger(CashLogyServices.class.getName()).log(Level.SEVERE, null, ex);
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "\u00c9CHEC DE CONNEXION AVEC LE CASHLOGY", 4000, NPosition.TOP_CENTER_FULL, (int)AppVarUtils.getScreenDimension().getWidth(), 70);
        }
        return response;
    }

    public final void initMachine() {
        this.operation_type = INITIALIZE_MACHINE;
        String respense = this.CommunicteWithCashLogy("#I#");
        if (respense != null && respense.equals("#ER:BUSY#")) {
            new NotifyWindow(NotifyType.WARNING_NOTIFICATION, "Cashlogy Connector est occup\u00e9", 1500, NPosition.CENTER);
        }
    }

    public final void getStatusConnection() {
        this.operation_type = "status";
        String trame = "status\n";
        this.CommunicteWithCashLogy(trame);
    }

    public final void closeMachine() {
        this.operation_type = CLOSE_MACHINE;
        String respense = this.CommunicteWithCashLogy("#E#");
        if (respense != null && respense.equals("#0#")) {
            new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "Le CashLogy est F\u00e9rm\u00e9 .", 4000, NPosition.TOP_CENTER_FULL, (int)AppVarUtils.getScreenDimension().getWidth(), 70);
        }
        if (respense != null && respense.startsWith("#ER:BUSY#")) {
            new NotifyWindow(NotifyType.WARNING_NOTIFICATION, "Cashlogy Connector est occup\u00e9 ", 4000, NPosition.TOP_CENTER_FULL, (int)AppVarUtils.getScreenDimension().getWidth(), 70);
        }
    }

    public final String encaisserCommande(String NumberOrder2, Double total, String keenio) {
        System.out.println("+++++++++++++++Y_POSITION_DUAL_SCREEN" + AppLocal.Y_POSITION_DUAL_SCREEN);
        System.out.println("+++++++++++++++X_POSITION_DUAL_SCREEN" + AppLocal.X_POSITION_DUAL_SCREEN);
        System.out.println("+++++++++++++++PRINTING_DUAL_SCREEN" + AppLocal.PRINTING_DUAL_SCREEN);
        System.out.println("+++++++++++++++DISPLAY_CENTIMES_WINDOWS" + AppLocal.DISPLAY_CENTIMES_WINDOWS);
        System.out.println("+++++++++++++++DISPLAY_ACCEPT_ICON" + AppLocal.DISPLAY_ACCEPT_ICON);
        System.out.println("+++++++++++++++PARTIAL_ENCAISSE_ACCEPTED" + AppLocal.PARTIAL_ENCAISSE_ACCEPTED);
        System.out.println("+++++++++++++++SCREEN_IN_FRONT" + AppLocal.SCREEN_IN_FRONT);
        System.out.println("+++++++++++++++DISPLAY_CENTIMES_WINDOWS" + AppLocal.DISPLAY_CENTIMES_WINDOWS);
        System.out.println("+++++++++++++++DISPLAY_ENCAISSE_BUTTON" + AppLocal.DISPLAY_ENCAISSE_BUTTON);
        this.operation_type = ENCAISSEMENT;
        String TramOrder = "#C#" + NumberOrder2 + "#" + keenio + "#" + String.valueOf((int)NumericUtils.round(total * 100.0)) + "#" + AppLocal.PRINTING_DUAL_SCREEN + "#" + AppLocal.X_POSITION_DUAL_SCREEN + "#" + AppLocal.Y_POSITION_DUAL_SCREEN + "#" + AppLocal.DISPLAY_ACCEPT_ICON + "#" + AppLocal.PARTIAL_ENCAISSE_ACCEPTED + "#" + AppLocal.SCREEN_IN_FRONT + "#" + AppLocal.DISPLAY_CENTIMES_WINDOWS + "#" + AppLocal.DISPLAY_ENCAISSE_BUTTON + "#";
        String respense = this.CommunicteWithCashLogy(TramOrder);
        System.out.println("+++++++++++++++++++++++++++++respense encaisserCommande" + respense);
        return respense;
    }

    public final String encaissePaiment(String NumberOrder2, Double total, String keenio) {
        System.out.println("+++++++++++++++Y_POSITION_DUAL_SCREEN" + AppLocal.Y_POSITION_DUAL_SCREEN);
        System.out.println("+++++++++++++++X_POSITION_DUAL_SCREEN" + AppLocal.X_POSITION_DUAL_SCREEN);
        System.out.println("+++++++++++++++PRINTING_DUAL_SCREEN" + AppLocal.PRINTING_DUAL_SCREEN);
        System.out.println("+++++++++++++++DISPLAY_CENTIMES_WINDOWS" + AppLocal.DISPLAY_CENTIMES_WINDOWS);
        System.out.println("+++++++++++++++DISPLAY_ACCEPT_ICON" + AppLocal.DISPLAY_ACCEPT_ICON);
        System.out.println("+++++++++++++++PARTIAL_ENCAISSE_ACCEPTED" + AppLocal.PARTIAL_ENCAISSE_ACCEPTED);
        System.out.println("+++++++++++++++SCREEN_IN_FRONT" + AppLocal.SCREEN_IN_FRONT);
        System.out.println("+++++++++++++++DISPLAY_CENTIMES_WINDOWS" + AppLocal.DISPLAY_CENTIMES_WINDOWS);
        System.out.println("+++++++++++++++DISPLAY_ENCAISSE_BUTTON" + AppLocal.DISPLAY_ENCAISSE_BUTTON);
        this.operation_type = ENCAISSEMENT;
        String TramOrder = "#C#" + NumberOrder2 + "#" + keenio + "#" + String.valueOf((int)NumericUtils.round(total * 100.0)) + "#" + AppLocal.PRINTING_DUAL_SCREEN + "#" + AppLocal.X_POSITION_DUAL_SCREEN + "#" + AppLocal.Y_POSITION_DUAL_SCREEN + "#" + AppLocal.DISPLAY_ACCEPT_ICON + "#" + AppLocal.PARTIAL_ENCAISSE_ACCEPTED + "#" + AppLocal.SCREEN_IN_FRONT + "#" + AppLocal.DISPLAY_CENTIMES_WINDOWS + "#" + AppLocal.DISPLAY_ENCAISSE_BUTTON + "#";
        String respense = this.CommunicteWithCashLogy(TramOrder);
        System.out.println("+++++++++++++++++++++++++++++respense encaisserCommande" + respense);
        return respense;
    }

    public final String encaisserCommandeSelfcheckout(String NumberOrder2, Double total, String keenio) {
        System.out.println("+++++++++++++++Y_POSITION_DUAL_SCREEN" + AppLocal.Y_POSITION_DUAL_SCREEN);
        System.out.println("+++++++++++++++X_POSITION_DUAL_SCREEN" + AppLocal.X_POSITION_DUAL_SCREEN);
        System.out.println("+++++++++++++++PRINTING_DUAL_SCREEN" + AppLocal.PRINTING_DUAL_SCREEN);
        System.out.println("+++++++++++++++DISPLAY_CENTIMES_WINDOWS" + AppLocal.DISPLAY_CENTIMES_WINDOWS);
        System.out.println("+++++++++++++++DISPLAY_ACCEPT_ICON" + AppLocal.DISPLAY_ACCEPT_ICON);
        System.out.println("+++++++++++++++PARTIAL_ENCAISSE_ACCEPTED" + AppLocal.PARTIAL_ENCAISSE_ACCEPTED);
        System.out.println("+++++++++++++++SCREEN_IN_FRONT" + AppLocal.SCREEN_IN_FRONT);
        System.out.println("+++++++++++++++DISPLAY_CENTIMES_WINDOWS" + AppLocal.DISPLAY_CENTIMES_WINDOWS);
        this.operation_type = ENCAISSEMENT;
        AppLocal.Y_POSITION_DUAL_SCREEN = "0";
        AppLocal.X_POSITION_DUAL_SCREEN = "0";
        AppLocal.DISPLAY_CENTIMES_WINDOWS = "0";
        AppLocal.DISPLAY_ACCEPT_ICON = "0";
        AppLocal.PARTIAL_ENCAISSE_ACCEPTED = "0";
        AppLocal.SCREEN_IN_FRONT = "1";
        AppLocal.DISPLAY_CENTIMES_WINDOWS = "0";
        String TramOrder = "#C#" + NumberOrder2 + "#" + keenio + "#" + String.valueOf((int)NumericUtils.round(total * 100.0)) + "#" + AppLocal.PRINTING_DUAL_SCREEN + "#" + AppLocal.X_POSITION_DUAL_SCREEN + "#" + AppLocal.Y_POSITION_DUAL_SCREEN + "#" + AppLocal.DISPLAY_ACCEPT_ICON + "#" + AppLocal.PARTIAL_ENCAISSE_ACCEPTED + "#" + AppLocal.SCREEN_IN_FRONT + "#" + AppLocal.DISPLAY_CENTIMES_WINDOWS + "#0#";
        String respense = this.CommunicteWithCashLogy(TramOrder);
        System.out.println("+++++++++++++++++++++++++++++respense encaisserCommande" + respense);
        return respense;
    }

    public final boolean isorderValid(String respense) {
        if (respense == null || respense.isEmpty()) {
            return false;
        }
        return !respense.startsWith("#WR") || !respense.startsWith("#ER");
    }

    public HashMap<String, Integer> Descreption(String respense, TicketInfo ticket) {
        boolean is_self_checkout = AppLocal.modeCaisse.equals("Self-checkout");
        double total = NumericUtils.round(ticket.getTotal());
        System.out.println("+++++++++++++++respense Cashlogy" + respense);
        HashMap<String, Integer> Descreption = new HashMap<String, Integer>();
        if (this.isorderValid(respense)) {
            if (respense.startsWith("#WR:CANCEL")) {
                System.out.println("+++++++++++++++++++Canceled Order");
                String[] tokens = respense.split("#");
                String desc = "OP\u00c9RATION ANNUL\u00c9E, MONTANT INTRODUIT : " + this.getDouble(tokens[4]) + "\u20ac, MONTANT ENCAISS\u00c9 AVANT ANNULATION : " + this.getDouble(tokens[2]) + "\u20ac, MONTANT RENDU : " + this.getDouble(tokens[3]) + "\u20ac";
                Descreption.put(desc, 2);
            } else if (respense.startsWith("#ER:GENERIC")) {
                String[] tokens = respense.split("#");
                System.out.println("++++++++++++++++++++DMONTANT INTRODUIT MANUELLEMENT : " + Double.parseDouble(tokens[4]));
                if (Double.parseDouble(tokens[4]) > 0.0) {
                    String desc = "\u00c9RREUR DANS OP\u00c9RATION, MONTANT INTRODUIT MANUELLEMENT :" + this.getDouble(tokens[4]) + "\u20ac, MONTANT ENCAISS\u00c9  :" + this.getDouble(tokens[2]) + "\u20ac, LE MONTANT RENDU SERA PAY\u00c9 MANUELLEMENT :" + this.getFormat(String.valueOf(Double.parseDouble(tokens[2]) / 100.0 - Double.parseDouble(tokens[3]) / 100.0 - ticket.getTotal() + Double.parseDouble(tokens[4]) / 100.0)) + "\u20ac";
                    Descreption.put(desc, 3);
                } else {
                    System.out.println("+++++++++++++++++++++++Montant a encaisse" + this.getDouble(tokens[2]));
                    System.out.println("++++++++++++++++++ Montant introduit manuellement" + this.getDouble(tokens[4]));
                    System.out.println("++++++++++++++++++ Montant rendu manuellement" + this.getFormat(String.valueOf(Double.parseDouble(tokens[2]) / 100.0 - Double.parseDouble(tokens[3]) / 100.0 - total + Double.parseDouble(tokens[4]) / 100.0)));
                    if (Double.parseDouble(tokens[2]) > 0.0) {
                        String desc = "\u00c9RREUR DANS OP\u00c9RATION, MONTANT INTRODUIT MANUELLEMENT :" + this.getDouble(tokens[4]) + "\u20ac, MONTANT ENCAISS\u00c9  :" + this.getDouble(tokens[2]) + "\u20ac, LE MONTANT RENDU SERA PAY\u00c9 MANUELLEMENT :" + this.getFormat(String.valueOf(Double.parseDouble(tokens[2]) / 100.0 - Double.parseDouble(tokens[3]) / 100.0 - ticket.getTotal() + Double.parseDouble(tokens[4]) / 100.0)) + "\u20ac";
                        Descreption.put(desc, 9);
                    } else {
                        String desc = "\u00c9RREUR DANS OP\u00c9RATION, MONTANT INTRODUIT MANUELLEMENT : 0\u20ac, MONTANT ENCAISS\u00c9  : 0\u20ac ";
                        Descreption.put(desc, 8);
                    }
                }
            } else if (respense.startsWith("#ER:BUSY")) {
                String desc = "Cashlogy Connector est occup\u00e9 ! ";
                Descreption.put(desc, 4);
            } else if (respense.startsWith("#ER:BAD_DATA#")) {
                String desc = "Les param\u00e8tres de la commande incorrectes! ";
                Descreption.put(desc, 5);
            } else if (respense.startsWith("#ER:ILLEGAL#")) {
                String desc = " CashlogyConnector n'est pas d\u00e9marr\u00e9 ";
                Descreption.put(desc, 6);
            } else if (respense.startsWith("#WR:LEVEL#")) {
                String[] tokens = respense.split("#");
                String desc = is_self_checkout ? "LA COMMANDE A \u00c9T\u00c9 ENCAISS\u00c9E AVEC SUCC\u00c8S, MONTANT INTRODUIT : " + this.getDouble(tokens[2]) + "\u20ac, MONTANT ENCAISS\u00c9 : " + ticket.getTotal() + "\u20ac, MONTANT RENDU : " + this.getDouble(tokens[3]) + "\u20ac" : "LA COMMANDE A \u00c9T\u00c9 ENCAISS\u00c9E AVEC SUCC\u00c8S, MONTANT INTRODUIT : " + this.getDouble(tokens[4]) + "\u20ac, MONTANT ENCAISS\u00c9 : " + this.getDouble(tokens[2]) + "\u20ac, MONTANT RENDU : " + this.getDouble(tokens[3]) + "\u20ac";
                Descreption.put(desc, 7);
            } else {
                String[] tokens = respense.split("#");
                String desc = is_self_checkout ? "LA COMMANDE A \u00c9T\u00c9 ENCAISS\u00c9E AVEC SUCC\u00c8S, MONTANT INTRODUIT : " + this.getDouble(tokens[2]) + "\u20ac MONTANT ENCAISS\u00c9 : " + ticket.getTotal() + "\u20ac MONTANT RENDU : " + this.getDouble(tokens[3]) + "\u20ac" : "LA COMMANDE A \u00c9T\u00c9 ENCAISS\u00c9E AVEC SUCC\u00c8S, MONTANT INTRODUIT : " + this.getDouble(tokens[4]) + "\u20ac MONTANT ENCAISS\u00c9 : " + this.getDouble(tokens[2]) + "\u20ac MONTANT RENDU : " + this.getDouble(tokens[3]) + "\u20ac";
                AppLocal.TOTAL_RENDU_CASHLOGY = Double.parseDouble(tokens[3]) / 100.0;
                AppLocal.TOTAL_INPUT_CASHLOGY = Double.parseDouble(tokens[4]) / 100.0;
                AppLocal.TOTAL_PAID_CASHLOGY = Double.parseDouble(tokens[2]) / 100.0;
                Descreption.put(desc, 1);
            }
        }
        return Descreption;
    }

    public String getDouble(String Stringnumber) {
        double number = Double.parseDouble(Stringnumber) / 100.0;
        DecimalFormat df = new DecimalFormat("#.##");
        df.setRoundingMode(RoundingMode.DOWN);
        String result = df.format(number);
        return result;
    }

    public String getFormat(String number) {
        DecimalFormat df = new DecimalFormat("#.##");
        df.setRoundingMode(RoundingMode.DOWN);
        String result = df.format(Double.parseDouble(number));
        return result;
    }

    public void loadBackOffice() {
        String desc;
        String BackOfficeTrame = "#G#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#";
        String response = this.CommunicteWithCashLogy(BackOfficeTrame);
        if (response.startsWith("#ER:BUSY")) {
            desc = "Cashlogy Connector est occup\u00e9 ! ";
            new NotifyWindow(NotifyType.WARNING_NOTIFICATION, desc, 4000, NPosition.TOP_CENTER_FULL, (int)AppVarUtils.getScreenDimension().getWidth(), 70);
        }
        if (response.startsWith("#WR:LEVEL#")) {
            desc = " Une pi\u00e8ce ou un billet est hors de sa limite ! ";
            new NotifyWindow(NotifyType.WARNING_NOTIFICATION, desc, 4000, NPosition.TOP_CENTER_FULL, (int)AppVarUtils.getScreenDimension().getWidth(), 70);
        }
        ResponseParser mResponseParser = new ResponseParser();
        mResponseParser.printTicketBackOffice(response);
    }

    public HashMap<String, Integer> DescreptionSplitPayment(String respense, double m_paid) {
        double total = NumericUtils.round(m_paid);
        System.out.println("+++++++++++++++respense Cashlogy" + respense);
        HashMap<String, Integer> Descreption = new HashMap<String, Integer>();
        if (this.isorderValid(respense)) {
            if (respense.startsWith("#WR:CANCEL")) {
                System.out.println("+++++++++++++++++++Canceled Order");
                String[] tokens = respense.split("#");
                String desc = "OP\u00c9RATION ANNUL\u00c9E ,MONTANT INTRODUIT : " + this.getDouble(tokens[4]) + "\u20ac ,MONTANT ENCAISS\u00c9 AVANT ANNULATION : " + this.getDouble(tokens[2]) + "\u20ac ,MONTANT RENDU : " + this.getDouble(tokens[3]) + "\u20ac";
                Descreption.put(desc, 2);
            } else if (respense.startsWith("#ER:GENERIC")) {
                String[] tokens = respense.split("#");
                System.out.println("++++++++++++++++++++DMONTANT INTRODUIT MANUELLEMENT : " + Double.parseDouble(tokens[4]));
                if (Double.parseDouble(tokens[4]) > 0.0) {
                    String desc = "\u00c9RREUR DANS OP\u00c9RATION  ,MONTANT INTRODUIT MANUELLEMENT :" + this.getDouble(tokens[4]) + " \u20ac ,MONTANT ENCAISS\u00c9  :" + this.getDouble(tokens[2]) + "\u20ac ,LE MONTANT RENDU SERA PAY\u00c9 MANUELLEMENT :" + this.getFormat(String.valueOf(Double.parseDouble(tokens[2]) / 100.0 - Double.parseDouble(tokens[3]) / 100.0 - total + Double.parseDouble(tokens[4]) / 100.0)) + "\u20ac";
                    Descreption.put(desc, 3);
                } else {
                    System.out.println("+++++++++++++++++++++++Montant a encaisse" + this.getDouble(tokens[2]));
                    System.out.println("++++++++++++++++++ Montant introduit manuellement" + this.getDouble(tokens[4]));
                    System.out.println("++++++++++++++++++ Montant rendu manuellement" + this.getFormat(String.valueOf(Double.parseDouble(tokens[2]) / 100.0 - Double.parseDouble(tokens[3]) / 100.0 - total + Double.parseDouble(tokens[4]) / 100.0)));
                    if (Double.parseDouble(tokens[2]) > 0.0) {
                        String desc = "\u00c9RREUR DANS OP\u00c9RATION  ,MONTANT INTRODUIT MANUELLEMENT :" + this.getDouble(tokens[4]) + " \u20ac ,MONTANT ENCAISS\u00c9  :" + this.getDouble(tokens[2]) + "\u20ac ,LE MONTANT RENDU SERA PAY\u00c9 MANUELLEMENT :" + this.getFormat(String.valueOf(Double.parseDouble(tokens[2]) / 100.0 - Double.parseDouble(tokens[3]) / 100.0 - total + Double.parseDouble(tokens[4]) / 100.0)) + "\u20ac";
                        Descreption.put(desc, 9);
                    } else {
                        String desc = "\u00c9RREUR DANS OP\u00c9RATION  ,MONTANT INTRODUIT MANUELLEMENT : 0 \u20ac ,MONTANT ENCAISS\u00c9  : 0 \u20ac ";
                        Descreption.put(desc, 8);
                    }
                }
            } else if (respense.startsWith("#ER:BUSY")) {
                String desc = "Cashlogy Connector est occup\u00e9 ! ";
                Descreption.put(desc, 4);
            } else if (respense.startsWith("#ER:BAD_DATA#")) {
                String desc = "Les param\u00e8tres du paiement incorrectes! ";
                Descreption.put(desc, 5);
            } else if (respense.startsWith("#ER:ILLEGAL#")) {
                String desc = " CashlogyConnector n'est pas d\u00e9marr\u00e9 ";
                Descreption.put(desc, 6);
            } else if (respense.startsWith("#WR:LEVEL#")) {
                String[] tokens = respense.split("#");
                String desc = "LE PAIEMENT A \u00c9T\u00c9 ENCAISS\u00c9E AVEC SUCC\u00c8S, MONTANT INTRODUIT : " + this.getDouble(tokens[4]) + "\u20ac MONTANT ENCAISS\u00c9 : " + this.getDouble(tokens[2]) + "\u20ac MONTANT RENDU : " + this.getDouble(tokens[3]) + "\u20ac";
                Descreption.put(desc, 7);
            } else {
                String[] tokens = respense.split("#");
                String desc = "LE PAIEMENT A \u00c9T\u00c9 ENCAISS\u00c9E AVEC SUCC\u00c8S, MONTANT INTRODUIT : " + this.getDouble(tokens[4]) + "\u20ac MONTANT ENCAISS\u00c9 : " + this.getDouble(tokens[2]) + "\u20ac MONTANT RENDU : " + this.getDouble(tokens[3]) + "\u20ac";
                AppLocal.TOTAL_RENDU_CASHLOGY = Double.parseDouble(tokens[3]) / 100.0;
                AppLocal.TOTAL_INPUT_CASHLOGY = Double.parseDouble(tokens[4]) / 100.0;
                AppLocal.TOTAL_PAID_CASHLOGY = Double.parseDouble(tokens[2]) / 100.0;
                Descreption.put(desc, 1);
            }
        }
        return Descreption;
    }
}

