/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.beans;

import com.openbravo.basic.BasicException;
import com.openbravo.data.loader.SerializerRead;
import com.openbravo.pos.util.DateUtils;
import com.procaisse.db.metadata.DataRead;
import java.util.Date;

public class TicketAvoir {
    private int id;
    private boolean used;
    private double amount;
    private String barCode;
    private String origin;
    private Date expirationDate;
    private static int lastId = -1;
    private String ticket;

    public TicketAvoir(boolean used, double amount, String barCode, Date expirationDate, String origin) {
        this.used = used;
        this.amount = amount;
        this.barCode = barCode;
        this.expirationDate = expirationDate;
        this.origin = origin;
    }

    public TicketAvoir(int id, boolean used, double amount, String barCode, Date expirationDate, String origin) {
        this.used = used;
        this.amount = amount;
        this.barCode = barCode;
        this.expirationDate = expirationDate;
        this.id = id;
        this.origin = origin;
    }

    public TicketAvoir() {
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public boolean isUsed() {
        return this.used;
    }

    public void setUsed(boolean used) {
        this.used = used;
    }

    public double getAmount() {
        return this.amount;
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }

    public String getBarCode() {
        return this.barCode;
    }

    public String buildBarCode() {
        this.barCode = DateUtils.formatDateForBarCode(this.expirationDate) + this.id;
        return this.barCode;
    }

    public void setBarCode(String barCode) {
        this.barCode = barCode;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public static SerializerRead getSerializerRead() {
        return new SerializerRead(){

            @Override
            public Object readValues(DataRead dr) throws BasicException {
                return new TicketAvoir(dr.getInt(1), dr.getBoolean(3), dr.getDouble(2), dr.getString(5), dr.getTimestamp(4), dr.getString(6));
            }
        };
    }

    public static int getLastId() {
        return lastId;
    }

    public static void setLastId(int lastId) {
        TicketAvoir.lastId = lastId;
    }

    public String getOrigin() {
        return this.origin;
    }

    public String toString() {
        return "TicketAvoir{id=" + this.id + ", used=" + this.used + ", amount=" + this.amount + ", barCode=" + this.barCode + ", expirationDate=" + this.expirationDate + "}";
    }

    public String getTicket() {
        return this.ticket;
    }

    public void setTicket(String ticket) {
        this.ticket = ticket;
    }
}

