/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.beans;

import com.openbravo.pos.util.DateUtils;
import com.openbravo.pos.util.LogToFile;
import java.text.ParseException;
import java.util.Date;
import org.json.JSONObject;

public class OrderOnLine {
    private int id;
    private String type;
    private String clientName;
    private String clientTel;
    private String typePayment;
    private Double total;
    private Date dateCmd;
    private Date dateDelevery;
    private Date date_Synchronized;
    private boolean validate;
    private String jsonSource;
    private JSONObject client;
    private JSONObject jsonOrder;

    public String getClientTel() {
        return this.clientTel;
    }

    public JSONObject getJsonOrder() {
        return this.jsonOrder;
    }

    public void setJsonOrder(JSONObject jsonOrder) {
        this.jsonOrder = jsonOrder;
    }

    public void setClientTel(String clientTel) {
        this.clientTel = clientTel;
    }

    public OrderOnLine(int id, String type, String clientName, String typePayment, Double total, Date dateCmd, Date date_Synchronized, boolean validate, String jsonSource, String clientTel, JSONObject client, Date dateDelevery) {
        this.id = id;
        this.type = type;
        this.clientName = clientName;
        this.clientTel = clientTel;
        this.typePayment = typePayment;
        this.total = total;
        this.dateCmd = dateCmd;
        this.dateDelevery = dateDelevery;
        this.date_Synchronized = date_Synchronized;
        this.validate = validate;
        this.jsonSource = jsonSource;
        this.client = client;
    }

    public String getJsonSource() {
        return this.jsonSource;
    }

    public void setJsonSource(String jsonSource) {
        this.jsonSource = jsonSource;
    }

    public OrderOnLine(JSONObject jsonOrder) {
        this.id = jsonOrder.getInt("id");
        this.type = jsonOrder.getString("type");
        this.client = jsonOrder.getJSONObject("client");
        this.clientName = this.client != null ? this.client.getString("first_name") + " " + this.client.getString("last_name") : "";
        this.clientTel = this.client != null ? this.client.getString("phone") : "";
        this.typePayment = jsonOrder.getString("payment_type");
        this.total = jsonOrder.getDouble("total");
        this.date_Synchronized = new Date();
        try {
            this.dateCmd = DateUtils.FORMATTER_DATE_TIME.parse(jsonOrder.getJSONObject("created").getString("date"));
            this.dateDelevery = DateUtils.FORMATTER_DATE_TIME.parse(jsonOrder.getJSONObject("delivery_date").getString("date").substring(0, 11) + jsonOrder.getString("delivery_time") + ":00.000");
        }
        catch (ParseException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        this.jsonSource = jsonOrder.toString();
        this.jsonOrder = jsonOrder;
    }

    public boolean isValidate() {
        return this.validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public String getTypePayment() {
        return this.typePayment;
    }

    public void setTypePayment(String typePayment) {
        this.typePayment = typePayment;
    }

    public Double getTotal() {
        return this.total;
    }

    public void setTotal(Double total) {
        this.total = total;
    }

    public Date getDateCmd() {
        return this.dateCmd;
    }

    public void setDateCmd(Date dateCmd) {
        this.dateCmd = dateCmd;
    }

    public Date getDateDelevery() {
        return this.dateDelevery;
    }

    public void setDateDelevery(Date dateDelevery) {
        this.dateDelevery = dateDelevery;
    }

    public JSONObject getClient() {
        return this.client;
    }

    public void setClient(JSONObject client) {
        this.client = client;
    }

    public Date getDate_Synchronized() {
        return this.date_Synchronized;
    }

    public void setDate_Synchronized(Date date_Synchronized) {
        this.date_Synchronized = date_Synchronized;
    }

    public String getAdresse() {
        return (!this.getClient().isNull("address") ? this.getClient().getString("address") : "") + " " + (!this.getClient().isNull("city") ? this.getClient().getString("city") : "");
    }
}

