/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.beans;

import com.openbravo.beans.IlocalResources;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.util.LogToFile;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public class LocaleResources
implements IlocalResources {
    private List<ResourceBundle> m_resources = new LinkedList<ResourceBundle>();
    private ClassLoader m_localeloader;

    public LocaleResources() {
        File fuserdir = new File(System.getProperty("user.dir"));
        File fresources = new File(fuserdir, "locales");
        try {
            this.m_localeloader = URLClassLoader.newInstance(new URL[]{fresources.toURI().toURL()}, Thread.currentThread().getContextClassLoader());
        }
        catch (MalformedURLException e) {
            this.m_localeloader = Thread.currentThread().getContextClassLoader();
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public ResourceBundle getBundle(String bundlename) {
        return ResourceBundle.getBundle(bundlename, Locale.getDefault(), this.m_localeloader);
    }

    @Override
    public void addBundleName(String bundlename) {
        Locale local = null;
        System.out.println("+++++++++++++++++ APP_LANGUAGE appLocal " + AppLocal.APP_LANGUAGE + "        date " + new Date());
        if (AppLocal.APP_LANGUAGE != null) {
            switch (AppLocal.APP_LANGUAGE) {
                case "fr": {
                    local = new Locale("fr", "FR");
                    break;
                }
                case "es": {
                    local = new Locale("es", "ES");
                    break;
                }
                case "en": {
                    local = new Locale("en", "EN");
                    break;
                }
                case "ar": {
                    local = new Locale("ar", "AR");
                    break;
                }
                case "fr-CA": {
                    local = new Locale("fr", "CA");
                    break;
                }
                default: {
                    local = new Locale("fr", "FR");
                    break;
                }
            }
        } else {
            local = new Locale("fr", "FR");
        }
        System.out.println("local l " + local.getCountry());
        this.m_resources.add(ResourceBundle.getBundle(bundlename, local));
    }

    @Override
    public String getString(String sKey) {
        if (sKey == null) {
            return null;
        }
        for (ResourceBundle r : this.m_resources) {
            try {
                if (!r.containsKey(sKey)) continue;
                return r.getString(sKey);
            }
            catch (Exception e) {
                LogToFile.log("severe", e.getMessage(), e);
            }
        }
        return "** " + sKey + " **";
    }

    public String getString(String sKey, Object ... sValues) {
        if (sKey == null) {
            return null;
        }
        for (ResourceBundle r : this.m_resources) {
            try {
                return MessageFormat.format(r.getString(sKey), sValues);
            }
            catch (Exception e) {
                LogToFile.log("severe", e.getMessage(), e);
            }
        }
        StringBuilder sreturn = new StringBuilder();
        sreturn.append("** ");
        sreturn.append(sKey);
        for (Object value : sValues) {
            sreturn.append(" < ");
            sreturn.append(value.toString());
        }
        sreturn.append("** ");
        return sreturn.toString();
    }

    public InputStream getRessourceAsStream(String ressourceName) {
        return this.m_localeloader.getResourceAsStream(ressourceName);
    }
}

