/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.animation;

import com.openbravo.animation.AnimationNode;
import com.openbravo.animation.AnimationType;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;

public class AnimationsUtils {
    public static KeyFrame[] getKeyFrames(AnimationType[] types, AnimationNode anim) {
        if (types == null) {
            return null;
        }
        KeyFrame[] frames = null;
        block16: for (AnimationType type : types) {
            switch (type) {
                case FADE_OUT: {
                    frames = anim.getFadeOut(frames);
                    continue block16;
                }
                case FLAP_RIGHT: {
                    frames = anim.getFlapRight(frames);
                    continue block16;
                }
                case FLATTERN_OUT: {
                    frames = anim.getFlatternOut(frames);
                    continue block16;
                }
                case FLY_FROM_DOWN: {
                    frames = anim.getFlyFromDown(frames);
                    continue block16;
                }
                case FLY_FROM_UP: {
                    frames = anim.getFlyFromUp(frames);
                    continue block16;
                }
                case ROTATE_RIGHT: {
                    frames = anim.getRotateYRight(frames);
                    continue block16;
                }
                case SPEED_LEFT: {
                    frames = anim.getSpeedLeft(frames);
                    continue block16;
                }
                case SPEED_RIGHT: {
                    frames = anim.getSpeedRight(frames);
                    continue block16;
                }
                case TRANSITION_DOWN: {
                    frames = anim.getTransitionDown(frames);
                    continue block16;
                }
                case TRANSITION_LEFT: {
                    frames = anim.getTransitionLeft(frames);
                    continue block16;
                }
                case TRANSITION_RIGHT: {
                    frames = anim.getTransitionRight(frames);
                    continue block16;
                }
                case TRANSITION_TOP: {
                    frames = anim.getTransitionTop(frames);
                    continue block16;
                }
                case ZOOM_IN: {
                    frames = anim.getZoomIn(0.0, frames);
                    continue block16;
                }
                case POP_OUT: {
                    frames = anim.getPopOut(frames);
                }
            }
        }
        return frames;
    }

    public static void animate(AnimationNode anim) {
        if (anim != null && anim.getKeyFrames().size() >= 0 && (anim.getTimeline().getStatus() == Animation.Status.STOPPED || anim.getTimeline().getStatus() == Animation.Status.PAUSED)) {
            anim.getTimeline().playFromStart();
        }
    }
}

