/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.animation;

import java.util.Arrays;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Shear;
import javafx.util.Duration;

public abstract class AnimationNode {
    public Node node;
    final Timeline ti = new Timeline();
    final Timeline rti = new Timeline();
    public int animDuration = 600;
    public Shear sh;
    public Rotate rotate;

    public AnimationNode(Node n) {
        this.node = n;
    }

    public abstract KeyFrame[] getFlatternOut(KeyFrame ... var1);

    public abstract KeyFrame[] getPopOut(KeyFrame ... var1);

    public abstract KeyFrame[] getFlapRight(KeyFrame ... var1);

    public abstract KeyFrame[] getFlyFromUp(KeyFrame ... var1);

    public abstract KeyFrame[] getFlyFromDown(KeyFrame ... var1);

    public abstract KeyFrame[] getRotateYRight(KeyFrame ... var1);

    public abstract KeyFrame[] getSpeedLeft(KeyFrame ... var1);

    public abstract KeyFrame[] getSpeedRight(KeyFrame ... var1);

    public abstract KeyFrame[] getTransitionTop(KeyFrame ... var1);

    public abstract KeyFrame[] getTransitionDown(KeyFrame ... var1);

    public abstract KeyFrame[] getTransitionLeft(KeyFrame ... var1);

    public abstract KeyFrame[] getTransitionRight(KeyFrame ... var1);

    public KeyFrame[] getZoomIn(double from, KeyFrame ... k) {
        return AnimationNode.concat(k, new KeyFrame[]{new KeyFrame(Duration.millis((double)0.0), new KeyValue[]{new KeyValue((WritableValue)this.node.scaleXProperty(), (Object)from)}), new KeyFrame(Duration.millis((double)0.0), new KeyValue[]{new KeyValue((WritableValue)this.node.scaleYProperty(), (Object)from)}), new KeyFrame(Duration.millis((double)this.animDuration), new KeyValue[]{new KeyValue((WritableValue)this.node.scaleXProperty(), (Object)1)}), new KeyFrame(Duration.millis((double)this.animDuration), new KeyValue[]{new KeyValue((WritableValue)this.node.scaleYProperty(), (Object)1)})});
    }

    public KeyFrame[] getFadeOut(KeyFrame ... k) {
        return AnimationNode.concat(k, new KeyFrame[]{new KeyFrame(Duration.millis((double)0.0), new KeyValue[]{new KeyValue((WritableValue)this.node.opacityProperty(), (Object)0)}), new KeyFrame(Duration.millis((double)this.animDuration), new KeyValue[]{new KeyValue((WritableValue)this.node.opacityProperty(), (Object)1)})});
    }

    public static <T> T[] concat(T[] first, T[] second) {
        if (first == null && second != null) {
            return second;
        }
        if (second == null && first != null) {
            return first;
        }
        T[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public ObservableList<KeyFrame> getKeyFrames() {
        return this.ti.getKeyFrames();
    }

    public Timeline getTimeline() {
        return this.ti;
    }

    public Timeline getReversedTimeline() {
        Duration dur;
        Duration start = null;
        Duration end = null;
        for (KeyFrame f : this.ti.getKeyFrames()) {
            dur = f.getTime();
            if (start == null && end == null) {
                start = end = dur;
            }
            if (dur.greaterThan(end)) {
                end = dur;
            }
            if (!dur.lessThan(start)) continue;
            start = dur;
        }
        for (KeyFrame f : this.ti.getKeyFrames()) {
            dur = f.getTime();
            this.rti.getKeyFrames().add((Object)new KeyFrame(Duration.millis((double)((1.0 - dur.toMillis() / end.toMillis()) * end.toMillis())), f.getValues().toArray(new KeyValue[f.getValues().size()])));
        }
        return this.rti;
    }
}

