/*
 * Decompiled with CFR 0.152.
 */
package com.glory.fcc.service;

import com.glory.fcc.service.BrueBoxServiceCallbackHandler;
import com.glory.fcc.service.BrueBoxServiceStub;
import com.glory.fcc.service.FCCClient;
import com.glory.fcc.service.FCCConst;
import com.openbravo.controllers.GloryController;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.util.LogToFile;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.ButtonType;
import javafx.scene.control.DialogPane;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.text.Text;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import org.jdom.Element;

public interface IUserInterface
extends FCCConst {
    public static final DecimalFormat decimalFormat = new DecimalFormat("#####0.00");

    public void setGuidance(String var1, int var2);

    public String getGuidance();

    public void setDeposit(String var1);

    public void setStatus(int var1, String var2);

    default public void setLocked(int devid) {
    }

    default public String getStatusString(int statusCode) {
        if (FCCConst.STATUS_STRING.length <= statusCode) {
            return "Unknown";
        }
        return FCCConst.STATUS_STRING[statusCode];
    }

    default public void showRecoveryScreen(String errCode, String text) {
        Platform.runLater(() -> {
            Alert.AlertType alertType1 = Alert.AlertType.ERROR;
            String msg = text;
            String bgColor = "red";
            Alert alert = new Alert(null, errCode, new ButtonType[]{ButtonType.OK});
            alert.setHeight(500.0);
            DialogPane root = alert.getDialogPane();
            WebView wb = new WebView();
            wb.setPrefHeight(400.0);
            wb.setPrefWidth(400.0);
            WebEngine pp = wb.getEngine();
            Text codeError = new Text("\n\n\n\n\n\n\n\n\n\n\n\nCode d'erreur : " + errCode);
            String styleRetrait = "-fx-text-fill: red  ; -fx-alignment-adjust: center;-fx-font-size: 20px; -fx-font-family: \"AvenirNext-Bold\"; -fx-font-weight: bold;";
            codeError.setStyle(styleRetrait);
            StackPane stack = new StackPane(new Node[]{wb, codeError});
            root.setContent((Node)stack);
            pp.load(msg);
            root.getScene().setRoot((Parent)new Group());
            root.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
            root.setStyle("    -fx-background-color: " + bgColor + ";-fx-effect: dropshadow(gaussian, " + bgColor + ", 40, 0, 0, 0);-fx-background-insets: 5;");
            Stage dialogStage = new Stage(StageStyle.DECORATED);
            root.getButtonTypes().forEach(buttonType -> {
                ButtonBase button = (ButtonBase)root.lookupButton(buttonType);
                button.setOnAction(evt -> {
                    root.setUserData(buttonType);
                    dialogStage.close();
                });
            });
            Scene scene = new Scene((Parent)root);
            dialogStage.setScene(scene);
            dialogStage.initModality(Modality.APPLICATION_MODAL);
            dialogStage.setAlwaysOnTop(true);
            dialogStage.setResizable(false);
            dialogStage.initStyle(StageStyle.UNDECORATED);
            root.getScene().getRoot().setEffect((Effect)new DropShadow(10.0, 300.0, 300.0, Color.BLACK));
            dialogStage.showAndWait();
            Optional<ButtonType> result = Optional.ofNullable((ButtonType)root.getUserData());
            if (result.get() == ButtonType.OK) {
                // empty if block
            }
        });
    }

    default public void setWarningLabel(int proc, String devid, String fv) {
        if (!fv.isEmpty() && FCCClient.isHas_advanced_functions_glory_permission()) {
            double fvDouble = Double.valueOf(fv) / 100.0;
            String key = decimalFormat.format(fvDouble).replace(",", ".") + "\u20ac";
            GloryController.showMessageDialogue(Alert.AlertType.ERROR, "le stacker des " + key + " est en anomalie.\nUne \u00ab Collecte de v\u00e9rification \u00bb est n\u00e9cessaire pour corriger le probl\u00e8me.");
        }
    }

    public void startRepFC();

    public boolean getRepFCState();

    default public String getCurrentViewName() {
        return this.getClass().getSimpleName();
    }

    default public void setEventInventory(Element node) {
        BrueBoxServiceStub.InventoryResponseType inv = new BrueBoxServiceStub.InventoryResponseType();
        inv.setId(node.getChild("Id").getText());
        inv.setSeqNo(node.getChild("SeqNo").getText());
        inv.setUser(node.getChild("User").getText());
        List nodeListCash = node.getChildren("Cash");
        int nodeCashCnt = 0;
        BrueBoxServiceStub.CashType[] cashCashArray = new BrueBoxServiceStub.CashType[nodeListCash.size()];
        for (Element nodeCash : nodeListCash) {
            BrueBoxServiceStub.CashType cash = new BrueBoxServiceStub.CashType();
            cash.setType(BigInteger.valueOf(Long.parseLong(nodeCash.getAttributeValue("type"))));
            List nodeListDenomi = nodeCash.getChildren("Denomination");
            int nodeDenomiCnt = 0;
            BrueBoxServiceStub.DenominationType[] cashDenomiArray = new BrueBoxServiceStub.DenominationType[nodeListDenomi.size()];
            for (Element nodeDenomi : nodeListDenomi) {
                BrueBoxServiceStub.DenominationType cashDenomi = new BrueBoxServiceStub.DenominationType();
                cashDenomi.setCc(nodeDenomi.getAttributeValue("cc"));
                cashDenomi.setFv(BigInteger.valueOf(Long.parseLong(nodeDenomi.getAttributeValue("fv"))));
                cashDenomi.setRev(BigInteger.valueOf(Long.parseLong(nodeDenomi.getAttributeValue("rev"))));
                cashDenomi.setDevid(BigInteger.valueOf(Long.parseLong(nodeDenomi.getAttributeValue("devid"))));
                cashDenomi.setPiece(BigInteger.valueOf(Long.parseLong(nodeDenomi.getChild("Piece").getText())));
                cashDenomi.setStatus(BigInteger.valueOf(Long.parseLong(nodeDenomi.getChild("Status").getText())));
                cashDenomiArray[nodeDenomiCnt] = cashDenomi;
                ++nodeDenomiCnt;
            }
            cash.setDenomination(cashDenomiArray);
            cashCashArray[nodeCashCnt] = cash;
            ++nodeCashCnt;
        }
        inv.setCash(cashCashArray);
        List nodeListUnits = node.getChildren("CashUnits");
        int nodeUnitsCnt = 0;
        BrueBoxServiceStub.CashUnitsType[] cashUnitsArray = new BrueBoxServiceStub.CashUnitsType[nodeListUnits.size()];
        for (Element nodeUnits : nodeListUnits) {
            BrueBoxServiceStub.CashUnitsType cashUnits = new BrueBoxServiceStub.CashUnitsType();
            cashUnits.setDevid(BigInteger.valueOf(Long.parseLong(nodeUnits.getAttributeValue("devid"))));
            List nodeListUnit = nodeUnits.getChildren("CashUnit");
            int nodeUnitCnt = 0;
            BrueBoxServiceStub.CashUnitType[] cashUnitArray = new BrueBoxServiceStub.CashUnitType[nodeListUnit.size()];
            for (Element nodeUnit : nodeListUnit) {
                BrueBoxServiceStub.CashUnitType cashUnit = new BrueBoxServiceStub.CashUnitType();
                cashUnit.setUnitno(BigInteger.valueOf(Long.parseLong(nodeUnit.getAttributeValue("unitno"))));
                cashUnit.setSt(BigInteger.valueOf(Long.parseLong(nodeUnit.getAttributeValue("st"))));
                cashUnit.setNf(BigInteger.valueOf(Long.parseLong(nodeUnit.getAttributeValue("nf"))));
                cashUnit.setNe(BigInteger.valueOf(Long.parseLong(nodeUnit.getAttributeValue("ne"))));
                cashUnit.setMax(BigInteger.valueOf(Long.parseLong(nodeUnit.getAttributeValue("max"))));
                List nodeListDenomi = nodeUnit.getChildren("Denomination");
                int nodeDenomiCnt = 0;
                BrueBoxServiceStub.DenominationType[] cashDenomiArray = new BrueBoxServiceStub.DenominationType[nodeListDenomi.size()];
                for (Element nodeDenomi : nodeListDenomi) {
                    BrueBoxServiceStub.DenominationType cashDenomi = new BrueBoxServiceStub.DenominationType();
                    cashDenomi.setCc(nodeDenomi.getAttributeValue("cc"));
                    cashDenomi.setFv(BigInteger.valueOf(Long.parseLong(nodeDenomi.getAttributeValue("fv"))));
                    cashDenomi.setRev(BigInteger.valueOf(Long.parseLong(nodeDenomi.getAttributeValue("rev"))));
                    cashDenomi.setDevid(BigInteger.valueOf(Long.parseLong(nodeDenomi.getAttributeValue("devid"))));
                    cashDenomi.setPiece(BigInteger.valueOf(Long.parseLong(nodeDenomi.getChild("Piece").getText())));
                    cashDenomi.setStatus(BigInteger.valueOf(Long.parseLong(nodeDenomi.getChild("Status").getText())));
                    cashDenomiArray[nodeDenomiCnt] = cashDenomi;
                    ++nodeDenomiCnt;
                }
                cashUnit.setDenomination(cashDenomiArray);
                cashUnitArray[nodeUnitCnt] = cashUnit;
                ++nodeUnitCnt;
            }
            cashUnits.setCashUnit(cashUnitArray);
            cashUnitsArray[nodeUnitsCnt] = cashUnits;
            ++nodeUnitsCnt;
        }
        inv.setCashUnits(cashUnitsArray);
        this.setInventory(inv);
    }

    public void setReplenishCounting(List<Element> var1);

    default public void setInventoryCassette(int devId, List<Element> denomination) {
    }

    default public void getGloryStatus() {
        System.out.println(" getFccInstance().getStatusAsync(new BrueBoxServiceCallbackHandler()");
        FCCClient.getFccInstance().getStatusAsync(new BrueBoxServiceCallbackHandler(){

            @Override
            public void receiveErrorgetStatus(Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Connexion au Monnayeur a \u00e9chou\u00e9.", 4000, NPosition.BOTTOM_RIGHT);
                super.receiveErrorgetStatus(ex);
                IUserInterface.this.setGuidance("Pas de communication", -1);
            }

            @Override
            public void receiveResultgetStatus(BrueBoxServiceStub.StatusResponse result) {
                IUserInterface.this.setGuidance(IUserInterface.this.getStatusString(result.getStatusResponse().getStatus().getCode().intValue()), result.getStatusResponse().getStatus().getCode().intValue());
                if (result.getStatusResponse().getStatus().getCode().intValue() == 1) {
                    // empty if block
                }
                if (result.getStatusResponse().getResult().intValue() == 0) {
                    if (result.getStatusResponse().getStatus().getCode().intValue() > 1 && result.getStatusResponse().getStatus().getCode().intValue() != 8) {
                        System.out.println("result.getStatusResponse() first :" + result.getStatusResponse().getResult().intValue());
                        if (FCCClient.getFccInstance().isResetRequired() && result.getStatusResponse().getStatus().getCode().intValue() == 3) {
                            IUserInterface.this.reset();
                        }
                    } else if (result.getStatusResponse().getStatus().getCode().intValue() != 1) {
                        // empty if block
                    }
                } else if (result.getStatusResponse().getResult().intValue() == 21 || result.getStatusResponse().getResult().intValue() == 22) {
                    if (FCCClient.getFccInstance().takeControl()) {
                        IUserInterface.this.getGloryStatus();
                    }
                } else {
                    new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "status response code : " + result.getStatusResponse().getResult().intValue(), 4000, NPosition.BOTTOM_RIGHT);
                    System.out.println("result.getStatusResponse().getResult().intValue()" + result.getStatusResponse().getResult().intValue());
                }
                IUserInterface.this.enableAndDisableBigDenomination(1500.0);
                FCCClient.getFccInstance().takeControl();
                FCCClient.setGobjVerify(result.getStatusResponse().getRequireVerifyInfos());
                FCCClient.getFccInstance().updateInventory(this);
            }
        });
    }

    default public void receiveResultinventoryOperation(BrueBoxServiceStub.InventoryResponse result) {
        BrueBoxServiceStub.InventoryResponseType response = result.getInventoryResponse();
        switch (response.getResult().intValue()) {
            case 0: {
                this.setInventory(response);
                FCCClient.getFccInstance().releaseControl();
                break;
            }
            case 21: {
                System.out.println("invalid session id ");
                break;
            }
        }
    }

    default public void finalizeIncompleteTransaction() {
    }

    public void setInventory(BrueBoxServiceStub.InventoryResponseType var1);

    default public void gloryCommunicationErrorBehavior() {
        new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Echec de connexion au Monnayeur !", 10000, NPosition.BOTTOM_LEFT);
    }

    default public void enableAndDisableBigDenomination(double fond) {
        try {
            ArrayList<Integer> denominationsToDisable = new ArrayList<Integer>();
            ArrayList<Integer> denominationsToEnable = new ArrayList<Integer>();
            if (fond < 100.0) {
                denominationsToDisable.add(50);
                denominationsToDisable.add(100);
                denominationsToDisable.add(200);
                denominationsToDisable.add(500);
            } else if (fond < 200.0) {
                denominationsToEnable.add(50);
                denominationsToDisable.add(100);
                denominationsToDisable.add(200);
                denominationsToDisable.add(500);
            } else if (fond < 400.0) {
                denominationsToEnable.add(50);
                denominationsToEnable.add(100);
                denominationsToDisable.add(200);
                denominationsToDisable.add(500);
            } else if (fond < 1000.0) {
                denominationsToEnable.add(50);
                denominationsToEnable.add(100);
                denominationsToEnable.add(200);
                denominationsToDisable.add(500);
            } else {
                denominationsToEnable.add(50);
                denominationsToEnable.add(100);
                denominationsToEnable.add(200);
                denominationsToEnable.add(500);
            }
            FCCClient.getFccInstance().disableEnableDenomination(denominationsToDisable, denominationsToEnable);
        }
        catch (RemoteException ex) {
            GloryController.showMessageDialogue(Alert.AlertType.ERROR, ex.getMessage());
        }
    }

    default public void reset() {
    }

    default public void SetVerifyInfo(BrueBoxServiceStub.RequireVerifyInfosType objVerify) {
        BrueBoxServiceStub.RequireVerifyMixStackerType[] objVerifyMix;
        BrueBoxServiceStub.RequireVerifyCollectionContainerType[] objVerifyContainer;
        String val;
        String devid;
        int i;
        int j = 0;
        this.setWarningLabel(3, String.valueOf(1), "");
        this.setWarningLabel(3, String.valueOf(2), "");
        this.setWarningLabel(4, String.valueOf(1), "");
        this.setWarningLabel(4, String.valueOf(2), "");
        this.setWarningLabel(6, String.valueOf(2), "");
        BrueBoxServiceStub.RequireVerifyDenominationType[] objVerifyDenomi = objVerify.getRequireVerifyDenominationInfos().getRequireVerifyDenomination();
        if (objVerifyDenomi != null) {
            for (i = 0; i <= objVerifyDenomi.length - 1; ++i) {
                devid = objVerifyDenomi[i].getDevid().toString();
                val = objVerifyDenomi[i].getVal().toString();
                BrueBoxServiceStub.CashType objCash = objVerifyDenomi[i].getCash();
                if (Integer.parseInt(val) != 1 || objCash == null) continue;
                BrueBoxServiceStub.DenominationType[] objDenomi = objCash.getDenomination();
                GloryController.compromisedDenomination = new HashMap<String, BrueBoxServiceStub.DenominationType>();
                for (j = 0; j <= objDenomi.length - 1; ++j) {
                    String fv = objDenomi[j].getFv().toString();
                    double fvDouble = Double.valueOf(fv) / 100.0;
                    String key = decimalFormat.format(fvDouble).replace(",", ".") + "\u20ac";
                    GloryController.compromisedDenomination.put(key, objDenomi[j]);
                    this.setWarningLabel(1, devid, fv);
                }
            }
        }
        if ((objVerifyContainer = objVerify.getRequireVerifyCollectionContainerInfos().getRequireVerifyCollectionContainer()) != null) {
            for (i = 0; i <= objVerifyContainer.length - 1; ++i) {
                devid = objVerifyContainer[i].getDevid().toString();
                val = objVerifyContainer[i].getVal().toString();
                if (Integer.parseInt(val) != 1) continue;
                this.setWarningLabel(2, devid, "");
            }
        }
        if ((objVerifyMix = objVerify.getRequireVerifyMixStackerInfos().getRequireVerifyMixStacker()) != null) {
            for (i = 0; i <= objVerifyMix.length - 1; ++i) {
                devid = objVerifyMix[i].getDevid().toString();
                val = objVerifyMix[i].getVal().toString();
                if (Integer.parseInt(val) != 1) continue;
                this.setWarningLabel(5, devid, "");
            }
        }
    }
}

