/*
 * Decompiled with CFR 0.152.
 */
package com.glory.fcc.service;

import com.glory.fcc.service.BrueBoxServiceCallbackHandler;
import com.glory.fcc.service.BrueBoxServiceStub;
import com.glory.fcc.service.EventHandleClass;
import com.glory.fcc.service.FCCConst;
import com.glory.fcc.service.IUserInterface;
import com.openbravo.basic.BasicException;
import com.openbravo.basic.BasicStorage;
import com.openbravo.controllers.Controller;
import com.openbravo.controllers.GloryController;
import com.openbravo.pos.admin.DataLogicAdmin;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.forms.BeanFactoryException;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.util.FilerUtils;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.NumericUtils;
import fr.protactile.glory.POSSimple.Collect;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.rmi.RemoteException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.scene.control.Alert;
import org.jdom.Element;

public class FCCClient
implements FCCConst {
    private static String namePos;
    BrueBoxServiceStub fcc = null;
    private int seqNumber;
    String lastId;
    private boolean cancelled = false;
    private boolean isDisable500 = true;
    private boolean isDisable200 = true;
    private boolean isDisable100 = true;
    private boolean isDisable50 = true;
    private boolean resetRequired = false;
    private boolean registred = false;
    public static HashMap<Integer, String> DEVICES_STATUS;
    Thread eventListenerGlory;
    private static FCCClient INSTANCE;
    SimpleDateFormat sdf1 = new SimpleDateFormat("yyMMdd");
    SimpleDateFormat sdf2 = new SimpleDateFormat("hhmmss");
    public static boolean has_advanced_functions_glory_permission;
    private static boolean has_functions_glory_permission;
    private EventHandleClass eventHandleClass;
    private String lastStatus;
    private int lastStatusInt = -1;
    private String sessionId;
    private boolean haveControl = false;
    private String gloryIp;
    private static String login;
    private static String password;
    private static IUserInterface currentView;
    Map<String, IUserInterface> recepientViews = new HashMap<String, IUserInterface>();
    BrueBoxServiceStub.InventoryResponseType inventory;
    private double amountIncompleteTransaction;
    private int seqNumberIncompleteTransaction;
    private static String userId;
    private static BrueBoxServiceStub.RequireVerifyInfosType gobjVerify;

    public static BrueBoxServiceStub.RequireVerifyInfosType getGobjVerify() {
        return gobjVerify;
    }

    public static void setGobjVerify(BrueBoxServiceStub.RequireVerifyInfosType gob) {
        gobjVerify = gob;
        if (gob != null) {
            currentView.SetVerifyInfo(gobjVerify);
        }
    }

    public double getAmountIncompleteTransaction() {
        return this.amountIncompleteTransaction;
    }

    public void setAmountAndSequeIncompleteTransaction(int sequenceNumber, double amountIncompleteTransaction) {
        this.amountIncompleteTransaction = amountIncompleteTransaction;
        this.seqNumberIncompleteTransaction = sequenceNumber;
    }

    public void setAmountIncompleteTransaction(double amountIncompleteTransaction) {
        this.amountIncompleteTransaction = amountIncompleteTransaction;
    }

    public int getSeqNumberIncompleteTransaction() {
        return this.seqNumberIncompleteTransaction;
    }

    public void setSeqNumberIncompleteTransaction(int seqNumberIncompleteTransaction) {
        this.seqNumberIncompleteTransaction = seqNumberIncompleteTransaction;
    }

    public BrueBoxServiceStub.InventoryResponseType getInventory() {
        return this.inventory;
    }

    public void setInventory(BrueBoxServiceStub.InventoryResponseType inventory) {
        this.inventory = inventory;
    }

    public FCCClient() {
        try {
            this.fcc = new BrueBoxServiceStub("http://192.168.0.25/axis2/services/BrueBoxService");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public FCCClient(String ip) {
        try {
            this.gloryIp = ip;
            this.fcc = new BrueBoxServiceStub("http://" + ip + "/axis2/services/BrueBoxService");
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Connexion au Monnayeur a \u00e9chou\u00e9.", 4000, NPosition.BOTTOM_RIGHT);
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean c) {
        this.cancelled = c;
    }

    private String getId() {
        Date date1 = new Date();
        this.lastId = namePos + this.sdf2.format(date1);
        return this.lastId;
    }

    public void addSequenceNumber() {
        ++this.seqNumber;
    }

    private String getSequenceNumber() {
        Date date1 = new Date();
        Object seqnum = this.sdf1.format(date1);
        DecimalFormat dFormat = new DecimalFormat("0000");
        seqnum = (String)seqnum + dFormat.format(this.seqNumber);
        return seqnum;
    }

    public BrueBoxServiceStub.StatusResponseType getStatus() throws RemoteException {
        BrueBoxServiceStub.StatusRequestType objStatusRequestType = new BrueBoxServiceStub.StatusRequestType();
        objStatusRequestType.setId(this.getId());
        objStatusRequestType.setSessionID(this.sessionId);
        objStatusRequestType.setSeqNo(this.getSequenceNumber());
        objStatusRequestType.setOption(new BrueBoxServiceStub.StatusOptionType());
        objStatusRequestType.getOption().setType(BigInteger.valueOf(0L));
        BrueBoxServiceStub.StatusRequest req = new BrueBoxServiceStub.StatusRequest();
        req.setStatusRequest(objStatusRequestType);
        BrueBoxServiceStub.StatusResponse res = this.fcc.getStatus(req);
        BrueBoxServiceStub.StatusResponseType objStatusResponseType = res.getStatusResponse();
        return objStatusResponseType;
    }

    public void getStatusAsync(BrueBoxServiceCallbackHandler callback) {
        try {
            BrueBoxServiceStub.StatusRequestType objStatusRequestType = new BrueBoxServiceStub.StatusRequestType();
            objStatusRequestType.setId(this.getId());
            objStatusRequestType.setSessionID(this.sessionId);
            objStatusRequestType.setSeqNo(this.getSequenceNumber());
            objStatusRequestType.setOption(new BrueBoxServiceStub.StatusOptionType());
            objStatusRequestType.getOption().setType(BigInteger.valueOf(1L));
            objStatusRequestType.setRequireVerification(new BrueBoxServiceStub.RequireVerificationType());
            objStatusRequestType.getRequireVerification().setType(BigInteger.valueOf(1L));
            BrueBoxServiceStub.StatusRequest req = new BrueBoxServiceStub.StatusRequest();
            req.setStatusRequest(objStatusRequestType);
            this.fcc.startgetStatus(req, callback);
        }
        catch (RemoteException ex) {
            ex.printStackTrace();
        }
    }

    public void updateInventory(BrueBoxServiceCallbackHandler callback) {
        if (this.takeControl()) {
            BrueBoxServiceStub.InventoryRequestType objInventoryRequestType = new BrueBoxServiceStub.InventoryRequestType();
            objInventoryRequestType.setId(this.getId());
            objInventoryRequestType.setSessionID(this.sessionId);
            objInventoryRequestType.setSeqNo(this.getSequenceNumber());
            objInventoryRequestType.setOption(new BrueBoxServiceStub.InventoryOptionType());
            objInventoryRequestType.getOption().setType(BigInteger.valueOf(0L));
            BrueBoxServiceStub.InventoryRequest req = new BrueBoxServiceStub.InventoryRequest();
            req.setInventoryRequest(objInventoryRequestType);
            try {
                this.fcc.startinventoryOperation(req, callback);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void registerEvent(int jikkiMode, BrueBoxServiceCallbackHandler callback) {
        String ipaddr = "192.168.1.1";
        try {
            Socket socket = new Socket();
            socket.connect(new InetSocketAddress(this.gloryIp, 80));
            System.out.println(socket.getLocalAddress());
            ipaddr = socket.getLocalAddress().getHostAddress();
            socket.close();
            System.out.println("ipaddr :" + ipaddr);
            BrueBoxServiceStub.RegisterEventRequestType objRegisterRequest = new BrueBoxServiceStub.RegisterEventRequestType();
            objRegisterRequest.setId(this.getId());
            objRegisterRequest.setSessionID(this.sessionId);
            objRegisterRequest.setSeqNo(this.getSequenceNumber());
            objRegisterRequest.setUrl(ipaddr);
            objRegisterRequest.setPort(BigInteger.valueOf(55561L));
            BrueBoxServiceStub.RegisterEventRequest req = new BrueBoxServiceStub.RegisterEventRequest();
            req.setRegisterEventRequest(objRegisterRequest);
            this.fcc._getServiceClient().getOptions().setTimeOutInMilliSeconds(40000L);
            this.fcc.startregisterEventOperation(req, callback);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public BrueBoxServiceStub.StartCashinResponseType beginDeposit() throws RemoteException {
        BrueBoxServiceStub.StartCashinRequestType objDepositRequest = new BrueBoxServiceStub.StartCashinRequestType();
        objDepositRequest.setId(this.getId());
        objDepositRequest.setSessionID(this.sessionId);
        objDepositRequest.setSeqNo(this.getSequenceNumber());
        BrueBoxServiceStub.StartCashinRequest req = new BrueBoxServiceStub.StartCashinRequest();
        req.setStartCashinRequest(objDepositRequest);
        BrueBoxServiceStub.StartCashinResponse res = this.fcc.startCashinOperation(req);
        return res.getStartCashinResponse();
    }

    public void beginDepositAsync(BrueBoxServiceCallbackHandler callback) {
        BrueBoxServiceStub.StartCashinRequestType objDepositRequest = new BrueBoxServiceStub.StartCashinRequestType();
        objDepositRequest.setId(this.getId());
        objDepositRequest.setSessionID(this.sessionId);
        objDepositRequest.setSeqNo(this.getSequenceNumber());
        BrueBoxServiceStub.StartCashinRequest req = new BrueBoxServiceStub.StartCashinRequest();
        req.setStartCashinRequest(objDepositRequest);
        try {
            this.fcc.startstartCashinOperation(req, callback);
        }
        catch (RemoteException ex) {
            ex.printStackTrace();
        }
    }

    public BrueBoxServiceStub.EndCashinResponseType endDeposit() throws RemoteException {
        BrueBoxServiceStub.EndCashinRequestType objEndCashinRequest = new BrueBoxServiceStub.EndCashinRequestType();
        objEndCashinRequest.setId(this.lastId);
        objEndCashinRequest.setSeqNo(this.getSequenceNumber());
        BrueBoxServiceStub.EndCashinRequest req = new BrueBoxServiceStub.EndCashinRequest();
        req.setEndCashinRequest(objEndCashinRequest);
        BrueBoxServiceStub.EndCashinResponse objEndCashinResponse = this.fcc.endCashinOperation(req);
        return objEndCashinResponse.getEndCashinResponse();
    }

    public void startChangeAsync(double amount, BrueBoxServiceCallbackHandler callback) {
        this.addSequenceNumber();
        BrueBoxServiceStub.ChangeRequestType objChangeRequestType = new BrueBoxServiceStub.ChangeRequestType();
        objChangeRequestType.setId(this.getId());
        objChangeRequestType.setSessionID(this.sessionId);
        System.out.println("getSequenceNumber " + this.getSequenceNumber());
        objChangeRequestType.setSeqNo(this.getSequenceNumber());
        int amountLong = (int)NumericUtils.round(amount * 100.0);
        objChangeRequestType.setAmount("" + amountLong);
        BrueBoxServiceStub.ChangeRequest req = new BrueBoxServiceStub.ChangeRequest();
        req.setChangeRequest(objChangeRequestType);
        try {
            this.fcc._getServiceClient().getOptions().setTimeOutInMilliSeconds(6000000L);
            this.fcc.startchangeOperation(req, callback);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public BrueBoxServiceStub.ChangeCancelResponseType cancelChangeOperation() throws RemoteException {
        BrueBoxServiceStub.ChangeCancelRequestType objChangeCancelRequest = new BrueBoxServiceStub.ChangeCancelRequestType();
        objChangeCancelRequest.setId(this.getId());
        objChangeCancelRequest.setSessionID(this.sessionId);
        objChangeCancelRequest.setSeqNo(this.getSequenceNumber());
        BrueBoxServiceStub.ChangeCancelRequest req = new BrueBoxServiceStub.ChangeCancelRequest();
        req.setChangeCancelRequest(objChangeCancelRequest);
        BrueBoxServiceStub.ChangeCancelResponse objChangeCancelResponse = this.fcc.changeCancelOperation(req);
        if (objChangeCancelResponse.getChangeCancelResponse().getResult().intValue() == 0) {
            this.setCancelled(true);
        }
        return objChangeCancelResponse.getChangeCancelResponse();
    }

    public void cancelCashInAsync(BrueBoxServiceCallbackHandler callback) {
        BrueBoxServiceStub.CashinCancelRequestType objCashinCancelRequest = new BrueBoxServiceStub.CashinCancelRequestType();
        objCashinCancelRequest.setId(this.getId());
        objCashinCancelRequest.setSessionID(this.sessionId);
        objCashinCancelRequest.setSeqNo(this.getSequenceNumber());
        BrueBoxServiceStub.CashinCancelRequest req = new BrueBoxServiceStub.CashinCancelRequest();
        req.setCashinCancelRequest(objCashinCancelRequest);
        try {
            this.fcc.startcashinCancelOperation(req, callback);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public BrueBoxServiceStub.CashinCancelResponseType cancelCashIn() throws RemoteException {
        BrueBoxServiceStub.CashinCancelRequestType objCashinCancelRequest = new BrueBoxServiceStub.CashinCancelRequestType();
        objCashinCancelRequest.setId(this.getId());
        objCashinCancelRequest.setSessionID(this.sessionId);
        objCashinCancelRequest.setSeqNo(this.getSequenceNumber());
        BrueBoxServiceStub.CashinCancelRequest req = new BrueBoxServiceStub.CashinCancelRequest();
        req.setCashinCancelRequest(objCashinCancelRequest);
        BrueBoxServiceStub.CashinCancelResponse res = this.fcc.cashinCancelOperation(req);
        return res.getCashinCancelResponse();
    }

    public void collectAll(int option, BrueBoxServiceCallbackHandler callback) {
        BrueBoxServiceStub.CollectRequestType objCollectRequest = new BrueBoxServiceStub.CollectRequestType();
        objCollectRequest.setId(this.getId());
        objCollectRequest.setSessionID(this.sessionId);
        objCollectRequest.setSeqNo(this.getSequenceNumber());
        objCollectRequest.setOption(new BrueBoxServiceStub.CollectOptionType());
        objCollectRequest.getOption().setType(BigInteger.valueOf(option));
        objCollectRequest.setMix(new BrueBoxServiceStub.CollectOptionType());
        objCollectRequest.getMix().setType(BigInteger.valueOf(1L));
        objCollectRequest.setCash(new BrueBoxServiceStub.CashType());
        objCollectRequest.getCash().setType(BigInteger.valueOf(5L));
        objCollectRequest.setPartial(new BrueBoxServiceStub.CollectPartialType());
        objCollectRequest.getPartial().setType(BigInteger.valueOf(1L));
        BrueBoxServiceStub.DenominationType[] dnm = new BrueBoxServiceStub.DenominationType[11];
        int[] fv = new int[]{1, 2, 5, 10, 20, 50, 100, 200, 500, 1000, 2000};
        for (int i = 0; i < fv.length; ++i) {
            dnm[i] = new BrueBoxServiceStub.DenominationType();
            dnm[i].setCc("EUR");
            dnm[i].setFv(BigInteger.valueOf(fv[i]));
            dnm[i].setDevid(BigInteger.valueOf(i < 8 ? 2L : 1L));
            dnm[i].setStatus(BigInteger.valueOf(0L));
            dnm[i].setPiece(BigInteger.valueOf(0L));
        }
        objCollectRequest.getCash().setDenomination(dnm);
        try {
            BrueBoxServiceStub.CollectRequest req = new BrueBoxServiceStub.CollectRequest();
            req.setCollectRequest(objCollectRequest);
            this.fcc._getServiceClient().getOptions().setTimeOutInMilliSeconds(300000L);
            this.fcc.startcollectOperation(req, callback);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void collectSurplus(List<Collect> collectList, int option, BrueBoxServiceCallbackHandler callback) {
        BrueBoxServiceStub.CollectRequestType objCollectRequest = new BrueBoxServiceStub.CollectRequestType();
        ArrayList denomiList = new ArrayList();
        objCollectRequest.setId(this.getId());
        objCollectRequest.setSessionID(this.sessionId);
        objCollectRequest.setSeqNo(this.getSequenceNumber());
        objCollectRequest.setOption(new BrueBoxServiceStub.CollectOptionType());
        objCollectRequest.getOption().setType(BigInteger.valueOf(option));
        objCollectRequest.setPartial(new BrueBoxServiceStub.CollectPartialType());
        objCollectRequest.getPartial().setType(BigInteger.valueOf(1L));
        objCollectRequest.setCash(new BrueBoxServiceStub.CashType());
        objCollectRequest.getCash().setType(BigInteger.valueOf(5L));
        collectList.stream().map(col -> {
            BrueBoxServiceStub.DenominationType objDenomi = new BrueBoxServiceStub.DenominationType();
            objDenomi = new BrueBoxServiceStub.DenominationType();
            objDenomi.setCc("EUR");
            BigInteger fvBI = BigInteger.valueOf(Long.valueOf(col.getFv()));
            objDenomi.setFv(fvBI);
            objDenomi.setDevid(BigInteger.valueOf(fvBI.intValue() < 500 ? 2L : 1L));
            objDenomi.setStatus(BigInteger.valueOf(0L));
            objDenomi.setPiece(new BigInteger("" + col.getPiece()));
            return objDenomi;
        }).map(objDenomi -> {
            System.out.println("___  objDenomi.getDevid" + objDenomi.getDevid() + "_____objDenomi.getPiece() : " + objDenomi.getPiece() + " bjDenomi.getFv()  " + objDenomi.getFv());
            return objDenomi;
        }).forEachOrdered(objDenomi -> denomiList.add(objDenomi));
        if (denomiList != null && !denomiList.isEmpty()) {
            objCollectRequest.getCash().setDenomination(denomiList.toArray(new BrueBoxServiceStub.DenominationType[denomiList.size()]));
        }
        try {
            BrueBoxServiceStub.CollectRequest req = new BrueBoxServiceStub.CollectRequest();
            req.setCollectRequest(objCollectRequest);
            this.fcc._getServiceClient().getOptions().setTimeOutInMilliSeconds(360000L);
            this.fcc.startcollectOperation(req, callback);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void collectToCst(List<Collect> collectList, int option, BrueBoxServiceCallbackHandler callback) {
        BrueBoxServiceStub.CollectRequestType objCollectRequest = new BrueBoxServiceStub.CollectRequestType();
        ArrayList denomiList = new ArrayList();
        objCollectRequest.setId(this.getId());
        objCollectRequest.setSessionID(this.sessionId);
        objCollectRequest.setSeqNo(this.getSequenceNumber());
        objCollectRequest.setOption(new BrueBoxServiceStub.CollectOptionType());
        objCollectRequest.getOption().setType(BigInteger.valueOf(0L));
        objCollectRequest.setCash(new BrueBoxServiceStub.CashType());
        objCollectRequest.getCash().setType(BigInteger.valueOf(5L));
        collectList.stream().map(col -> {
            BrueBoxServiceStub.DenominationType objDenomi = new BrueBoxServiceStub.DenominationType();
            objDenomi = new BrueBoxServiceStub.DenominationType();
            objDenomi.setCc("EUR");
            BigInteger fvBI = BigInteger.valueOf(Long.valueOf(col.getFv()));
            objDenomi.setFv(fvBI);
            objDenomi.setDevid(BigInteger.valueOf(fvBI.intValue() < 500 ? 2L : 1L));
            objDenomi.setStatus(BigInteger.valueOf(0L));
            objDenomi.setPiece(new BigInteger("" + col.getPiece()));
            return objDenomi;
        }).map(objDenomi -> {
            System.out.println("___  objDenomi.getDevid" + objDenomi.getDevid() + "_____objDenomi.getPiece() : " + objDenomi.getPiece() + " bjDenomi.getFv()  " + objDenomi.getFv());
            return objDenomi;
        }).forEachOrdered(objDenomi -> denomiList.add(objDenomi));
        if (denomiList != null && !denomiList.isEmpty()) {
            objCollectRequest.getCash().setDenomination(denomiList.toArray(new BrueBoxServiceStub.DenominationType[denomiList.size()]));
        }
        try {
            BrueBoxServiceStub.CollectRequest req = new BrueBoxServiceStub.CollectRequest();
            req.setCollectRequest(objCollectRequest);
            this.fcc._getServiceClient().getOptions().setTimeOutInMilliSeconds(6000000L);
            this.fcc.startcollectOperation(req, callback);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void collectVerification(BrueBoxServiceCallbackHandler callback) {
        BrueBoxServiceStub.CollectRequestType objCollectRequest = new BrueBoxServiceStub.CollectRequestType();
        objCollectRequest.setId(this.getId());
        objCollectRequest.setSessionID(this.sessionId);
        objCollectRequest.setSeqNo(this.getSequenceNumber());
        objCollectRequest.setOption(new BrueBoxServiceStub.CollectOptionType());
        objCollectRequest.getOption().setType(BigInteger.valueOf(0L));
        objCollectRequest.setRequireVerification(new BrueBoxServiceStub.RequireVerificationType());
        objCollectRequest.getRequireVerification().setType(BigInteger.ONE);
        objCollectRequest.setCash(new BrueBoxServiceStub.CashType());
        objCollectRequest.getCash().setType(BigInteger.valueOf(5L));
        try {
            BrueBoxServiceStub.CollectRequest req = new BrueBoxServiceStub.CollectRequest();
            req.setCollectRequest(objCollectRequest);
            this.fcc._getServiceClient().getOptions().setTimeOutInMilliSeconds(1800000L);
            this.fcc.startcollectOperation(req, callback);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void resetOperationAsync(BrueBoxServiceCallbackHandler callback) {
        BrueBoxServiceStub.ResetRequestType objResetRequestType = new BrueBoxServiceStub.ResetRequestType();
        objResetRequestType.setId(this.getId());
        objResetRequestType.setSeqNo(this.getSequenceNumber());
        objResetRequestType.setSessionID(this.sessionId);
        BrueBoxServiceStub.ResetRequest req = new BrueBoxServiceStub.ResetRequest();
        req.setResetRequest(objResetRequestType);
        try {
            this.fcc._getServiceClient().getOptions().setTimeOutInMilliSeconds(30000L);
            this.fcc.startresetOperation(req, callback);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public BrueBoxServiceStub.ResetResponseType resetOperation() throws RemoteException {
        BrueBoxServiceStub.ResetRequestType objResetRequestType = new BrueBoxServiceStub.ResetRequestType();
        objResetRequestType.setId(this.getId());
        objResetRequestType.setSessionID(this.sessionId);
        objResetRequestType.setSeqNo(this.getSequenceNumber());
        BrueBoxServiceStub.ResetRequest req = new BrueBoxServiceStub.ResetRequest();
        req.setResetRequest(objResetRequestType);
        BrueBoxServiceStub.ResetResponse res = this.fcc.resetOperation(req);
        return res.getResetResponse();
    }

    public BrueBoxServiceStub.PowerControlResponseType powerControlOperation(int type) throws RemoteException {
        this.registred = false;
        BrueBoxServiceStub.PowerControlRequestType objPowerControlRequestType = new BrueBoxServiceStub.PowerControlRequestType();
        objPowerControlRequestType.setId(this.getId());
        objPowerControlRequestType.setSessionID(this.sessionId);
        objPowerControlRequestType.setSeqNo(this.getSequenceNumber());
        objPowerControlRequestType.setOption(new BrueBoxServiceStub.PowerControlOptionType());
        objPowerControlRequestType.getOption().setType(BigInteger.valueOf(type));
        BrueBoxServiceStub.PowerControlRequest req = new BrueBoxServiceStub.PowerControlRequest();
        req.setPowerControlRequest(objPowerControlRequestType);
        BrueBoxServiceStub.PowerControlResponse res = this.fcc.powerControlOperation(req);
        return res.getPowerControlResponse();
    }

    public BrueBoxServiceStub.UnLockUnitResponseType unLockUnitOperation(int device) throws RemoteException {
        BrueBoxServiceStub.UnLockUnitRequestType objUnLockUnitRequestType = new BrueBoxServiceStub.UnLockUnitRequestType();
        objUnLockUnitRequestType.setId(this.getId());
        objUnLockUnitRequestType.setSessionID(this.sessionId);
        objUnLockUnitRequestType.setSeqNo(this.getSequenceNumber());
        objUnLockUnitRequestType.setOption(new BrueBoxServiceStub.UnLockUnitOptionType());
        objUnLockUnitRequestType.getOption().setType(BigInteger.valueOf(device));
        BrueBoxServiceStub.UnLockUnitRequest req = new BrueBoxServiceStub.UnLockUnitRequest();
        req.setUnLockUnitRequest(objUnLockUnitRequestType);
        BrueBoxServiceStub.UnLockUnitResponse res = this.fcc.unLockUnitOperation(req);
        return res.getUnLockUnitResponse();
    }

    public int openExitCover() throws RemoteException {
        BrueBoxServiceStub.OpenExitCoverRequestType objectRequest = new BrueBoxServiceStub.OpenExitCoverRequestType();
        objectRequest.setId(this.getId());
        objectRequest.setSessionID(this.sessionId);
        objectRequest.setSeqNo(this.getSequenceNumber());
        BrueBoxServiceStub.OpenExitCoverRequest req = new BrueBoxServiceStub.OpenExitCoverRequest();
        req.setOpenExitCoverRequest(objectRequest);
        BrueBoxServiceStub.OpenExitCoverResponse res = this.fcc.openExitCoverOperation(req);
        return res.getOpenExitCoverResponse().getResult().intValue();
    }

    public int closeExitCover() throws RemoteException {
        BrueBoxServiceStub.CloseExitCoverRequestType objectRequest = new BrueBoxServiceStub.CloseExitCoverRequestType();
        objectRequest.setId(this.getId());
        objectRequest.setSessionID(this.sessionId);
        objectRequest.setSeqNo(this.getSequenceNumber());
        BrueBoxServiceStub.CloseExitCoverRequest req = new BrueBoxServiceStub.CloseExitCoverRequest();
        req.setCloseExitCoverRequest(objectRequest);
        BrueBoxServiceStub.CloseExitCoverResponse res = this.fcc.closeExitCoverOperation(req);
        return res.getCloseExitCoverResponse().getResult().intValue();
    }

    public int rejectCoin() throws RemoteException {
        BrueBoxServiceStub.ReturnCashRequestType objectRequest = new BrueBoxServiceStub.ReturnCashRequestType();
        objectRequest.setId(this.getId());
        objectRequest.setSessionID(this.sessionId);
        objectRequest.setSeqNo(this.getSequenceNumber());
        objectRequest.setOption(new BrueBoxServiceStub.ReturnCashOptionType());
        objectRequest.getOption().setType(BigInteger.valueOf(2L));
        BrueBoxServiceStub.ReturnCashRequest req = new BrueBoxServiceStub.ReturnCashRequest();
        req.setReturnCashRequest(objectRequest);
        this.fcc._getServiceClient().getOptions().setTimeOutInMilliSeconds(30000L);
        BrueBoxServiceStub.ReturnCashResponse res = this.fcc.returnCashOperation(req);
        return res.getReturnCashResponse().getResult().intValue();
    }

    public void unlockUnitOperationAsync(BrueBoxServiceCallbackHandler callback) {
        BrueBoxServiceStub.UnLockUnitRequestType objUnLockUnitRequestType = new BrueBoxServiceStub.UnLockUnitRequestType();
        objUnLockUnitRequestType.setId(this.getId());
        objUnLockUnitRequestType.setSessionID(this.sessionId);
        objUnLockUnitRequestType.setSeqNo(this.getSequenceNumber());
        objUnLockUnitRequestType.setOption(new BrueBoxServiceStub.UnLockUnitOptionType());
        objUnLockUnitRequestType.getOption().setType(BigInteger.valueOf(1L));
        BrueBoxServiceStub.UnLockUnitRequest req = new BrueBoxServiceStub.UnLockUnitRequest();
        req.setUnLockUnitRequest(objUnLockUnitRequestType);
        try {
            this.fcc.startunLockUnitOperation(req, callback);
        }
        catch (RemoteException ex) {
            ex.printStackTrace();
        }
    }

    public void unlockUnitOperationAsyncRC(BrueBoxServiceCallbackHandler callback) {
        BrueBoxServiceStub.UnLockUnitRequestType objUnLockUnitRequestType = new BrueBoxServiceStub.UnLockUnitRequestType();
        objUnLockUnitRequestType.setId(this.getId());
        objUnLockUnitRequestType.setSessionID(this.sessionId);
        objUnLockUnitRequestType.setSeqNo(this.getSequenceNumber());
        objUnLockUnitRequestType.setOption(new BrueBoxServiceStub.UnLockUnitOptionType());
        objUnLockUnitRequestType.getOption().setType(BigInteger.valueOf(2L));
        BrueBoxServiceStub.UnLockUnitRequest req = new BrueBoxServiceStub.UnLockUnitRequest();
        req.setUnLockUnitRequest(objUnLockUnitRequestType);
        try {
            this.fcc.startunLockUnitOperation(req, callback);
        }
        catch (RemoteException ex) {
            ex.printStackTrace();
        }
    }

    public BrueBoxServiceStub.LockUnitResponseType lockUnitOperation(int device) throws RemoteException {
        System.out.println("__ time out:" + this.fcc._getServiceClient().getOptions().getTimeOutInMilliSeconds());
        BrueBoxServiceStub.LockUnitRequestType objLockUnitRequestType = new BrueBoxServiceStub.LockUnitRequestType();
        objLockUnitRequestType.setId(this.getId());
        objLockUnitRequestType.setSessionID(this.sessionId);
        objLockUnitRequestType.setSeqNo(this.getSequenceNumber());
        objLockUnitRequestType.setOption(new BrueBoxServiceStub.LockUnitOptionType());
        objLockUnitRequestType.getOption().setType(BigInteger.valueOf(device));
        BrueBoxServiceStub.LockUnitRequest req = new BrueBoxServiceStub.LockUnitRequest();
        req.setLockUnitRequest(objLockUnitRequestType);
        BrueBoxServiceStub.LockUnitResponse res = this.fcc.lockUnitOperation(req);
        return res.getLockUnitResponse();
    }

    public void lockUnitOperationAsync(BrueBoxServiceCallbackHandler callback) {
        BrueBoxServiceStub.LockUnitRequestType objLockUnitRequestType = new BrueBoxServiceStub.LockUnitRequestType();
        objLockUnitRequestType.setId(this.getId());
        objLockUnitRequestType.setSessionID(this.sessionId);
        objLockUnitRequestType.setSeqNo(this.getSequenceNumber());
        objLockUnitRequestType.setOption(new BrueBoxServiceStub.LockUnitOptionType());
        objLockUnitRequestType.getOption().setType(BigInteger.valueOf(1L));
        BrueBoxServiceStub.LockUnitRequest req = new BrueBoxServiceStub.LockUnitRequest();
        req.setLockUnitRequest(objLockUnitRequestType);
        try {
            this.fcc.startlockUnitOperation(req, callback);
        }
        catch (RemoteException ex) {
            ex.printStackTrace();
        }
    }

    public void lockUnitOperationAsyncRC(BrueBoxServiceCallbackHandler callback) {
        BrueBoxServiceStub.LockUnitRequestType objLockUnitRequestType = new BrueBoxServiceStub.LockUnitRequestType();
        objLockUnitRequestType.setId(this.getId());
        objLockUnitRequestType.setSessionID(this.sessionId);
        objLockUnitRequestType.setSeqNo(this.getSequenceNumber());
        objLockUnitRequestType.setOption(new BrueBoxServiceStub.LockUnitOptionType());
        objLockUnitRequestType.getOption().setType(BigInteger.valueOf(2L));
        BrueBoxServiceStub.LockUnitRequest req = new BrueBoxServiceStub.LockUnitRequest();
        req.setLockUnitRequest(objLockUnitRequestType);
        try {
            this.fcc.startlockUnitOperation(req, callback);
        }
        catch (RemoteException ex) {
            ex.printStackTrace();
        }
    }

    public BrueBoxServiceStub.RefreshSalesTotalResponseType refreshSalesTotalOperation(String amount) throws RemoteException {
        BrueBoxServiceStub.RefreshSalesTotalRequestType objRefreshSalesTotalRequestType = new BrueBoxServiceStub.RefreshSalesTotalRequestType();
        objRefreshSalesTotalRequestType.setId(this.getId());
        objRefreshSalesTotalRequestType.setSessionID(this.sessionId);
        objRefreshSalesTotalRequestType.setSeqNo(this.getSequenceNumber());
        objRefreshSalesTotalRequestType.setAmount(amount);
        BrueBoxServiceStub.RefreshSalesTotalRequest req = new BrueBoxServiceStub.RefreshSalesTotalRequest();
        req.setRefreshSalesTotalRequest(objRefreshSalesTotalRequestType);
        BrueBoxServiceStub.RefreshSalesTotalResponse res = this.fcc.refreshSalesTotalOperation(req);
        return res.getRefreshSalesTotalResponse();
    }

    public BrueBoxServiceStub.StartReplenishmentFromEntranceResponseType startRepFEOperation() throws RemoteException {
        BrueBoxServiceStub.StartReplenishmentFromEntranceRequestType objStartRepFERequest = new BrueBoxServiceStub.StartReplenishmentFromEntranceRequestType();
        objStartRepFERequest.setId(this.getId());
        objStartRepFERequest.setSessionID(this.sessionId);
        objStartRepFERequest.setSeqNo(this.getSequenceNumber());
        BrueBoxServiceStub.StartReplenishmentFromEntranceRequest req = new BrueBoxServiceStub.StartReplenishmentFromEntranceRequest();
        req.setStartReplenishmentFromEntranceRequest(objStartRepFERequest);
        BrueBoxServiceStub.StartReplenishmentFromEntranceResponse res = this.fcc.startReplenishmentFromEntranceOperation(req);
        return res.getStartReplenishmentFromEntranceResponse();
    }

    public BrueBoxServiceStub.EndReplenishmentFromEntranceResponseType endRepFEOperation() throws RemoteException {
        BrueBoxServiceStub.EndReplenishmentFromEntranceRequestType objEndRepFERequest = new BrueBoxServiceStub.EndReplenishmentFromEntranceRequestType();
        objEndRepFERequest.setId(this.getId());
        objEndRepFERequest.setSessionID(this.sessionId);
        objEndRepFERequest.setSeqNo(this.getSequenceNumber());
        BrueBoxServiceStub.EndReplenishmentFromEntranceRequest req = new BrueBoxServiceStub.EndReplenishmentFromEntranceRequest();
        req.setEndReplenishmentFromEntranceRequest(objEndRepFERequest);
        this.fcc._getServiceClient().getOptions().setTimeOutInMilliSeconds(300000L);
        BrueBoxServiceStub.EndReplenishmentFromEntranceResponse res = this.fcc.endReplenishmentFromEntranceOperation(req);
        return res.getEndReplenishmentFromEntranceResponse();
    }

    public BrueBoxServiceStub.ReplenishmentFromEntranceCancelResponseType cancelRepFEOperation() throws RemoteException {
        BrueBoxServiceStub.ReplenishmentFromEntranceCancelRequestType objCancelRepFERequest = new BrueBoxServiceStub.ReplenishmentFromEntranceCancelRequestType();
        objCancelRepFERequest.setId(this.getId());
        objCancelRepFERequest.setSessionID(this.sessionId);
        objCancelRepFERequest.setSeqNo(this.getSequenceNumber());
        BrueBoxServiceStub.ReplenishmentFromEntranceCancelRequest req = new BrueBoxServiceStub.ReplenishmentFromEntranceCancelRequest();
        req.setReplenishmentFromEntranceCancelRequest(objCancelRepFERequest);
        this.setTimeOutInMilliSeconds(30000);
        BrueBoxServiceStub.ReplenishmentFromEntranceCancelResponse res = this.fcc.replenishmentFromEntranceCancelOperation(req);
        return res.getReplenishmentFromEntranceCancelResponse();
    }

    public void cancelRepFEOperation(BrueBoxServiceCallbackHandler callback) throws RemoteException {
        BrueBoxServiceStub.ReplenishmentFromEntranceCancelRequestType objCancelRepFERequest = new BrueBoxServiceStub.ReplenishmentFromEntranceCancelRequestType();
        objCancelRepFERequest.setId(this.getId());
        objCancelRepFERequest.setSessionID(this.sessionId);
        objCancelRepFERequest.setSeqNo(this.getSequenceNumber());
        BrueBoxServiceStub.ReplenishmentFromEntranceCancelRequest req = new BrueBoxServiceStub.ReplenishmentFromEntranceCancelRequest();
        req.setReplenishmentFromEntranceCancelRequest(objCancelRepFERequest);
        this.fcc._getServiceClient().getOptions().setTimeOutInMilliSeconds(1200000L);
        this.fcc.startreplenishmentFromEntranceCancelOperation(req, callback);
    }

    public BrueBoxServiceStub.StartReplenishmentFromCassetteResponseType startRepFCOperation() throws RemoteException {
        BrueBoxServiceStub.StartReplenishmentFromCassetteRequestType objStartRepFCRequestType = new BrueBoxServiceStub.StartReplenishmentFromCassetteRequestType();
        objStartRepFCRequestType.setId(this.getId());
        objStartRepFCRequestType.setSessionID(this.sessionId);
        objStartRepFCRequestType.setSeqNo(this.getSequenceNumber());
        BrueBoxServiceStub.StartReplenishmentFromCassetteRequest req = new BrueBoxServiceStub.StartReplenishmentFromCassetteRequest();
        req.setStartReplenishmentFromCassetteRequest(objStartRepFCRequestType);
        BrueBoxServiceStub.StartReplenishmentFromCassetteResponse res = this.fcc.startReplenishmentFromCassetteOperation(req);
        return res.getStartReplenishmentFromCassetteResponse();
    }

    public BrueBoxServiceStub.EndReplenishmentFromCassetteResponseType endRepFCOperation() throws RemoteException {
        BrueBoxServiceStub.EndReplenishmentFromCassetteRequestType objEndRepFCRequestType = new BrueBoxServiceStub.EndReplenishmentFromCassetteRequestType();
        objEndRepFCRequestType.setId(this.getId());
        objEndRepFCRequestType.setSessionID(this.sessionId);
        objEndRepFCRequestType.setSeqNo(this.getSequenceNumber());
        BrueBoxServiceStub.EndReplenishmentFromCassetteRequest req = new BrueBoxServiceStub.EndReplenishmentFromCassetteRequest();
        req.setEndReplenishmentFromCassetteRequest(objEndRepFCRequestType);
        BrueBoxServiceStub.EndReplenishmentFromCassetteResponse res = this.fcc.endReplenishmentFromCassetteOperation(req);
        return res.getEndReplenishmentFromCassetteResponse();
    }

    public void updateManualDepositTotalOperationAsync(BrueBoxServiceCallbackHandler callback) {
        System.out.println(" amountIncompleteTransaction " + this.amountIncompleteTransaction);
        BigInteger amount = BigInteger.valueOf((long)(this.amountIncompleteTransaction * 100.0));
        System.out.println(" amount " + amount);
        BrueBoxServiceStub.CurrencyType currency = new BrueBoxServiceStub.CurrencyType();
        currency.setCc("EUR");
        currency.setFv(amount);
        currency.setType(BigInteger.ZERO);
        currency.setPiece(BigInteger.ONE);
        BrueBoxServiceStub.CurrencyType[] currencyArray = new BrueBoxServiceStub.CurrencyType[]{currency};
        BrueBoxServiceStub.UpdateManualDepositTotalRequestType objUpdateManualDepositTotalRequestType = new BrueBoxServiceStub.UpdateManualDepositTotalRequestType();
        objUpdateManualDepositTotalRequestType.setId(this.getId());
        objUpdateManualDepositTotalRequestType.setSessionID(this.sessionId);
        objUpdateManualDepositTotalRequestType.setSeqNo(this.getSequenceNumber());
        objUpdateManualDepositTotalRequestType.setAmount(String.valueOf(amount));
        objUpdateManualDepositTotalRequestType.setDepositCurrency(new BrueBoxServiceStub.DepositCurrencyType());
        objUpdateManualDepositTotalRequestType.getDepositCurrency().setCurrency(currencyArray);
        BrueBoxServiceStub.UpdateManualDepositTotalRequest req = new BrueBoxServiceStub.UpdateManualDepositTotalRequest();
        req.setUpdateManualDepositTotalRequest(objUpdateManualDepositTotalRequestType);
        try {
            this.fcc.startupdateManualDepositTotalOperation(req, callback);
        }
        catch (RemoteException ex) {
            ex.printStackTrace();
        }
    }

    public void setTimeOutInMilliSeconds(int i) {
        this.fcc._getServiceClient().getOptions().setTimeOutInMilliSeconds((long)i);
    }

    public Thread registerAdjustTimeAndGetStatus(final IUserInterface iu) {
        currentView = iu;
        System.out.println("******* registred :" + this.registred);
        if (!this.registred) {
            if (this.takeControl()) {
                this.registerEvent(1, new BrueBoxServiceCallbackHandler(){

                    @Override
                    public void receiveErrorregisterEventOperation(Exception e) {
                        FCCClient.this.releaseControl();
                    }

                    @Override
                    public void receiveResultregisterEventOperation(BrueBoxServiceStub.RegisterEventResponse result) {
                        BrueBoxServiceStub.RegisterEventResponseType response = result.getRegisterEventResponse();
                        if (response.getResult().intValue() == 0) {
                            FCCClient.this.registred = true;
                            FCCClient.this.eventHandleClass = new EventHandleClass(iu);
                            System.out.println("**** eventHandleClass :" + FCCClient.this.eventHandleClass);
                            FCCClient.this.eventListenerGlory = new Thread(FCCClient.this.eventHandleClass);
                            FCCClient.this.eventListenerGlory.start();
                            FCCClient.this.adjustTime();
                            iu.getGloryStatus();
                            FCCClient.this.recepientViews.put(iu.getCurrentViewName(), iu);
                        } else {
                            new NotifyWindow(NotifyType.WARNING_NOTIFICATION, "Abonnement aux notifications du Monnayeur a \u00e9chou\u00e9.", 4000, NPosition.BOTTOM_RIGHT);
                        }
                    }
                });
                return this.eventListenerGlory;
            }
            this.registred = false;
            new NotifyWindow(NotifyType.WARNING_NOTIFICATION, "Abonnement aux notifications du Monnayeur a \u00e9chou\u00e9.", 4000, NPosition.BOTTOM_RIGHT);
        } else {
            EventHandleClass.setpFrm(iu);
            this.recepientViews.put(iu.getCurrentViewName(), iu);
        }
        return this.eventListenerGlory;
    }

    public void stopLestening() {
        this.unRegisterEvent();
        if (this.eventHandleClass != null) {
            this.eventHandleClass.stop();
            this.eventHandleClass = null;
        }
    }

    public static FCCClient getFccInstance() {
        if (INSTANCE == null) {
            AppView m_App = (AppView)BasicStorage.getObject("APP_ROOT_INSTANCE");
            String gloryIp = m_App.getProperties().getProperty("module.glory.ip");
            login = m_App.getProperties().getProperty("module.glory.login");
            password = m_App.getProperties().getProperty("module.glory.password");
            namePos = AppLocal.host_name != null && AppLocal.host_name.length() >= 4 ? AppLocal.host_name.substring(0, 3) : AppLocal.host_name;
            FCCClient.loadPermissions();
            INSTANCE = new FCCClient(gloryIp);
            System.out.println("********INSTANCE :" + INSTANCE);
        }
        return INSTANCE;
    }

    public static void loadPermissions() throws BeanFactoryException {
        AppView m_App = (AppView)BasicStorage.getObject("APP_ROOT_INSTANCE");
        System.out.println("loadPermissions  user courant" + m_App.getAppUserView().getUser().getId());
        System.out.println("loadPermissions  user ols" + userId);
        if (!(m_App.getAppUserView() == null || m_App.getAppUserView().getUser() == null || userId != null && userId.equals(m_App.getAppUserView().getUser().getId()))) {
            userId = m_App.getAppUserView().getUser().getId();
            System.out.println("loadPermissions  user changed");
            try {
                has_functions_glory_permission = ((DataLogicAdmin)m_App.getBean("com.openbravo.pos.admin.DataLogicAdmin")).hasPermission(m_App.getAppUserView().getUser().getId(), "8");
                has_advanced_functions_glory_permission = ((DataLogicAdmin)m_App.getBean("com.openbravo.pos.admin.DataLogicAdmin")).hasPermission(m_App.getAppUserView().getUser().getId(), "9") || "0".equals(m_App.getAppUserView().getUser().getRole());
            }
            catch (BasicException ex) {
                ex.printStackTrace();
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    public boolean isMyTransaction(String id) {
        return id.substring(0, namePos.length()).equals(namePos.substring(0, namePos.length()));
    }

    public void unRegisterEvent() {
        if (this.registred && this.takeControl()) {
            try {
                String ipaddr = "";
                Socket socket = new Socket();
                socket.connect(new InetSocketAddress(this.gloryIp, 80));
                System.out.println(socket.getLocalAddress());
                ipaddr = socket.getLocalAddress().getHostAddress();
                socket.close();
                BrueBoxServiceStub.UnRegisterEventRequestType objRegisterRequest = new BrueBoxServiceStub.UnRegisterEventRequestType();
                objRegisterRequest.setId(this.getId());
                objRegisterRequest.setSessionID(this.sessionId);
                objRegisterRequest.setSeqNo(this.getSequenceNumber());
                objRegisterRequest.setUrl(ipaddr);
                objRegisterRequest.setPort(BigInteger.valueOf(55561L));
                BrueBoxServiceStub.UnRegisterEventRequest req = new BrueBoxServiceStub.UnRegisterEventRequest();
                req.setUnRegisterEventRequest(objRegisterRequest);
                this.fcc.unRegisterEventOperation(req);
                this.registred = false;
                this.releaseControl();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public BrueBoxServiceStub.DenominationType[] getCashDenomiArrayFromNodeListDenomi(List<Element> nodeListDenomi) throws NumberFormatException {
        int nodeDenomiCnt = 0;
        BrueBoxServiceStub.DenominationType[] cashDenomiArray = new BrueBoxServiceStub.DenominationType[nodeListDenomi.size()];
        for (Element nodeDenomi : nodeListDenomi) {
            BrueBoxServiceStub.DenominationType cashDenomi = new BrueBoxServiceStub.DenominationType();
            cashDenomi.setCc(nodeDenomi.getAttributeValue("cc"));
            cashDenomi.setFv(BigInteger.valueOf(Long.parseLong(nodeDenomi.getAttributeValue("fv"))));
            cashDenomi.setRev(BigInteger.valueOf(Long.parseLong(nodeDenomi.getAttributeValue("rev"))));
            cashDenomi.setDevid(BigInteger.valueOf(Long.parseLong(nodeDenomi.getAttributeValue("devid"))));
            cashDenomi.setPiece(BigInteger.valueOf(Long.parseLong(nodeDenomi.getChild("Piece").getText())));
            cashDenomi.setStatus(BigInteger.valueOf(Long.parseLong(nodeDenomi.getChild("Status").getText())));
            cashDenomiArray[nodeDenomiCnt] = cashDenomi;
            ++nodeDenomiCnt;
        }
        return cashDenomiArray;
    }

    public void extractMoney(double amount, List<Collect> collectList, BrueBoxServiceCallbackHandler callback) {
        int amountLong = (int)NumericUtils.round(amount * 100.0);
        if (FCCClient.getFccInstance().takeControl() && this.exclusiveMatrice("change")) {
            BrueBoxServiceStub.ChangeRequestType objChangeRequestType = new BrueBoxServiceStub.ChangeRequestType();
            objChangeRequestType.setId(this.getId());
            objChangeRequestType.setSessionID(this.sessionId);
            objChangeRequestType.setSeqNo(this.getSequenceNumber());
            objChangeRequestType.setCash(new BrueBoxServiceStub.CashType());
            if (collectList != null) {
                collectList.stream().map(col -> {
                    BrueBoxServiceStub.DenominationType objDenomi = new BrueBoxServiceStub.DenominationType();
                    objDenomi = new BrueBoxServiceStub.DenominationType();
                    objDenomi.setCc("EUR");
                    BigInteger fvBI = BigInteger.valueOf(Long.valueOf(col.getFv()));
                    objDenomi.setFv(fvBI);
                    objDenomi.setDevid(BigInteger.valueOf(fvBI.intValue() < 500 ? 2L : 1L));
                    objDenomi.setStatus(BigInteger.ZERO);
                    objDenomi.setPiece(new BigInteger("" + col.getPiece()));
                    return objDenomi;
                }).map(objDenomi -> objDenomi).forEachOrdered(objDenomi -> objChangeRequestType.getCash().addDenomination((BrueBoxServiceStub.DenominationType)objDenomi));
            }
            objChangeRequestType.setAmount(Double.toString(-Math.abs(amountLong)));
            BrueBoxServiceStub.ChangeRequest req = new BrueBoxServiceStub.ChangeRequest();
            req.setChangeRequest(objChangeRequestType);
            try {
                this.fcc._getServiceClient().getOptions().setTimeOutInMilliSeconds(10000L);
                this.fcc.startchangeOperation(req, callback);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public int openRequest() throws RemoteException {
        BrueBoxServiceStub.OpenRequestType objectRequest = new BrueBoxServiceStub.OpenRequestType();
        objectRequest.setId(this.getId());
        objectRequest.setDeviceName(AppLocal.token);
        objectRequest.setUser(login);
        objectRequest.setUserPwd(password);
        objectRequest.setSeqNo(this.getSequenceNumber());
        BrueBoxServiceStub.OpenRequest req = new BrueBoxServiceStub.OpenRequest();
        req.setOpenRequest(objectRequest);
        this.fcc._getServiceClient().getOptions().setTimeOutInMilliSeconds(5000L);
        BrueBoxServiceStub.OpenResponse res = this.fcc.openOperation(req);
        this.sessionId = res.getOpenResponse().getSessionID();
        System.out.println("objectRequest :" + objectRequest);
        System.out.println("session ID " + this.sessionId);
        System.out.println("res.getOpenResponse().getResult().intValue() ID " + res.getOpenResponse().getResult().intValue());
        return res.getOpenResponse().getResult().intValue();
    }

    public int occupyRequest() throws RemoteException {
        BrueBoxServiceStub.OccupyRequestType objectRequest = new BrueBoxServiceStub.OccupyRequestType();
        objectRequest.setId(this.getId());
        objectRequest.setSeqNo(this.getSequenceNumber());
        objectRequest.setSessionID(this.sessionId);
        BrueBoxServiceStub.OccupyRequest req = new BrueBoxServiceStub.OccupyRequest();
        req.setOccupyRequest(objectRequest);
        BrueBoxServiceStub.OccupyResponse res = this.fcc.occupyOperation(req);
        return res.getOccupyResponse().getResult().intValue();
    }

    public int releaseRequest() throws RemoteException {
        BrueBoxServiceStub.ReleaseRequestType objectRequest = new BrueBoxServiceStub.ReleaseRequestType();
        objectRequest.setId(this.getId());
        objectRequest.setSeqNo(this.getSequenceNumber());
        objectRequest.setSessionID(this.sessionId);
        BrueBoxServiceStub.ReleaseRequest req = new BrueBoxServiceStub.ReleaseRequest();
        req.setReleaseRequest(objectRequest);
        BrueBoxServiceStub.ReleaseResponse res = this.fcc.releaseOperation(req);
        return res.getReleaseResponse().getResult().intValue();
    }

    public int closeRequest() throws RemoteException {
        BrueBoxServiceStub.CloseRequestType objectRequest = new BrueBoxServiceStub.CloseRequestType();
        objectRequest.setId(this.getId());
        objectRequest.setSeqNo(this.getSequenceNumber());
        objectRequest.setSessionID(this.sessionId);
        BrueBoxServiceStub.CloseRequest req = new BrueBoxServiceStub.CloseRequest();
        req.setCloseRequest(objectRequest);
        BrueBoxServiceStub.CloseResponse res = this.fcc.closeOperation(req);
        this.sessionId = "";
        return res.getCloseResponse().getResult().intValue();
    }

    public boolean takeControl() {
        try {
            int result = this.openRequest();
            switch (result) {
                case 0: {
                    int re = this.occupyRequest();
                    System.out.println("+++++++++++++occupyRequest re :" + re);
                    if (re != 0 && re != 17) break;
                    this.haveControl = true;
                    return true;
                }
                case 15: {
                    this.getCurrentView().setGuidance("Authentification de L'utilisateur a \u00e9chou\u00e9.", -1);
                    break;
                }
                case 16: {
                    this.getCurrentView().setGuidance("Session a \u00e9t\u00e9 exp\u00e9r\u00e9.", -1);
                    break;
                }
                case 20: {
                    new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Session non valid.", 4000, NPosition.BOTTOM_LEFT);
                    this.getCurrentView().setGuidance("Session non valid.", -1);
                    break;
                }
                case 99: {
                    new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Erreur interne", 4000, NPosition.BOTTOM_LEFT);
                }
            }
        }
        catch (RemoteException ex) {
            GloryController.showMessageDialogue(Alert.AlertType.ERROR, "La connexion au monnayeur a \u00e9chou\u00e9.\n* V\u00e9rifier est ce que le monnayeur est allum\u00e9;\n* V\u00e9rifier la connectivit\u00e9 du monnayeur ;");
            this.getCurrentView().setGuidance(this.getCurrentView().getStatusString(22), 22);
        }
        this.haveControl = false;
        return false;
    }

    public void releaseControl() {
        try {
            this.haveControl = false;
            this.releaseRequest();
            this.closeRequest();
        }
        catch (RemoteException ex) {
            Logger.getLogger(FCCClient.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static boolean isInstanceNull() {
        return INSTANCE == null;
    }

    public void adjustTime() {
        try {
            Calendar cal = Calendar.getInstance();
            BrueBoxServiceStub.AdjustTimeRequestType objectRequest = new BrueBoxServiceStub.AdjustTimeRequestType();
            objectRequest.setId(this.getId());
            objectRequest.setSeqNo(this.getSequenceNumber());
            objectRequest.setSessionID(this.sessionId);
            BrueBoxServiceStub.AdjustTimeDateType dateType = new BrueBoxServiceStub.AdjustTimeDateType();
            dateType.setDay(BigInteger.valueOf(cal.get(5)));
            dateType.setMonth(BigInteger.valueOf(cal.get(2)));
            dateType.setYear(BigInteger.valueOf(cal.get(1)));
            objectRequest.setDate(dateType);
            BrueBoxServiceStub.AdjustTimeTimeType timetype = new BrueBoxServiceStub.AdjustTimeTimeType();
            timetype.setHour(BigInteger.valueOf(cal.get(11)));
            timetype.setMinute(BigInteger.valueOf(cal.get(12)));
            timetype.setSecond(BigInteger.valueOf(cal.get(13)));
            objectRequest.setTime(timetype);
            BrueBoxServiceStub.AdjustTimeRequest req = new BrueBoxServiceStub.AdjustTimeRequest();
            req.setAdjustTimeRequest(objectRequest);
            BrueBoxServiceStub.AdjustTimeResponse adjustTimeResponse = this.fcc.adjustTimeOperation(req);
        }
        catch (RemoteException ex) {
            Logger.getLogger(FCCClient.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public boolean isListenerRunning() {
        System.out.println("********** eventHandleClass" + this.eventHandleClass);
        if (this.eventHandleClass == null) {
            return false;
        }
        return this.eventHandleClass.isRunning();
    }

    public void setToNotRunning() {
        if (this.eventHandleClass != null) {
            this.eventHandleClass.setIsRunning(false);
        }
    }

    public String getLastId() {
        return this.lastId;
    }

    public void setLastId(String lastId) {
        this.lastId = lastId;
    }

    public boolean isRegistred() {
        return this.registred;
    }

    public void setRegistred(boolean registred) {
        this.registred = registred;
    }

    public String getGloryIp() {
        return this.gloryIp;
    }

    public void setGloryIp(String gloryIp) {
        this.gloryIp = gloryIp;
    }

    public static String getLogin() {
        return login;
    }

    public static void setLogin(String login) {
        FCCClient.login = login;
    }

    public static String getPassword() {
        return password;
    }

    public static void setPassword(String password) {
        FCCClient.password = password;
    }

    public String getLastStatus() {
        return this.lastStatus;
    }

    public void setLastStatus(String lastStatus) {
        this.lastStatus = lastStatus;
    }

    public IUserInterface getCurrentView() {
        return currentView;
    }

    public void setCurrentView(IUserInterface currentView) {
        FCCClient.currentView = currentView;
    }

    public boolean isResetRequired() {
        return this.resetRequired;
    }

    public void setResetRequired(boolean resetRequired) {
        this.resetRequired = resetRequired;
    }

    public void setAllViewGuidance(String msg, int code) {
        IUserInterface controller = this.recepientViews.get("Controller");
        if (controller != null) {
            controller.setGuidance(msg, code);
        }
    }

    public void basculToPrincipalView() {
        Controller controller = (Controller)this.recepientViews.get("Controller");
        if (controller != null) {
            controller.enableGloryListener();
        }
    }

    public int getSeqNumber() {
        return this.seqNumber;
    }

    public void setSeqNumber(int seqNumber) {
        this.seqNumber = seqNumber;
    }

    public void enableDenomination(Integer ... denominations) throws RemoteException {
        ArrayList<BrueBoxServiceStub.DenominationType> denominationsToEnable = new ArrayList<BrueBoxServiceStub.DenominationType>();
        Integer[] integerArray = denominations;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int denomination = integerArray[i];
            boolean disabled = this.isDenominationDisabled(denomination);
            if (!disabled) continue;
            BrueBoxServiceStub.DenominationType objDenomi = new BrueBoxServiceStub.DenominationType();
            objDenomi.setCc("EUR");
            BigInteger fvBI = BigInteger.valueOf(denomination * 100);
            objDenomi.setFv(fvBI);
            objDenomi.setDevid(BigInteger.valueOf(1L));
            objDenomi.setStatus(BigInteger.ZERO);
            objDenomi.setPiece(BigInteger.ZERO);
            denominationsToEnable.add(objDenomi);
        }
        if (!denominationsToEnable.isEmpty() && this.takeControl()) {
            BrueBoxServiceStub.EnableDenomRequestType objectRequest = new BrueBoxServiceStub.EnableDenomRequestType();
            objectRequest.setId(this.getId());
            objectRequest.setSeqNo(this.getSequenceNumber());
            objectRequest.setSessionID(this.sessionId);
            BrueBoxServiceStub.CashType cash = new BrueBoxServiceStub.CashType();
            cash.setDenomination(denominationsToEnable.toArray(new BrueBoxServiceStub.DenominationType[denominationsToEnable.size()]));
            objectRequest.setCash(cash);
            BrueBoxServiceStub.EnableDenomRequest req = new BrueBoxServiceStub.EnableDenomRequest();
            req.setEnableDenomRequest(objectRequest);
            BrueBoxServiceStub.EnableDenomResponse res = this.fcc.enableDenomOperation(req);
            this.releaseControl();
            if (res.getEnableDenomResponse().getResult().intValue() == 0) {
                this.togleDenomination(denominationsToEnable);
            }
        }
    }

    private void togleDenomination(List<BrueBoxServiceStub.DenominationType> denominationsToEnable) {
        for (BrueBoxServiceStub.DenominationType denomination : denominationsToEnable) {
            switch (denomination.getFv().intValue() / 100) {
                case 50: {
                    this.isDisable50 = !this.isDisable50;
                    break;
                }
                case 100: {
                    this.isDisable100 = !this.isDisable100;
                    break;
                }
                case 200: {
                    this.isDisable200 = !this.isDisable200;
                    break;
                }
                case 500: {
                    this.isDisable500 = !this.isDisable500;
                }
            }
        }
    }

    public void disableDenomination(Integer ... denominations) throws RemoteException {
        ArrayList<BrueBoxServiceStub.DenominationType> denominationsToDisable = new ArrayList<BrueBoxServiceStub.DenominationType>();
        Integer[] integerArray = denominations;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int denomination = integerArray[i];
            boolean disabled = this.isDenominationDisabled(denomination);
            if (disabled) continue;
            BrueBoxServiceStub.DenominationType objDenomi = new BrueBoxServiceStub.DenominationType();
            objDenomi.setCc("EUR");
            BigInteger fvBI = BigInteger.valueOf(denomination * 100);
            objDenomi.setFv(fvBI);
            objDenomi.setDevid(BigInteger.valueOf(1L));
            objDenomi.setStatus(BigInteger.ZERO);
            objDenomi.setPiece(BigInteger.ZERO);
            denominationsToDisable.add(objDenomi);
        }
        if (!denominationsToDisable.isEmpty() && this.takeControl()) {
            BrueBoxServiceStub.DisableDenomRequestType objectRequest = new BrueBoxServiceStub.DisableDenomRequestType();
            objectRequest.setId(this.getId());
            objectRequest.setSeqNo(this.getSequenceNumber());
            objectRequest.setSessionID(this.sessionId);
            BrueBoxServiceStub.CashType cash = new BrueBoxServiceStub.CashType();
            cash.setDenomination(denominationsToDisable.toArray(new BrueBoxServiceStub.DenominationType[denominationsToDisable.size()]));
            objectRequest.setCash(cash);
            BrueBoxServiceStub.DisableDenomRequest req = new BrueBoxServiceStub.DisableDenomRequest();
            req.setDisableDenomRequest(objectRequest);
            BrueBoxServiceStub.DisableDenomResponse res = this.fcc.disableDenomOperation(req);
            this.releaseControl();
            if (res.getDisableDenomResponse().getResult().intValue() == 0) {
                this.togleDenomination(denominationsToDisable);
            }
        }
    }

    private boolean isDenominationDisabled(int denomination) {
        boolean disabled = false;
        switch (denomination) {
            case 50: {
                disabled = this.isDisable50;
                break;
            }
            case 100: {
                disabled = this.isDisable100;
                break;
            }
            case 200: {
                disabled = this.isDisable200;
                break;
            }
            case 500: {
                disabled = this.isDisable500;
            }
        }
        return disabled;
    }

    public void disableEnableDenomination(List<Integer> denominationsToDisable, List<Integer> denominationsToEnable) throws RemoteException {
        this.enableDenomination(denominationsToEnable.toArray(new Integer[denominationsToEnable.size()]));
        this.disableDenomination(denominationsToDisable.toArray(new Integer[denominationsToDisable.size()]));
    }

    public String getdisabledBigNotes() {
        StringBuilder builder = new StringBuilder();
        String separator = "";
        if (this.isDisable50) {
            builder.append(separator).append("50\u20ac");
            separator = " , ";
        }
        if (this.isDisable100) {
            builder.append(separator).append("100\u20ac");
            separator = " , ";
        }
        if (this.isDisable200) {
            builder.append(separator).append("200\u20ac");
            separator = " , ";
        }
        if (this.isDisable500) {
            builder.append(separator).append("500\u20ac");
            separator = " , ";
        }
        if (separator.equals("")) {
            return null;
        }
        builder.insert(0, "Billets d\u00e9sactiv\u00e9s: ");
        return builder.toString();
    }

    public static boolean isHas_advanced_functions_glory_permission() {
        return has_advanced_functions_glory_permission;
    }

    public static void setHas_advanced_functions_glory_permission(boolean has_advanced_functions_glory_permission) {
        FCCClient.has_advanced_functions_glory_permission = has_advanced_functions_glory_permission;
    }

    public static boolean isHas_functions_glory_permission() {
        return has_functions_glory_permission;
    }

    public static void setHas_functions_glory_permission(boolean has_functions_glory_permission) {
        FCCClient.has_functions_glory_permission = has_functions_glory_permission;
    }

    public Properties getFondGloryProperties() {
        try {
            File clairPropertiesFile = FilerUtils.getInstance().getFileFondGloryProperties();
            Properties prop = new Properties();
            if (clairPropertiesFile.exists()) {
                FileInputStream input = new FileInputStream(clairPropertiesFile);
                prop.load(input);
            }
            return prop;
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(FCCClient.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(FCCClient.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    public void saveFondGloryProperties(Map<String, String> map) {
        try {
            File clairPropertiesFile = FilerUtils.getInstance().getFileFondGloryProperties();
            Properties prop = new Properties();
            map.entrySet().forEach(entry -> {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                prop.setProperty(key, value);
            });
            prop.store(new FileOutputStream(clairPropertiesFile), " ");
            new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "Fond de caisse est appliqu\u00e9 avec succ\u00e8s.", 4000, NPosition.CENTER);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(FCCClient.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(FCCClient.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public boolean exclusiveMatrice(String operation) {
        switch (operation) {
            case "change": {
                return this.lastStatusInt == 1 || this.lastStatusInt == 3 || this.lastStatusInt == 4 || this.lastStatusInt == -1 || this.lastStatusInt == 18;
            }
            case "cancelChange": {
                return this.lastStatusInt == 3 || this.lastStatusInt == 4 || this.lastStatusInt == 6 || this.lastStatusInt == -1 || this.lastStatusInt == 23;
            }
            case "collect": {
                return this.lastStatusInt == 1 || this.lastStatusInt == -1 || this.lastStatusInt == 18;
            }
            case "reset": {
                return this.lastStatusInt == 1 || this.lastStatusInt == 3 || this.lastStatusInt == 13 || this.lastStatusInt == 16 || this.lastStatusInt == 30 || this.lastStatusInt == -1 || this.lastStatusInt == 18;
            }
            case "reboot": {
                return this.lastStatusInt == 1 || this.lastStatusInt == 0 || this.lastStatusInt == 8 || this.lastStatusInt == 13 || this.lastStatusInt == 19 || this.lastStatusInt == 30 || this.lastStatusInt == -1 || this.lastStatusInt == 18;
            }
            case "unlock": {
                return this.lastStatusInt == 1 || this.lastStatusInt == 0 || this.lastStatusInt == 13 || this.lastStatusInt == 19 || this.lastStatusInt == 30 || this.lastStatusInt == -1 || this.lastStatusInt == 18;
            }
            case "lock": {
                return this.lastStatusInt == 1 || this.lastStatusInt == 0 || this.lastStatusInt == 13 || this.lastStatusInt == 30 || this.lastStatusInt == -1 || this.lastStatusInt == 18;
            }
            case "cover": {
                return this.lastStatusInt == 1 || this.lastStatusInt == 13 || this.lastStatusInt == 30 || this.lastStatusInt == -1 || this.lastStatusInt == 18;
            }
            case "startReplenish": {
                return this.lastStatusInt == 1 || this.lastStatusInt == -1 || this.lastStatusInt == 18;
            }
            case "endReplenish": {
                return this.lastStatusInt == 3 || this.lastStatusInt == 4 || this.lastStatusInt == 6 || this.lastStatusInt == -1;
            }
        }
        return true;
    }

    public int getLastStatusInt() {
        return this.lastStatusInt;
    }

    public void setLastStatusInt(int lastStatusInt) {
        this.lastStatusInt = lastStatusInt;
    }
}

