/*
 * Decompiled with CFR 0.152.
 */
package com.glory.fcc.service;

import com.glory.fcc.service.FCCClient;
import com.glory.fcc.service.IUserInterface;
import com.openbravo.controllers.GloryController;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.scene.control.Alert;
import javax.xml.stream.XMLStreamException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class EventHandleClass
implements Runnable {
    private static IUserInterface pFrm;
    private boolean doRun = true;
    private boolean isRunning = true;
    private static ServerSocket serverSocket;
    boolean closeSock = false;
    boolean killSocket = false;
    private boolean isFirst = true;
    Socket socket;
    private static final String DENOMINATION = "Denomination";
    private static final String CASH = "Cash";
    private static final String DEVID = "devid";
    private static final String AMOUNT = "Amount";
    private static final String STATUS = "Status";

    public EventHandleClass(IUserInterface frm) {
        pFrm = frm;
        try {
            if (serverSocket == null) {
                serverSocket = new ServerSocket(55561);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(EventHandleClass.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void run() {
        this.doRun = true;
        this.killSocket = false;
        this.closeSock = true;
        long nEventRecvCount = 0L;
        try {
            while (this.doRun && serverSocket != null) {
                this.socket = serverSocket.accept();
                nEventRecvCount = 0L;
                InputStream in = this.socket.getInputStream();
                int resSize = 0;
                Object cmd = "";
                do {
                    byte[] bytes = new byte[this.socket.getReceiveBufferSize()];
                    try {
                        resSize = in.read(bytes, 0, this.socket.getReceiveBufferSize());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    if (resSize == 0) {
                        this.closeSock = true;
                        break;
                    }
                    int s = 0;
                    int e = 0;
                    for (e = 0; e < resSize; ++e) {
                        if (bytes[e] == 0) {
                            cmd = (String)cmd + new String(bytes, s, e - s, Charset.forName("US-ASCII"));
                            this.CheckRecvComand((String)cmd, nEventRecvCount);
                            s = e + 1;
                            cmd = "";
                            continue;
                        }
                        if (e != resSize - 1) continue;
                        cmd = (String)cmd + new String(bytes, s, e - s + 1, Charset.forName("US-ASCII"));
                    }
                } while (!this.killSocket);
                if (this.closeSock || this.socket == null || serverSocket == null) continue;
                this.socket.close();
                serverSocket.close();
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (Exception ex) {
            Logger.getLogger(EventHandleClass.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.isRunning = false;
    }

    public void callRun() {
        this.doRun = true;
        this.killSocket = false;
        this.run();
    }

    public void stop() {
        this.closeSock = false;
        this.killSocket = true;
        this.doRun = false;
        if (serverSocket != null) {
            try {
                serverSocket.close();
                serverSocket = null;
            }
            catch (IOException ex) {
                Logger.getLogger(EventHandleClass.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void CheckRecvComand(String returndata, long nEventRecvCount) throws XMLStreamException, Exception {
        try {
            Document doc = null;
            SAXBuilder adapter = new SAXBuilder();
            StringReader sr = new StringReader(returndata);
            sr.reset();
            doc = adapter.build((Reader)sr);
            List list = doc.getRootElement().getChildren();
            for (Element node : list) {
                String strName = node.getName();
                if (strName.equals("StatusChangeEvent")) {
                    Element nodeStatus = node.getChild(STATUS);
                    Element nodeAmount = node.getChild(AMOUNT);
                    if (Integer.parseInt(nodeStatus.getText()) == 3 || Integer.parseInt(nodeStatus.getText()) == 4 || Integer.parseInt(nodeStatus.getText()) == 17) {
                        double dblCashin = Double.parseDouble(nodeAmount.getText()) / 100.0;
                        pFrm.setDeposit(IUserInterface.decimalFormat.format(dblCashin));
                    } else if (Integer.parseInt(nodeStatus.getText()) == 5) {
                        // empty if block
                    }
                    if (pFrm.getRepFCState() && Integer.parseInt(nodeStatus.getText()) == 1) {
                        pFrm.startRepFC();
                    }
                    int statut = Integer.parseInt(nodeStatus.getText());
                    FCCClient.getFccInstance().setLastStatusInt(statut);
                    pFrm.setGuidance(pFrm.getStatusString(Integer.parseInt(nodeStatus.getText())), statut);
                    continue;
                }
                if (strName.equals("GlyCashierEvent")) {
                    Element nDoorID;
                    List nodeListDenomi;
                    String strIDName;
                    Element nDevicePositionID;
                    ArrayList<Element> nodeListDenomi2;
                    List cash;
                    String sDevID = node.getAttributeValue(DEVID);
                    int devId = Integer.parseInt(sDevID);
                    List nEventTypeNodes = node.getChildren();
                    Iterator i_ev = nEventTypeNodes.iterator();
                    Element nEventTypeNode = (Element)i_ev.next();
                    String strEventName = nEventTypeNode.getName();
                    if (strEventName.equals("eventCassetteInventoryOnInsertion")) {
                        cash = nEventTypeNode.getChildren(CASH);
                        nodeListDenomi2 = new ArrayList<Element>();
                        cash.forEach(element -> nodeListDenomi2.addAll(element.getChildren(DENOMINATION)));
                        if (nodeListDenomi2.size() <= 0) continue;
                        String device = Integer.parseInt(sDevID) == 1 ? "billets" : "pi\u00e8ces";
                        GloryController.showMessageDialogue(Alert.AlertType.WARNING, "la cassette " + device + " n'as pas \u00e9t\u00e9 vid\u00e9 correctement.");
                        continue;
                    }
                    if (strEventName.equals("eventCassetteInventoryOnRemoval")) {
                        cash = nEventTypeNode.getChildren(CASH);
                        nodeListDenomi2 = new ArrayList();
                        cash.forEach(element -> nodeListDenomi2.addAll(element.getChildren(DENOMINATION)));
                        pFrm.setInventoryCassette(devId, nodeListDenomi2);
                        continue;
                    }
                    if (strEventName.equals("eventWaitForRemoving")) {
                        nDevicePositionID = (Element)nEventTypeNode.getChildren().iterator().next();
                        strIDName = this.GetDevicePositionIDString(nDevicePositionID.getText(), devId);
                        pFrm.setStatus(devId, "en attent de l'ouverture de " + strIDName);
                        continue;
                    }
                    if (strEventName.equals("eventRemoved")) {
                        nDevicePositionID = (Element)nEventTypeNode.getChildren().iterator().next();
                        strIDName = this.GetDevicePositionIDString(nDevicePositionID.getText(), devId);
                        pFrm.setStatus(devId, strIDName + " enlev\u00e9e");
                        continue;
                    }
                    if (strEventName.equals("eventStatusChange")) {
                        Element nDeviceStatusID = (Element)nEventTypeNode.getChildren().iterator().next();
                        strIDName = this.GetDeviceStatusIDString(nDeviceStatusID.getText());
                        pFrm.setStatus(devId, strIDName);
                        continue;
                    }
                    if (strEventName.equals("eventEmpty")) {
                        nDevicePositionID = (Element)nEventTypeNode.getChildren().iterator().next();
                        strIDName = this.GetDevicePositionIDString(nDevicePositionID.getText(), devId);
                        if (this.GetDevicePositionIDString("1", devId).equals(strIDName)) continue;
                        new NotifyWindow(NotifyType.WARNING_NOTIFICATION, strIDName + " vide ", 4000, NPosition.TOP_LEFT);
                        continue;
                    }
                    if (strEventName.equals("eventLow")) {
                        nDevicePositionID = (Element)nEventTypeNode.getChildren().iterator().next();
                        strIDName = this.GetDevicePositionIDString(nDevicePositionID.getText(), devId);
                        pFrm.setStatus(devId, strIDName + " presque vide ");
                        continue;
                    }
                    if (strEventName.equals("eventExist")) {
                        nDevicePositionID = (Element)nEventTypeNode.getChildren().iterator().next();
                        strIDName = this.GetDevicePositionIDString(nDevicePositionID.getText(), devId);
                        new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, strIDName + " exist ", 4000, NPosition.TOP_LEFT);
                        pFrm.setStatus(devId, strIDName + " exist ");
                        continue;
                    }
                    if (strEventName.equals("eventHigh")) {
                        nDevicePositionID = (Element)nEventTypeNode.getChildren().iterator().next();
                        strIDName = this.GetDevicePositionIDString(nDevicePositionID.getText(), devId);
                        new NotifyWindow(NotifyType.WARNING_NOTIFICATION, strIDName + " plein ", 4000, NPosition.TOP_LEFT);
                        pFrm.setStatus(devId, strIDName + " trop plein ");
                        continue;
                    }
                    if (strEventName.equals("eventFull")) {
                        nDevicePositionID = (Element)nEventTypeNode.getChildren().iterator().next();
                        strIDName = this.GetDevicePositionIDString(nDevicePositionID.getText(), devId);
                        pFrm.setStatus(devId, strIDName + " plein");
                        new NotifyWindow(NotifyType.WARNING_NOTIFICATION, strIDName + " presque plein ", 4000, NPosition.TOP_LEFT);
                        continue;
                    }
                    if (strEventName.equals("eventMissing")) {
                        nDevicePositionID = (Element)nEventTypeNode.getChildren().iterator().next();
                        strIDName = this.GetDevicePositionIDString(nDevicePositionID.getText(), devId);
                        new NotifyWindow(NotifyType.WARNING_NOTIFICATION, strIDName + " manquant ", 4000, NPosition.TOP_LEFT);
                        pFrm.setStatus(devId, strIDName + " Manquant");
                        continue;
                    }
                    if (strEventName.equals("eventDepositCountChange")) continue;
                    if (strEventName.equals("eventReplenishCountChange")) {
                        nodeListDenomi = nEventTypeNode.getChildren(DENOMINATION);
                        pFrm.setReplenishCounting(nodeListDenomi);
                        continue;
                    }
                    if (strEventName.equals("eventDepositCountMonitor")) {
                        nodeListDenomi = nEventTypeNode.getChildren(DENOMINATION);
                        pFrm.setReplenishCounting(nodeListDenomi);
                        continue;
                    }
                    if (strEventName.equals("eventError")) {
                        Iterator ite2 = nEventTypeNode.getChildren().iterator();
                        Element nErrorCode = (Element)ite2.next();
                        Element nURL = (Element)ite2.next();
                        pFrm.setStatus(devId, "Error " + nErrorCode.getText());
                        Object errCode = Integer.toHexString(Integer.parseInt(nErrorCode.getText()));
                        for (int i = 1; i <= 4 - ((String)errCode).length(); ++i) {
                            errCode = "0" + (String)errCode;
                        }
                        if (nURL.getText() == null || nURL.getText().length() <= 0) continue;
                        pFrm.showRecoveryScreen((String)errCode, nURL.getText());
                        continue;
                    }
                    if (strEventName.equals("eventCassetteInserted")) continue;
                    if (strEventName.equals("eventPowerOffOnRequest")) {
                        Element nCassetteID = (Element)nEventTypeNode.getChildren().iterator().next();
                        pFrm.setStatus(devId, "eventPowerOffOnRequest: " + nCassetteID.getText());
                        continue;
                    }
                    if (strEventName.equals("eventDownloadProgress") || strEventName.equals("eventLogreadProgress")) continue;
                    if (strEventName.equals("eventRequireVerifyDenomination")) {
                        Element nCash = (Element)nEventTypeNode.getChildren().iterator().next();
                        pFrm.setWarningLabel(3, sDevID, "");
                        for (Element denomi : nCash.getChildren()) {
                            String fv = denomi.getAttributeValue("fv");
                            pFrm.setWarningLabel(1, sDevID, fv);
                        }
                        continue;
                    }
                    if (strEventName.equals("eventRequireVerifyCollectionContainer")) {
                        pFrm.setWarningLabel(2, sDevID, "");
                        continue;
                    }
                    if (strEventName.equals("eventRequireVerifyMixStacker")) {
                        pFrm.setWarningLabel(5, sDevID, "");
                        continue;
                    }
                    if (strEventName.equals("eventExactDenomination")) {
                        pFrm.setWarningLabel(3, sDevID, "");
                        continue;
                    }
                    if (strEventName.equals("eventExactCollectionContainer")) {
                        pFrm.setWarningLabel(4, sDevID, "");
                        continue;
                    }
                    if (strEventName.equals("eventExactMixStacker")) {
                        pFrm.setWarningLabel(6, sDevID, "");
                        continue;
                    }
                    if (strEventName.equals("eventWaitForOpening")) {
                        nDoorID = (Element)nEventTypeNode.getChildren().iterator().next();
                        strIDName = this.GetDoorIDString(nDoorID.getText());
                        pFrm.setStatus(devId, "en attent de l'ouverture " + strIDName);
                        continue;
                    }
                    if (strEventName.equals("eventOpened")) {
                        nDoorID = (Element)nEventTypeNode.getChildren().iterator().next();
                        strIDName = this.GetDoorIDString(nDoorID.getText());
                        pFrm.setStatus(devId, strIDName + " ouvert");
                        continue;
                    }
                    if (strEventName.equals("eventClosed")) {
                        nDoorID = (Element)nEventTypeNode.getChildren().iterator().next();
                        strIDName = this.GetDoorIDString(nDoorID.getText());
                        pFrm.setStatus(devId, strIDName + " ferm\u00e9");
                        pFrm.setLocked(devId);
                        continue;
                    }
                    if (strEventName.equals("eventLocked")) {
                        nDoorID = (Element)nEventTypeNode.getChildren().iterator().next();
                        strIDName = this.GetDoorIDString(nDoorID.getText());
                        pFrm.setStatus(devId, strIDName + " v\u00e9rouill\u00e9");
                        continue;
                    }
                    if (!strEventName.equals("eventWaitForInsertion")) continue;
                    nDevicePositionID = (Element)nEventTypeNode.getChildren().iterator().next();
                    strIDName = this.GetDevicePositionIDString(nDevicePositionID.getText(), devId);
                    pFrm.setStatus(devId, "Attendre l'insertion : " + strIDName);
                    continue;
                }
                if (strName.equals("InventoryResponse")) {
                    pFrm.setEventInventory(node);
                    continue;
                }
                if (strName.equals("HeartBeatEvent")) {
                    if (pFrm.getGuidance().equals(pFrm.getStatusString(22))) {
                        pFrm.setGuidance("Le monnayeur est connect\u00e9", -1);
                        pFrm.getGloryStatus();
                    }
                    this.isRunning = true;
                    continue;
                }
                if (!strName.equals("StatusResponse")) continue;
            }
        }
        catch (IOException | NumberFormatException | JDOMException e1) {
            e1.printStackTrace();
        }
    }

    private void CheckRecvComand2(String returndata, long nEventRecvCount) {
        try {
            Document doc = null;
            SAXBuilder adapter = new SAXBuilder();
            doc = adapter.build((Reader)new StringReader(returndata));
            List list = doc.getRootElement().getChildren();
            for (Element node : list) {
                String strName = node.getName();
                if (strName.equals("StatusChangeEvent")) {
                    Element nodeStatus = node.getChild(STATUS);
                    Element nodeAmount = node.getChild(AMOUNT);
                    if (Integer.parseInt(nodeStatus.getText()) == 3 || Integer.parseInt(nodeStatus.getText()) == 4 || Integer.parseInt(nodeStatus.getText()) == 17) {
                        double dblCashin = Double.parseDouble(nodeAmount.getText()) / 100.0;
                        pFrm.setDeposit(IUserInterface.decimalFormat.format(dblCashin));
                    } else if (Integer.parseInt(nodeStatus.getText()) == 5) {
                        // empty if block
                    }
                    if (pFrm.getRepFCState() && Integer.parseInt(nodeStatus.getText()) == 1) {
                        pFrm.startRepFC();
                    }
                    int statut = Integer.parseInt(nodeStatus.getText());
                    FCCClient.getFccInstance().setLastStatusInt(statut);
                    pFrm.setGuidance(pFrm.getStatusString(Integer.parseInt(nodeStatus.getText())), Integer.parseInt(nodeStatus.getText()));
                    continue;
                }
                if (strName.equals("GlyCashierEvent")) {
                    Element nDoorID;
                    String strIDName;
                    Element nDevicePositionID;
                    String sDevID = node.getAttributeValue(DEVID);
                    int devId = Integer.parseInt(sDevID);
                    List nEventTypeNodes = node.getChildren();
                    Iterator i_ev = nEventTypeNodes.iterator();
                    Element nEventTypeNode = (Element)i_ev.next();
                    String strEventName = nEventTypeNode.getName();
                    if (strEventName.equals("eventWaitForRemoving")) {
                        nDevicePositionID = (Element)nEventTypeNode.getChildren().iterator().next();
                        strIDName = this.GetDevicePositionIDString(nDevicePositionID.getText(), devId);
                        pFrm.setStatus(devId, "WaitForRemoving " + strIDName);
                        continue;
                    }
                    if (strEventName.equals("eventRemoved")) {
                        nDevicePositionID = (Element)nEventTypeNode.getChildren().iterator().next();
                        strIDName = this.GetDevicePositionIDString(nDevicePositionID.getText(), devId);
                        pFrm.setStatus(devId, "Removed " + strIDName);
                        continue;
                    }
                    if (strEventName.equals("eventStatusChange")) {
                        Element nDeviceStatusID = (Element)nEventTypeNode.getChildren().iterator().next();
                        strIDName = this.GetDeviceStatusIDString(nDeviceStatusID.getText());
                        if (nDeviceStatusID.getText().trim().equals("1")) continue;
                        pFrm.setStatus(devId, strIDName);
                        continue;
                    }
                    if (strEventName.equals("eventEmpty")) {
                        nDevicePositionID = (Element)nEventTypeNode.getChildren().iterator().next();
                        strIDName = this.GetDevicePositionIDString(nDevicePositionID.getText(), devId);
                        pFrm.setStatus(devId, "Empty " + strIDName);
                        continue;
                    }
                    if (strEventName.equals("eventLow")) {
                        nDevicePositionID = (Element)nEventTypeNode.getChildren().iterator().next();
                        strIDName = this.GetDevicePositionIDString(nDevicePositionID.getText(), devId);
                        pFrm.setStatus(devId, "Near Empty " + strIDName);
                        continue;
                    }
                    if (strEventName.equals("eventExist")) {
                        nDevicePositionID = (Element)nEventTypeNode.getChildren().iterator().next();
                        strIDName = this.GetDevicePositionIDString(nDevicePositionID.getText(), devId);
                        pFrm.setStatus(devId, "Exist " + strIDName);
                        continue;
                    }
                    if (strEventName.equals("eventHigh")) {
                        nDevicePositionID = (Element)nEventTypeNode.getChildren().iterator().next();
                        strIDName = this.GetDevicePositionIDString(nDevicePositionID.getText(), devId);
                        pFrm.setStatus(devId, "High " + strIDName);
                        continue;
                    }
                    if (strEventName.equals("eventFull")) {
                        nDevicePositionID = (Element)nEventTypeNode.getChildren().iterator().next();
                        strIDName = this.GetDevicePositionIDString(nDevicePositionID.getText(), devId);
                        pFrm.setStatus(devId, "Full " + strIDName);
                        continue;
                    }
                    if (strEventName.equals("eventMissing")) {
                        nDevicePositionID = (Element)nEventTypeNode.getChildren().iterator().next();
                        strIDName = this.GetDevicePositionIDString(nDevicePositionID.getText(), devId);
                        pFrm.setStatus(devId, "Missing " + strIDName);
                        continue;
                    }
                    if (strEventName.equals("eventDepositCountChange") || strEventName.equals("eventReplenishCountChange")) continue;
                    if (strEventName.equals("eventError")) {
                        Iterator ite2 = nEventTypeNode.getChildren().iterator();
                        Element nErrorCode = (Element)ite2.next();
                        Element nURL = (Element)ite2.next();
                        pFrm.setStatus(devId, "Error " + nErrorCode.getText());
                        Object errCode = Integer.toHexString(Integer.parseInt(nErrorCode.getText()));
                        for (int i = 1; i <= 4 - ((String)errCode).length(); ++i) {
                            errCode = "0" + (String)errCode;
                        }
                        if (nURL.getText() == null || nURL.getText().length() <= 0) continue;
                        pFrm.showRecoveryScreen((String)errCode, nURL.getText());
                        continue;
                    }
                    if (strEventName.equals("eventCassetteInserted")) {
                        Element nCassetteID = (Element)nEventTypeNode.getChildren().iterator().next();
                        pFrm.setStatus(devId, "CassetteInserted " + nCassetteID.getText());
                        continue;
                    }
                    if (strEventName.equals("eventPowerOffOnRequest") || strEventName.equals("eventDownloadProgress") || strEventName.equals("eventLogreadProgress")) continue;
                    if (strEventName == "eventRequireVerifyDenomination") {
                        Element nCash = (Element)nEventTypeNode.getChildren().iterator().next();
                        pFrm.setWarningLabel(3, sDevID, "");
                        for (Element denomi : nCash.getChildren()) {
                            String fv = denomi.getAttributeValue("fv");
                            pFrm.setWarningLabel(1, sDevID, fv);
                        }
                        continue;
                    }
                    if (strEventName == "eventRequireVerifyCollectionContainer") {
                        pFrm.setWarningLabel(2, sDevID, "");
                        continue;
                    }
                    if (strEventName == "eventRequireVerifyMixStacker") {
                        pFrm.setWarningLabel(5, sDevID, "");
                        continue;
                    }
                    if (strEventName == "eventExactDenomination") {
                        pFrm.setWarningLabel(3, sDevID, "");
                        continue;
                    }
                    if (strEventName == "eventExactCollectionContainer") {
                        pFrm.setWarningLabel(4, sDevID, "");
                        continue;
                    }
                    if (strEventName == "eventExactMixStacker") {
                        pFrm.setWarningLabel(6, sDevID, "");
                        continue;
                    }
                    if (strEventName == "eventWaitForOpening") {
                        nDoorID = (Element)nEventTypeNode.getChildren().iterator().next();
                        strIDName = this.GetDoorIDString(nDoorID.getText());
                        pFrm.setStatus(devId, "WaitForOpening " + strIDName);
                        continue;
                    }
                    if (strEventName == "eventOpened") {
                        nDoorID = (Element)nEventTypeNode.getChildren().iterator().next();
                        strIDName = this.GetDoorIDString(nDoorID.getText());
                        pFrm.setStatus(devId, "Opened " + strIDName);
                        continue;
                    }
                    if (strEventName == "eventClosed") {
                        nDoorID = (Element)nEventTypeNode.getChildren().iterator().next();
                        strIDName = this.GetDoorIDString(nDoorID.getText());
                        pFrm.setStatus(devId, strIDName + " ferm\u00e9");
                        continue;
                    }
                    if (strEventName == "eventLocked") {
                        nDoorID = (Element)nEventTypeNode.getChildren().iterator().next();
                        strIDName = this.GetDoorIDString(nDoorID.getText());
                        pFrm.setStatus(devId, strIDName + " verrouill\u00e9");
                        continue;
                    }
                    if (strEventName != "eventWaitForInsertion") continue;
                    nDevicePositionID = (Element)nEventTypeNode.getChildren().iterator().next();
                    strIDName = this.GetDevicePositionIDString(nDevicePositionID.getText(), devId);
                    pFrm.setStatus(devId, "en attente d'insertion: " + strIDName);
                    continue;
                }
                if (!strName.equals("InventoryResponse")) continue;
                pFrm.setEventInventory(node);
            }
        }
        catch (JDOMException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String GetDeviceStatusIDString(String strID) {
        return switch (Integer.parseInt(strID)) {
            case 0 -> "Erreur interne";
            case 1 -> "Monnayeur pret";
            case 2 -> "Comptage en cours";
            case 3 -> "Op\u00e9ration en cours";
            case 4 -> "Demande d'intervention";
            case 5 -> "Erreur";
            case 6 -> "Erreur de communication";
            case 7 -> "STATUS_DLL_INITIALIZE_BUSY";
            default -> "Unknown:" + strID;
        };
    }

    public String GetDevicePositionIDString(String strID, int devid) {
        return switch (Integer.parseInt(strID)) {
            case 1 -> "Entr\u00e9e d'argent";
            case 2 -> "Sortie d'argent";
            case 3 -> devid == 1 ? "Boite de 5.00\u20ac" : "Boite de 1.00\u20ac";
            case 4 -> devid == 1 ? "Boite de 10.00\u20ac" : "Boite de 0.02\u20ac";
            case 5 -> devid == 1 ? "Boite de 20.00\u20ac" : "Boite de 2.00\u20ac";
            case 6 -> "Boite de 0.20\u20ac";
            case 7 -> "Boite de 0.05\u20ac";
            case 8 -> "Boite de 0.50\u20ac";
            case 9 -> "Boite de 0.01\u20ac";
            case 10 -> "Boite de 0.10\u20ac";
            case 11 -> "CONTAINER_C1_COUNTER";
            case 12 -> "CONTAINER_C2_COUNTER";
            case 13 -> "CONTAINER_C3_COUNTER";
            case 14 -> "CONTAINER_C4A_COUNTER";
            case 15 -> "CONTAINER_C4B_COUNTER";
            case 16 -> "CPS1_C3_COUNTER";
            case 17 -> "CPS2_C3_COUNTER";
            case 18 -> "CPS3_C3_COUNTER";
            case 19 -> "CAPTUREBIN_COUNTER";
            case 20 -> "CONTAINER_FIT_COUNTER";
            case 21 -> "Bo\u00eete de collection";
            case 22 -> "CPS4_C3_COUNTER";
            case 23 -> "CPS5_C3_COUNTER";
            case 24 -> "CPS6_C3_COUNTER";
            case 25 -> "CPS7_C3_COUNTER";
            case 26 -> "CPS8_C3_COUNTER";
            case 27 -> "ESCROW";
            case 28 -> "CPS9_COUNTER";
            case 29 -> "CPS10_COUNTER";
            case 30 -> "CPS9_C3_COUNTER";
            case 31 -> "CPS10_C3_COUNTER";
            case 32 -> "CPS1_C4B_COUNTER";
            case 33 -> "CPS2_C4B_COUNTER";
            case 34 -> "CPS3_C4B_COUNTER";
            case 35 -> "CPS4_C4B_COUNTER";
            case 36 -> "CPS5_C4B_COUNTER";
            case 37 -> "CPS6_C4B_COUNTER";
            case 38 -> "CPS7_C4B_COUNTER";
            case 39 -> "CPS8_C4B_COUNTER";
            case 40 -> "CPS9_C4B_COUNTER";
            case 41 -> "CPS10_C4B_COUNTER";
            case 42 -> "RCW100_JAM_DOOR";
            case 43 -> "RCW100_TRANSPORT_UNIT";
            case 44 -> "ENTREE UNITE DES PIECES";
            case 45 -> "PORTE DE MAINTENANCE DE L'UNITE DES BILLETS";
            case 46 -> "Porte haute du RB";
            case 47 -> "RBW100_IF_CASETTE";
            case 48 -> "RBW100_STACK_CASETTE";
            case 49 -> "CPS1_C2_COUNTER";
            case 50 -> "CPS2_C2_COUNTER";
            case 51 -> "CPS3_C2_COUNTER";
            case 52 -> "CPS4_C2_COUNTER";
            case 53 -> "CPS5_C2_COUNTER";
            case 54 -> "CPS6_C2_COUNTER";
            case 55 -> "CPS7_C2_COUNTER";
            case 56 -> "CPS8_C2_COUNTER";
            case 57 -> "CPS9_C2_COUNTER";
            case 58 -> "CPS10_C2_COUNTER";
            case 64 -> "UPPER_UNIT";
            case 65 -> "LOWER_UNIT";
            case 73 -> "COFB";
            case 74 -> "MIXED STACKER";
            default -> "Unknown:" + strID;
        };
    }

    public String GetDoorIDString(String strID) {
        return switch (Integer.parseInt(strID)) {
            case 1 -> "Porte de collection";
            case 2 -> "Porte de maintenance";
            case 73 -> "COFB";
            default -> "Unknown:" + strID;
        };
    }

    public static IUserInterface getpFrm() {
        return pFrm;
    }

    public static void setpFrm(IUserInterface pFrm) {
        EventHandleClass.pFrm = pFrm;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void setIsRunning(boolean isRunning) {
        this.isRunning = isRunning;
    }
}

