/*
 * Decompiled with CFR 0.152.
 */
package com.biborne.yavin;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.NumericUtils;
import fr.protactile.procaisse.dao.entities.CustomerInfo;
import fr.protactile.procaisse.tpeCB.PaymentResult;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONObject;

public class YavinManager {
    private String yavinApiKey;
    private String username;
    private String password;
    private static YavinManager m_instance;
    private static final ObjectMapper objectMapper;

    public YavinManager(String yavinApiKey, String username, String password) {
        this.yavinApiKey = yavinApiKey;
        this.username = username;
        this.password = password;
    }

    public YavinManager() {
    }

    public static YavinManager getInstance() {
        if (m_instance == null) {
            m_instance = new YavinManager();
        }
        return m_instance;
    }

    public String pingTerminal(String localIpHost, boolean showMessage) {
        String response = null;
        try {
            String line;
            String urlString = "http://" + localIpHost + ":16125/localapi/v4/ping";
            if (showMessage) {
                urlString = urlString + "?showMessage=true";
            }
            URL url = new URL(urlString);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            int responseCode = connection.getResponseCode();
            BufferedReader reader = responseCode == 200 ? new BufferedReader(new InputStreamReader(connection.getInputStream())) : new BufferedReader(new InputStreamReader(connection.getErrorStream()));
            StringBuilder responseContent = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                responseContent.append(line);
            }
            reader.close();
            connection.disconnect();
            response = responseContent.toString();
            this.checkStatusConnection(response);
        }
        catch (Exception e) {
            LogToFile.log("severe", e.getMessage(), e);
        }
        return response;
    }

    public String getYavinApiKey() {
        return this.yavinApiKey;
    }

    public void setYavinApiKey(String yavinApiKey) {
        this.yavinApiKey = yavinApiKey;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public static YavinManager getM_instance() {
        return m_instance;
    }

    public static void setM_instance(YavinManager m_instance) {
        YavinManager.m_instance = m_instance;
    }

    public void checkStatusConnection(String response) throws IOException {
        String error = null;
        JsonNode jsonNode = objectMapper.readTree(response);
        if (jsonNode.has("status") && jsonNode.get("status").asText().equals("ok") && response != null) {
            error = "Ping r\u00e9ussi avec le TPE Yavin";
            new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, error, 4000, NPosition.BOTTOM_RIGHT);
        } else {
            error = "Ping non r\u00e9ussi avec le TPE Yavin.";
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, error, 4000, NPosition.BOTTOM_RIGHT);
        }
    }

    public PaymentResult sendPaymentRequest(double amount, CustomerInfo mCustomerInfo, String transactionType, String lastTransactionId) throws IOException {
        PaymentResult paymentResult = new PaymentResult();
        paymentResult.setResult(-1);
        String API_URL = "http://" + AppLocal.PAYMENT_TYPE_CB_TPE_PORT + ":16125/localapi/v4/payment";
        System.out.println("API_URL : " + API_URL);
        OkHttpClient client = new OkHttpClient.Builder().writeTimeout(1L, TimeUnit.MINUTES).readTimeout(1L, TimeUnit.MINUTES).build();
        HashMap<String, Object> customerMap = new HashMap<String, Object>();
        customerMap.put("firstName", mCustomerInfo != null ? mCustomerInfo.getName() : "");
        customerMap.put("lastName", "");
        customerMap.put("phone", mCustomerInfo != null ? AppLocal.PREFIX_PHONE + mCustomerInfo.getPhone().substring(1) : "");
        customerMap.put("email", mCustomerInfo != null ? mCustomerInfo.getEmail() : "");
        HashMap<String, String> receiptTicketMap = new HashMap<String, String>();
        receiptTicketMap.put("data", "Receipt ticket here to print if needed");
        receiptTicketMap.put("format", "text");
        HashMap<String, String> vendorMap = new HashMap<String, String>();
        vendorMap.put("softwareVersion", "3.94.47");
        vendorMap.put("softwareName", "BIBORNE");
        Object transactionId = lastTransactionId != null && !lastTransactionId.isEmpty() ? lastTransactionId : "" + new Date().getTime();
        int amountCentieme = (int)NumericUtils.round(amount * 100.0);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("amount", amountCentieme);
        params.put("giftAmount", 0);
        params.put("medium", "card");
        params.put("transactionType", transactionType);
        params.put("customer", customerMap);
        params.put("vendor", vendorMap);
        params.put("reference", "");
        params.put("receiptTicket", null);
        params.put("receiptTicketJson", null);
        params.put("idempotentUuid", transactionId);
        System.out.println("new ObjectMapper().writeValueAsString(params) : " + new ObjectMapper().writeValueAsString(params));
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)new ObjectMapper().writeValueAsString(params));
        Request request = new Request.Builder().url(API_URL).post(requestBody).build();
        try (Response response = client.newCall(request).execute();){
            String response_items = response.body().string();
            if (response.code() == 200 && response_items != null && !response_items.trim().isEmpty()) {
                String status;
                JSONObject jsonResponse = new JSONObject(response_items);
                System.out.println("jsonResponse : " + jsonResponse);
                String string = status = jsonResponse.isNull("status") ? "" : jsonResponse.getString("status");
                if (status != null && status.equalsIgnoreCase("ok")) {
                    String clientCardTicket;
                    paymentResult.setResult(0);
                    String string2 = clientCardTicket = jsonResponse.isNull("clientCardTicket") ? "" : jsonResponse.getString("clientCardTicket");
                    if (clientCardTicket != null && !clientCardTicket.isEmpty()) {
                        paymentResult.setHolder_ticket(clientCardTicket);
                    }
                }
            }
        }
        catch (Exception e) {
            LogToFile.log("severe", e.getMessage(), e);
            paymentResult.setLast_transaction_id((String)transactionId);
        }
        if (paymentResult.getResult() == 0) {
            new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "Transaction effectu\u00e9e avec succ\u00e8s ! ", 4000, NPosition.BOTTOM_RIGHT);
        } else {
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "La transaction n'a pas abouti . ", 4000, NPosition.BOTTOM_RIGHT);
        }
        return paymentResult;
    }

    static {
        objectMapper = new ObjectMapper();
    }
}

