/*
 * Decompiled with CFR 0.152.
 */
package com.biborne.utils;

import java.util.function.Consumer;
import javafx.animation.PauseTransition;
import javafx.scene.Scene;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.stage.Stage;
import javafx.util.Duration;

public class BarcodeScannerListener {
    private final StringBuilder buffer = new StringBuilder();
    private final PauseTransition pause;
    private final Consumer<String> onBarcodeScanned;

    private BarcodeScannerListener(Scene scene, Consumer<String> onBarcodeScanned) {
        this.onBarcodeScanned = onBarcodeScanned;
        this.pause = new PauseTransition(Duration.millis((double)100.0));
        this.pause.setOnFinished(e -> this.validateScannedBarcode());
        scene.addEventFilter(KeyEvent.KEY_TYPED, event -> {
            char ch;
            event.consume();
            String character = event.getCharacter();
            if (!character.isEmpty() && (ch = character.charAt(0)) >= ' ') {
                this.buffer.append(ch);
                this.pause.playFromStart();
            }
        });
        scene.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode() == KeyCode.ENTER) {
                event.consume();
                this.validateScannedBarcode();
            }
        });
    }

    private void validateScannedBarcode() {
        if (this.buffer.length() > 0) {
            String barcode = this.buffer.toString();
            this.buffer.setLength(0);
            this.onBarcodeScanned.accept(barcode);
        }
    }

    public static void attach(Scene scene, Consumer<String> onBarcodeScanned) {
        new BarcodeScannerListener(scene, onBarcodeScanned);
    }

    public static void attach(Stage stage, Consumer<String> onBarcodeScanned) {
        BarcodeScannerListener.attach(stage.getScene(), onBarcodeScanned);
    }
}

