/*
 * Decompiled with CFR 0.152.
 */
package com.biborne.sms;

import com.biborne.sms.ISendSMS;
import com.biborne.sms.NEXMO;
import com.biborne.sms.SMSMODE;
import com.openbravo.pos.forms.AppLocal;

public class SmsService {
    private static SmsService m_instance;
    private final String prefix = AppLocal.SMS_PREFIX;
    private ISendSMS m_ISendSMS;

    private SmsService() {
        String modelSMS;
        switch (modelSMS = AppLocal.MODEL_SMS) {
            case "NEXMO": {
                this.m_ISendSMS = new NEXMO();
                break;
            }
            case "SMSMODE": {
                this.m_ISendSMS = new SMSMODE();
            }
        }
    }

    public static SmsService getInstance() {
        if (m_instance == null) {
            m_instance = new SmsService();
        }
        return m_instance;
    }

    private String getPhoneWithPrefix(String phone) {
        if (phone.startsWith("+")) {
            phone = phone.substring(1);
        }
        if (!phone.startsWith(this.prefix)) {
            if (phone.length() == 10 && phone.startsWith("0")) {
                phone = phone.substring(1);
            }
            StringBuilder phoneWithPrefix = new StringBuilder();
            phoneWithPrefix.append(this.prefix);
            phoneWithPrefix.append(phone);
            return phoneWithPrefix.toString();
        }
        return phone;
    }

    public void sendSMS(String phoneNumber, String message) {
        String phoneWithPrefix = this.getPhoneWithPrefix(phoneNumber);
        this.m_ISendSMS.sendSms(phoneWithPrefix, message);
    }
}

