/*
 * Decompiled with CFR 0.152.
 */
package com.biborne.sms;

import com.biborne.sms.ISendSMS;
import com.biborne.sms.SMSTags;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.util.LogToFile;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONObject;

public class SMSMODE
implements ISendSMS {
    private String URL = "https://rest.smsmode.com/sms/v1/messages";
    private String API_KEY = AppLocal.SMS_API_KEY;

    @Override
    public void sendSms(String phoneNumber, String message) {
        if (this.API_KEY != null && !this.API_KEY.isEmpty()) {
            System.out.println("++" + this.API_KEY + "++");
            try {
                JSONObject jsonBody = new JSONObject();
                JSONObject recipientObject = new JSONObject();
                recipientObject.put("to", (Object)phoneNumber);
                JSONObject bodyObject = new JSONObject();
                bodyObject.put("text", (Object)message);
                jsonBody.put("recipient", (Object)recipientObject);
                jsonBody.put("body", (Object)bodyObject);
                OkHttpClient client = new OkHttpClient().newBuilder().build();
                RequestBody body = RequestBody.create((MediaType)SMSTags.MediaType_JSON, (String)jsonBody.toString());
                Request request = new Request.Builder().url(this.URL).post(body).addHeader("X-Api-Key", this.API_KEY).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
                Response response = client.newCall(request).execute();
                System.out.println("response : " + response);
                String reponse = response.body().string();
                JSONObject jsonResponse = new JSONObject(reponse);
                System.out.println("jsonResponse.getString(\"error\") : " + jsonResponse);
                response.close();
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }
}

